function myparser(s) {
    if (!s)
        return new Date();
    var ss = (s.split('/'));
    var d = parseInt(ss[0], 10);
    var m = parseInt(ss[1], 10);
    var y = parseInt(ss[2], 10);
    //alert(s);
    if (!isNaN(y) && !isNaN(m) && !isNaN(d)) {
        return new Date(y, m - 1, d);
    } else {
        return new Date();
    }
}

function fullDate(dt) {
    return (dt.getDate() < 10 ? "0" + dt.getDate() : dt.getDate()) + '/' + (dt.getMonth() + 1 < 10 ? "0" + (dt.getMonth() + 1) : dt.getMonth() + 1) + '/' + dt.getFullYear();
}

function validateLogin(emailId, passwordId) {
    var flag = $("#" + emailId).val().indexOf("@") > 0 || !$.isNumeric($("#" + emailId).val());
    if ((flag && validateEmail(emailId)) || (!flag && validatePhone(emailId))) {
        var password = $("#" + passwordId).val().trim();
        if (password === "") {
            showMessage(pleaseEnter + passwordLabel);
        } else
            return true;
    }
    return false;
}

function validatePasswords(oldPwd, newPwd, cnfPwd) {
    if (validate(oldPwd, "old password") &&
            validate(newPwd, "new password") &&
            validate(cnfPwd, "confirm password") &&
            validateMatch(newPwd, cnfPwd))
        return true;
    return false;
}

function validateEmail(emailId, label) {
    var email = $("#" + emailId).val().trim();
    if (email === "") {
        showMessage(pleaseEnter + (label ? label : " email id"));
        return false;
    } else if (!/^((([a-z]|\d|[!#\$%&'\*\+\-\/=\?\^_`{\|}~]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])+(\.([a-z]|\d|[!#\$%&'\*\+\-\/=\?\^_`{\|}~]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])+)*)|((\x22)((((\x20|\x09)*(\x0d\x0a))?(\x20|\x09)+)?(([\x01-\x08\x0b\x0c\x0e-\x1f\x7f]|\x21|[\x23-\x5b]|[\x5d-\x7e]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(\\([\x01-\x09\x0b\x0c\x0d-\x7f]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]))))*(((\x20|\x09)*(\x0d\x0a))?(\x20|\x09)+)?(\x22)))@((([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.)+(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.?$/i.test(email)) {
        showMessage(pleaseEnter + " valid email id" + (label ? " for " + label : ""));
        return false;
    }
    return true;
}

function validatePhone(phoneId, label) {
    var phone = $("#" + phoneId).val().trim();
    if (phone === "") {
        showMessage(pleaseEnter + (label ? label : " phone number"));
        return false;
    } else if (!/^(?:(?:\+|0{0,2})91(\s*[\-]\s*)?|[0]?)?[789]\d{9}$/.test(phone) && !/^(\(?[0-9]{3}\)?)((\s|\-){1})?[0-9]{3}((\s|\-){1})?[0-9]{4}$/.test(phone)) {
        showMessage(pleaseEnter + " valid phone number" + (label ? " for " + label : ""));
        return false;
    }
    return true;
}

function validateMobile(phoneId, label) {
    var phone = $("#" + phoneId).val().trim();
    if (phone === "") {
        showMessage(pleaseEnter + " " + label + " phone number");
        return false;
    } else if (!/^(?:(?:\+|0{0,2})91(\s*[\-]\s*)?|[0]?)?[789]\d{9}$/.test(phone)) {
        showMessage(pleaseEnter + " valid phone number" + (label ? " for " + label : ""));
        return false;
    }
    return true;
}

function validatePincode(pincodeId) {
    var pattern = /^[0-9]{6}$/;
    var pincode = $("#" + pincodeId).val().trim();
    if (pincode === "") {
        showMessage(pleaseEnter + " pincode number");
        return false;
    } else if (!pattern.test(pincode)) {
        showMessage(pleaseEnter + " valid pincode number");
        return false;
    }
    return true;
}

function validateGovtId(govtId) {
    var govtCode = $("#" + govtId).val().trim();
    var pattern = /^[A-Za-z0-9 '.-]+$/;
    if (govtCode === "") {
        showMessage(pleaseEnter + " Id number");
        return false;
    } else if (!pattern.test(govtCode)) {
        showMessage(pleaseEnter + " valid Id number");
        return false;
    }
    return true;
}

function validateDOB(dob) {
    var date1 = $("#" + dob).val().trim();
    var pattern = /^\d{4}[-/\s]?((((0[13578])|(1[02]))[-/\s]?(([0-2][0-9])|(3[01])))|(((0[469])|(11))[-/\s]?(([0-2][0-9])|(30)))|(02[-/\s]?[0-2][0-9]))$/;
    var agePattern = /^[1-9]?[0-9]{1}$|^100$/;
    if (date1 === "") {
        showMessage(pleaseEnter + " date or age in given format");
        return false;
    } else if (!pattern.test(date1)) {
        if (!agePattern.test(date1)) {
            showMessage(pleaseEnter + " valid date format");
            return false;
        }
    }
    return true;
}

function validate(id, label) {
    var val = $('#' + id).val().trim();
    if (val === "") {
        showMessage((label.includes("image") ? pleaseUpload : pleaseEnter) + label);
        return false;
    }
    return true;
}
function validateTextLength(id, label, length) {
    if (validate(id, label)) {
        var val = $("#" + id).val().trim();
        if (val.length > length) {
            showMessage(label + " should be less than " + length + " characters");
            return false;
        }
        return true;
    }
}
function validateWebsite(id) {
    if (validate(id, "website")) {
        var val = $('#' + id).val().trim();
        if (val.startsWith("http://www.") || val.startsWith("https://www.") || val.startsWith("www."))
            return true;
        showMessage(pleaseEnter + " valid website");
        return false;
    }
}
function validateHttp(id) {
    if (validate(id, "url")) {
        var val = $('#' + id).val().trim();
        if (val.startsWith("http://") || val.startsWith("https://"))
            return true;
        showMessage(pleaseEnter + " valid url");
        return false;
    }
}
function validateEmbeddedHttp(id) {
    if (validate(id, "url") && validateHttp(id)) {
        var val = $('#' + id).val().trim();
        if (val.includes("www.youtube.com/embed/"))
            return true;
        showMessage("Please copy url from embed tag under share option in youtube");
        return false;
    }
}
function validateSearch(id, label) {
    var val = $('#' + id).val().trim();
    if (val === "") {
        showMessage(pleaseEnter + label);
        return false;
    }
    return true;
}

function validateSelection(id, label) {
    var val = $('#' + id).val().trim();
    if (val === "-1") {
        showMessage("Please Select " + label);
        return false;
    }
    return true;
}

function validateMatch(id1, id2) {
    var val1 = $('#' + id1).val();
    var val2 = $('#' + id2).val();
    if (val1 !== val2) {
        showMessage("Passwords doesn't match");
        return false;
    }
    return true;
}
function validateNumber(id, label) {
    var val = $('#' + id).val().trim();
    if (validate(id, label)) {
        if (isNaN(val)) {
            showMessage(pleaseEnter + " valid number for " + label);
            return false;
        } else
            return true;
    }
}
function validateLandLine(id, label) {
    var val = $('#' + id).val().trim();
    var no = val.split("-");
    if (no.length === 1) {
        if (validatePositiveNumber(id, label)) {
            return true;
        }
    } else {
        for (i = 0; i < no.length; i++) {
            if (isNaN(no[i])) {
                showMessage(pleaseEnter + " valid number for " + label + ", please use '-' for seperation");
                return false;
            }
        }
        return true;
    }
}
function validatePositiveNumber(id, label) {
    if (validateNumber(id, label)) {
        var val = $('#' + id).val().trim();
        if (val >= 0)
            return true;
        else {
            showMessage(pleaseEnter + " valid " + label);
            return false;
        }
    }
}
function validateAutoSelect(id, label) {
    var val = $('#' + id).val().trim();
    if (val === "") {
        showMessage("please enter " + label);
        return false;
    } else if (validateNumber(id, label)) {
        var val = $('#' + id).val().trim();
        if (val >= 0)
            return true;
        else {
            showMessage("please select " + label + " from the list only");
            return false;
        }
    }
}
function validateSelect(id, label) {
    var val = $('#' + id).val().trim();
    if (val === "" || val === "0") {
        showMessage("please select " + label);
        return false;
    }
    return true;
}
function showMessage(message, app) {
    if (app) {
        App.alert(message);
    } else {
        $('.mask_status').fadeIn(300);
        $("#statusDivContent").html(message);
        $("#statusDiv").slideDown(300);
        $("body").css('overflow-y', 'hidden');
    }
}
var redirect = '';
var reload = false;
$(function () {
    $("#status_close").click(function () {
        $('.mask_status').fadeOut(300);
        $("#statusDiv").slideUp(300);
        $("body").css('overflow-y', 'auto');
        if (redirect && redirect !== "") {
            location.href = redirect;
        }
        if (reload) {
            location.reload();
        }
    });

    $(window).keyup(function (e) {
        if (e.which === 27) {
            $("#status_close").click();
        }
    });
});
$(document).ready(function () {
    $(".forg_text").click(function () {
        $("#forgotEmail").val("");
        $(".forgot_pasword").show();
    });
    $(".forgot_close").click(function () {
        $(".forgot_pasword").hide();
    });
    $("#submitForgot").click(function () {
        if (validateEmail("forgotEmail", "email")) {
            var type = $("#forgotEmail").data("type");
            jQuery.post((type === 0 ? "/admin/account/" : "/doctor/") + "forgotPassword.save", {email: $("#forgotEmail").val()}, function (data) {
                if (data && data !== "") {
                    showMessage(data);
                    $(".forgot_pasword").hide();
                }
            });
        }
    });
});