$(document).ready(function () {
   
    $("#saveMemberBlog").click(function () {
        var formData;
        if (validate("title", "Enter title") &&
                ($("#videoUrl").val() !== "" ? validateEmbeddedHttp("videoUrl") : true) &&
                validate("description", "description")) {
            formData = new FormData();
            formData.append("title", $("#title").val());
            formData.append("description", $("#description").val());
            formData.append("videoUrl", $("#videoUrl").val());
            formData.append("imageForm", document.getElementById("imageForm").files[0]);
            $.ajax({
                url: "/member-blog.save",
                data: formData,
                processData: false,
                type: 'POST',
                contentType: false,
                success: function (data) {
                    showMessage(data);
                    if (data.indexOf("successfully") !== -1) {
                        resetMemBlogFields();
                        location.href = "/member-blog.html";
                    }
                },
                error: function (err) {
                    showMessage(err);
                }
            });
        }
    });
});
function submitMemberBlogComments(id, parentId) {
    if (validate("comments", "comments")) {
        jQuery.post("/save-member-blog-comments.save", {name: $("#name").val(), emailId: $("#email").val(),
            comment: $("#comments").val(), memberBlogId: id, memberBlogCommentId: parentId},
        function (data) {
            if (data && data.indexOf("successfully") !== -1) {
                var text = "<div class='comment_cnt_box' style='padding: 10px 0px 0px 10px;'>";
                text += "<b>" + $("#name").val() + "</b><small>Just Now</small>";
                text += "<div class='clear'></div>";
                text += "</div>";
                text += "<p style='padding-left:10px'>" + $("#comments").val() + "</p>";
                text += "<p></p>";
                $("#commentList").append(text);
                $("#commentsCount").html(parseInt($("#commentsCount").html()) + 1);
                $("#comments").val('');
                $(".comment_filds").slideToggle(200);
                $(".add_comment_btn").toggleClass("add_comment_click");
                showMessage("Thanks for your comment");
            } else {
                showMessage(data);
            }
        });
    }
}

function saveMemberBlogLike(memberBlogId, clientId, likeFlag) {
    jQuery.post("/member-blog-like.save", {memberBlogId: memberBlogId, clientId: clientId, like: likeFlag},
    function (data) {
        if (data && data.indexOf("successfully") !== -1) {
//            location.reload();
            if (likeFlag) {
                $("#likeCount").html(parseInt($("#likeCount").html().toString().substring(0)[0]) + 1 + " like(s)");
                $("#likes").html(parseInt($("#likes").html().toString().substring(0)[0]) + 1 + " like(s)");
                $("#likeDiv").hide();
                $("#likedDiv").show();
            }
            else {
                $("#likeCount").html(parseInt($("#likeCount").html().toString().substring(0)[0]) - 1 + " like(s)");
                $("#likes").html(parseInt($("#likes").html().toString().substring(0)[0]) - 1 + " like(s)");
                $("#likeDiv").show();
                $("#likedDiv").hide();
            }
            showMessage("You " + (likeFlag ? " liked " : "un-liked") + " this blog");
        } else
            showMessage(data);
    });
}

function saveMemberBlogDislike(memberBlogId, clientId, dislikeFlag) {
    jQuery.post("/member-blog-dislike.save", {memberBlogId: memberBlogId, clientId: clientId, dislike: dislikeFlag},
    function (data) {
        if (data && data.indexOf("successfully") !== -1) {
//            location.reload();
            if (dislikeFlag) {
                $("#dislikeCount").html(parseInt($("#dislikeCount").html().toString().substring(0)[0]) + 1 + " dislike(s)");
                $("#dislikes").html(parseInt($("#dislikes").html().toString().substring(0)[0]) + 1 + " dislike(s)");
                $("#dislikeDiv").hide();
                $("#dislikedDiv").show();
            }
            else {
                $("#dislikeCount").html(parseInt($("#dislikeCount").html().toString().substring(0)[0]) - 1 + " dislike(s)");
                $("#dislikes").html(parseInt($("#dislikes").html().toString().substring(0)[0]) - 1 + " dislike(s)");
                $("#dislikeDiv").show();
                $("#dislikedDiv").hide();
            }
            showMessage("You " + (dislikeFlag ? " disliked " : "un-disliked") + " this blog");
        } else
            showMessage(data);
    });
}

function showLike() {
    showMessage("sign-in to like this blog");
}

function resetMemBlogFields() {
    $("#tile").val('');
    $("#description").val('');
    $("#videoUrl").val('');
    $("#imageForm").val('');
    $("#imageUrl").val('');
}