function removeItem(key)
{
    $("#alert-box").html('');
    $(".loader_animation").show();
    $.post('/donations/removeitem',{key:key}, function(res)
    {
        try
        {
            var r=$.parseJSON(res);
        }
        catch(err)
        {
            $(".loader_animation").hide();
            showNotification('ruby',"Something wrong, please refresh the page and try again.");
            return false;
        }

        if(r.flag==0)
        {
            $(".loader_animation").hide();
            showNotification("ruby","Invalid request");
        }
        else if(r.flag==1)
        {
            $(".loader_animation").hide();
            clearNotifications();
            showNotification("ruby","Donation removed from cart");
        }
        else if(r.flag==2)
        {
            $(".loader_animation").hide();
            showNotification("ruby","Donation does not exist in cart");
        }
        else if(r.flag==3)
        {
            $(".loader_animation").hide();
            $("#alert-box").html('\
                <div class="alert alert-danger">\
                    <button class="close" data-dismiss="alert"></button>\
                    <strong>There are no items in your cart.</strong>\
                </div>');
            Metronic.scrollTo($('.page-title'));
            $(".hideShowClearCart").hide();
        }
        else if(r.flag==11)
        {
            $(".loader_animation").hide();
            $("#alert-box").html('\
                <div class="alert alert-danger">\
                    <button class="close" data-dismiss="alert"></button>\
                    <span style="font-size:20px;">\
                        Sorry! A transaction initiated by you, is already in progress.<br>\
                        If you want to cancel previous transaction, please \
                        <a href="javascript:;" class="btn btn-danger btn-sm" onClick="cancelPrevTransaction()">Click Here</a>\
                    </span>\
                </div>');
            Metronic.scrollTo($('.page-title'));
            return false;
        }
        if(window.location.pathname=='/donations')
        {
            loadTopCart();
        }
        else
        {
            if(r.cart_count==0)
            {
                var redirectLocation = '/donations';
                if(r.ashram_id > 0)
                {
                    redirectLocation += '?ashram_id='+r.ashram_id;
                }
                if(r.ashram_id > 0 && r.currency!='')
                {
                    redirectLocation += '&currency='+r.currency;
                }
                window.location = redirectLocation;
            }
            else
            {
                reloadCart();
            }
        }
    });
}



function clearCart()
{
    
    $("#clearCartModal").modal('hide');
    $("#alert-box").html('');
    $(".loader_animation").show();
    $.post('/donations/clearCart',{}, function(res)
    {
        try
        {
            var r=$.parseJSON(res);
        }
        catch(err)
        {
            $(".loader_animation").hide();
            showNotification('ruby',"Something wrong, please refresh the page and try again.");
            return false;
        }

        if(r.flag==0)
        {
            $(".loader_animation").hide();
            showNotification("ruby","Invalid request");
        }
        else if(r.flag==1)
        {
            $(".loader_animation").hide();
            clearNotifications();
            showNotification("ruby","Cart has been emptied");
        }
        else if(r.flag==2)
        {
            $(".loader_animation").hide();
            $("#alert-box").html('\
                <div class="alert alert-danger">\
                    <button class="close" data-dismiss="alert"></button>\
                    <strong>There are no items in your cart.</strong>\
                </div>');
            Metronic.scrollTo($('.page-title'));
            $(".hideShowClearCart").hide();
        }
        else if(r.flag==11 || r.flag==3)
        {
            $(".loader_animation").hide();
            $("#alert-box").html('\
                <div class="alert alert-danger">\
                    <button class="close" data-dismiss="alert"></button>\
                    <span style="font-size:20px;">\
                        Sorry! A transaction initiated by you, is already in progress.<br>\
                        If you want to cancel previous transaction, please \
                        <a href="javascript:;" class="btn btn-danger btn-sm" onClick="cancelPrevTransaction()">Click Here</a>\
                    </span>\
                </div>');
            Metronic.scrollTo($('.page-title'));
            return false;
        }
        if(window.location.pathname=='/donations')
        {
            loadTopCart();
        }
        else
        {
            if(r.cart_count==0)
            {
                var redirectLocation = '/donations';
                if(r.ashram_id > 0)
                {
                    redirectLocation += '?ashram_id='+r.ashram_id;
                }
                if(r.ashram_id > 0 && r.currency!='')
                {
                    redirectLocation += '&currency='+r.currency;
                }
                window.location = redirectLocation;
            }
            else
            {
                reloadCart();
            }
        }
    });
}