<!DOCTYPE html>
<html>
    <head>
        <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
        <meta content="width=device-width, initial-scale=1.0" name="viewport" />
        <title><?PHP echo site_name_string1; ?> | Vishwashanti Pada Yatra 2022 - Top Cities Report</title>
        <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css">
        <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>
        <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/js/bootstrap.min.js"></script>
        <link href="<?php echo base_url."site_theme"; ?>/admin_fonts/google-css-open-sans.css" rel="stylesheet">
        <link href="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/datatables_1_10_5/media/css/dataTables.bootstrap.css" rel="stylesheet" type="text/css"/>
        <link rel="stylesheet" href="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/responsive.min.css">
        <link href="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/font-awesome/css/font-awesome.min.css" rel="stylesheet" type="text/css"/>
        <link href="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/admin/layout/css/layout.css" rel="stylesheet" type="text/css"/>
        <link href="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/admin/layout/css/custom.css" rel="stylesheet" type="text/css"/>
        <link href="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/css/components.css" rel="stylesheet" type="text/css"/>
        <style type="text/css">
            @media screen and (max-width:800px)
            {
                .no-more-tables td 
                {
                    padding-left: 135px !important;
                }
            }
        </style>
    </head>
    <body>
        <div class="container">

            <div class="row-fluid fixedheaderform">
                <h3 class="page-title" style="margin-top: 5px;font-weight: bold;">
                    Vishwashanti Pada Yatra 2022 - Top Cities Report
                </h3>
                <!-- END PAGE TITLE & BREADCRUMB-->
                <div class="row-fluid">
                   <div class="portlet box blue">
                		<div class="portlet-title">
                			<div class="caption">Vishwashanti Pada Yatra 2022 - Top Cities Report</div>
                			<div class="tools">
                				<a href="javascript:;" class="collapse"></a>
                			</div>
                		</div>
                		<div class="portlet-body no-more-tables">
                            <table class="table-bordered table-striped dataTable  table table-condensed cf">
                                <thead>
                                    <tr>
                                        <th width="6%">S.No.</th>
                                        <th width="7%">Submissions</th>
                                        <th width="8%">City</th>
                                        <th width="8%">Country</th>
                                        <th width="14%">Devotee Name</th>
                                        <th width="16%">Total Steps Count</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php 
                                    if(empty($report) || count($report) < 0)
                                    {
                                        ?>
                                        <tr><td></td><td></td><td style="font-weight:bold; color:maroon;">No Records found</td><td></td><td></td><td></td></tr>
                                        <?php
                                    }
                                    else
                                    {
                                        $sno = 1;
                                        foreach($report as $city)
                                        {
                                            ?>
                                            <tr>
                                                <td style="font-weight:bold;" data-title="S.No.">
                                                    <span class="tooltips" data-container="body" data-placement="bottom" data-original-title="<?PHP  echo $sno; ?>">
                                                        <?PHP  echo $sno; ?>
                                                    </span>
                                                </td>
                                                <td style="font-weight:bold;" data-title="Submissions">
                                                    <span class="tooltips" data-container="body" data-placement="bottom" data-original-title="Submissions">
                                                        <?PHP  
                                                            echo $city["submissions"];
                                                        ?>
                                                    </span>
                                                </td>
                                                <td data-title="City">
                                                    <span class="tooltips" data-container="body" data-placement="bottom" data-original-title="City">
                                                        <?PHP  
                                                            echo $city["city"];
                                                        ?>
                                                    </span>
                                                </td>
                                                <td data-title="Country">
                                                    <span class="tooltips" data-container="body" data-placement="bottom" data-original-title="Country Code">
                                                        <?PHP  
                                                            echo $city["country_code"];
                                                        ?>
                                                    </span>
                                                </td>
                                                <td style="font-weight:bold; color:maroon;" data-title="Devotee Name">
                                                    NA
                                                </td>
                                                <td style="font-weight:bold; color:maroon;" data-title="Total Steps Count">
                                                    <span class="tooltips" data-container="body" data-placement="bottom" 
                                                        data-original-title="<?PHP echo $city["submission_count"]; ?>">
                                                        <?PHP  
                                                            echo $city["submission_count"];
                                                        ?>
                                                    </span>
                                                </td>
                                                </tr>
                                                <?php
                                                $sno++;
                                            }
                                        }
                                        ?>
                                </tbody>
                            </table>
                        </div>
                   </div>
                </div>
            </div>
        </div>
    </body>
</html>
<script src="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/jquery.min.js" type="text/javascript"></script>
<script src="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/jquery-migrate.min.js" type="text/javascript"></script>
<script src="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/jquery-ui/jquery-ui-1.10.3.custom.min.js" type="text/javascript"></script>
<script src="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/bootstrap/js/bootstrap.min.js" type="text/javascript"></script>
<script src="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/bootstrap-hover-dropdown/bootstrap-hover-dropdown.min.js" type="text/javascript"></script>
<script src="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/pace/pace.js" type="text/javascript"></script>
<script src="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/datatables_1_10_5/media/js/jquery.dataTables.js" type="text/javascript"></script>
<script src="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/datatables_1_10_5/media/js/dataTables_custom.js" type="text/javascript"></script>