
<input class="current-browser-title" data-title=" User Dashboard | Change password" type="hidden">
<?PHP echo $this->general_model->help_link(); ?>
<!-- BEGIN PAGE TITLE & BREADCRUMB-->
<h3 class="page-title">
    Change Password
    
</h3>
<div class="page-bar">
	<ul class="page-breadcrumb">
        <li>
            <i class="fa fa-home"></i>
            <a href="<?PHP echo base_url; ?>myaccount">Dashboard</a>
            <i class="fa fa-angle-right"></i>
        </li>
        <li>Change Password
        </li>
        
    </ul>
</div>
<!-- END PAGE TITLE & BREADCRUMB-->

<div class="alert alert-danger">
    <strong>Please change your password before navigating.</strong>
</div>

<div class="row-fluid">
   <div class="portlet box blue">
        <div class="portlet-title">
            <div class="caption">Change Password</div>
            <div class="tools">
                <a href="javascript:;" class="collapse"></a>
            </div>
            
        </div>
        
        <div class="portlet-body">
            <div class="row">
                <form action="" id="changepass_form" name="changepass_form" method="post" class="col-md-6 changepass_form">

                    <div class="form-group">
                        <label class="control-label" style="text-align:left;">New Password</label>
                        <div class="form-content">
                            <input type="password" name="newpass" id="newpass" class="form-control" />
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="control-label" style="text-align:left;">Confirm Password</label>
                        <div class="form-content">
                            <input type="password" name="confpass" id="confpass" class="form-control" />
                        </div>
                    </div>

                    <div class="form-group">
                        <div class="form-content">
                            <button type="submit" name="save_password" id="save_password" class="btn btn-xs blue"> 
                            <i class="fa fa-check"></i> Change</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<div style=" width: 100%; clear:both; line-height:0; height:0; overflow:hidden; "></div>
<script type="text/javascript">
    $( document ).ready(function() 
    {
        $('.changepass_form').validate(
        {
            errorElement: 'span', //default input error message container
            errorClass: 'help-block help-block-error', // default input error message class
            focusInvalid: true, // do not focus the last invalid input
            onkeyup:false,
            rules: {
                newpass: {
                    required: true,
                    minlength: 8,
                    maxlength: 50
                },
                confpass:
                {
                    required:true,
                    equalTo: "#newpass"
                }
            },

            messages: 
            {
                newpass: 
                {
                    required: "Please enter New Password"
                },
                confpass: 
                {
                    required:"Please Retype New Password",
                    equalTo: "Passwords did not match"
                }
            },
            highlight: function(element)
            {
                $(element).closest('.form-group').addClass('has-error');
            },
            success: function(label)
            {
                label.closest('.form-group').removeClass('has-error');
                label.remove();
            },
            errorPlacement: function(error, element)
            {
                error.insertAfter(element);
                error.addClass('help-small no-left-padding').insertAfter(element);
            },
            submitHandler: function() 
            {
                $(".loader_animation").show();
                $.post('/myaccount/update_pass_force',
                {
                    new_password:$('#newpass').val()
                },
                function(mm) 
                {
                    
                    if(mm==1)
                    {
                        $('#newpass').val('');
                        $('#confpass').val('');
                        showNotification("lime","Password changed successfully");
                        window.location='/myaccount';
                    }
                    else if(mm==2)
                    {
                        var error=$("<span class='help-block help-block-error' id='oldpass-error'>").html("Invalid Current Password");
                        $('#oldpass').closest('.form-group').removeClass("has-success").addClass('has-error');
                        error.addClass('help-small no-left-padding').insertAfter("#oldpass");
                    }
                    else if(mm==3)
                    {
                        var error=$("<span class='help-block help-block-error' id='newpass-error'>").html("New Password cannot be same as previous password");
                        $('#newpass').closest('.form-group').removeClass("has-success").addClass('has-error');
                        error.addClass('help-small no-left-padding').insertAfter("#newpass");
                    }
                    else
                    {
                        var error=$("<span class='help-block help-block-error' id='oldpass-error'>").html("Invalid Current Password");
                        $('#oldpass').closest('.form-group').removeClass("has-success").addClass('has-error');
                        error.addClass('help-small no-left-padding').insertAfter("#oldpass");
                    }
                    $(".loader_animation").hide();
                    return false;
                },'html');
                return false;
            }
        });
    });
</script>