<?PHP
$credit_cards=$this->credit_cards_model->getCards($this->currentUser->id);
if(!empty($credit_cards))
{
    ?>
    <div class="alert alert-info">
        JGD. Editing credit cards is not permitted. To add/update your new card, please delete the card and add it during checkout.
        Your payment information is secure and managed by PayPal. Credit Card details are not stored on our website.
    </div>
    <?PHP
    foreach ($credit_cards as $creditCard)
    {
        ?>
        <div class="col-md-4">
            <li class="creditCard-row" data-id="<?PHP echo $creditCard->id; ?>" id="crow<?PHP echo $creditCard->id; ?>">
                <a href="#cc<?PHP echo $creditCard->id ?>" class="pull-right" role="button" data-toggle="modal" style="color:red;">
                    <i class="fa fa-trash" style="font-size: 24px;"></i>
                </a>
                

                <img src="<?PHP echo aws_s3_base_url;?>images/site_assets/global_site_images/card<?PHP echo $creditCard->card_type; ?>.png">
                <span class="cardnum">**** **** **** <?PHP echo str_replace("*","",$creditCard->card_number); ?></span>
                <span class="cardexp">
                    <?PHP echo substr($creditCard->card_expiry,0,2)."/".
                    substr($creditCard->card_expiry,-2); ?>
                </span>
                <span class="cardname"><?PHP echo $creditCard->card_name; ?></span>
                <?php if($creditCard->is_expired == "1")
                {
                    ?>
                    <span class="cardexp" style="color:red;margin-left:55px;">Card Expired</span>
                    <?php
                }
                ?>
                <div id="cc<?PHP echo $creditCard->id ?>" class="modal fade in">
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
                        <h4 class="modal-title" style="color:#fff;">Delete Confirmation</h4>
                    </div>
                    <div class="modal-body">
                        <div class="modal-body"><div class="pull-left delete-confirmation-icon">
                            <i class="fa fa-exclamation-triangle"></i>
                        </div>
                            Do you really want to delete the Credit Card ending with <span style="color:red; font-weight:bold;"><?PHP  echo $creditCard->card_number; ?></span>?
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" data-dismiss="modal" class="btn btn-xs">
                        <i class="fa fa-remove"></i> Cancel</button>
                        <button type="submit" class="btn btn-xs red credit_card_delete" data-id="<?PHP echo $creditCard->id; ?>">
                        <i class="fa fa-trash"></i> Delete</button>
                    </div>
                </div>
            </li>
        </div>
        <?PHP
    }
}
else
{
    ?>
    <div class="alert alert-info">
        No saved cards yet!
    </div>
    <?PHP
}
?>
<div style="clear:both;"></div>
<script type="text/javascript">
    $(".credit_card_delete").on("click",function()
    {
        var ele=this;
        $(this).prop("disabled",true);

        var id=$(this).attr("data-id");
        $("#cc"+id).modal("hide");
        $.post('/myaccount/deletecard/' + id , {}, function(res) 
        {
            var r=$.parseJSON(res);
            if(r.flag==1)
            {
                $("#crow"+id).remove();
                showNotification("lime","Credit Card ending with '"+r.card_number+"' deleted successfully");
                window.location.reload();
            }
            else
            {
                showNotification("ruby","Invalid request. Please try again.");
                $(ele).prop("disabled",false);
            }
        });
    });
</script>