<style type="text/css">
    .table tr.fail,
    .table tr.fail td.fail
    {
        background: rgba(255,0,0,0.05);
    }
</style>
<div class="col-md-12" style="padding: 0;">
    <div class="col-md-12 alert alert-warning" id="pulsate-regularalert">
        PLEASE NOTE: 
        <br>
        You can hide a Family member / Donor in your profile, if you no longer wish to display them when participating in Sevas.
        <br>
        Family member / Donor who participated in any Seva cannot be deleted.
    </div>
</div>
<form action="" name="" style="margin:0px;" onsubmit="return false" novalidate="" class="form-horizontal row search_form">
	<div class="col-md-2">
	    <input  type="text" id="search_text_d"  class="form-control input-inline custom-input" 
	    placeholder="Type keyword to search..." style="border:1px solid skyblue;" />
	</div>
	<div class="col-md-2">
	    <select id="search_col_d" class="form-control input-inline custom-input">
			<option value="donor_name">Name</option>
            <option value="donor_email">Email ID</option>
            <option value="donor_phone">Phone</option>
		</select>
	</div>
	<!-- <div class="col-md-2">
	    <select id="wild_d" class="form-control input-inline custom-input">
			<option value="contains">Contains</option>
			<option value="starts">Starts With</option>
			<option value="ends">Ends With</option>
		</select>
	</div> -->
	<button id="searchButton_d" class="btn btn-xs blue tooltips"
		type="button" data-container="body" data-placement="bottom" data-original-title="Search">
		<i class="fa fa-search"></i> Search
	</button>
	<button id="searchClear_d" class="btn btn-xs red display-hide tooltips"
		type="button" data-container="body" data-placement="bottom" data-original-title="Clear">
		<i class="fa fa-search-minus"></i> Clear
	</button>

    <a class="btn btn-xs blue pull-right add-donor-button" href="javascript:;">
        <i class="fa fa-plus"></i> Add Family Member / Donor
    </a>
</form>
<br class="hidden-lg hidden-md">
<table class="table table-striped table-bordered table-condensed" id="donors_list">
    <thead>
        <tr>
            <th width="50">S. No.</th>
            <th>Relation</th>
            <th>Photo</th>
            <th>Name</th>
            <th>Phone</th>
            <th>Email ID</th>
            <th>DOB</th>
            <th>Actions</th>
        </tr>
    </thead>
    <tbody>
        
    </tbody>
</table>
<div class="modal-section">
</div>
<script type="text/javascript">
    var donorsCount = 0;
    var donorsFlag=0;
    var table='';
    var search_text='';
    var search_col='';
    $("#donors_button").on("click",function()
    {
        $("#searchButton_d").on("click",function()
        {
            clearNotifications();
            if(!$("#search_text_d").length || !$("#search_col_d").length)
            {
                showNotification("ruby","Something went wrong!!! Please refresh page and try again.");
                return;
            }
            if ($("#search_text_d").length && $("#search_text_d").val().trim() == '') 
            {
                showNotification('ruby','Please enter search keywords');
                return false;
            }
            $(".dataTables_processing").show();
            if($("#search_text_d").length)
                search_text = $("#search_text_d").val().trim();
            if($("#search_col_d").length)
                search_col = $("#search_col_d").val().trim();

            if (search_text != '')
                $("#searchClear_d").css("display", "inline-block");
            
            table.fnDraw();

        });

        $("#searchClear_d").on("click",function()
        {
            $(".dataTables_processing").show();
            $("#search_text_d").val('');
            search_text = '';
            search_col = '';
            $("#searchClear_d").css("display", "none");
            table.fnDraw();
        });

        if(donorsFlag==1)
            return;
        donorsFlag=1;
        var from_date = '';
        var to_date = '';
        var search_text='';
        var search_col='';
        table= $('#donors_list').dataTable(
        {
            "processing": true,
            "language": {
                "sProcessing": '<div class="spinnerspin"></div>',
                "emptyTable": "No records found!"
            },
            "sDom": "l<'custom-clear visible-xs'>ptr<'clearfix'>p",
            "sPaginationType": "bootstrap",
            "serverSide": true,
            "iDisplayLength": 50,
            "order": [
                [0, "asc"]
            ],
            "responsive": true,
            "lengthMenu": [
                [20, 50, 100],
                [20, 50, 100]
            ],
            "drawCallback": function(settings) 
            {
                var api = this.api();
                var totalrows = api.rows({
                    page: 'current'
                }).data().context[0]._iRecordsTotal;
                $("#donors_count").html('(' + totalrows + ')');
                donorsCount = totalrows;
            },
            "columns": 
            [
                {
                    "width": 50,
                    "orderable": false
                },
                {
                    "name":"donor_relation",
                    "width": "10%",
                    "orderable": false
                },{
                    "name":"photo",
                    "width": "10%",
                    "orderable": false
                },
                {
                    "name":"donor_name",
                    "orderable": true
                },
                {
                    "name":"donor_phone",
                    "width": "14%",
                    "orderable": false
                },
                {
                    "name":"donor_email",
                    "width": "20%",
                    "orderable": true
                },
                {
                    "name":"dob",
                    "width": "6%",
                    "orderable": false
                },
                {
                    "width": "8%",
                    "orderable": false
                }
            ],
            "ajax": 
            {
                <?PHP
                if($this->currentUser->roles == 1)
                {
                    $id = $this->uri->segment(3);
                    $tableUrl="/myaccount/donors_list/".$id;
                }
                else 
                {
                    $tableUrl="/myaccount/donors_list";
                }
                
                ?>

                url: '<?PHP echo $tableUrl; ?>',
                type: 'POST',
                data: function(d)
                {
                    if (search_text != '')
                        d.search_text = search_text;
                    d.search_col = search_col;
                },
                error: function (xhr, error, thrown) 
                {
                    if(xhr.responseText=='login')
                    {
                        window.location="<?PHP echo base_url; ?>"
                    }
                    else if(xhr.responseText==404 || xhr.responseText=='404' || xhr.responseText=='0')
                    {
                       showNotification('ruby',"Invalid request");
                    }
                    $(".dataTables_processing").hide();
                    return false;
                },
                dataSrc:function(res)
                {
                    if(res.data.length==0 && res.recordsTotal!=0)
                    {
                        oTable.fnDraw();
                    }
                    return res.data;
                }
            },
            "fnRowCallback": function(nRow, aData, iDisplayIndex, iDisplayIndexFull) 
            {
                var vis = true;
                var ii = 0;
                var sno = 0;

                if(aData.is_hidden==1)
                {
                    $(nRow).addClass("fail");
                    $(nRow).find("td").addClass("fail");
                }

                if (this.api().column(sno).visible()) {
                    $('td:eq(' + ii + ')', nRow).attr('data-title', "S. No.");
                    ii++;
                }
                sno++;
                if (this.api().column(sno).visible()) {
                    $('td:eq(' + ii + ')', nRow).attr('data-title', "Relation");
                    ii++;
                }
                sno++;
                if (this.api().column(sno).visible()) {
                    $('td:eq(' + ii + ')', nRow).attr('data-title', "Photo");
                    ii++;
                }
                sno++;
                if (this.api().column(sno).visible()) {
                    $('td:eq(' + ii + ')', nRow).attr('data-title', "Name");
                    ii++;
                }
                sno++;
                if (this.api().column(sno).visible()) {
                    $('td:eq(' + ii + ')', nRow).attr('data-title', "Phone");
                    ii++;
                }
                sno++;
                if (this.api().column(sno).visible()) {
                    $('td:eq(' + ii + ')', nRow).attr('data-title', "Email ID");
                    ii++;
                }
                sno++;
                if (this.api().column(sno).visible()) {
                    $('td:eq(' + ii + ')', nRow).attr('data-title', "DOB");
                    ii++;
                }
                sno++;
                if (this.api().column(sno).visible()) {
                    $('td:eq(' + ii + ')', nRow).attr('data-title', "Actions");
                    ii++;
                }
            },
            "columnDefs": 
            [
                {
                    "render": function(data, type, row) 
                    {
                        return row.sno;
                    },
                    "targets": 0
                },
                {
                    "render": function(data, type, row) 
                    {
                        return '<span style="font-weight:bold;color:#f85050;">'+row.donor_relation+'<span>';
                    },
                    "targets": 1
                },
                {
                    "render": function(data, type, row) 
                    {
                        return '<img src="'+row.donor_photo+'" style="max-width:65px;" >';
                    },
                    "targets": 2
                },
                {
                    "render": function(data, type, row) 
                    {
                        return row.donor_name;
                    },
                    "targets": 3
                },
                {
                    "render": function(data, type, row) 
                    {
                        if(row.donor_phone == '')
                        {
                            return '-';
                        }
                        return row.donor_phone;
                    },
                    "targets": 4
                },
                {
                    "render": function(data, type, row) 
                    {
                        if(row.donor_email == '')
                        {
                            return '-';
                        }
                        return row.donor_email;
                    },
                    "targets": 5
                },
                {
                    "render": function(data, type, row) 
                    {
                        if(row.donor_dob == '')
                        {
                            return '-';
                        }
                        return row.donor_dob;
                    },
                    "targets": 6
                },
                {
                    "render": function(data, type, row)
                    {
                        var str = '<div class="btn-group" id="actions' + row.id + '">' +
                            '<a class="btn red btn-xs" href="#" data-toggle="dropdown"> Actions ' +
                            '<i class="fa fa-angle-down"></i></a>' +
                            '<ul class="dropdown-menu pull-right" style="text-align:left;">' +
                            '<li><a data-id="' + row.id + '" href="javascript:;" class="edit-donor"><i class="fa fa-edit"></i> Edit</a></li>';
                        if(row.donor_relation!="Self")
                        {
                            str += '<li><a href="#donor' + row.id + '" role="button" data-toggle="modal">' +
                                '<i class="fa fa-trash-o"></i> Delete</a></li>' +

                                '<div id="donor' + row.id + '" class="modal fade" tabindex="-1">' +
                                '<div class="modal-header">' +
                                '<button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>' +
                                '<h4 class="modal-title">Delete Confirmation</h4>' +
                                '</div>' +
                                '<div class="modal-body"><div class="pull-left delete-confirmation-icon"' +
                                '><i class="fa fa-exclamation-triangle"></i></div>' +
                                'Do you really want to delete the Donor: ' +
                                '<span style="color:red; font-weight:bold;">' + row.donor_name + '</span>?' +
                                '</div>' +
                                '<div class="modal-footer">' +
                                '<button type="button" data-dismiss="modal" class="btn btn-xs default close' + row.id + '">' +
                                '<i class="fa fa-remove"></i> Cancel</button>' +
                                '<a onClick="deleteDonor(' + row.id + ')" class="btn btn-xs red">' +
                                '<i class="fa fa-trash"></i> Delete</a>' +
                                '</div>' +
                                '</div>';

                            if(row.is_hidden==1)
                            {
                                str += '<li><a href="#hideUnhideDonor' + row.id + '" role="button" data-toggle="modal">' +
                                            '<i class="fa fa-check"></i> Unhide</a></li>';
                            }
                            if(row.is_hidden==0)
                            {
                                str += '<li><a href="#hideUnhideDonor' + row.id + '" role="button" data-toggle="modal">' +
                                            '<i class="fa fa-ban"></i> Hide</a></li>';
                            }
                            var hideUnhideStatusstr = ''; 
                            var hideUnhideStatusstrCapital = ''; 
                            var hideUnhideStatus = 0; 
                            var subunsubicon = ''; 
                            var subunsubbtncls = 'red'; 
                            if(row.is_hidden==1)
                            {
                                hideUnhideStatus = 0;
                                hideUnhideStatusstr = 'unhide';
                                hideUnhideStatusstrCapital = 'Unhide';
                                subunsubicon = 'ban';
                                subunsubbtncls = 'btn-primary';
                            }
                            if(row.is_hidden==0)
                            {
                                hideUnhideStatus = 1;
                                hideUnhideStatusstr = 'hide';
                                hideUnhideStatusstrCapital = 'Hide';
                                subunsubicon = 'check';
                                subunsubbtncls = 'btn-primary';
                            }
                            str += '<div id="hideUnhideDonor' + row.id + '" class="modal fade" tabindex="-1">' +
                                '<div class="modal-header">' +
                                '<button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>' +
                                '<h4 class="modal-title">'+hideUnhideStatusstrCapital+' Family member / Donor Confirmation</h4>' +
                                '</div>' +
                                '<div class="modal-body">' +
                                'Do you really want to '+hideUnhideStatusstr+' Family member / Donor: ' +
                                '<span style="color:red; font-weight:bold;">' + row.donor_name + '</span>?' +
                                '</div>' +
                                '<div class="modal-footer">' +
                                '<button type="button" data-dismiss="modal" class="btn btn-xs close' + row.id + '">' +
                                '<i class="fa fa-remove"></i> Cancel</button>' +
                                '<a class="btn btn-xs '+subunsubbtncls+' hideUnhideButton" data-status="'+hideUnhideStatus+'" data-id="'+row.id+'">' +
                                '<i class="fa fa-'+subunsubicon+'"></i> '+hideUnhideStatusstrCapital+'</a>' +
                                '</div>' +
                                '</div>';
                        }

                        return str;
                    },
                    "targets": 7
                }
            ]
        });
        $(".add-donor-button").on("click",function()
        {
            if(donorsCount>=20)
            {
                clearNotifications();
                showNotification('ruby', "Sorry you cannot add any more family members, permitted limit has been reached.");
                return false;
            }
            <?PHP
            if($this->currentUser->roles == 1)
            {
                $id = $this->uri->segment(3);
                $addtableUrl="/donorsadmin/donor_form?userid=".$id;
            }
            else 
            {
                $addtableUrl="/myaccount/donor_form";
            }
            
            ?>
            $(".loader_animation").show();
            $.ajax(
            {
                url: "<?php echo $addtableUrl; ?>",
                cache: false,
                contentType: false,
                processData: false,
                type: 'post',
                success: function(res)
                {
                    $(".modal-section").html(res);
                    $("#donor-modal").modal('show');
                    $(".loader_animation").hide();
                }
            });
        });

        $(".edit-donor").live("click",function()
        {
            var id=$(this).data("id");
            <?PHP
            if($this->currentUser->roles == 1)
            {
                $editUrl="/donorsadmin/donor_form";
            }
            else 
            {
                $editUrl="/myaccount/donor_form";
            }
            ?>
            var url = "<?php echo $editUrl;?>";
            var editurl = url+"/"+id;
            $(".loader_animation").show();
            $.ajax(
            {
                url: editurl,
                cache: false,
                contentType: false,
                processData: false,
                type: 'post',
                success: function(res)
                {
                    $(".modal-section").html(res);
                    $("#donor-modal").modal('show');
                    $(".loader_animation").hide();
                }
            });
        });

        var hideUnhideStatusflag=0;
        $(".hideUnhideButton").live("click",function()
        {
            clearNotifications();
            if(hideUnhideStatusflag==1)
                return false;
            hideUnhideStatusflag=1;
            var uid=$(this).attr("data-id");
            var status=$(this).attr("data-status");
            $(".dataTables_processing").show();
            $.post('/myaccount/hideUnhideDonor/'+uid+'/'+ status, {}, function(res) 
            {
                var r = $.parseJSON(res);
                if (r.flag == 1) 
                {
                    table.fnSettings.bResetDisplay  =false;
                    table.fnDraw(table.fnSettings);
                    if(status == 1)
                    {
                        showNotification('lime', "Family member / Donor '" + r.donor_name + "' hidden successfully");
                    }
                    if(status == 0)
                    {
                         showNotification('lime', "Family member / Donor '" + r.donor_name + "' made visible successfully");
                    }
                }
                else 
                {
                    showNotification("ruby", "Error occured. Please try again.");
                }
                $("#hideUnhideDonor"+uid).modal("toggle");
                $(".dataTables_processing").hide();
                hideUnhideStatusflag=0;
            });
        });

    });

    var statusflag=0;
    function deleteDonor(id)
    {
        if(statusflag==1)
            return false;
        statusflag=1;
        $(".dataTables_processing").show();
        $.post('/myaccount/donor_delete/' + id , {}, function(res) 
        {
            if(res=='login')
            {
                window.location="<?PHP echo base_url; ?>"
            }
            if(res=='access_denied')
            {
                showNotification('ruby',"Access Denied");
                $(".dataTables_processing").hide();
                $("#donor" + id).modal('hide');
                statusflag=0;
                return;
            }
            var r = $.parseJSON(res);
            $(".dataTables_processing").hide();
            if (r.flag == 1) 
            {
                table.fnSettings.bResetDisplay  =false;
                table.fnDraw(table.fnSettings);
                showNotification('ruby', "Donor '" + r.name + "' has been deleted successfully ");
            }
            else if(r.flag==2)
            {
                showNotification('ruby', "Donor '" + r.name + "' cannot be deleted. Sevas are associated.");   
            }
            else if(r.flag==3)
            {
                showNotification('ruby', "Self donor '" + r.name + "' cannot be deleted");   
            }
            else
            {
                showNotification("ruby", "Error occured. Please try again.");
            }
            $("#donor" + id).modal('hide');
            statusflag=0;
        });
    }
    
</script>
