<link href="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/datatables_1_10_5/media/css/dataTables.bootstrap.css" rel="stylesheet" type="text/css"/>
<input class="current-browser-title" data-title=" Admin Dashboard | Users Admin | User Misc. Reports" type="hidden">
<?PHP
    $this->load->view("users/admin/user_reports_nav_buttons");
?>
<h3 class="page-title">
User Misc. Reports
</h3>
<div class="page-bar">
    <ul class="page-breadcrumb">
        <li>
            <i class="fa fa-home"></i>
            <a href="/admin">Dashboard</a>
            <i class="fa fa-angle-right"></i>
        </li>
        <li>User Misc. Reports</li>
    </ul>
</div>
     
<div class="row-fluid">
<?PHP
if($this->session->flashdata("user_error"))
{
	?>
    <div class="alert alert-danger">
        <button class="close" data-dismiss="alert"></button>
        <strong>Invalid Request</strong>
    </div>
    <?PHP
}
?>
<div class="alert alert-info">
    <strong>Misc. Reports are listed for:<br>
    1. Wrong Login attempts<br>
    2. Password resets requested<br>
    3. Password reset attempts<br>
    4. Password resets done
    </strong>
</div>
	<form action="" method="get" name="list_of_users" style="margin:0px;" onsubmit="return false"
        class="form-horizontal row search_form">
        <input type="hidden" name="param" id="param"
        value="<?php if (isset($_GET['param'])) echo $_GET['param']; ?>" />
        <input type="hidden" name="order" id="order"
        value="<?php if (isset($_GET['order'])) echo $_GET['order']; ?>" />
        
        <div class="col-md-2">
            <select id="misc_action" class="input-inline form-control custom-input" onchange="search(1)">
                <option value="">All Actions</option>
                <option value="wrong_login">Wrong Logins</option>
                <option value="password_reset_sent">Password Resets Requested</option>
                <option value="password_reset_attempt">Password Reset Attempts</option>
                <option value="password_reset">Password Resets</option>  
            </select>
        </div>
        <br class="hidden-sm hidden-xs" style="clear:both;">
        <div class="col-md-2">
            <input type="text" name="search_text" id="search_text" placeholder="Type keyword to search..."
            class="input-inline form-control custom-input" />
        </div>
        <div class="col-md-2">
            <select name="search_col" id="search_col" class=" input-inline form-control custom-input">
                <option value="username">User ID</option>
                <option value="email">Email ID</option>
                <option value="ip_address">IP Address</option>
            </select>
        </div>
       <!--  <div class="col-md-2">
            <select name="wild" id="wild" class="input-inline form-control custom-input">
                <option value="contains">Contains</option>
                <option value="starts">Starts with</option>
                <option value="ends">Ends with</option>
            </select>
        </div> -->
        
        <button type="button" id="searchButton" class="btn btn-xs blue searchButton"
        onClick="search(0)"><i class="fa fa-search"></i> Search</button>
        <a class="btn btn-xs red" id="searchClear" onClick="search_clear()"
        style="display:none;"><i class="fa fa-search-minus"></i> Clear</a>
        <button type="button" id="excelButton" class="btn btn-xs green excelButton" ><i class="fa fa-file-excel-o"></i> Report</button>
    </form>
    <br class="hidden-lg hidden-md">
    <div class="portlet box blue">
        <div class="portlet-title">
            <div class="caption"> <i class="fa fa-list"></i> User Misc. Reports <span id="total_records"></span></div>
            <div class="tools">
                <a href="javascript:;" class="collapse"></a>
            </div>
        </div>
        
        <div class="portlet-body no-more-tables">
            
                <table id="pagestable" class="display table-bordered table-condensed table table-striped table-hover" cellspacing="0" width="100%" >
                    <thead>
                        <tr>
                            <th>S. No.</th>
                            <th>Date</th>
                            <th>User ID</th>
                            <th>Email ID</th>
                            <th>IP Address
                            <th>Misc. Action</th>
                        </tr>
                    </thead>
                    
                </table>
            
            <div style="clear:both;"></div>
        </div>
    </div>

</div>
<script src="<?php
echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/datatables_1_10_5/media/js/jquery.dataTables.js" type="text/javascript"></script>
<script src="<?php
echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/datatables_1_10_5/media/js/dataTables_custom.js" type="text/javascript"></script>
<script type="text/javascript">
var search_text = '';
var search_col = '';
var table = '';
var misc_action='';
function applyFilter(ele) 
{
    table.fnDraw();
}
function search(flag) 
{
    clearNotifications();
    if(!$("#search_text").length || !$("#search_col").length)
    {
        showNotification("ruby","Something went wrong!!! Please refresh page and try again.");
        return;
    }
    if (flag == 0)
    {
        if ($("#search_text").length && $("#search_text").val().trim() == '') 
        {
            showNotification('ruby','Please enter search keywords or select dates');
            return false;
        }
    }
    $(".dataTables_processing").show();
    if($("#search_text").length)
        search_text = $("#search_text").val().trim();
    if($("#search_col").length)
        search_col = $("#search_col").val().trim();
    if (search_text != '')
        $("#searchClear").css("display", "inline-block");
    if($("#misc_action").length)
        misc_action = $("#misc_action").val().trim();
    
    table.fnDraw();
}
function search_clear() 
{
    $(".dataTables_processing").show();
    $("#search_text").val('');
    $("#misc_action").val('');
    search_text = '';
    search_col = '';
    misc_action='';
    $("#searchClear").css("display", "none");
    table.fnDraw();
}

$(document).ready(function()
{
    $("#search_text").val('');
    $("#search_col").val($("#search_col option:first").val());

    table = $('#pagestable').dataTable({
        "processing": true,
        "language": {
            "sProcessing": '<div class="spinnerspin"></div>',
            "emptyTable": "No records found!"
        },
        "sDom": "l<'custom-clear visible-xs'>ptr<'clearfix'>p",
        "sPaginationType": "bootstrap",
        "serverSide": true,
        "iDisplayLength": 50,
        "order": [
            [1, "desc"]
        ],
        "responsive": true,
        "lengthMenu": [
            [20, 50, 100],
            [20, 50, 100]
        ],
        "drawCallback": function(settings) 
        {
            var api = this.api();
            var totalrows = api.rows({
                page: 'current'
            }).data().context[0]._iRecordsTotal;
            $("#total_records").html('(' + totalrows + ')');
        },
        "columns": [
        {
            "width": "7%",
            "orderable": false
        }, {
            name: "date",
            "width": "12%",
            "orderable": false
        }, {
            name: "username",
            "width": "20%",
            "orderable": true
        }, {
            name: "email",
            "width": "18%",
            "orderable": true
        }, {
            name:"ip_address",
            width: "7%",
            "orderable": true
        },{
            name: "action",
            "width": "18%",
            "orderable": false
        }],
        "ajax": {
            url: '/usersadmin/listmiscreports',
            type: 'POST',
            data: function(d) 
            {
                if (status != '' && $.isNumeric(status)) 
                {
                    d.status = status;
                }
                if (search_text != '')
                    d.search_text = search_text;
                d.search_col = search_col;
                d.misc_action=misc_action;
            },
            error: function (xhr, error, thrown) 
            {
                if(xhr.responseText=='login')
                {
                    window.location="<?PHP echo base_url; ?>"
                }
                else if(xhr.responseText==404 || xhr.responseText=='404' || xhr.responseText=='0')
                {
                   showNotification('ruby',"Invalid request");
                }
                $(".dataTables_processing").hide();
                return false;
            },
            dataSrc:function(res)
            {
                if(res.data.length==0 && res.recordsTotal!=0)
                {
                    table.fnDraw();
                }
                return res.data;
            }
        },
        "fnRowCallback": function(nRow, aData, iDisplayIndex, iDisplayIndexFull) 
        {
            var vis = true;
            var ii = 0;
            var sno = 0;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "S. No.");
                ii++;
            }
            sno++;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "Date");
                ii++;
            }
            sno++;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "User ID");
                ii++;
            }
            
            sno++;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "Email ID");
                ii++;
            }
            sno++;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "IP Address");
                ii++;
            }
            sno++;
            if (this.api().column(sno).visible())
                $('td:eq(' + ii + ')', nRow).attr('data-title', "Misc. Action");
            return nRow;
        },
        "columnDefs": [
        {
            "render": function(data, type, row) {
                return row.sno;
            },
            "targets": 0
        }, {
            "render": function(data, type, row) 
            {
                return row.date;
            },
            "targets": 1
        }, {
            "render": function(data, type, row) 
            {
                return row.username+'&nbsp;';
            },
            "targets": 2
        },  {
            "render": function(data, type, row) 
            {
                return row.email+'&nbsp;';
            },
            "targets": 3
        }, {
            "render": function(data, type, row) 
            {
                return row.ip_address+'&nbsp;';
            },
            "targets": 4
        }, {
            "render": function(data, type, row) 
            {
                return row.action;
            },
            "targets": 5
        }]
    });
    $('.columnhide').on('click', function(e) 
    {
        var column = table.api().column( $(this).attr('data-column') );
        var cnum=$(this).attr('data-column');
        
        column.visible( ! column.visible(),true );
        var bVis = table.fnSettings().aoColumns[cnum].bVisible;
        var title = table.fnSettings().aoColumns[cnum].sTitle;
        
        var visibility=table.api().column(cnum).visible();
        table.api().column(cnum).nodes().to$().attr("data-title",title);
        if (visibility == false) 
        {
            $(this).removeClass('blue').addClass('red');
        }
        else 
        {
            $(this).removeClass('red').addClass('blue');
        }
    });
});
    $("#excelButton").on("click",function()
    {
        $(".loader_animation").show();
        clearNotifications();
        var sortindex=table.fnSettings().aaSorting[0][0];
        var order_by=table.fnSettings().aoColumns[sortindex].name;
        var dir=table.fnSettings().aaSorting[0][1];
        $.post('/usersadmin/listmiscreports/1',
        {
            misc_action:misc_action,search_text:search_text,search_col:search_col,
            order_by:order_by,dir:dir
        },
            function(res)
            {
                var r=$.parseJSON(res);
                if(r.flag==1)
                {
                    window.location='<?PHP echo base_url; ?>excelreports/download/'+r.report_id;
                }
                if(r.flag==2)
                {
                    showNotification("ruby","Sorry! You have already requested the same report.");
                }
                if(r.flag==0)
                {
                    showNotification("ruby","Sorry! Report cannot be generated. Data is empty.");
                }
                $(".loader_animation").hide();
            }
        );
    });
</script>     