<input class="current-browser-title" data-title=" Admin Dashboard  | All <?PHP echo $sub_title; ?> User IDs | Add Edit <?PHP echo $sub_title; ?> User ID(s)" type="hidden">
<?PHP
	$this->load->view("users/admin/users_nav_buttons");
?>
<h3 class="page-title">
	<?PHP
		echo "Add ".$sub_title." User ID(s)";
	?>
</h3>
<div class="page-bar">
    <ul class="page-breadcrumb">
        <li>
            <i class="fa fa-home"></i>
            <a href="<?PHP echo base_url; ?>admin">Dashboard</a>
            <i class="fa fa-angle-right"></i>
        </li>
        <li>
            <a href="/usersadmin/<?PHP echo strtolower($sub_title); ?>userids">All <?PHP echo $sub_title; ?> User IDs</a>
            <i class="fa fa-angle-right"></i>
        </li>
        <li><?PHP echo "Add ".$sub_title." User ID(s)"; ?></li>
    </ul>
</div>
<?PHP
if($this->session->flashdata("user_error"))
{
	?>
    <div class="alert alert-danger">
        <button class="close" data-dismiss="alert"></button>
        <strong>Error saving changes, please try again.</strong>
    </div>
    <?PHP
}
if($this->session->flashdata('userids_complete'))
{

	?>
	<div class="alert alert-info">
		<button class="close" data-dismiss="alert"></button>
		<strong>User ID(s) created: 
		<?PHP echo $this->session->flashdata('userids_count'); ?></strong><br />

		<strong>User ID(s) skipped: <?PHP echo $this->session->flashdata('userids_skipped'); ?></strong>

	</div>
	<?PHP
}
if($this->session->flashdata('userids_skipped')>0)
{
	?>
	<div class="alert alert-danger">
		<button class="close" data-dismiss="alert"></button>
		<strong>User ID(s) already exist:<br /> 
		<?PHP echo $this->session->flashdata('userids_exist'); ?></strong>
	</div>
	<?PHP
}
 if($flag==0)
{
	?>
	<div class="alert alert-info">
		<span class="label label-danger">Please Note:</span>
		<span style="color:#000;">Restricted User ID acts in the format 
		<span style="color:red; font-weight:bold;">*USERID*</span>. For example, if you add "SGS", any User ID containing "SGS" word like "SGSINDIA9","SGSDEVOTEE","CHICAGOSGS",etc.. will be restricted.</span>
	</div>
	<?PHP
}
if($flag==1)
{
	?>
	<div class="alert alert-info">
		<span class="label label-danger">Please Note:</span>
		<span style="color:#000;">Reserved User ID reserves the exact word given.                                     For example, if you add "NETWORKADMIN", no user can register with "NETWORKADMIN" as his/her User ID.</span>
	</div>
	<?PHP
}
?>

<div class="row-fluid">
<!-- BEGIN SAMPLE TABLE PORTLET-->
	<div class="margin-bottom-40">
		
		<div class="portlet box blue">
			<div class="portlet-title">
				<div class="caption">Add/Edit <?PHP echo $sub_title; ?> User ID(s)</div>
				<div class="tools">
					<a href="javascript:;" class="collapse"></a>
				</div>
                
			</div>
            
			<div class="portlet-body">
				<form action="" id="admin_form" name="admin_form" method="post">

		            <div class="form-group">
		                <label class="control-label">User ID(s)
		                </label>
		                <div class="form-content">
		                    <textarea class="form-control" name="username" id="username" rows="4"></textarea>
		                </div>
		                    
		            </div>
		            <div class="form-group">
		                <div class="form-content">
		                    <b>Example:</b><br>
								networkadmin,systemadmin,useradmin<br>
								networkadmin<br>
								systemadmin<br>
								useradmin<br>
		                </div>  
		            </div>
	
		            <div class="form-group">
						<label class="control-label">
							
						</label>
						<div class="form-content">
							<button type="submit" name="add_userid" id="add_userid" class="btn btn-xs blue"> 
							<i class="fa fa-check"></i> <?PHP echo "Add User ID"; ?></button>
							<a href="<?PHP echo URL_PREFIX; ?>usersadmin/<?PHP echo strtolower($sub_title); ?>userids" 
							class="btn btn-xs red"> <i class="fa fa-ban"></i> Cancel</a>
						</div>
					</div>


				</form>
			</div>
		</div>



    </div>
 
</div>

<script type="text/javascript">
				
$( document ).ready(function() 
{
	jQuery.validator.addMethod("stripids", function(value, element) 
	{ 
		var validator = this;

		var em= value.match(/([a-zA-Z0-9]+)/gi);

		if(!em)
		{
			cc="Please enter at least one valid User ID";
			jQuery.validator.messages.stripids = cc;
			return false;
		}
		if(em.length>500)
		{
			jQuery.validator.messages.stripids = "Maximum of 500 User IDs are allowed";
			return false
		}
		$("#username").val(em.join(','));
		var minn=1;
		var maxx=1;
		$.each(em, function(childKey, value)
		{
			<?PHP
			if($flag==1)
			{
				?>
				if(value.length<6)
				{
					minn=0;
				}
				<?PHP
			}
			else
			{
				?>
				if(value.length<3)
				{
					minn=0;
				}
				<?PHP
			}
			?>
			if(value.length>60)
			{
				maxx=0;
			}
		});
						
		if(minn==0)
		{
			<?PHP
				if($flag==1)
				{
				?>
					jQuery.validator.messages.stripids = "Each User ID must be minimum 6 character length";
				<?PHP
				}
				else
				{
					?>
					jQuery.validator.messages.stripids = "Eash User ID must be minimum 3 character length";
					<?PHP
				}
				?>
					return false
		}
		if(maxx==0)
		{
			jQuery.validator.messages.stripids = "All User IDs must not exceed 60 characters";
					return false
		}
		 
		  
        return true; 

	}, '');
	

	$('#admin_form').validate(
	{
        errorElement: 'label', //default input error message container
        errorClass: 'help-inline', // default input error message class
        focusInvalid: true, // do not focus the last invalid input
		onkeyup: false,
       	rules: {
       		username:
       		{
       			required:true,
       			stripids:true
       		}
        },

        messages: 
        {
        	username:
            {
                required: "Please enter User ID(s)"
            }
        },
    	highlight: function (element) { // hightlight error inputs
            $(element).closest('.form-group').removeClass("has-success").addClass('has-error'); // set error class to the control group   
        },
        success: function (label, element) {
            $(element).closest('.form-group').removeClass('has-error').addClass('has-success');
			label.remove();
        },

        errorPlacement: function (error, element) { // render error placement for each input type
			error.addClass('help-small no-left-padding').insertAfter(element);
        }
    });
	
});
</script>
