<link href="<?PHP echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/datatables_1_10_5/media/css/dataTables.bootstrap.css" rel="stylesheet" type="text/css"/>
<input class="current-browser-title" data-title=" User Dashboard | My Support Tickets" type="hidden">
<style type="text/css">
    @media only screen and (min-width: 992px) and (max-width: 1450px){
        .buttons{
            padding: 29px 0px 6px 0px;
        }
    }
</style>
<?PHP echo $this->general_model->help_link(); ?>
<h3 class="page-title">
My Support Tickets
<?PHP $this->load->view("techsupport/user/nav_buttons"); ?>
</h3>
<div class="page-bar">
    <ul class="page-breadcrumb">
        <li>
            <i class="fa fa-home"></i>
            <a href="/myaccount">Dashboard</a>
            <i class="fa fa-angle-right"></i>
        </li>
        <li>
            My Support Tickets
        </li>
    </ul>
</div>
     
<div class="row-fluid">
<?PHP
if($this->session->flashdata("techsupport_error"))
{
    ?>
    <div class="alert alert-danger">
        <button class="close" data-dismiss="alert"></button>
        <strong>Invalid Request</strong>
    </div>
    <?PHP
}
?>
<div class="alert alert-info">
    <strong>Only active support tickets are displayed here. To view closed support tickets, please apply the filters accordingly.</strong>
</div>

    <form action="" method="get" name="list_of_mes" style="margin:0px;" onsubmit="return false"
        class="form-horizontal row search_form">
        <div class="col-md-2">
            <select id="fstatus" onChange="search(1)" class="form-control input-inline custom-input">
                <option value="">All Messages (Except Closed)</option>
                <option value="1">Open Messages</option>
                <option value="2">Waiting Admin Messages</option>
                <option value="3">Waiting User Messages</option>
                <option value="4">Closed Messages</option>
            </select>
        </div>
        <div class="col-md-2">
            <select id="purpose" onChange="search(1)" class="form-control input-inline custom-input">
                <option value="">All Purposes</option>
                <?PHP
                foreach ($this->purposeArray as $key => $purpose)
                {
                    ?>
                    <option value="<?PHP echo $key; ?>"><?PHP echo $purpose; ?></option>
                    <?PHP
                }
                ?>
            </select>
        </div>
        <br style="clear:both;" class="hidden-sm hidden-xs">

        <div class="col-md-2">
            <input type="text" name="search_text" id="search_text" placeholder="Type keyword to search..."
            class="input-inline form-control custom-input" />
        </div>
        <div class="col-md-2">
            <select name="search_col" id="search_col" class=" input-inline form-control custom-input">
                <option value="techsupport_id">TechSupport ID</option>
                <option value="content">TechSupport Request</option>
            </select>
        </div>
        <div class="col-md-2" style="display:none">
            <select name="wild" id="wild" class="input-inline form-control custom-input">
                <option value="contains">Contains</option>
                <option value="starts">Starts with</option>
                <option value="ends">Ends with</option>
            </select>
        </div>
        <div class="col-md-2">
            
            <input type="text" class="datepickerclass form-control input-inline custom-input"  name="from_date" id="from_date"
            placeholder="From date"/>
        </div>
        <div class="col-md-2">
            <input type="text" class="datepickerclass form-control input-inline custom-input"  name="to_date" id="to_date"
            placeholder="To date" />
        </div>
        <div class="buttons">
            <button type="button" id="searchButton" class="btn btn-xs blue searchButton"
            onClick="search(0)"><i class="fa fa-search"></i> Search</button>
            <a class="btn btn-xs red" id="searchClear" onClick="search_clear()"
            style="display:none;"><i class="fa fa-search-minus"></i> Clear</a>
            <!-- <button type="button" id="excelButton" class="btn btn-xs green excelButton" ><i class="fa fa-file-excel-o"></i></button> -->
        </div>
    </form>
    <br class="hidden-lg hidden-md">
    <div class="portlet box blue">
        <div class="portlet-title">
            <div class="caption"> <i class="fa fa-list"></i> My Support Tickets
            <span id="total_records"></span></div>
            <div class="tools">
                <a href="javascript:;" class="collapse"></a>
            </div>
        </div>
        
        <div class="portlet-body no-more-tables">
            
            <table id="fbtable" class="display table-bordered table-condensed table table-striped table-hover" cellspacing="0" width="100%" >
                <thead>
                    <tr>
                        <th>S. No.</th>
                        <th>TechSupport ID</th>
                        <th>Purpose</th>
                        <th>Request</th>
                        <th>Date</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                
            </table>
        
            <div style="clear:both;"></div>
        </div>
    </div>

</div>
<script src="<?PHP echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/datatables_1_10_5/media/js/jquery.dataTables.js" type="text/javascript"></script>
<script src="<?PHP echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/datatables_1_10_5/media/js/dataTables_custom.js" type="text/javascript"></script>
<script type="text/javascript">
var from_date = '';
var to_date = '';
var search_text = '';
var search_col = '';
var wild = '';
var fstatus='';
var table = '';
var purpose='';
function applyFilter(ele) 
{
    table.fnDraw();
}
function search(flag) 
{
    clearNotifications();
    if(!$("#from_date").length || !$("#to_date").length || !$("#search_text").length || !$("#search_col").length ||
            !$("#wild").length)
    {
        showNotification("ruby","Something wrong, please refresh the page and try again.");
        return;
    }
    if (flag == 0)
    {
        if ($("#from_date").length && $("#to_date").length && $("#search_text").length && 
            $("#from_date").val().trim() == '' && $("#to_date").val().trim() == '' && $("#search_text").val().trim() == '') 
        {
            showNotification('ruby','Please enter search keywords or select dates');
            return false;
        }
        if($("#from_date").length && $("#to_date").length && $('#from_date').val().trim()!='' && $('#to_date').val().trim()!='')
        {
            var frm=Date.parse($("#from_date").val());
            var to=Date.parse($("#to_date").val());
            if(frm>to)
            {
                showNotification('ruby','From date cannot be after To date');
                return false
            }
        }
    }
    $(".dataTables_processing").show();
    if($("#from_date").length)
        from_date = $("#from_date").val().trim();
    if($("#to_date").length)
        to_date = $("#to_date").val().trim();
    if($("#search_text").length)
        search_text = $("#search_text").val().trim();
    if($("#search_col").length)
        search_col = $("#search_col").val().trim();
    if($("#wild").length)
        wild = $("#wild").val().trim();
    if (from_date != '' || to_date != '' || search_text != '')
        $("#searchClear").css("display", "inline-block");
    if($("#purpose").length)
        purpose = $("#purpose").val();
    fstatus=$("#fstatus").val();
    
    table.fnDraw();
}
function search_clear() 
{
    $(".dataTables_processing").show();
    $("#from_date").val('');
    from_date = '';
    $("#to_date").val('');
    to_date = '';
    $("#search_text").val('');
    search_text = '';
    search_col = '';
    wild = '';
    $("#fstatus").val('');
    fstatus='';
    purpose='';
    $("#purpose").val('');
    $("#searchClear").css("display", "none");
    table.fnDraw();
}
var statusflag=0;
function changeStatus(id, status)
{
    if(statusflag==1)
        return false;
    statusflag=1;
    $(".dataTables_processing").show();
    $.post('/mytechsupport/changestatus/' + id + '/' + status, {}, function(res) 
    {
        if(res=='login')
        {
            window.location="<?PHP echo base_url; ?>"
        }
        if(res=='access_denied')
        {
            showNotification('ruby',"Access Denied");
            $(".dataTables_processing").hide();
            if (status == 4) 
            {
                $("#fb" + id).modal('toggle');
            }
            statusflag=0;
            return;
        }
        var r = $.parseJSON(res);
        $(".dataTables_processing").hide();
        if (r.flag == 1)
        {
            table.fnSettings.bResetDisplay  =false;
            table.fnDraw(table.fnSettings);
            showNotification(r.message.color, "Tech Support Message '" + r.data.techsupport_id + "' " + r.message.info);
        }
        else
        {
            showNotification("ruby", "Something went wrong. Please try again.");
        }
        if (status == 4) 
        {
            $("#fb" + id).modal('toggle');
        }
        statusflag=0;
    });
}
$(document).ready(function()
{
    $("#search_text").val('');
    $("#from_date").val('');
    $("#to_date").val('');
    $("#wild").val($("#wild option:first").val());
    $("#search_col").val($("#search_col option:first").val());
    $("#fstatus").val('');
    $("#purpose").val($("#purpose option:first").val());
    table = $('#fbtable').dataTable(
    {
        "processing": true,
        "language": {
            "sProcessing": '<div class="spinnerspin"></div>',
            "emptyTable": "No records found!"
        },
        "sDom": "l<'custom-clear visible-xs'>ptr<'clearfix'>p",
        "sPaginationType": "bootstrap",
        "serverSide": true,
        "order": [
            [1, "desc"]
        ],
        "responsive": true,
        "lengthMenu": [
            [10, 20],
            [10, 20]
        ],
        "iDisplayLength": 20,
        "drawCallback": function(settings) 
        {
            var api = this.api();
            var totalrows = api.rows({
                page: 'current'
            }).data().context[0]._iRecordsTotal;
            $("#total_records").html('(' + totalrows + ')');
            $('.tooltips').tooltip();
            $("#checkall").prop('checked', false);
        },
        "columns": [
        {
            "width": "7%",
            "orderable": false
        }, {
            name: "techsupport_id",
            "width": "15%",
            "orderable": true
        }, {
            name: "purpose",
            "width": "10%",
            "orderable": false
        }, {
            name: "message",
            "orderable": false
        }, {
            name: "date",
            "width": "12%",
            "orderable": true
        }, {
            width: "7%",
            "orderable": false
        }],
        "ajax": {
            url: '/mytechsupport/listmessages',
            type: 'POST',
            data: function(d) 
            {
                if (from_date != '')
                    d.from_date = from_date;
                if (to_date != '')
                    d.to_date = to_date;
                if (search_text != '')
                    d.search_text = search_text;
                d.search_col = search_col;
                d.wild = wild;
                d.fstatus=fstatus;
                d.purpose=purpose;
            },
            error: function (xhr, error, thrown) 
            {
                if(xhr.responseText=='login')
                {
                    window.location="<?PHP echo base_url; ?>"
                }
                else if(xhr.responseText==404 || xhr.responseText=='404' || xhr.responseText=='0')
                {
                   showNotification('ruby',"Invalid request");
                }
                $(".dataTables_processing").hide();
                return false;
            },
            dataSrc:function(res)
            {
                if(res.data.length==0 && res.recordsTotal!=0)
                {
                    table.fnDraw();
                }
                return res.data;
            }
        },
        "fnRowCallback": function(nRow, aData, iDisplayIndex, iDisplayIndexFull) {
            var vis = true;
            var ii = 0;
            var sno = 0;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "S. No.");
                ii++;
            }
            sno++;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "Support ID");
                ii++;
            }
            sno++;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "Purpose");
                ii++;
            }
            sno++;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "Message");
                ii++;
            }
            sno++;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "Date");
                ii++;
            }
            sno++;
            if (this.api().column(sno).visible())
                $('td:eq(' + ii + ')', nRow).attr('data-title', "Actions");
            return nRow;
        },
        "columnDefs": [
        {
            "render": function(data, type, row) 
            {
                return row.sno;
            },
            "targets": 0
        }, {
            "render": function(data, type, row) 
            {
                var str = '';
                str += "<a href='/mytechsupport/view/" + row.id + "' target='_blank'>"+row.techsupport_id + '</a><br>';
                if(row.fstatus==1)
                    str+="<span class='custom-label green'>Open</span>";
                else if(row.fstatus==2)
                    str+="<span class='custom-label darkblue'>Waiting Admin</span>";
                else if(row.fstatus==3)
                    str+="<span class='custom-label yellow'>Waiting User</span>";
                else if(row.fstatus==4)
                    str+="<span class='custom-label darkred'>Closed</span>";

                if(row.admin ==1)
                {
                    str+="<br><span style='margin-top:5px;' class='custom-label purple'>Created by Admin</span>";
                }
                return str;
            },
            "targets": 1
        }, {
            "render": function(data, type, row)
            {
                return row.purpose;
            },
            "targets": 2
        }, {
            "render": function(data, type, row)
            {
                return row.content;
            },
            "targets": 3
        }, 
        {
            "render": function(data, type, row)
            {
                return row.date;
            },
            "targets": 4
        },
        {
            "render": function(data, type, row) 
            {
                var str = '<div class="btn-group" id="actions' + row.id + '">' +
                            '<a class="btn red btn-xs" href="#" data-toggle="dropdown"> Actions ' +
                            '<i class="fa fa-angle-down"></i></a>' +
                            '<ul class="dropdown-menu pull-right" style="text-align:left;">' +
                            '<li><a href="/mytechsupport/view/' + row.id + '" target="_blank"><i class="fa fa-eye"></i> View</a></li>';
                
                if(row.fstatus!=4)
                {
                    str += '<li><a href="#fb' + row.id + '" role="button" data-toggle="modal">' +
                    '<i class="fa fa-ban"></i> Close</a></li>' +

                    '<div id="fb' + row.id + '" class="modal fade" tabindex="-1">' +
                    '<div class="modal-header">' +
                    '<button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>' +
                    '<h4 class="modal-title">Close Confirmation</h4>' +
                    '</div>' +
                    '<div class="modal-body"><div class="pull-left delete-confirmation-icon"' +
                    '><i class="fa fa-exclamation-triangle"></i></div>' +
                    'Do you really want to close the Tech Support Message: ' +
                    '<span style="color:red; font-weight:bold;">' + row.techsupport_id + '</span>?' +
                    '</div>' +
                    '<div class="modal-footer">' +
                    '<button type="button" data-dismiss="modal" class="btn btn-xs close' + row.id + '">' +
                    '<i class="fa fa-remove"></i> Cancel</button>' +
                    '<a onClick="changeStatus(' + row.id + ',4)" class="btn btn-xs red">' +
                    '<i class="fa fa-ban"></i> Close</a>' +
                    '</div>' +
                    '</div>';
                }
                return str;
            },
            "targets": 5
        }
        ]
    });
});
$("#excelButton").on("click",function()
{
    var sortindex=table.fnSettings().aaSorting[0][0];
    var order_by=table.fnSettings().aoColumns[sortindex].name;
    var dir=table.fnSettings().aaSorting[0][1];
    $.post('/mytechsupport/listmessages/1',
    {
        from_date:from_date,to_date:to_date,search_text:search_text,wild:wild,search_col:search_col,
        fstatus:fstatus,order_by:order_by,dir:dir
    },
        function(res)
        {
            var r=$.parseJSON(res);
            if(r.flag==1)
            {
                window.location='<?PHP echo base_url; ?>myexcelreports/download/'+r.report_id;
            }
            if(r.flag==2)
            {
                showNotification("ruby","Sorry! You have already requested the same report.");
            }
        }
    );
});
</script>     