<link href="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/datatables_1_10_5/media/css/dataTables.bootstrap.css" rel="stylesheet" type="text/css"/>
<?PHP
$partHeader="Speeches By Category";
?>
<input class="current-browser-title" data-title="<?PHP echo $partHeader; ?>" type="hidden">
<div class="page-content">
	<!-- BEGIN PAGE HEADER-->
	<h3 class="page-title">
        <i class="icomoon-microphone5 subicon"></i>
		<?PHP echo $partHeader; ?>
        <span class="category_name"><?PHP echo $categoryName; ?></span>
		<span id="total_records"></span>
	</h3>
	<div class="page-bar">
		<ul class="page-breadcrumb">
			<li>
				<a href="/">Home</a>
				<i class="fa fa-angle-right"></i>
			</li>
            <?php
            if(isset($ashramData))
            {
                ?>
                <li>
                    <a href="/ashrams">
                        Ashrams
                    </a>
                    <i class="fa fa-angle-right"></i>
                </li>
                <li>
                    <a href="<?PHP echo base_url; ?>ashrams/<?PHP  echo $ashramData->slug; ?>">
                        <?PHP echo word_limiter(htmlentities($ashramData->name),4); ?>
                    </a>
                    <i class="fa fa-angle-right"></i>
                </li>
                <li>
                    <a href="/ashrams/<?PHP  echo $ashramData->slug; ?>/speeches">
                        Speeches By Category
                    </a>
                    <i class="fa fa-angle-right"></i>
                </li>
                <?php
            }
            else
            {
            ?>
    			<li>
    				<a href="/speeches/category">
    					Speeches By Category
    				</a>
    				<i class="fa fa-angle-right"></i>
    			</li>
                <?php
            }
            ?>
			<li class="active category_name">
            <?PHP
                echo $categoryName;
            ?>
            </li>
		</ul>
	</div>
	<!-- END PAGE HEADER-->
	<div class="row">
		<div class="col-md-12 margin-bottom-20">
			Categories:
        	<select name="category" id="category">
        		<option value="" data-title="All Categories" data-slug="">All Categories</option>
        		<?PHP
                $this->categories_model->buildCategoryDropdown(0,1,$categoryId,true,array(),'id',false);
                ?>
        	</select>
		</div>
	</div>

	<div class="row">
		<div class="col-md-12 no-more-tables">
			<table id="listtable" class="display table-bordered table-condensed table table-striped" cellspacing="0" width="100%" >
                <thead>
                    <tr>
                        <th>S. No.</th>
                        <th>Speeches in "<?PHP echo $categoryName; ?>"</th>
                    </tr>
                </thead>
                
            </table>
		</div>
	</div>
	<div class="clearfix">
	</div>
</div>
<script src="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/datatables_1_10_5/media/js/jquery.dataTables.js" type="text/javascript"></script>
<script src="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/datatables_1_10_5/media/js/dataTables_custom.js" type="text/javascript"></script>
<script type="text/javascript">
$("#category").on("change",function()
{
	category=$(this).val();
    $(".category_name").html($("#category :selected").attr("data-title"));
    <?php
        if(isset($ashramData))
        {
            ?>
            var ashramSlug = "<?PHP  echo $ashramData->slug; ?>";
            window.history.replaceState('obj', '', '/ashrams/'+ashramSlug+'/speechescategory/'+$("#category :selected").attr("data-slug"));
            <?php
        }
        else
        {
            ?>
            window.history.replaceState('obj', '', '/speeches/category/'+$("#category :selected").attr("data-slug"));
        <?php
        }
    ?>
	table.fnDraw();
});
<?php
    if(isset($ashramData))
    {
        ?>
        var postUrl = '/ashrams/listbyspeechescategory/<?php echo $ashramData->id;?>';
        var catlink = '<?PHP echo base_url; ?>ashrams/<?php echo $ashramData->slug;?>/speeches/';
        <?php
    }
    else
    {
        ?>
        var postUrl = '/speeches/listbycategory';
        var catlink = '<?PHP echo base_url; ?>speeches/';
    <?php
    }
?>
var table='';
var category='<?PHP echo $category; ?>';
table = $('#listtable').dataTable(
		{
            "processing": true,
            "language": {
                "sProcessing": '<div class="spinnerspin"></div>',
                "emptyTable": "No records found!"
            },
            "sDom": "l<'custom-clear visible-xs'>ptr<'clearfix'>p",
            "sPaginationType": "bootstrap",
            "serverSide": true,
            "order": [
                [1, "asc"]
            ],
            "responsive": true,
            "lengthMenu": [
                [10, 20],
                [10, 20]
            ],
            "drawCallback": function(settings) 
            {
                var api = this.api();
                var totalrows = api.rows({
                    page: 'current'
                }).data().context[0]._iRecordsTotal;
                $("#total_records").html('(' + totalrows + ')');
                $('.tooltips').tooltip();
            },
            "columns": [
            {
                "width": "5%",
                "orderable": false
            }, {
                "orderable": false
            }],
            "ajax": {
                url: postUrl,
                type: 'POST',
                data: function(d) 
                {
                    d.category = category;
                },
                error: function (xhr, error, thrown) 
                {
                    $(".dataTables_processing").hide();
                    return false;
                }
            },
            "fnRowCallback": function(nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                var vis = true;
                var ii = 0;
                var sno = 0;

                if (this.api().column(sno).visible()) {
                    $('td:eq(' + ii + ')', nRow).attr('data-title', "S. No.");
                    ii++;
                }
                sno++;
                if (this.api().column(sno).visible()) {
                    $('td:eq(' + ii + ')', nRow).attr('data-title', 'Speeches in "<?PHP echo $categoryName; ?>"');
                    ii++;
                }
               
                return nRow;
            },
            "columnDefs": [
            {
                "render": function(data, type, row) {
                    return row.sno;
                },
                "targets": 0
            }, {
                "render": function(data, type, row) 
                {
                    var str = '<a href="'+catlink+''+row.year+'/'+row.month+'/'+row.day+'/'+row.slug+'" target="_blank"\
                    style="text-decoration:none;">'+row.name + '</a>';
                    return str;
                },
                "targets": 1
            }]
        });
</script>