<link href="<?php echo base_url . theme_folder_name; ?>/global/plugins/datatables_1_10_5/media/css/dataTables.bootstrap.css" rel="stylesheet" type="text/css"/>
<style type="text/css">
	.btn-xs {
    padding: 8px 10px;
    height: 35px;
    margin-bottom: 3px;
    margin-top: 1px;
}.required{
	color:red;
}
.btn-primary.active {
  background-color: #E02222 !important;
}
.btn-primary.inactive {
  background-color: #2d6ca2 !important;
}
#email-error{
    color: #a94442;
    font-weight: bold;
}
.al{
    text-align: left;
}
.language-link{
    font-weight: bold;
    font-size: 20px;
}
.listrw{
    margin-bottom: 30px;
    border: 1px solid #e1e1e1;
    padding: 10px 10px 0 10px;
    float: left;
}
.image-col{
    float: left;
    width: 300px;
    height: 300px;
    overflow: hidden;
}
.image-col img{
    width: 300px;
}
.desc-col{
    float: left;
    width: calc(100% - 300px);
    padding: 0 0px 0px 25px;
    height: 370px;
    overflow: hidden;
}
.desc-col span{
    padding-bottom: 2px;
    float: left;
    width: 100%;
}
.mainselectbx{
    padding: 5px;
    font-size: 18px;
    margin-bottom: 20px;
    background: #bce8f1;
    border: 1px solid #c2c2c2;
    float: left;
    width: 100%;
}
@media only screen and (min-width:960px){
    /* styles for browsers larger than 960px; */
    .shukavana-text-box{
        width:400px;
    }

    .language-margin{
        margin-right: 150px;
    }
}
@media only screen and (min-device-width: 768px) and (max-device-width: 1280px) {
    .image-col{
        width: 200px;
        height: 200px;
    }
    .image-col img{
        width: 100%;
    }
    .desc-col{
        width: calc(100% - 200px);
        height: 340px;
        overflow: hidden;
    }
}
@media only screen and (min-device-width: 990px) and (max-device-width: 1100px) {
    .desc-col{
        height: 490px !important;
        overflow: hidden;
    }
}

@media only screen and (max-device-width:650px){
    .image-col{
        width: 100%;
        height: auto;
    }
    .image-col img{
        width: 100%;
    }
    .desc-col{
        width: 100%;
        padding: 10px 0 0 0;
    }
}
            
@media only screen and (max-device-width:480px){
    .shukavana-text-box{
        width:100% !important;
    }

    .language-margin{
        margin-right: -15px !important;
        margin-top: 15px !important;
    }
    .desc-col{
        height: auto;
    }
}

@media only screen and (min-device-width: 481px) and (max-device-width: 1024px) and (orientation:portrait) {
    .shukavana-text-box{
        width:100% !important;
    }
}

@media only screen and (max-device-width:480px){
    .shukavana-text-box{
        width:100% !important;
    }
}
input, textarea {background-color: #fff; border: 1px solid #ddd; outline: none; height: 32px; width: 235px; margin-left: 65px; padding: 8px 10px; margin: 0; } table{ text-align: center; } th { text-align: center; }td{width:auto;}
</style>
<input class="current-browser-title" data-title="Shukavana Voting" type="hidden">
<div class="page-content">
	<!-- BEGIN PAGE HEADER-->
    <h3 class="page-title">Voting for Top Ten Birds of Shuka Vana ~ Oct 2022</h3>
    <div class="page-bar">
        <ul class="page-breadcrumb">
            <li>
                <a href="<?PHP echo base_url; ?>">Home</a>
                <i class="fa fa-angle-right"></i>
            </li>
            <li class="active">
                Voting for Top Ten Birds of Shuka Vana, Mysore, India ~ Oct 2022
            </li>
        </ul>
    </div>
    <div class="alert alert-info">
        You can vote for the Top Ten Birds of Shuka Vana (Oct 2022) here. There are 10 Parrots in the list.<br>
        * Each Parrot photo has description and ranking number.<br>
        * Please select the ranking number in the drop down menu.<br>
        * After you rank your preference for the Top ten birds out of 10 choices, kindly enter your Name, Email, Country and VOTE !!<br><br>
        <B> Voting closes at 10 AM IST on 5th Oct 2022 and results would be the announced by Sri Swamiji on the same day.</B>
    </div>
	
	<!-- <div class="page-bar">        
        <div class='col-md-3 pull-right' style="text-align: right;">
            <span class="glyphicon glyphicon-globe">&nbsp;</span><a href="<?php //echo base_url('shukavana/voting'); ?>" class='language-link' style="color: black;">English</a>&nbsp;
			<span style='color:gray;'>|</span>&nbsp;<a href="<?php //echo base_url('shukavana/voting?lang=kn'); ?>" class='language-link' style="color: red;">Kannada</a>&nbsp;
			<span style='color:gray;'>|</span>&nbsp;<a href="<?php //echo base_url('shukavana/voting?lang=te'); ?>" class='language-link' style="color: blue;">Telugu</a>
        </div>
    </div> -->
    <?PHP
    if($this->session->flashdata("message"))
    {
        ?>
        <div class="alert alert-success">
            <button class="close" data-dismiss="alert"></button>
            <strong>Thank you for your vote</strong>
        </div>
        <?PHP
    }
    if($this->session->flashdata("error_message"))
    {
        ?>
        <div class="alert alert-danger">
            <button class="close" data-dismiss="alert"></button>
            <strong>Sorry, you have already voted</strong>
        </div>
        <?PHP
    }
    ?>
    <div class="alert alert-danger hide" id="votes-error">
        <button class="close" data-dismiss="alert"></button>
        <strong>Please vote for top 10 birds.</strong>
    </div>
    <form method="post" action="<?php echo base_url.'shukavana/voting';?>" class="voting-form">
	<div class="row">
        <div class="col-md-12" style="padding:0;">
            <?php 
            $count = 1;
            foreach($pets as $key => $pet)
            {
                $colorcode = "#FFF"; 
                if($count%2==0)
                    $colorcode = "#F5F5F5"; 
            ?>
            <div class="col-md-6">
                <div class="col-md-12 listrw">
                    <div class="image-col">
                        <image src="<?php echo $pet['path'] ?>"></image>
                    </div>
                    <div class="desc-col">
                        <div class="col-md-12 btn-group mainselectbx" data-toggle="buttons">
                            <span style='font-weight: bold;width: auto;'>Select your vote :</span> 
                            <select id="petmain<?php echo $pet['id'] ?>" name="pet<?php echo $pet['id'] ?>" class="shukavana-pet pet<?php echo $pet['id'] ?> pull-right" rel='<?php echo $pet['id'] ?>' style="margin-left: 10px;">
                            <?php for($i=0; $i<=10; $i++){ ?> 
                                <option id="pet_<?php echo $pet['id'] ?>_<?php echo $i ?>" class="option_<?php echo $i ?>" name="pet_<?php echo $pet['id'] ?>" value="<?php echo $i ?>"><?php echo $i ?></option>
                            <?php } ?>
                            </select>
                        </div>
                        <?PHP
                        if(isset($pet['name']) && $pet['name']!="")
                        {
                            ?>
                            <span style='font-weight: bold;'><?php echo $pet['name'] ?></span>
                            <?PHP
                        }
                        ?>
                        <?PHP
                        if(isset($pet['pet_name']) && $pet['pet_name']!="")
                        {
                            ?>
                            <span style='font-weight: bold;'><?php echo $pet['pet_name'] ?></span>
                            <?PHP
                        }
                        ?>
                        <?PHP
                        if(isset($pet['date_birth']) && $pet['date_birth']!="")
                        {
                            ?>
                            <span style='font-weight: bold;'><?php echo $pet['date_birth'] ?></span>
                            <?PHP
                        }
                        ?>
                        <?PHP
                        if(isset($pet['native']) && $pet['native']!="")
                        {
                            ?>
                            <span style='font-weight: bold;'><?php echo $pet['native'] ?></span>
                            <?PHP
                        }
                        ?>
                        <?PHP
                        if(isset($pet['about']) && $pet['about']!="")
                        {
                            ?>
                            <span style='margin-bottom: 10px;'><?php echo $pet['about'] ?></span>
                            <?PHP
                        }
                        ?>
                    </div>
                </div>
            </div>
            <?PHP
            }
            ?>
        </div>
        <div class="clearfix"></div>

		<div class="col-md-4">
            <div class='row' style="margin: 0px 5px 0px 5px;">
                <div class="form-group">
                    <label class="control-label">Name <span class="required" aria-required="true">*</span></label>
                    <input class=" form-control placeholder-no-fix" type="text" autocomplete="off" placeholder="Name" name="user_name">
                </div>

                <div class="form-group">
                    <label class="control-label">Email <span class="required" aria-required="true">*</span></label>
                    <input class=" form-control placeholder-no-fix" type="text" autocomplete="off" placeholder="Email" name="user_email" id="user_email">
                    <span id="email-error" class="help-block help-block-error help-small no-left-padding hide"></span>
                </div>

                <div class="form-group">
                    <label class="control-label">Country <span class="required" aria-required="true">*</span></label>
                    <select name="user_country" class="form-control ">
                        <option value="">Select</option>
                            <?PHP
                            foreach($country as $value) 
                            {
                                echo '<option value="'.$value->country_code.'">'.
                                $value->country_name.' +'.$value->isd_code.'</option>';
                            }
                            ?>
                    </select>
                </div>

                <div class='form-actions'>
                    <button type="submit" value="Vote" class="btn blue btn-xs pull-left" id="voting-submit"><i class="fa fa-check"></i> Submit Vote</button>
                </div>
            </div>
		</div>
    </div>
    </form>
	</div>
	<!-- END PAGE HEADER-->
	<div class="clearfix">
	</div>
</div>
<script type="text/javascript">
</script>
<script>
$(document).ready(function()
{
    var count = 0;
    localStorage.clear();
    $('.voting-form').validate(
    {
        errorElement: 'span', //default input error message container
        errorClass: 'help-block help-block-error', // default input error message class
        focusInvalid: true, // do not focus the last invalid input
        rules: {
            user_name: {
                required: true
            },
            user_email: {
                required: true,
                email_validate:true
            },
            user_country: {
                required: true
            },
        },
        messages: {
            user_name: {
                required: "Please enter Name"
            },
            user_email: {
                required: "Please enter Email"
            },
            user_country: {
                required: "Please select Country"
            }
        },
        highlight: function(element)
        {
            $(element).closest('.form-group').addClass('has-error');
        },
        success: function(label)
        {
            label.closest('.form-group').removeClass('has-error');
            label.remove();
        },
        errorPlacement: function(error, element)
        {
            error.insertAfter(element);
            error.addClass('help-small no-left-padding').insertAfter(element);
        },
        submitHandler:function(form)
        {
            $(".loader_animation").show();
            $("#voting-submit").prop("disabled",true);
            form.submit();
        }
    });

    $('.shukavana-pet').change(function(){
        var petId = $(this).attr('rel');
        var option = $(this).find(":selected").text();
        var petData = localStorage.getItem(petId);
        
        if(option!=0){
            if(petData!=null && petData!==option){
                $('.option_'+petData).remove();
                for(var i=1;i<=16;i++){
                    $('#petmain'+i).append($("<option></option>").attr('id','pet_'+i+'_'+petData).addClass('option_'+petData).attr('name','pet_'+i).attr("value",petData).text(petData)); 
                }
                //$('#pet_'+i+'_'+petData).remove();
                count = count-1;
            }

            //console.log("select option[value="+option+"]");
            $("select option[value="+option+"]").remove();
            localStorage.setItem(petId, option);
            $('#petmain'+petId).append($("<option></option>").attr('id','pet_'+petId+'_'+option).addClass('option_'+option).attr('name','pet_'+petId).attr("value",option).attr('selected','selected').text(option)); 

            count++;
            localStorage.setItem("count", count);
        }else{
            count = count-1;
            //console.log('Remvoing :: #pet_'+petId+'_'+petData);
            $('#pet_'+petId+'_'+petData).remove();
            for(var i=1;i<=16;i++){
                $('#petmain'+i).append($("<option></option>").attr('id','pet_'+i+'_'+petData).addClass('option_'+petData).attr('name','pet_'+i).attr("value",petData).text(petData)); 
            }
            localStorage.setItem("count", count);
            localStorage.removeItem(petId);
        }
    });

    $('#user_email').blur(function() {
        $("#voting-submit").prop("disabled",false);
        $("#email-error").html('').addClass('hide');
        $.post('/shukavana/checkemail',{email:this.value}, function(res){
            if(res==1){
                $("#email-error").html('You have already voted!').removeClass('hide');
                $("#voting-submit").prop("disabled",true);
            }
        });
    });

    $('#voting-submit').click(function() {
        var votesCount = localStorage.getItem('count');
        $('.option_0').attr('disabled',false);
        if(votesCount==null || votesCount < 10){
            $("#votes-error").removeClass('hide');
            Metronic.scrollTo($('.page-title'));
            return false;
        }
        else{
            $("#votes-error").addClass('hide');
        }
        return true;
    });

});

</script>