<!DOCTYPE html>
<html>
    <head>
        <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
        <meta content="width=device-width, initial-scale=1.0" name="viewport" />
        <title><?PHP echo site_name_string1; ?> | Donation Sevas</title>
        <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css">
        <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>
        <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/js/bootstrap.min.js"></script>
        <link href="<?php echo base_url."site_theme"; ?>/admin_fonts/google-css-open-sans.css" rel="stylesheet">
        <link href="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/datatables_1_10_5/media/css/dataTables.bootstrap.css" rel="stylesheet" type="text/css"/>
        <link rel="stylesheet" href="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/responsive.min.css">
        <link href="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/font-awesome/css/font-awesome.min.css" rel="stylesheet" type="text/css"/>
        <link href="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/bootstrap-datepicker/css/datepicker.css" rel="stylesheet" type="text/css" />
        <link rel="stylesheet" type="text/css" href="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/bootstrap-select/bootstrap-select.min.css"/>
        <link rel="stylesheet" type="text/css" href="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/select2/select2.css"/>
        <link rel="stylesheet" type="text/css" href="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/jquery-multi-select/css/multi-select.css"/>
        <link href="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/admin/layout/css/custom.css" rel="stylesheet" type="text/css"/>
        <link href="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/css/components.css" rel="stylesheet" type="text/css"/>
        <link rel="stylesheet" type="text/css" href="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/jquery-notific8/jquery.notific8.min.css"/>
        <link href="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/admin/layout/css/layout.css" rel="stylesheet" type="text/css"/>
        <style type="text/css">
            .fixedheaderform
            {
                position: fixed;
                width: 100%;
                background: #fff;
                z-index: 9999;
            }
            .listRowContainer
            {
                margin-top: 175px;
            }
            .searchFormButton
            {
                margin-top: 15px;
                font-size: 14px;
                font-weight: bold;
                margin-right: 20px;
            }
            .searchFormRow
            {
                margin-top: 15px;
                padding-left: 0;
            }
            .searchFormRow input
            {
                font-size: 16px !important;
                padding-left: 5px !important;
                width: 100%;
            }
            .searchFormRow select
            {
                font-size: 16px !important;
                padding-left: 5px !important;
                width: 100%;
            }

            @media screen and (max-width:992px)
            {
                .fixedheaderform
                {
                    position: relative;
                }
                .listRowContainer
                {
                    margin-top: 20px;
                }
            }

            @media only screen and (min-width: 992px) and (max-width: 1110px)
            {
                .listRowContainer {
                  margin-top: 175px;
                }
            }
        </style>
    </head>
    <body>
        <div class="container">

            <div class="row-fluid fixedheaderform">
                <h3 class="page-title" style="margin-top: 5px;font-weight: bold;">
                    Shodasha Datta Kshetra Pada Yatra - Total steps count: <span id="total_steps"></span>
                </h3>
                <form action="" method="get" style="margin:0px;" onsubmit="return false" class="form-horizontal row search_form">
                    <div class="col-md-2 searchFormRow">
                        <select name="country" onChange="search(1)" id="country" class=" input-inline form-control custom-input">
                            <option value="">All Countries</option>
                            <?PHP
                                $countriesList=$this->locations_model->getCountries();
                                foreach ($countriesList as $countryData)
                                {
                                    if(isset($yatraCountryCodes) && is_array($yatraCountryCodes) && in_array($countryData->country_code, $yatraCountryCodes))
                                    {
                                        ?>
                                        <option value="<?PHP echo $countryData->country_code; ?>">
                                        <?PHP echo $countryData->country_name." +".$countryData->isd_code; ?></option>
                                        <?PHP
                                    }
                                }
                            ?>
                        </select>
                    </div>
                    <br style="clear:both;" class="hidden-sm hidden-xs">
                    <a href="javascript:;" class="btn btn-xs default searchFormButton changeGroupByButton" id="buttonGroupByYatraDate" groupByType="yatra_date">Total Steps by Yatra Date</a>
                    <a href="javascript:;" class="btn btn-xs default searchFormButton changeGroupByButton" id="buttonGroupBySevaName" groupByType="item_name">Total Steps by Seva Name</a>
                    <a href="javascript:;" class="btn btn-xs default searchFormButton changeGroupByButton" id="buttonGroupByYatraDate" groupByType="city">Total Steps by City</a>
                    <a href="javascript:;" class="btn btn-xs default searchFormButton changeGroupByButton" id="buttonGroupByYatraDate" groupByType="country">Total Steps by Country</a>
                    <a href="javascript:;" class="btn btn-xs default searchFormButton changeGroupByButton" id="buttonGroupByYatraDate" groupByType="participant_name">Total Steps by Participant</a>
                    <br style="clear:both;" class="hidden-sm hidden-xs">
                    <div class="col-md-2 searchFormRow">
                        <input type="text" name="search_text" id="search_text" placeholder="Type keyword to search..."
                        class="input-inline form-control custom-input" />
                    </div>
                    <div class="col-md-2 searchFormRow">
                        <select name="search_col" id="search_col" class=" input-inline form-control custom-input">
                            <option value="participant_name">Participant Name</option>
                            <option value="email">Email ID</option>
                            <option value="phone">Phone</option>
                        </select>
                    </div>
                    <div class="col-md-2 searchFormRow">
                        <input type="text" class="datepickerclass form-control input-inline custom-input"  name="from_date" id="from_date"
                        placeholder="From date"/>
                    </div>
                    <div class="col-md-2 searchFormRow">
                        <input type="text" class="datepickerclass form-control input-inline custom-input"  name="to_date" id="to_date"
                        placeholder="To date"/>
                    </div>
                    <div class="buttons">
                        <button type="button" id="searchButton" class="btn btn-xs blue searchButton"
                        onClick="search(0)" style="margin-top: 15px;font-size: 16px;"><i class="fa fa-search"></i> Search</button>
                        <a class="btn btn-xs red" id="searchClear" onClick="search_clear()"
                        style="display:none;margin-top: 15px;font-size: 16px;"><i class="fa fa-search-minus"></i> Clear</a>
                    </div>
                </form>
            </div>
        </div>

        <div class="container listRowContainer">
            <div class="row-fluid">
                <div class="portlet box blue">
                    <div class="portlet-title">
                        <div class="caption"> <i class="fa fa-list"></i> All Shodasha Datta Kshetra Pada Yatra Steps count <span id="total_records"></span></div>
                        <div class="tools">
                            <a href="javascript:;" class="collapse"></a>
                        </div>
                    </div>
                    
                    <div class="portlet-body no-more-tables">
                            <div class="col-md-12 nopadding column-buttons">
                                <a href="javascript:;" data-order="desc" data-column="4" class="sortcolumn btn btn-xs default">Sort by Count <i class="fa fa-arrow-down"></i></a>
                                <a href="javascript:;" data-order="desc" data-column="7" class="sortcolumn btn btn-xs default">Sort by Date <i class="fa fa-arrow-down"></i></a>
                                <a href="javascript:;" data-order="desc" data-column="6" class="sortcolumn btn btn-xs default">Sort by Country <i class="fa fa-arrow-down"></i></a>
                                <a href="javascript:;" data-order="desc" data-column="5" class="sortcolumn btn btn-xs default">Sort by City <i class="fa fa-arrow-down"></i></a>
                                <a href="javascript:;" data-order="desc" data-column="1" class="sortcolumn btn btn-xs default">Sort by Devotee <i class="fa fa-arrow-down"></i></a>
                                <a href="javascript:;" data-order="desc" data-column="2" class="sortcolumn btn btn-xs default">Sort by Participant <i class="fa fa-arrow-down"></i></a>
                                <div class="clearfix visible-xs"></div>
                                <div style="clear:both;"></div>
                            </div>
                            <table id="rtable" class="display table-bordered table-condensed table table-striped table-hover" cellspacing="0" width="100%" >
                                <thead>
                                    <tr>
                                        <th>S. No.</th>
                                        <th>Devotee</th>
                                        <th>Yatra Participant</th>
                                        <th>Seva Name</th>
                                        <th>Steps Count</th>
                                        <th>City</th>
                                        <th>Country</th>
                                        <th>Yatra Date</th>
                                    </tr>
                                </thead>
                                
                            </table>
                        
                        <div style="clear:both;"></div>
                    </div>
                </div>
            </div>
        </div>
    </body>
</html>
<script type="text/javascript">
    var base_url='<?PHP echo base_url(); ?>';
    var theme_folder_name='theme_v361';
    var aws_s3_base_url='<?PHP echo aws_s3_base_url; ?>';
</script>
<script src="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/jquery.min.js" type="text/javascript"></script>
<script src="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/jquery-migrate.min.js" type="text/javascript"></script>
<script src="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/jquery-ui/jquery-ui-1.10.3.custom.min.js" type="text/javascript"></script>
<script src="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/bootstrap/js/bootstrap.min.js" type="text/javascript"></script>
<script src="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/bootstrap-hover-dropdown/bootstrap-hover-dropdown.min.js" type="text/javascript"></script>
<script src="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/pace/pace.js" type="text/javascript"></script>


<script src="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/frontend-2/js/back-to-top.js" type="text/javascript"></script>
<script src="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/bootstrap-touchspin/bootstrap.touchspin.js" type="text/javascript"></script>
<script src="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/jquery-slimscroll/jquery.slimscroll.min.js" type="text/javascript"></script>

<script src="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/bootstrap-datepicker/js/bootstrap-datepicker.js" type="text/javascript"></script>
<script src="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/datatables_1_10_5/media/js/jquery.dataTables.js" type="text/javascript"></script>
<script src="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/datatables_1_10_5/media/js/dataTables_custom.js" type="text/javascript"></script>
<script type="text/javascript" src="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/bootstrap-select/bootstrap-select.min.js"></script>
<script type="text/javascript" src="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/select2/select2.min.js"></script>
<script type="text/javascript" src="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/jquery-multi-select/js/jquery.multi-select.js"></script>
<script src="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/jquery-notific8/jquery.notific8.min.js"></script>
<script type="text/javascript">
var search_text = '';
var search_col = '';
var wild = 'contains';
var table = '';
var purpose='';
var country;
var from_date ='';
var to_date ='';
var group_by='';
var secret_key='<?PHP echo $secret_key; ?>';

function clearNotifications()
{
    $('.jquery-notific8-notification').remove();
}
function showNotification(theme,message)
{
    $.notific8('zindex', 11500);
    $.notific8(message,
    {
        theme:theme,
        sticky: false,
        horizontalEdge:'top',
        verticalEdge:'right',
        life:5000
    });
}
function search(flag) 
{
    clearNotifications();
    if (flag == 0)
    {
        if($('#from_date').val().trim()=='' && $('#to_date').val().trim()=='' && $("#search_text").val().trim() == '') 
        {
            showNotification('ruby','Please enter search keywords');
            return false;
        }
        if($("#from_date").length && $("#to_date").length && $('#from_date').val().trim()!='' && $('#to_date').val().trim()!='')
        {
            var frm=Date.parse($("#from_date").val());
            var to=Date.parse($("#to_date").val());
            if(frm>to)
            {
                showNotification('ruby','From date cannot be after To date');
                return false
            }
        }
    }
    $(".dataTables_processing").show();
    if($("#search_text").length)
        search_text = $("#search_text").val().trim();
    if($("#search_col").length)
        search_col = $("#search_col").val().trim();
    
    if($("#country").length)
        country = $("#country").val().trim();
    if($("#from_date").length)
        from_date = $("#from_date").val().trim();
    if($("#to_date").length)
        to_date = $("#to_date").val().trim();
    
    if (search_text != '' || from_date != '' || to_date != '' || group_by != '' || country != '')
        $("#searchClear").css("display", "inline-block");
    
    table.fnDraw();
}
function search_clear() 
{
    group_by='';
    $(".dataTables_processing").show();
    $("#country").val('');
    country = '';
    $("#from_date").val('');
    from_date = '';
    $("#to_date").val('');
    to_date = '';
    $("#search_text").val('');
    search_text = '';
    search_col = '';
    $("#searchClear").css("display", "none");
    $(".changeGroupByButton").removeClass("blue").addClass("default");
    table.fnDraw();
}

$(document).ready(function()
{
    $(".datepickerclass").datepicker(
    {
        format: 'dd M yyyy',
        defaultDate:''
    });

    $("#search_text").val('');
    $("#country").val($("#country option:first").val());
    $("#search_col").val($("#search_col option:first").val());

    table = $('#rtable').dataTable({
        "processing": true,
        "language": {
            "sProcessing": '<div class="spinnerspin"></div>',
            "emptyTable": "No records found!"
        },
        "sDom": "l<'custom-clear visible-xs'>ptr<'clearfix'>p",
        "sPaginationType": "bootstrap",
        "serverSide": true,
        "iDisplayLength": 100,
        "order": [
            [7, "desc"]
        ],
        "responsive": true,
        "lengthMenu": [
            [20, 50, 100],
            [20, 50, 100]
        ],
        "drawCallback": function(settings) 
        {
            var api = this.api();
            var totalrows = api.rows({
                page: 'current'
            }).data().context[0]._iRecordsTotal;
            $("#total_records").html("("+totalrows+")");
            $('.tooltips').tooltip();
            $("#checkall").prop('checked', false);
            sortIdentify();
        },
        "columns": [
        {
            "width": "6%",
            "orderable": false
        }, {
            name: "name",
            "width": "14%",
            "orderable": false
        }, {
            name: "participant_name",
            "width": "13%",
            "orderable": false
        }, {
            'name':"item_name",
            "width": "10%",
            "orderable": false
        }, {
            name: "steps_count",
            "width": "9%",
            "orderable": true
        }, {
            'name':"city",
            "width": "10%",
            "orderable": false
        }, {
            name: "country",
            "width": "10%",
            "orderable": false
        }, {
            name: "yatra_date",
            width: "10%",
            "orderable": true
        }],
        "ajax": {
            url: '/shodashadattakshetrapadayatraadmin/listPublucResults',
            type: 'POST',
            data: function(d) 
            {
                if (from_date != '')
                    d.from_date = from_date;
                if (to_date != '')
                    d.to_date = to_date;
                if (search_text != '')
                    d.search_text = search_text;
                d.search_col = search_col;
                d.country = country;
                d.wild = wild;
                d.group_by=group_by;
                d.secret_key=secret_key;
            },
            error: function (xhr, error, thrown) 
            {
                if(xhr.responseText=='login')
                {
                    window.location="<?PHP echo base_url; ?>"
                }
                else if(xhr.responseText==404 || xhr.responseText=='404' || xhr.responseText=='0')
                {
                   showNotification('ruby',"Invalid request");
                }
                $(".dataTables_processing").hide();
                return false;
            },
            complete: function (xhr, error, thrown)
            {
                var jdata=$.parseJSON(xhr.responseText);
                $(".loader_animation").hide();
                $("#total_steps").html(jdata.total_steps_count);
                $("#total_submissions").html(jdata.total_submissions);
                if(group_by!="")
                {
                    $("#searchClear").css("display", "inline-block");
                }
            },
            dataSrc:function(res)
            {
                if(res.data.length==0 && res.recordsTotal!=0)
                {
                    table.fnDraw();
                }
                return res.data;
            }
        },
        "fnRowCallback": function(nRow, aData, iDisplayIndex, iDisplayIndexFull) 
        {
            var vis = true;
            var ii = 0;
            var sno = 0;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "S. No.");
                ii++;
            }
            sno++;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "Devotee");
                ii++;
            }
            sno++;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "Yatra Participant");
                ii++;
            }
            sno++;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "Seva Name");
                ii++;
            }
            sno++;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "Steps Count");
                ii++;
            }
            sno++;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "City");
                ii++;
            }
            sno++;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "Country");
                ii++;
            }
            sno++;
            if (this.api().column(sno).visible())
                $('td:eq(' + ii + ')', nRow).attr('data-title', "Yatra Date");
            return nRow;
        },
        "columnDefs": [
        {
            "render": function(data, type, row) {
                return row.sno;
            },
            "targets": 0
        }, {
            "render": function(data, type, row) 
            {
                var str = "";
                str+= "<b>"+row.name;
                str+= "<br>"+row.phone;
                str+= "<br>"+row.email+"</b>";
                return str;
            },
            "targets": 1
        }, {
            "render": function(data, type, row) 
            {
                return '<span style="color:maroon;font-weight:bold;">'+row.participant_name+'</span>';
            },
            "targets": 2
        }, {
            "render": function(data, type, row) 
            {
                var str = row.item_name;
                return str;
            },
            "targets": 3
        }, {
            "render": function(data, type, row) 
            {
                var str='<span style="font-weight:bold;">'+row.steps_count+'</span>';
                return str;
            },
            "targets": 4
        }, {
            "render": function(data, type, row) 
            {
                var str = row.city;
                return str;
            },
            "targets": 5
        }, {
            "render": function(data, type, row) 
            {
                return row.country_name;
            },
            "targets": 6
        }, {
            "render": function(data, type, row) 
            {
                return row.yatra_date;
            },
            "targets": 7
        }]
    });
    $('.columnhide').on('click', function(e) 
    {
        var column = table.api().column( $(this).attr('data-column') );
        var cnum=$(this).attr('data-column');
        
        column.visible( ! column.visible(),true );
        var bVis = table.fnSettings().aoColumns[cnum].bVisible;
        var title = table.fnSettings().aoColumns[cnum].sTitle;
        
        var visibility=table.api().column(cnum).visible();
        table.api().column(cnum).nodes().to$().attr("data-title",title);
        if (visibility == false) 
        {
            $(this).removeClass('blue').addClass('red');
        }
        else 
        {
            $(this).removeClass('red').addClass('blue');
        }
    });
    $(".sortcolumn").on("click",function()
    {
        var currentSort = table.api().rows().context[0].aLastSort[0];   
        var corder=$(this).attr('data-order');
        var cnum=$(this).attr('data-column');
        if(currentSort.col==cnum)
        {
            if(currentSort.dir!=corder)
            {
                table.fnSort([cnum,corder]);
            }
        }
        else
        {
            table.fnSort([cnum,corder]);
        }
        sortIdentify();
    });

    $(".changeGroupByButton").on("click",function()
    {
        var groupByType=$(this).attr('groupByType');
        $(".changeGroupByButton").removeClass("blue").addClass("default");
        $(this).removeClass("default").addClass("blue");

        if(groupByType == '')
        {
            group_by = '';
        }
        else
        {
            group_by = groupByType;
        }
        table.fnDraw();
    });
});
function sortIdentify()
{
    var currentSort = table.api().rows().context[0].aLastSort[0];
    $(".sortcolumn").each(function(i,ele)
    {
        $(this).removeClass("blue").addClass("default");
        var corder=$(this).attr('data-order');
        var cnum=$(this).attr('data-column');
        if(cnum==currentSort.col)
        {
            $(this).removeClass("default").addClass("blue");
            if(currentSort.dir=='desc')
            {
                $(this).attr("data-order","asc");
                $(this).find("i").removeClass("fa-arrow-up").addClass("fa-arrow-down");
            }
            if(currentSort.dir=='asc')
            {
                $(this).attr("data-order","desc");
                $(this).find("i").removeClass("fa-arrow-down").addClass("fa-arrow-up");
            }
        }
    });
}
</script>