<?php
$ashram_name = "Avadhoota Datta Peetham";
if(isset($_GET['ashram_id']) && $_GET['ashram_id']>0)
{
    $ashramData=$this->ashrams_model->ashramData($_GET['ashram_id']);
    $ashram_name = $ashramData->name;
}
ob_start();
$CI =& get_instance();
$CI->load->library('Pdf');
$pdf = new Pdf('P', 'mm', 'A4', false, 'UTF-8', false);
$pdf->SetAuthor($ashram_name);
$pdf->SetTitle('Poojas Seva Karta Report');
$pdfHeader_logo = $_SERVER['DOCUMENT_ROOT']."/homepage_assets/site_".global_site_flag."/front_page_images/dattapeetham_logo.jpg";

$fromdate = '';
$todate = '';
$displayDate = date("d M Y, l");
if($_GET['from_date']!='')
{
    $fromdate = $_GET['from_date'];
}
if($_GET['to_date']!='')
{
    $todate = $_GET['to_date'];
}
if($fromdate == $todate)
{
    $displayDate = $fromdate;
}
else
{
     $displayDate = $fromdate.' to '.$todate;
}
if($fromdate=='' && $todate=='')
{
    $displayDate = date("d M Y, l");
}

// set default header data
$pdf->SetHeaderData("", 0, "Poojas Seva Karta Report", $ashram_name."\n"."Date: ".$displayDate,array(0,0,0), array(255,255,255));
$pdf->setFooterData(array(0,0,0), array(255,255,255));
// set header and footer fonts
$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

// set default monospaced font
$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

// set margins
$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
$pdf->SetTopMargin(26);
$pdf->SetHeaderMargin(12);
$pdf->SetFooterMargin(20);
$pdf->setOpenCell(0);

// set auto page breaks
$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

// set image scale factor
$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
$font_size = $pdf->pixelsToUnits('14');

$pdf->SetFont ('dejavusans', '', '10' , '', 'default', true );
// add a page
$pdf->AddPage();


// create some HTML content

$allpoojas = [];
if(@$reports['data'] && count($reports['data']) > 0)
{
    $allpoojas = array_unique(array_column($reports['data'], 'item_name'));
}
if(count($allpoojas)>0)
{
    foreach($allpoojas as $this_pooja)
    {
        echo 
        $html = '<br><h2 style = "color:black;font-weight:bold;">
           '.rtrim($this_pooja).'
        </h2>';
        $pdf->writeHTML($html, true, false, true, false, '');
        $html = '<br>';
        $pdf->writeHTML($html, true, false, true, false, '');
        $html = '<table class = "mainpoojas" style="border-bottom-color:grey;border-top-color:grey;border-left-color:grey;border-right-color:grey;width:100%; border:1px solid #CCC; margin-left:10px; float: left; border-top-width:0.5px;border-left-width:0.5px;border-right-width:0.5px;border-bottom-width:0.5px;" cellpadding="4">
            <thead>
                <tr bgcolor="#FAEAE6">
                    <th style="border-top-color:grey;border-left-color:grey;border-top-width:0.5px;border-top-style:solid;font-weight:bold;" width = "9%">S. No.</th>
                    <th style="border-top-color:grey;border-top-width:0.5px;border-top-style:solid;font-weight:bold;" width = "22%">Name</th>
                    <th style="border-top-color:grey;border-top-width:0.5px;border-top-style:solid;font-weight:bold;" width = "35%">Family Details</th>
                    <th style="border-top-color:grey;border-top-width:0.5px;border-top-style:solid;font-weight:bold;" width = "17%">City</th>
                    <th style="border-top-color:grey;border-right-color:grey;border-top-width:0.5px;border-top-style:solid;font-weight:bold;" width = "17%">Country</th>
                </tr>
            </thead>
            <tbody>';
                $sno = 1;
                foreach($reports["data"] as $this_report)
                {
                    if($this_report["item_name"] == $this_pooja)
                    {
                        $html.= '<tr>';
                            $html.= '<td style="border-top-color:grey;border-top-width:0.5px;border-top-style:solid;margin-top:10px;" width = "9%">'.$sno.''.".".'</td>';
                            $html.= '<td style="border-top-color:grey;border-top-width:0.5px;border-top-style:solid;" width = "22%">'.$this_report["display_name"].'</td>';
                            $html.= '<td style="border-top-color:grey;border-top-width:0.5px;border-top-style:solid;" width = "35%">'.strip_tags($this_report["family_details"], '<br></br><br/><p></p><b><br ><br /></br >').'</td>';
                            $html.= '<td style="border-top-color:grey;border-top-width:0.5px;border-top-style:solid;" width = "17%">'.$this_report["city"].'</td>';
                            $html.= '<td style="border-top-color:grey;border-top-width:0.5px;border-top-style:solid;" width = "17%">'.$this_report["country_name"].'</td>';
                            $html.= '</tr>';
                    $sno++;
                    }
                }
            $html.= '</tbody>
        </table>';
        $pdf->writeHTML($html, true, false, true, false, '');
    }
}
// output the HTML content
ob_clean();
$fileatt = $pdf->Output('poojas_seva_karta_report-'.date("Y-m-d-His").'.pdf', 'I');

exit
?>