<link href="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/datatables_1_10_5/media/css/dataTables.bootstrap.css" rel="stylesheet" type="text/css"/>
<input class="current-browser-title" data-title=" Admin Dashboard | Pledges | All Pledges" type="hidden">
<style type="text/css">
    @media only screen and (min-width: 992px) and (max-width: 1450px){
        .buttons{
            padding: 29px 0px 6px 0px;
        }
    }
</style>
<?PHP
    //$this->load->view("faqs/admin/nav_buttons");
?>
<h3 class="page-title">
    All Pledges
</h3>
<div class="page-bar">
    <ul class="page-breadcrumb">
        <li>
            <i class="fa fa-home"></i>
            <a href="/admin">Dashboard</a>
            <i class="fa fa-angle-right"></i>
        </li>
        <li>All Pledges</li>
    </ul>
</div>
     
<div class="row-fluid">
<?PHP
if($this->session->flashdata("pledge_error"))
{
	?>
    <div class="alert alert-danger">
        <button class="close" data-dismiss="alert"></button>
        <strong>Invalid Request</strong>
    </div>
    <?PHP
}
?>
    <div class="alert alert-info">
        <strong>Pledges public URL:</strong>
        <a href="<?php echo base_url. "pledge"; ?>" target="_blank">
        <?php echo base_url . "pledge"; ?></a>
    </div>
	<form action="" method="get" style="margin:0px;" onsubmit="return false"
        class="form-horizontal row search_form">
        <div class="col-md-2">
            <select name="purpose" id="purpose" class=" input-inline form-control custom-input" onChange="search(1)">
                <option value="">All Purposes</option>
                <?PHP
                foreach ($this->pledge_categories_model->getCategories() as $category)
                {
                    ?>
                    <option value="<?PHP echo $category->id; ?>"><?PHP echo $category->name; ?></option>
                    <?PHP
                }
                ?>
            </select>
        </div>
        <div class="col-md-2">
            <select name="status" onChange="search(1)" id="status" class=" input-inline form-control custom-input">
                <option value="">All Status</option>
                <option value="0">New</option>
                <option value="1">Pending</option>
                <option value="2">Completed</option>
            </select>
        </div>
        <div class="col-md-2">
            <select name="currency" id="currency" class=" input-inline form-control custom-input" onChange="search(1)">
                <option value="">All Currencies</option>
                <?PHP
                $currencies=$this->currencies_model->getByAshram(0);
                foreach ($currencies as $currency)
                {
                    ?>
                    <option value="<?PHP echo $currency['currency']; ?>"><?PHP echo strtoupper($currency['currency']); ?></option>
                    <?PHP
                }
                ?>
            </select>
        </div>
        <div class="col-md-2">
            <select name="app" onChange="search(1)" id="app" class=" input-inline form-control custom-input">
                <option value="">All Sources</option>
                <option value="1">App</option>
                <option value="0">Website</option>
            </select>
        </div>
        <br style="clear:both;" class="hidden-sm hidden-xs">
        <div class="col-md-2">
            <input type="text" name="search_text" id="search_text" placeholder="Type keyword to search..."
            class="input-inline form-control custom-input" />
        </div>
        <div class="col-md-2">
            <select name="search_col" id="search_col" class=" input-inline form-control custom-input">
                <option value="email">Email ID</option>
                <option value="phone">Phone</option>
                <option value="name">Name</option>
                <option value="pledge_id">Pledge ID</option>
            </select>
        </div>
        <div class="col-md-2" style="display:none">
            <select name="wild" id="wild" class="input-inline form-control custom-input">
                <option value="contains">Contains</option>
                <option value="starts">Starts with</option>
                <option value="ends">Ends with</option>
            </select>
        </div>

        <div class="col-md-2">
            <input type="text" class="datepickerclass form-control input-inline custom-input"  name="from_date" id="from_date"
            placeholder="From date"/>
        </div>
        <div class="col-md-2">
            <input type="text" class="datepickerclass form-control input-inline custom-input"  name="to_date" id="to_date"
            placeholder="To date"/>
        </div>
        <div class="buttons">
            <button type="button" id="searchButton" class="btn btn-xs blue searchButton"
            onClick="search(0)"><i class="fa fa-search"></i> Search</button>
            <a class="btn btn-xs red" id="searchClear" onClick="search_clear()"
            style="display:none;"><i class="fa fa-search-minus"></i> Clear</a>
            <button type="button" id="excelButton" class="btn btn-xs green excelButton" ><i class="fa fa-file-excel-o"></i> Report</button>
        </div>
    </form>
    <br class="hidden-lg hidden-md">
    <div class="portlet box blue">
        <div class="portlet-title">
            <div class="caption"> <i class="fa fa-list"></i> All Pledges <span id="total_records"></span></div>
            <div class="tools">
                <a href="javascript:;" class="collapse"></a>
            </div>
        </div>
        
        <div class="portlet-body no-more-tables">
            
                <table id="ptable" class="display table-bordered table-condensed table table-striped table-hover" cellspacing="0" width="100%" >
                    <thead>
                        <tr>
                            <th>S. No.</th>
                            <th>Pledge ID</th>
                            <th>User</th>
                            <th>Purpose</th>
                            <th>Amount</th>
                            <th>Date</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    
                </table>
            
            <div style="clear:both;"></div>
        </div>
    </div>

</div>
<script src="<?php
echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/datatables_1_10_5/media/js/jquery.dataTables.js" type="text/javascript"></script>
<script src="<?php
echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/datatables_1_10_5/media/js/dataTables_custom.js" type="text/javascript"></script>
<script type="text/javascript">
var search_text = '';
var search_col = '';
var wild = '';
var table = '';
var purpose='';
var from_date ='';
var to_date ='';
var status='';
var currency='';
var app='';
function search(flag) 
{
    clearNotifications();
    if(!$("#from_date").length || !$("#to_date").length || !$("#search_text").length || !$("#search_col").length ||
            !$("#wild").length)
    {
        showNotification("ruby","Something went wrong!!! Please refresh page and try again.");
        return;
    }
    if (flag == 0)
    {
        if ($("#from_date").length && $("#to_date").length && $("#search_text").length && 
            $("#from_date").val().trim() == '' && $("#to_date").val().trim() == '' && $("#search_text").val().trim() == '') 
        {
            showNotification('ruby','Please enter search keywords or select dates');
            return false;
        }
        if($("#from_date").length && $("#to_date").length && $('#from_date').val().trim()!='' && $('#to_date').val().trim()!='')
        {
            var frm=Date.parse($("#from_date").val());
            var to=Date.parse($("#to_date").val());
            if(frm>to)
            {
                showNotification('ruby','From date cannot be after To date');
                return false
            }
        }
    }
    $(".dataTables_processing").show();
    if($("#search_text").length)
        search_text = $("#search_text").val().trim();
    if($("#search_col").length)
        search_col = $("#search_col").val().trim();
    if($("#wild").length)
        wild = $("#wild").val().trim();
    if($("#purpose").length)
        purpose = $("#purpose").val().trim();

    if($("#from_date").length)
        from_date = $("#from_date").val().trim();
    if($("#to_date").length)
        to_date = $("#to_date").val().trim();
    if($("#status").length)
        status=$("#status").val();
    if($("#currency").length)
        currency=$("#currency").val();
    if($("#app").length)
        app=$("#app").val();
    if (search_text != '' || from_date != '' || to_date != '')
        $("#searchClear").css("display", "inline-block");
    
    table.fnDraw();
}
function search_clear() 
{
    $(".dataTables_processing").show();
    $("#from_date").val('');
    from_date = '';
    $("#to_date").val('');
    to_date = '';
    $("#search_text").val('');
    search_text = '';
    search_col = '';
    wild = '';
    purpose='';
    $("#purpose").val("");
    status='';
    $("#status").val("");
    currency='';
    $("#currency").val("");
    app='';
    $("#app").val("");
    $("#searchClear").css("display", "none");
    table.fnDraw();
}
var statusflag=0;
$(".change-status").live("click",function()
{
    if(statusflag==1)
        return false;
    statusflag=1;
    var pid=$(this).attr("data-id");
    var status=$(this).attr("data-status");
    $(".dataTables_processing").show();
    $.post('/pledgeadmin/changestatus/'+ pid+'/'+status, {}, function(res) 
    {   
        var r = $.parseJSON(res);
        if (r.status == 1)
        {
            table.fnSettings.bResetDisplay  =false;
            table.fnDraw(table.fnSettings);
            if(status==0)
                showNotification('lime', "Pledge '" + r.pledge_id + "' marked as New.");
            if(status==1)
                showNotification('lime', "Pledge '" + r.pledge_id + "' marked as Pending.");
            if(status==2)
                showNotification('lime', "Pledge '" + r.pledge_id + "' marked as Completed.");
        }
        else 
        {
            $(".dataTables_processing").hide();
            showNotification("ruby", "Error occured. Please try again.");
        }
        $(".dataTables_processing").hide();
        statusflag=0;
    });
});

$(document).ready(function()
{
    $("#search_text").val('');
    $("#purpose").val("");
    $("#currency").val("");
    $("#wild").val($("#wild option:first").val());
    $("#search_col").val($("#search_col option:first").val());

    table = $('#ptable').dataTable({
        "processing": true,
        "language": {
            "sProcessing": '<div class="spinnerspin"></div>',
            "emptyTable": "No records found!"
        },
        "sDom": "l<'custom-clear visible-xs'>ptr<'clearfix'>p",
        "sPaginationType": "bootstrap",
        "serverSide": true,
        "iDisplayLength": 50,
        "order": [
            [1, "desc"]
        ],
        "responsive": true,
        "lengthMenu": [
            [20, 50, 100],
            [20, 50, 100]
        ],
        "drawCallback": function(settings) 
        {
            var api = this.api();
            var totalrows = api.rows({
                page: 'current'
            }).data().context[0]._iRecordsTotal;
            $("#total_records").html('(' + totalrows + ')');
            $('.tooltips').tooltip();
            $("#checkall").prop('checked', false);
        },
        "columns": [
        {
            "width": "7%",
            "orderable": false
        }, {
            'name':"pledge_id",
            "width": "15%",
            "orderable": false
        }, {
            name: "name",
            "width": "18%",
            "orderable": false
        }, {
            'name':"purpose",
            "orderable": false
        }, {
            'name':"amount",
            "width": "8%",
            "orderable": false
        }, {
            name: "created_on",
            "width": "15%",
            "orderable": true
        }, {
            name: "status",
            "width": "8%",
            "orderable": false
        }, {
            width: "7%",
            "orderable": false
        }],
        "ajax": {
            url: '/pledgeadmin/listc',
            type: 'POST',
            data: function(d) 
            {
                if (from_date != '')
                    d.from_date = from_date;
                if (to_date != '')
                    d.to_date = to_date;
                if (status != '' && $.isNumeric(status)) 
                {
                    d.status = status;
                }
                if (search_text != '')
                    d.search_text = search_text;
                d.search_col = search_col;
                d.purpose=purpose;
                d.wild = wild;
                d.status=status;
                d.currency=currency;
                d.app=app;
            },
            error: function (xhr, error, thrown) 
            {
                if(xhr.responseText=='login')
                {
                    window.location="<?PHP echo base_url; ?>"
                }
                else if(xhr.responseText==404 || xhr.responseText=='404' || xhr.responseText=='0')
                {
                   showNotification('ruby',"Invalid request");
                }
                $(".dataTables_processing").hide();
                return false;
            },
            dataSrc:function(res)
            {
                if(res.data.length==0 && res.recordsTotal!=0)
                {
                    table.fnDraw();
                }
                return res.data;
            }
        },
        "fnRowCallback": function(nRow, aData, iDisplayIndex, iDisplayIndexFull) 
        {
            var vis = true;
            var ii = 0;
            var sno = 0;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "S. No.");
                ii++;
            }
            sno++;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "Pledge ID");
                ii++;
            }
            sno++;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "User");
                ii++;
            }
            sno++;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "Purpose");
                ii++;
            }
            sno++;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "Amount");
                ii++;
            }
            sno++;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "Date");
                ii++;
            }
            sno++;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "Status");
                ii++;
            }
            sno++;
            if (this.api().column(sno).visible())
                $('td:eq(' + ii + ')', nRow).attr('data-title', "Actions");
            return nRow;
        },
        "columnDefs": [
        {
            "render": function(data, type, row) {
                return row.sno;
            },
            "targets": 0
        }, {
            "render": function(data, type, row) 
            {
                var str = '<a href="/pledgeadmin/view/'+row.pid+'" target="_blank">'+row.pledge_id+'</a>';
                if(row.app==1)
                {
                    str+='<span class="custom-label darkblue pull-right">A</span>';
                }
                return str;
            },
            "targets": 1
        }, {
            "render": function(data, type, row) 
            {
                var str='';
                if(row.user_id!=0)
                    str+= '<a href="/usersadmin/view/'+row.user_id+'" target="_blank">'+row.name+'</a><br>';
                else
                    str+=row.name+"<br>";
                str+=row.phone+"<br>";
                str+=row.email;
                return str;
            },
            "targets": 2
        }, {
            "render": function(data, type, row) 
            {
                var str = row.purpose;
                return str;
            },
            "targets": 3
        }, {
            "render": function(data, type, row) 
            {
                var str = row.currency.toUpperCase()+' '+row.amount;
                return str;
            },
            "targets": 4
        }, {
            "render": function(data, type, row) 
            {
                return row.created_on;
            },
            "targets": 5
        }, {
            "render": function(data, type, row) 
            {
                var str='';
                if(row.pstatus==0)
                {
                    str='<span class="label label-danger">New</span>';
                }
                if(row.pstatus==1)
                {
                    str='<span class="label label-warning">Pending</span>';
                }
                if(row.pstatus==2)
                {
                    str='<span class="label label-success">Completed</span>';
                }
                return str;
            },
            "targets": 6
        }, {
            "render": function(data, type, row) 
            {
                var str = '<div class="btn-group" id="actions' + row.pid + '">' +
                    '<a class="btn red btn-xs" href="#" data-toggle="dropdown"> Actions ' +
                    '<i class="fa fa-angle-down"></i></a>' +
                    '<ul class="dropdown-menu pull-right" style="text-align:left;">' +
                    '<li><a href="/pledgeadmin/view/' + row.pid + '" target="_blank"><i class="fa fa-eye"></i> View</a></li>';

                    if(row.pstatus!=0)
                    {
                        str+='<li><a href="javascript:;" data-status="0" data-id="' + row.pid + '" class="change-status" >Mark New</a></li>';
                    }
                    if(row.pstatus!=1)
                    {
                        str+='<li><a href="javascript:;" data-status="1" data-id="' + row.pid + '" class="change-status">Mark Pending</a></li>';
                    }
                    if(row.pstatus!=2)
                    {
                        str+='<li><a href="javascript:;" data-status="2" data-id="' + row.pid + '" class="change-status">Mark Completed</a></li>';
                    }
                    str+='</ul></div>';

                return str;
            },
            "targets": 7
        }]
    });
    $('.columnhide').on('click', function(e) 
    {
        var column = table.api().column( $(this).attr('data-column') );
        var cnum=$(this).attr('data-column');
        
        column.visible( ! column.visible(),true );
        var bVis = table.fnSettings().aoColumns[cnum].bVisible;
        var title = table.fnSettings().aoColumns[cnum].sTitle;
        
        var visibility=table.api().column(cnum).visible();
        table.api().column(cnum).nodes().to$().attr("data-title",title);
        if (visibility == false) 
        {
            $(this).removeClass('blue').addClass('red');
        }
        else 
        {
            $(this).removeClass('red').addClass('blue');
        }
    });
});
    $("#excelButton").on("click",function()
    {
        $(".loader_animation").show();
        clearNotifications();
        var sortindex=table.fnSettings().aaSorting[0][0];
        var order_by=table.fnSettings().aoColumns[sortindex].name;
        var dir=table.fnSettings().aaSorting[0][1];
        $.post('/pledgeadmin/listc/1',
        {
            search_text:search_text,wild:wild,search_col:search_col,order_by:order_by,dir:dir,from_date:from_date,to_date:to_date,purpose:purpose,currency:currency,app:app
        },
            function(res)
            {
                var r=$.parseJSON(res);
                if(r.flag==1)
                {
                    window.location='<?PHP echo base_url; ?>excelreports/download/'+r.report_id;
                }
                if(r.flag==2)
                {
                    showNotification("ruby","Sorry! You have already requested the same report.");
                }
                if(r.flag==0)
                {
                    showNotification("ruby","Sorry! Report cannot be generated. Data is empty.");
                }
                $(".loader_animation").hide();
            }
        );
    });
</script>     