<style type="text/css">
    .modal-body .block
    {
        margin:0px;
        padding: 0px 0px 10px 0px;
    }
    .help-block
    {
        color: #a94442;
        font-weight: bold;
        font-size: 13px;
    }
</style>
<div id="pet-modal" class="modal fade in container">
    <form class="pet-form" novalidate="novalidate" method="post">
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
            <h4 class="modal-title">Pet</h4>
        </div>
        <div class="modal-body">
            <div class="row">
                <div class="col-md-6">
                    <div class="form-group">
                        <label class="control-label" style="text-align:left;">Serial Number <span class="required">*</span></label>
                        <div class="controls" >
                            <input type="text" name="pet_serial_number" class="form-control" id="pet_serial_number" placeholder="Enter Serial number"
                                value="<?PHP if($id) echo htmlentities($petData->pet_serial_number); ?>" >
                         </div>
                    </div>
                    <div class="form-group">
                        <label class="control-label" style="text-align:left;">Name <span class="required">*</span></label>
                        <div class="controls" >
                            <input type="text" name="pet_name" class="form-control"
                                value="<?PHP if($id) echo htmlentities($petData->pet_name); ?>" 
                                id="pet_name" autocomplete="off" placeholder="Enter Name">
                         </div>
                    </div>

                    <div class="form-group">
                        <label class="control-label" style="text-align:left;">Species <span class="required">*</span></label>
                        <div class="controls" >
                            <input type="text" name="pet_species" class="form-control" id="pet_species" placeholder="Enter Species"
                                value="<?PHP if($id) echo htmlentities($petData->pet_species); ?>" >
                         </div>
                    </div>

                    <div class="form-group">
                        <label class="control-label" style="text-align:left;">Type <span class="required">*</span></label>
                        <div class="controls" >
                            <input type="text" name="pet_type" class="form-control" id="pet_type" placeholder="Enter Type"
                                value="<?PHP if($id) echo htmlentities($petData->pet_type); ?>" >
                         </div>
                    </div>

                    <div class="form-group">
                        <label class="control-label" style="text-align:left;">Description</label>
                        <div class="controls">
                            <textarea name="pet_description" rows="4" class="form-control" id="pet_description" placeholder="Enter description"><?PHP if($id) echo htmlentities($petData->pet_description); ?></textarea>
                         </div>
                    </div>
                </div>
                <div class="col-md-6">
                    <div style="font-weight:bold;">Photo</div>
                        <?PHP
                        if($id && $petData->pet_photo)
                            $pic_exist=1;
                        else $pic_exist=0;
                        ?>
                        <div class="fileupload fileupload-<?PHP if($pic_exist) echo "exists"; else echo "new"; ?>" data-provides="fileupload">
                        <div class="fileupload-new thumbnail" style="width: 150px;">
                            <img src="<?PHP echo aws_s3_base_url."images/site_assets/global_site_images/no-image.png"; ?>" alt="">
                        </div>
                        
                        <div class="fileupload-preview fileupload-exists thumbnail" style="max-width: 150px; max-height: 150px; line-height: 20px;">
                            <img src="<?PHP
                            if($id && $petData->pet_photo) echo aws_s3_base_url."pets/thumb_".$petData->pet_photo; 
                            ?>" alt="">
                            <input type="hidden" name="pet_imgupl" id="pet_imgupl" />
                        </div>
                        <div class="form-group">
                            <span class="btn btn-xs btn-file blue">
                                <span class="fileupload-new"><i class="fa fa-check"></i>  Select Image</span>
                                <span class="fileupload-exists"><i class="fa fa-refresh"></i> Change</span>
                                <input type="file" name="pet_profile_image" id="pet_profile_image" />
                            </span>
                            <a href="#" class="btn btn-xs red fileupload-exists" data-dismiss="fileupload" style="margin-left:10px;">
                                <i class="fa fa-ban"></i> Remove</a>
                            <span class="file_error"></span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="modal-footer">
            <input type="hidden" name="pet_id" id="pet_id">
            <button type="button" data-dismiss="modal" class="btn btn-xs default">
            <i class="fa fa-remove"></i> Cancel</button>
            <button type="submit" class="btn btn-xs blue">
            <i class="fa fa-check"></i> <?PHP if($id) echo "Save"; else echo "Add"; ?></button>
        </div>
    </form>
</div>

<script type="text/javascript">

$(document).ready(function()
{   
    jQuery.validator.addMethod('uploadfuncpet',function (value) 
    { 
    
        var ext='';
        if(value!='')
        ext=value.split('.').pop();
        var allowed=1*1024*1024;
        if(ext!='')
        {
            var size = document.getElementById('pet_profile_image').files[0].size;
            if(ext!='jpg' && ext!='png' && ext!='jpeg' && ext!='JPG' && ext!='PNG' && ext!='JPEG')
            {
                jQuery.validator.messages.uploadfuncpet =  "Please upload only photos (.png or .jpg or .jpeg formats)";
                return false;
            }
            else if(size==0)
            {
                jQuery.validator.messages.uploadfuncpet="Please upload a valid photo";
                return false;
            }
            else if(size>allowed)
            {
                jQuery.validator.messages.uploadfuncpet="Please upload photo less than or equal to 1 MB in size ";
                return false;
            }
        }
        return true
    
    },'');

    var form = $('.pet-form'); 
    form.validate(
    {
        doNotHideMessage: true,
        errorElement: 'span',
        errorClass: 'help-block help-block-error',
        focusInvalid: true,
        onkeyup:true,
        ignore:"",
        rules: {
        
            pet_species:
            {
                required:true,
                minlength:3,
                maxlength:100
            },
            pet_profile_image:
            {
                uploadfuncpet:true
            },
            pet_name:
            {
                required:true,
                minlength:2,
                maxlength:200
            },
            pet_serial_number:
            {
                required:true,
                minlength:3,
                maxlength:100
            },
            pet_type:
            {
                required:true,
                minlength:3,
                maxlength:100
            },
            pet_description:
            {
                maxlength:2500
            }
        },
        messages:
        {
            pet_species:
            {
                required:'Please enter Species'
            },
            pet_name:
            {
                required:"Please enter Pet Name"
            },
            pet_serial_number:
            {
                required:"Please enter Serial Number"
            },
            pet_type:
            {
                required:"Please enter Type"
            }
        },
        
        errorPlacement: function (error, element) 
        {
            if (element.attr("name") == "pet_profile_image") 
            {
                error.addClass('help-small no-left-padding').insertAfter('.file_error');
            }
            else 
            {
                error.addClass('help-small no-left-padding').insertAfter(element);
            }
        },
        highlight: function (element) 
        {
            $(element).closest('.form-group').removeClass("has-success").addClass('has-error');
        },
        unhighlight: function (element) 
        {
            $(element).closest('.control-group').removeClass('error');
        },
        success: function (label,element) 
        {
            $(element).closest('.form-group').removeClass('has-error');
            label.remove();
        },
        submitHandler: function (form) 
        {
            
            var form_data = new FormData();
            var pet_profile_image = $("#pet_profile_image").prop("files")[0];
            form_data.append("pet_name",$("#pet_name").val());
            form_data.append("pet_species",$("#pet_species").val());
            form_data.append("pet_type",$("#pet_type").val());
            form_data.append("pet_serial_number",$("#pet_serial_number").val());
            form_data.append("pet_description",$("#pet_description").val());

            if($("#pet_imgupl").length)
                form_data.append("pet_imgupl",1);
            if(pet_profile_image!='undefined' && pet_profile_image!=null)
                form_data.append("pet_profile_image",pet_profile_image);

            $(".pet-form button[type=submit]").prop("disabled",true);

            $.ajax(
            {
                url: "/petsadmin/edit_pet/<?PHP echo $id;?>",
                cache: false,
                contentType: false,
                processData: false,
                data: form_data,
                type: 'post',
                success: function(res)
                {
                    showNotification("lime","Pet saved successfully.");
                    $("#pet-modal").modal('hide');
                                  
                    $(".pet-form button[type=submit]").prop("disabled",false);
                    table.fnDraw();
                }
            });
            return false;
        }
    });
});
</script>