<!DOCTYPE html>
<html>
<head>
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
    <meta content="width=device-width, initial-scale=1.0" name="viewport" />
    <title><?PHP echo site_name_string1; ?> | Donation Sevas</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>
    <!-- <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/js/bootstrap.min.js"></script> -->
    <link href="<?php echo base_url."site_theme"; ?>/admin_fonts/google-css-open-sans.css" rel="stylesheet">
    <link href="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/datatables_1_10_5/media/css/dataTables.bootstrap.css" rel="stylesheet" type="text/css"/>
    <link rel="stylesheet" href="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/responsive.min.css">
    <link href="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/font-awesome/css/font-awesome.min.css" rel="stylesheet" type="text/css"/>
    <link href="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/bootstrap-datepicker/css/datepicker.css" rel="stylesheet" type="text/css" />
    <link rel="stylesheet" type="text/css" href="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/bootstrap-select/bootstrap-select.min.css"/>
    <link rel="stylesheet" type="text/css" href="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/select2/select2.css"/>
    <link rel="stylesheet" type="text/css" href="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/jquery-multi-select/css/multi-select.css"/>
    <link href="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/admin/layout/css/layout.css" rel="stylesheet" type="text/css"/>
    <link href="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/admin/layout/css/custom.css" rel="stylesheet" type="text/css"/>
    <link href="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/css/components.css" rel="stylesheet" type="text/css"/>
    <link rel="stylesheet" type="text/css" href="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/jquery-notific8/jquery.notific8.min.css"/>
    <style type="text/css">
        .currencymaskrw
        {
            margin-left: 20px;
        }
        .fixedheaderform
        {
            position: fixed;
            width: 100%;
            background: #fff;
            z-index: 9999;
        }
        .listRowContainer
        {
            margin-top: 195px;
        }
        .searchFormButton
        {
            margin-top: 15px;
            font-size: 16px;
            font-weight: bold;
            margin-right: 20px;
        }
        .searchFormRow
        {
            margin-top: 15px;
            padding-left: 0;
        }
        .searchFormRow input
        {
            font-size: 16px !important;
            padding-left: 5px !important;
            width: 100%;
        }
        .searchFormRow select
        {
            font-size: 16px !important;
            padding-left: 5px !important;
            width: 100%;
        }
        .bootstrap-select.btn-group .btn .filter-option
        {
            height: 25px;
            line-height: 25px;
        }

        @media screen and (max-width:420px)
        {
            .currencymaskrw
            {
                font-size: 15px;
            }
        }

        @media screen and (max-width:991px)
        {
            .fixedheaderform
            {
                position: relative;
            }
            .listRowContainer
            {
                margin-top: 0px;
            }
        }

        @media only screen and (min-width: 991px) and (max-width: 992px)
        {
            .listRowContainer {
              margin-top: 436px;
            }
        }

        @media only screen and (min-width: 992px) and (max-width: 1416px)
        {
            .listRowContainer {
              margin-top: 240px;
            }
        }
    </style>

</head>
    <body>
        <div class="container">

            <div class="row-fluid fixedheaderform">
                <h3 class="page-title" style="margin-top: 5px;font-weight: bold;">
                    <?PHP
                    if(isset($ashramData->name))
                    {
                        echo $ashramData->name;
                    }
                    ?>
                    
                </h3>
                <h3 class="page-title" style="margin-top: 5px;">
                    Donation Sevas
                    <?PHP
                    foreach ($GLOBALS['currencies'] as $currencyData)
                    {
                        if(is_single_currency_site==1)
                        {
                            if(default_currency==strtolower($currencyData['currency']))
                            {
                                ?>
                                <span style=" color:<?PHP echo $currencyData['color']; ?>;" class="currencymaskrw">
                                    <?PHP echo $currencyData['symbol']; ?>
                                   <span id="total_<?PHP echo strtolower($currencyData['currency']); ?>" class="total-original">0</span>
                                </span>
                                <?PHP
                            }
                        }
                        else
                        {
                        ?>
                            <span style="color:<?PHP echo $currencyData['color']; ?>;" class="currencymaskrw">
                                <?PHP echo $currencyData['symbol']; ?>
                                <span id="total_<?PHP echo strtolower($currencyData['currency']); ?>" class="total-original">0</span>
                            </span>
                        <?PHP
                        }
                    }
                    ?>
                </h3>
                <form action="" method="get" name="" style="margin:0px;" onsubmit="return false" class="form-horizontal row search_form">
                    <?PHP
                    if(isset($donations))
                    {
                        ?>
                        <div class="col-md-4" style="padding-left:0px; padding-right: 5px;">
                            <select class="bs-select form-control" multiple id="donation_ids" title="All Donations">
                                <optgroup label="Active">
                                <?PHP
                                $iStatus=1;
                                foreach ($donations as $donationRow)
                                {
                                    if($iStatus!=$donationRow->status)
                                    {
                                        echo '</optgroup>';
                                        echo "<optgroup label='Inactive'>";
                                    }
                                    ?>
                                    <option value="<?PHP echo $donationRow->id ?>"
                                    class="<?PHP if($donationRow->status==1) echo "active"; else echo "inactive"; ?>" <?PHP if(isset($item_ids) && is_array($item_ids) && in_array($donationRow->id,$item_ids)){ echo "selected"; }?>><?PHP echo htmlentities($donationRow->donation_name); ?></option>
                                    <?PHP
                                    $iStatus=$donationRow->status;
                                }
                                ?>
                                </optgroup>
                            </select>
                        </div>
                        <div class="clearfix"></div>
                        <?PHP
                    }  
                    ?>
                    <?PHP
                    if(is_single_currency_site)
                    { 
                        ?>
                        <a href="javascript:;" class="btn btn-xs blue searchFormButton changeCurrencyButton" id="buttonCurrency<?php echo strtolower(default_currency); ?>" Currency="<?php echo strtolower(default_currency); ?>">Sevas - <?php echo strtoupper(default_currency); ?></a>
                        <?PHP
                    }
                    else
                    {
                        ?>
                        <a href="javascript:;" class="btn btn-xs blue searchFormButton changeCurrencyButton" id="buttonCurrencyAll" Currency="All">Sevas-All Currencies </a>
                        
                        <?PHP
                        foreach ($GLOBALS['currencies'] as $currencyData)
                        {
                            ?>
                                <a href="javascript:;" class="btn btn-xs default searchFormButton changeCurrencyButton" id="buttonCurrency<?php echo strtolower($currencyData['currency']); ?>" Currency="<?php echo strtolower($currencyData['currency']); ?>">Sevas - <?php echo strtoupper($currencyData['currency']); ?></a>
                            <?PHP
                        }
                    }
                    ?>
                    <a href="javascript:;" class="btn btn-xs default searchFormButton changeSevasByNameButton" showSevasByName="byappajisname">Sevas on Appaji's name</a>
                    <a href="javascript:;" class="btn btn-xs default searchFormButton changeSevasByNameButton" showSevasByName="byswajimisname">Sevas on Swamiji's name</a>
                    <a href="javascript:;" class="btn btn-xs default searchFormButton changeGroupByButton" groupByType="participant">Total By Participant</a>
                    <a href="javascript:;" class="btn btn-xs default searchFormButton changeGroupByButton" groupByType="user">Total By Devotee</a>
                    <a href="javascript:;" data-order="asc" data-column="11" class="sortcolumn btn btn-xs default searchFormButton">Sort By Amount <i class="fa fa-arrow-up"></i></a>
                    <div style="clear:both;" class="visible-lg visible-md"></div>
                    <div class="col-md-2 searchFormRow">
                        <input type="text" name="search_text" id="search_text" placeholder="Type keyword to search..."
                        class="input-inline form-control custom-input" />
                    </div>
                    <div class="col-md-2 searchFormRow">
                        <select name="search_col" id="search_col" class=" input-inline form-control custom-input">
                            <option value="family_member_details">Participant Name</option>
                            <option value="email">Email ID</option>
                            <option value="phone">Phone</option>
                        </select>
                    </div>
                    <div class="col-md-2 searchFormRow">
                        <input type="text" class="datepickerclass form-control input-inline custom-input"  name="from_date" id="from_date" placeholder="From date" value="" />
                    </div>
                    <div class="col-md-2 searchFormRow">
                        <input type="text" class="datepickerclass form-control input-inline custom-input"  name="to_date" id="to_date" placeholder="To date" value="" />
                    </div>
                    
                    <button type="button" id="searchButton" class="btn btn-xs blue searchButton" onClick="search(0)" style="margin-top: 15px;font-size: 16px;"><i class="fa fa-search"></i> Search</button>
                    <a class="btn btn-xs red" id="searchClear" onClick="search_clear()" style="display: none;margin-top: 15px;font-size: 16px;"><i class="fa fa-search-minus"></i> Clear</a>
                    <div class="clearfix" style="margin-top:5px;"></div>
                </form>
                <!-- <br class="hidden-lg hidden-md"> -->
            </div>
        </div>

        <div class="container listRowContainer">
            <div class="row-fluid">
                <div class="portlet box blue">
                    <div class="portlet-title">
                        <div class="caption"> <i class="fa fa-list"></i> Donation Sevas <span id="total_records"></span></div>
                        <div class="tools">
                            <a href="javascript:;" class="collapse"></a>
                        </div>
                    </div>
                    
                    <div class="portlet-body no-more-tables">
                        <table id="orderstable" class="display table-bordered table-condensed table table-striped table-hover" cellspacing="0" width="100%" >
                            <thead>
                                <tr>
                                    <th>S. No.</th>
                                    <th>Seva ID</th>
                                    <th>Seva Date</th>
                                    <th>Devotee</th>
                                    <th>Email ID</th>
                                    <th>Phone</th>
                                    <th>Participant Name</th>
                                    <th>Address</th>
                                    <th>Seva Name</th>
                                    <th>Donation Dates</th>
                                    <th>Note</th>
                                    <th>Donation Amount</th>
                                </tr>
                            </thead>
                            
                        </table>
                        <div style="clear:both;"></div>
                    </div>
                </div>
            </div>


        </div>
    </body>
</html>
<script type="text/javascript">
    var base_url='<?PHP echo base_url(); ?>';
    var theme_folder_name='theme_v361';
    var aws_s3_base_url='<?PHP echo aws_s3_base_url; ?>';
</script>
<script src="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/jquery.min.js" type="text/javascript"></script>
<script src="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/jquery-migrate.min.js" type="text/javascript"></script>
<script src="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/jquery-ui/jquery-ui-1.10.3.custom.min.js" type="text/javascript"></script>
<script src="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/bootstrap/js/bootstrap.min.js" type="text/javascript"></script>
<script src="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/bootstrap-hover-dropdown/bootstrap-hover-dropdown.min.js" type="text/javascript"></script>
<script src="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/pace/pace.js" type="text/javascript"></script>


<script src="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/frontend-2/js/back-to-top.js" type="text/javascript"></script>
<script src="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/bootstrap-touchspin/bootstrap.touchspin.js" type="text/javascript"></script>
<script src="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/jquery-slimscroll/jquery.slimscroll.min.js" type="text/javascript"></script>

<script src="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/bootstrap-datepicker/js/bootstrap-datepicker.js" type="text/javascript"></script>
<script src="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/datatables_1_10_5/media/js/jquery.dataTables.js" type="text/javascript"></script>
<script src="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/datatables_1_10_5/media/js/dataTables_custom.js" type="text/javascript"></script>
<script type="text/javascript" src="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/bootstrap-select/bootstrap-select.min.js"></script>
<script type="text/javascript" src="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/select2/select2.min.js"></script>
<script type="text/javascript" src="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/jquery-multi-select/js/jquery.multi-select.js"></script>
<script src="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/jquery-notific8/jquery.notific8.min.js"></script>
<script type="text/javascript">
var from_date = $("#from_date").val();
var to_date = $("#to_date").val();
var table = '';
var donation_id='';
<?PHP
if(is_single_currency_site)
{ 
    ?>
    var currency='<?php echo strtolower(default_currency); ?>';
    <?PHP
}
else
{
    ?>
    var currency='';
    <?PHP
}
?>
var search_text = '';
var search_col = '';
var wild = 'contains';
var group_by='';
var sevas_by_name='';
var ashram_id='<?PHP echo $ashram_id; ?>';
var secret_key='<?PHP echo $secret_key; ?>';
<?PHP
if(isset($item_ids) && is_array($item_ids))
{
    ?>
    var donation_id=JSON.parse('<?PHP echo json_encode($item_ids); ?>');
    <?PHP
}
?>
function clearNotifications()
{
    $('.jquery-notific8-notification').remove();
}
function showNotification(theme,message)
{
    $.notific8('zindex', 11500);
    $.notific8(message,
    {
        theme:theme,
        sticky: false,
        horizontalEdge:'top',
        verticalEdge:'right',
        life:5000
    });
}
function search(flag) 
{
    clearNotifications();
    if (flag == 0)
    {  
        if($('#from_date').val().trim()=='' && $('#to_date').val().trim()=='' && $('#search_text').val().trim()=='' && ($("#donation_ids").val()=='null' || $("#donation_ids").val()==null) )
        {
            showNotification('ruby','Please enter search key word');
            return false
        }
        if ($("#donation_ids").length)
        {
            if($("#from_date").length && $("#to_date").length && $('#from_date').val().trim()!='' && $('#to_date').val().trim()!='')
            {
                var frm=Date.parse($("#from_date").val());
                var to=Date.parse($("#to_date").val());
                if(frm>to)
                {
                    showNotification('ruby','From date cannot be after To date');
                    return false
                }
            }
        }
        else
        {

            if($("#from_date").length && $("#to_date").length && $('#from_date').val().trim()!='' && $('#to_date').val().trim()!='')
            {
                var frm=Date.parse($("#from_date").val());
                var to=Date.parse($("#to_date").val());
                if(frm>to)
                {
                    showNotification('ruby','From date cannot be after To date');
                    return false
                }
            }
        }
    }
    if($("#from_date").length && $("#to_date").length && $('#from_date').val().trim()!='' && $('#to_date').val().trim()!='')
    {
        var frm=Date.parse($("#from_date").val());
        var to=Date.parse($("#to_date").val());
    }
    $(".dataTables_processing").show();
    if($("#from_date").length)
        from_date = $("#from_date").val().trim();

    if($("#to_date").length)
        to_date = $("#to_date").val().trim();

    if($("#donation_ids").length)
        donation_id = $("#donation_ids").val();
    
    if($("#search_text").length)
        search_text = $("#search_text").val().trim();

    if($("#search_col").length)
        search_col = $("#search_col").val().trim();


    if (from_date != '' || to_date != '' || search_text!='' || donation_id!='' || currency!='' || group_by != '' || sevas_by_name != '')
        $("#searchClear").css("display", "inline-block");
    
    table.fnDraw();
}

function search_clear() 
{
    group_by='';
    sevas_by_name='';

    $(".dataTables_processing").show();
    $("#from_date").val('');
    from_date = '';

    $("#to_date").val('');
    to_date = '';

    $("#donation_ids").val('');
    $("#donation_ids").selectpicker("refresh");
    donation_id='';

    <?PHP
    if(is_single_currency_site==0)
    { 
        ?>
        currency='';
        <?PHP
    }
    ?>
    
    search_text='';
    $("#search_text").val("");

    search_col = '';
    $("#search_col").val($("#search_col option:first").val());
    
    $("#searchClear").css("display", "none");
    $(".changeCurrencyButton").removeClass("blue").addClass("default");
    $(".changeGroupByButton").removeClass("blue").addClass("default");
    $(".changeSevasByNameButton").removeClass("blue").addClass("default");
    $("#buttonCurrencyAll").removeClass("default").addClass("blue");
    table.fnDraw();
}


$(document).ready(function()
{
    $(".datepickerclass").datepicker(
    {
        format: 'dd M yyyy',
        defaultDate:''
    });

    $('.bs-select').selectpicker({
        iconBase: 'fa',
        tickIcon: 'fa-check'
    });
    $("#search_col").val($("#search_col option:first").val());

    table = $('#orderstable').dataTable({
        "processing": true,
        "language": {
            "sProcessing": '<div class="spinnerspin"></div>',
            "emptyTable": "No records found."
        },
        "sDom": "l<'custom-clear visible-xs'>ptr<'clearfix'>p",
        "sPaginationType": "bootstrap",
        "serverSide": true,
        "iDisplayLength": 100,
        "order": [
            [2, "desc"]
        ],
        "responsive": true,
        "lengthMenu": [
            [20,50,100],
            [20,50,100]
        ],
        "drawCallback": function(settings) 
        {
            var api = this.api();
            var totalrows = api.rows({
                page: 'current'
            }).data().context[0]._iRecordsTotal;
            $("#total_records").html('(' + totalrows + ')');
            $('.tooltips').tooltip();
        },
        "columns": [
        {
            "width": "5%",
            "orderable": false
        }, {
            name: "order_number",
            "width": "12%",
            "orderable": false
        }, {
            name: "o.date",
            "width": "9%",
            "orderable": false
        }, {
            name:"username",
            "width": "15%",
            "orderable": false
        }, {
            name:"email",
            "width": "12%",
            "orderable": false
        }, {
            name:"phone",
            "width": "12%",
            "orderable": false
        }, {
            "width": "12%",
            "orderable": false
        }, {
            "width": "15%",
            "orderable": false
        }, {
            "width": "15%",
            name: "item_name",
            "orderable": false
        }, {
            "width": "8%",
            "orderable": false
        }, {
            "width": "15%",//Note
            "orderable": false
        }, {
            name: "item_price",
            "width": "8%",
            "orderable": true
        }],
        "ajax": {
            url: '/orders/list_donation_sevas',
            type: 'POST',
            data: function(d) 
            {
                if (from_date != '')
                    d.from_date = from_date;
                if (to_date != '')
                    d.to_date = to_date;
                d.donation_id=donation_id;
                d.currency=currency;
                d.search_text=search_text;
                d.search_col=search_col;
                d.wild=wild;
                d.group_by=group_by;
                d.sevas_by_name=sevas_by_name;
                d.ashram_id=ashram_id;
                d.secret_key=secret_key;
            },
            complete: function (xhr, error, thrown) 
            {
                var jdata=$.parseJSON(xhr.responseText);
                <?PHP
                foreach ($GLOBALS['currencies'] as $currencyData)
                {
                    ?>
                    $("#total_<?PHP echo strtolower($currencyData['currency']) ?>").html(jdata.total_sum.<?PHP echo strtolower($currencyData['currency']); ?>);
                    <?PHP
                }
                ?>
                if(group_by!="" || sevas_by_name!="" )
                {
                    $("#searchClear").css("display", "inline-block");
                }
            },
            error: function (xhr, error, thrown) 
            {
                if(xhr.responseText=='login')
                {
                    window.location="<?PHP echo base_url; ?>"
                }
                else if(xhr.responseText==404 || xhr.responseText=='404' || xhr.responseText=='0')
                {
                   showNotification('ruby',"Invalid request");
                }
                $(".dataTables_processing").hide();
                return false;
            },
            dataSrc:function(res)
            {
                if(res.data.length==0 && res.recordsTotal!=0)
                {
                    table.fnDraw();
                }

                return res.data;
            }
        },
        "fnRowCallback": function(nRow, aData, iDisplayIndex, iDisplayIndexFull)
        {
            var vis = true;
            var ii = 0;
            var sno = 0;

            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "S. No.");
                ii++;
            }
            sno++;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "Seva ID");
                ii++;
            }
            sno++;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "Seva Date");
                ii++;
            }
            sno++;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "Devotee");
                ii++;
            }
            sno++;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "Email ID");
                ii++;
            }
            sno++;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "Phone");
                ii++;
            }
            sno++;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "Participant Name");
                ii++;
            }
            sno++;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "Address");
                ii++;
            }
            sno++;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "Seva Name");
                ii++;
            }
            sno++;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "Donation Dates");
                ii++;
            }
            sno++;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "Note");
                ii++;
            }
            sno++;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "Donation Amount");
                ii++;
            }
            return nRow;
        },
        "columnDefs": [
        {
            "render": function(data, type, row) {
                return row.sno;
            },
            "targets": 0
        }, {
            "render": function(data, type, row) 
            {
                var str='';
                if(row.group_by=='user' || row.group_by=='participant')
                {
                    str = "NA";
                }
                else
                {
                    str += '<b>'+row.order_number + '</b><br>';
                    if(row.tokens==1)
                    {
                        str+='<i class="pull-right fa fa-ticket tooltips" style="color:#3cc051;" data-placement="bottom" \
                                data-original-title="Tokens issued"></i>';
                    }
                    if(row.tokens==0)
                    {
                        str+='<i class="pull-right fa fa-ticket tooltips" style="color:red;" data-placement="bottom"\
                            data-original-title="Tokens not issued"></i>';
                    }
                    if(row.payment_status==1)
                        str+= '<span class="label label-success">Paid</span><br>';
                    if(row.payment_status==0)
                        str+= '<span class="label label-warning">Pending</span><br>';
                    if(row.payment_status==2)
                        str+= '<span class="label label-info">Partially paid</span><br>';

                    str+= '<b>'+row.payment_mode+'<b>';
                }
                return str;
            },
            "targets": 1
        }, {
            "render": function(data, type, row) 
            {
                if(row.group_by=='user' || row.group_by=='participant')
                {
                    return "NA";
                }
                else
                {
                    return row.date;
                }
            },
            "targets": 2
        }, {
            "render": function(data, type, row) 
            {
                var str='';
                str+='<strong>'+row.firstname+' '+row.lastname+'</strong>';
                str+='<br>'+row.email;
                str+='<br>'+row.phone;
                return '<span style="font-size:11px;">'+str+'</span>';
            },
            "targets": 3
        }, {
            "render": function(data, type, row) 
            {
                return row.email;
            },
            "targets": 4,
            "bVisible":false
        }, {
            "render": function(data, type, row) 
            {
                return row.phone;
            },
            "targets": 5,
            "bVisible":false
        }, {
            "render": function(data, type, row) 
            {
                if(row.group_by=='user')
                {
                    return "NA";
                }
                else
                {
                    return '<span style="font-weight:bold;color:maroon;">'+row.family_details+'</span>';
                }
            },
            "targets": 6,
        }, {
            "render": function(data, type, row) 
            {
                return row.address;
            },
            "targets": 7,
            'bVisible':false
        }, {
            "render": function(data, type, row) 
            {
                if(row.group_by=='user' || row.group_by=='participant')
                {
                    return "NA";
                }
                else
                {
                    return row.item_name;
                }
            },
            "targets": 8
        }, {
            "render": function(data, type, row) 
            {
                if(row.group_by=='user' || row.group_by=='participant')
                {
                    return "NA";
                }
                else
                {
                    return '<b>'+row.donation_dates+'</b>';
                }
            },
            "targets": 9
        },{
            "render": function(data, type, row) 
            {
                if(row.personal_note)
                    return row.personal_note;
                else
                    return "N/A";
            },
            "targets": 10,
            'bVisible':false
        }, {
            "render": function(data, type, row) 
            {
                var pricerow = '';
                if(row.group_by=='user' || row.group_by=='participant')
                {
                    if(row.currency.toLowerCase()=='usd')
                        pricerow += '<span style="color:red;font-weight:bold;">'+row.total_amount+'</span>';
                    else
                        pricerow += '<span style="font-weight:bold;">'+row.total_amount+'</span>';
                }
                else
                {
                    if(row.currency.toLowerCase()=='usd')
                        pricerow += '<span style="color:red;font-weight:bold;">'+row.item_price+'</span>';
                    else
                        pricerow += '<span style="font-weight:bold;">'+row.item_price+'</span>';
                    
                    pricerow += '<br><span style="font-size:10px;">'+row.item_price_quantity+'</span>';
                }
                return pricerow;
            },
            "targets": 11
        }]
    });
    $('.columnhide').on('click', function(e) 
    {
        var column = table.api().column( $(this).attr('data-column') );
        var cnum=$(this).attr('data-column');
        
        column.visible( ! column.visible(),true );
        var bVis = table.fnSettings().aoColumns[cnum].bVisible;
        var title = table.fnSettings().aoColumns[cnum].sTitle;
        
        var visibility=table.api().column(cnum).visible();
        table.api().column(cnum).nodes().to$().attr("data-title",title);
        if (visibility == false) 
        {
            $(this).removeClass('blue').addClass('red');
        }
        else 
        {
            $(this).removeClass('red').addClass('blue');
        }
    });
    $(".sortcolumn").on("click",function()
    {
        var currentSort = table.api().rows().context[0].aLastSort[0];   
        var corder=$(this).attr('data-order');
        var cnum=$(this).attr('data-column');
        if(currentSort.col==cnum)
        {
            if(currentSort.dir!=corder)
            {
                table.fnSort([cnum,corder]);
            }
        }
        else
        {
            table.fnSort([cnum,corder]);
        }
        sortIdentify();
    });

    $(".changeCurrencyButton").on("click",function()
    {
        var buttonCurrency=$(this).attr('currency');
        $(".changeCurrencyButton").removeClass("blue").addClass("default");
        $(this).removeClass("default").addClass("blue");

        if(buttonCurrency == 'All')
        {
            currency = '';
        }
        else
        {
            currency = buttonCurrency;
        }
        search(1)
        // table.fnDraw();
    });

    $(".changeGroupByButton").on("click",function()
    {
        var groupByType=$(this).attr('groupByType');
        $(".changeGroupByButton").removeClass("blue").addClass("default");
        $(this).removeClass("default").addClass("blue");

        if(groupByType == '')
        {
            group_by = '';
        }
        else
        {
            group_by = groupByType;
        }
        search(1)
    });

    $(".changeSevasByNameButton").on("click",function()
    {
        var showSevasByName=$(this).attr('showSevasByName');
        $(".changeSevasByNameButton").removeClass("blue").addClass("default");
        $(this).removeClass("default").addClass("blue");

        if(showSevasByName == '')
        {
            sevas_by_name = '';
        }
        else
        {
            sevas_by_name = showSevasByName;
        }
        search(1)
    });
});

function sortIdentify()
{
    var currentSort = table.api().rows().context[0].aLastSort[0];
    $(".sortcolumn").each(function(i,ele)
    {
        $(this).removeClass("blue").addClass("default");
        var corder=$(this).attr('data-order');
        var cnum=$(this).attr('data-column');
        if(cnum==currentSort.col)
        {
            $(this).removeClass("default").addClass("blue");
            if(currentSort.dir=='desc')
            {
                $(this).attr("data-order","asc");
                $(this).find("i").removeClass("fa-arrow-up").addClass("fa-arrow-down");
            }
            if(currentSort.dir=='asc')
            {
                $(this).attr("data-order","desc");
                $(this).find("i").removeClass("fa-arrow-down").addClass("fa-arrow-up");
            }
        }
    });
}
</script>