<!DOCTYPE html>
<html>
<head>
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
    <meta content="width=device-width, initial-scale=1.0" name="viewport" />
    <title><?PHP echo site_name_string1; ?> | Donation Sevas</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>
    <!-- <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/js/bootstrap.min.js"></script> -->
    <link href="<?php echo base_url."site_theme"; ?>/admin_fonts/google-css-open-sans.css" rel="stylesheet">
    <link href="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/datatables_1_10_5/media/css/dataTables.bootstrap.css" rel="stylesheet" type="text/css"/>
    <link rel="stylesheet" href="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/responsive.min.css">
    <link href="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/font-awesome/css/font-awesome.min.css" rel="stylesheet" type="text/css"/>
    <link href="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/bootstrap-datepicker/css/datepicker.css" rel="stylesheet" type="text/css" />
    <link rel="stylesheet" type="text/css" href="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/bootstrap-select/bootstrap-select.min.css"/>
    <link rel="stylesheet" type="text/css" href="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/select2/select2.css"/>
    <link rel="stylesheet" type="text/css" href="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/jquery-multi-select/css/multi-select.css"/>
    <link href="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/admin/layout/css/layout.css" rel="stylesheet" type="text/css"/>
    <link href="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/admin/layout/css/custom.css" rel="stylesheet" type="text/css"/>
    <link href="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/css/components.css" rel="stylesheet" type="text/css"/>
    <link rel="stylesheet" type="text/css" href="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/jquery-notific8/jquery.notific8.min.css"/>
    <style type="text/css">
        .currencymaskrw
        {
            margin-left: 20px;
        }
        .fixedheaderform
        {
            position: fixed;
            width: 100%;
            background: #fff;
            z-index: 9999;
        }
        .listRowContainer
        {
            margin-top: 195px;
        }
        .searchFormButton
        {
            margin-top: 15px;
            font-size: 16px;
            font-weight: bold;
            margin-right: 20px;
        }
        .searchFormRow
        {
            margin-top: 15px;
            padding-left: 0;
        }
        .searchFormRow input
        {
            font-size: 16px !important;
            padding-left: 5px !important;
            width: 100%;
        }
        .searchFormRow select
        {
            font-size: 16px !important;
            padding-left: 5px !important;
            width: 100%;
        }
        .bootstrap-select.btn-group .btn .filter-option
        {
            height: 25px;
            line-height: 25px;
        }

        @media screen and (max-width:420px)
        {
            .currencymaskrw
            {
                font-size: 15px;
            }
        }

        @media screen and (max-width:991px)
        {
            .fixedheaderform
            {
                position: relative;
            }
            .listRowContainer
            {
                margin-top: 0px;
            }
        }

        @media only screen and (min-width: 991px) and (max-width: 992px)
        {
            .listRowContainer {
              margin-top: 436px;
            }
        }

        @media only screen and (min-width: 992px) and (max-width: 1416px)
        {
            .listRowContainer {
              margin-top: 240px;
            }
        }
    </style>

</head>
<body>
    <div class="container">
        <!-- BEGIN PAGE TITLE & BREADCRUMB-->
        <h3 class="page-title" style="margin-top: 5px;font-weight: bold;">
           Vishwashanti Pada Yatra - Seva Karta Report
           <br>
           All Donation Sevas
        </h3>
        <h3 class="page-title" style="margin-top: 5px;">
            <span style="color:black; margin-right:20px;">
                ₹ <?PHP if(isset($reports['inr_total_amount']) && $reports['inr_total_amount']>0) { echo $reports['inr_total_amount']; } else { echo '0'; } ?>
            </span>
            <span style="color:red;">
                $ <?PHP if(isset($reports['usd_total_amount']) && $reports['usd_total_amount']>0) { echo $reports['usd_total_amount']; } else { echo '0'; } ?>
            </span>
        </h3>
        <!-- END PAGE TITLE & BREADCRUMB--> 
        <?php
        echo "<h3 style='font-weight:400;color:red;'>Report Date: ".date("d M Y, l")."</h3>";
        echo '<div class="row"><div class="col-md-12"><a href="'.base_url().'orders/vishwashanti_pada_yatra_all_items_report_seva_karta_pdf_report?secret_key='.vishwashantipadayatra2022_public_display_secret_key.'" target="_blank" class="btn btn-xs purple mobMarginBtm pull-right" style="margin-bottom:10px;"> <i class="fa fa-file-pdf-o"></i> Seva Karta PDF</a></div></div>';
        if(isset($reports['data']) && count($reports['data'])>0)
        {
            ?>
            <div class="row-fluid">
               <div class="portlet box blue">
                    <div class="portlet-title">
                        <div class="caption">Vishwashanti Pada Yatra - Seva Karta Report - All Donation Sevas</div>
                        <div class="tools">
                            <a href="javascript:;" class="collapse"></a>
                        </div>
                    </div>
                    <div class="portlet-body no-more-tables">
                        <table class="table-bordered table-striped dataTable  table table-condensed cf">
                            <thead>
                                <tr>
                                    <th width="6%">S. No.</th>
                                    <th width="18%">Name</th>
                                    <th width="25%">Family Details</th>
                                    <th width="18%">City</th>
                                    <th width="18%">Country</th>
                                    <th width="18%">Amount</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                $sno = 1;
                                $previousFamilyName = "";
                                foreach($reports['data'] as $this_report)
                                {
                                    if( ($this_report["family_details"]!="Sri Ganapathy Sachchidananda Swamiji" && $previousFamilyName=="Sri Ganapathy Sachchidananda Swamiji") || ($this_report["family_details"]!="Sri Datta Vijayananda Teertha Swamiji" && $previousFamilyName=="Sri Datta Vijayananda Teertha Swamiji") )
                                    {
                                        ?>
                                        <tr>
                                            <td colspan="6" style="height:20px;"></td>
                                        </tr>
                                        <?PHP
                                        $sno = 1;
                                    }
                                    $previousFamilyName = $this_report["family_details"];
                                    ?>
                                    <tr>
                                        <td style="font-weight:bold;font-size: 16px;" data-title="S.No.">
                                            <span class="tooltips" data-container="body" data-placement="bottom" data-original-title="<?PHP  echo $sno; ?>">
                                                <?PHP  echo $sno; ?>
                                            </span>
                                        </td>
                                        <td style="font-weight:bold;font-size: 16px;" data-title="Name">
                                            <span class="tooltips" data-container="body" data-placement="bottom" data-original-title="Name">
                                                <?PHP  
                                                    echo $this_report["name"];
                                                ?>
                                            </span>
                                        </td>
                                        <td style="font-weight:bold;font-size: 16px;" data-title="Family Details">
                                            <span class="tooltips" data-container="body" data-placement="bottom" data-original-title="Family Details">
                                                <?PHP  
                                                    echo strip_tags($this_report["family_details"], '<br></br><br/><p></p><b><br ><br /></br >');
                                                ?>
                                            </span>
                                        </td>
                                        <td style="font-weight:bold;font-size: 16px;" data-title="City">
                                            <span class="tooltips" data-container="body" data-placement="bottom" data-original-title="City">
                                                <?PHP  
                                                    echo $this_report["city"];
                                                ?>
                                            </span>
                                        </td>
                                        <td style="font-weight:bold;font-size: 16px;" data-title="Country">
                                            <span class="tooltips" data-container="body" data-placement="bottom" data-original-title="Country">
                                                <?PHP  
                                                    echo $this_report["country_name"];
                                                ?>
                                            </span>
                                        </td>
                                        <?PHP 
                                        if(strtolower($this_report["currency"]) == "inr")
                                        {
                                            $style = "font-weight:bold;";
                                            $amount_symbol = '<i class="fa fa-inr"></i>';
                                        }
                                        if(strtolower($this_report["currency"]) == "usd")
                                        {
                                            $style = "color:red;font-weight:bold;";
                                            $amount_symbol = '<i class="fa fa-usd"></i>';
                                        }
                                        ?>
                                        <td style="font-weight:bold;font-size: 16px;<?php echo $style;?>" data-title="Amount">
                                            <span class="tooltips" data-container="body" data-placement="bottom" data-original-title="Amount">
                                             <?php echo $amount_symbol . "". $this_report["amount"]; ?>   
                                            </span>
                                        </td>
                                    </tr>
                                    <?php
                                    $sno++;
                                }
                                ?>
                            </tbody>
                        </table>
                    </div>
               </div>
            </div>
        <?php } ?>

        <script src="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/datatables_1_10_5/media/js/jquery.dataTables.js" type="text/javascript"></script>
        <script src="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/datatables_1_10_5/media/js/dataTables_custom.js" type="text/javascript"></script>
    </div>
</body>