<!DOCTYPE html>
<html>
<head>
<style media = "screen">
body 
{
  background: rgb(204,204,204); 
}
page 
{
    background: white;
    display: block;
    margin: 0 auto;
    margin-bottom: 0.5cm;
    box-shadow: 0 0 0.5cm rgba(0,0,0,0.5);
}
page[size="A4"] 
{  
    width: 21cm;
    height: 29.7cm;
    overflow: auto;
    min-height: 100px;
    height: auto;
    word-wrap: break-word;
}
#paginationrw{
    float: left;
    width: 100%;
    margin-top: 20px;
    font-size: 18px;
    text-align: center;
}
#paginationrw a{
    padding-left: 5px;
    padding-right: 5px;
}
@media
    only screen  and (max-width: 760px), (min-device-width: 768px) and (max-device-width: 1024px)  
    {
        /* Force table to not be like tables anymore */
        page[size="A4"] 
        {
            width:100%;
        }
    }
</style>
<style type="text/css" media = "print">
@media print 
{   
    page[size="A4"] 
    {
        margin: 0;
        border: initial;
        border-radius: initial;
        width: initial;
        min-height: initial;
        box-shadow: initial;
        background: initial;
        page-break-after: always;
        page-break-after: avoid;
        overflow: auto;
        min-height: 100px;
        height: auto;
        page-break-before: avoid;
    }
    html, body {
      height:100vh; 
      margin: 0 !important; 
      padding: 0 !important;
    }
}
</style>
</head>
    <body>
        <input class="current-browser-title" data-title=" Admin Dashboard | All Transactions | Don. Declarations" type="hidden">
        <p id="paginationrw" class="hidden-print"><?php echo $pagination_links; ?></p>
        <a href="javascript:;" onclick="printDeclarations();" class="btn btn-xs green pull-right hidden-print declaration_print" style="margin-bottom:10px;">
            <i class="fa fa-print"></i> Print All Don. Declarations
        </a>
        <div class="clearfix"></div>
        <div class = "declaration_print" id="declaration_print">
            <?PHP
            $i = 0;
            if(isset($declarations) && !empty($declarations))
            {
                foreach($declarations as $transaction)
                { 
                    $order_data=unserialize($transaction->order_data);
                    if($i==2 || $i==0)
                    {
                        ?>
                        <page size="A4">
                        <?php
                    }
                    $i++;
                    $giftLetterFileName = '';
                    if((isset($transaction->declaration_type) && $transaction->declaration_type=='Gift') && (isset($transaction->declaration_template) && $transaction->declaration_template!='')  )
                    {

                        $templatepathcheck=$_SERVER['DOCUMENT_ROOT'].'/application/views/ashrams/admin/gift_donation_templates/'.trim($transaction->declaration_template).'.php';
                        if(file_exists($templatepathcheck))
                        {
                            $giftLetterFileName = trim($transaction->declaration_template);
                        }
                    }
                    if($giftLetterFileName!='')
                    {
                        $countryData = $this->locations_model->getCountryByCode($transaction->country);
                        $this->load->view("ashrams/admin/gift_donation_templates/".trim($transaction->declaration_template),array("transaction"=>$transaction,"modal"=>1, "showTransactionDetails"=>1,"countryData"=>$countryData));
                    }
                    else
                    {
                        if($transaction->payment_mode=='paypal')
                            $transaction->date=$transaction->created_on;
                        ?>
                        <div class="col-md-12 order-declaration" style="border: 2px solid #000; margin-top: 10px; padding: 10px;height:440px;overflow:hidden;">
                            <div class="agreement_summary">
                                <div align="center" class="receipt_header2" style="margin-top: 15px;">
                                    Donation Declaration
                                </div>
                                     
                                <div style="clear:both;margin-top: 25px;"></div>  
                                <p style="float:left; margin:0px;">
                                    <b><?PHP if(isset($transaction->declaration_type) && $transaction->declaration_type=='Gift') { echo 'Gift'; } else { echo 'Donation'; } ?> ID:</b> <?PHP if(isset($transaction->order_number)) echo $transaction->order_number; ?>
                                </p>

                                <p style="float:right; margin:0px;">
                                    <b>Date:</b> <?PHP if(!empty($transaction->date)) echo date("d M Y",strtotime($transaction->date));
                                    else  echo date("d M Y",strtotime($transaction->created_on)); ?><br>
                                </p>
                                <div style="clear:both"></div>      
                                <p style="float:right; margin:0px;"><b>Donor IP:</b> <?PHP echo $transaction->ip_address; ?></p>
                                <div style="clear:both; height:20px;"></div> 
                                <?PHP
                                $txamount=$transaction->amount;
                                /*if($transaction->sub_tx!='')
                                    $txamount=$transaction->t2amount;*/

                                ?>
                                <span>
                                    I / We <span class="dec_trust bold1">
                                        <?PHP
                                        if(isset(($transaction->firstname)))
                                            echo htmlentities($transaction->firstname);
                                        if(isset(($transaction->lastname)))
                                            echo " ".htmlentities($transaction->lastname);
                                        ?></span> hereby affirm that a donation of
                                             <span class="bold1" id="amount_declare">
                                                <?PHP if(isset($transaction->currency)) echo strtoupper($transaction->currency)." ".$txamount;  ?>
                                                </span> (in words) <span class="bold2" id="amount_declare_words">
                                                    <?PHP
                                                    if(isset($transaction->currency))
                                                        echo strtoupper($transaction->currency);
                                                    echo " ".$this->general_model->amountToWords($txamount);
                                                    ?>
                                                </span> only, has been made by me/us 
                                            <?PHP
                                            if(isset($transaction->currency) && strtolower($transaction->currency)=='inr')
                                            {
                                                ?>
                                                with a specific direction that it shall form a part of the
                                                <span class="bold1">corpus</span> of
                                                <?PHP
                                            }
                                            else
                                            {
                                                ?>
                                                towards
                                                <?PHP
                                            }
                                            ?>
                                            <span class="dec_trust bold1">
                                                <?PHP
                                                    if(isset($order_data['trustData']->trust_name))
                                                        echo htmlentities($order_data['trustData']->trust_name);
                                                    else if(isset($transaction->trust_name))
                                                        echo htmlentities($transaction->trust_name);
                                                ?>
                                            </span>.
                                    <br><br>
                                    <strong>Donor Address:</strong><br>
                                    <div class="donor_address">
                                        <?PHP
                                            if(isset($transaction->country))
                                                $countryData = $this->locations_model->getCountryByCode($transaction->country);
                                            if(isset($transaction->address1) && $transaction->address1!='')
                                                echo htmlentities($transaction->address1)."<br>";
                                            if(isset($transaction->address2) && $transaction->address2!='')
                                                echo htmlentities($transaction->address2)."<br>";
                                            if(isset($transaction->address3) && $transaction->address3!='')
                                                echo htmlentities($transaction->address3)."<br>";
                                            if(isset($transaction->city))
                                                echo htmlentities($transaction->city);
                                            if(isset($transaction->state))
                                                echo ", ".htmlentities($transaction->state);
                                            if(isset($transaction->zipcode)!='')
                                            {
                                                echo " - ".$transaction->zipcode;
                                            }
                                            if(isset($countryData->country_name))
                                                echo "<br>".htmlentities($countryData->country_name);

                                            $isdcode = '';
                                            if(isset($transaction->isd_code)!='')
                                            {  
                                                $isdcode = "+".$transaction->isd_code;
                                            }
                                            if(isset($transaction->phone))
                                                echo '<br>Ph: '.$isdcode." ".htmlentities($transaction->phone);
                                            if(isset($transaction->pan_or_aadhaar) && $transaction->pan_or_aadhaar=='PAN' && strtolower($transaction->currency)=='inr')
                                            {
                                                echo '<br>PAN Number: '.htmlentities($transaction->order_pan_number);
                                            }
                                            else if(isset($transaction->pan_or_aadhaar) && $transaction->pan_or_aadhaar=='Aadhaar' && strtolower($transaction->currency)=='inr')
                                            {
                                                echo '<br>Aadhaar Number: '.htmlentities($transaction->order_aadhaar_number);
                                            }
                                            else if(isset($transaction->pan_or_aadhaar) && $transaction->pan_or_aadhaar=='TIN' && strtolower($transaction->currency)=='inr')
                                            {
                                                echo '<br>TIN Number: '.htmlentities($transaction->order_tin_number);
                                            }
                                            else if(isset($transaction->pan_or_aadhaar) && $transaction->pan_or_aadhaar=='Passport' && strtolower($transaction->currency)=='inr')
                                            {
                                                echo '<br>Passport Number: '.htmlentities($transaction->order_passport_number);
                                            }
                                            else if(isset($transaction->pan_or_aadhaar) && $transaction->pan_or_aadhaar=='EPIC' && strtolower($transaction->currency)=='inr')
                                            {
                                                echo '<br>Voter EPIC Number: '.htmlentities($transaction->order_voter_epic_number);
                                            }
                                            else if(isset($transaction->pan_or_aadhaar) && $transaction->pan_or_aadhaar=='DL' && strtolower($transaction->currency)=='inr')
                                            {
                                                echo '<br>Driving License Number: '.htmlentities($transaction->order_driving_license_number);
                                            }
                                            else if(isset($transaction->pan_or_aadhaar) && $transaction->pan_or_aadhaar=='RationCard' && strtolower($transaction->currency)=='inr')
                                            {
                                                echo '<br>Ration Card Number: '.htmlentities($transaction->order_ration_card_number);
                                            }
                                            if(isset($transaction->email))
                                                echo '<br>Email ID: '.htmlentities($transaction->email);
                                        ?>
                                    </div>
                                </span>
                                <div class="control-group">
                                    <div class="controls">
                                        <p  align="right" style="border:1px solid grey; float:right; padding:2px;margin-top: -20px;">
                                            <?PHP
                                            if(isset($transaction->donation_initials))
                                                echo $transaction->donation_initials;
                                            ?>
                                        </p>
                                    </div>
                                </div>
                                <div class="clearfix"></div>
                            </div>
                        </div>
                        <?php
                    }
                    if($i==2 || $i==0)
                    {
                        ?>
                        </page>
                        <?php
                        $i=0;
                    }
                }
            }
            ?>
        </div>
    </body>
</html>
<script type="text/javascript">
    var pdfTitle = "Donation_Declarations";
    <?PHP
    if(isset($_GET["from_date"]) && $_GET["from_date"]!="")
    {
        ?>
        pdfTitle += "_<?PHP echo str_replace(' ', '_', $_GET["from_date"]); ?>";
        <?PHP
    }
    if(isset($_GET["to_date"]) && $_GET["to_date"]!="")
    {
        ?>
        pdfTitle += "_to_<?PHP echo str_replace(' ', '_', $_GET["to_date"]); ?>";
        <?PHP
    }
    if(isset($_GET["ashram_id"]) && $_GET["ashram_id"]!="")
    {
        ?>
        pdfTitle += "_<?PHP echo $_GET["ashram_id"]; ?>";
        <?PHP
    }
    if(isset($_GET["currency"]) && $_GET["currency"]!="")
    {
        ?>
        pdfTitle += "_<?PHP echo $_GET["currency"]; ?>";
        <?PHP
    }
    if(isset($page_number) && $page_number!="")
    {
        ?>
        pdfTitle += "_<?PHP echo $page_number; ?>";
        <?PHP
    }
    ?>
    var actualPageTitle = pdfTitle;
    function printDeclarations()
    {
        try 
        {
            iframe = document.getElementById('iframe-id');
            iframe.contentWindow.document.execCommand('print', false, null);
        }
        catch(e) {
            // document.title = 'Donation_Declarations_2022_Jan_01_<ashram-id>_inr_101_200';
            document.title = pdfTitle;
            window.print();
        }
    }

    // $(document).ready(function() {
    //     createPagination(0);

    //     $(document).on('click','#paginationrw a',function(e){
    //         e.preventDefault(); 
    //         var pageNum = $(this).attr('data-ci-pagination-page');
    //         createPagination(pageNum);
    //     });
    //     function createPagination(pageNum){
    //         $(".loader_animation").show();
    //         if(pageNum==0)
    //         {
    //             pdfTitle = actualPageTitle+"_1";
    //         }
    //         else
    //         {
    //             pdfTitle = actualPageTitle+"_"+pageNum;
    //         }
    //         $.ajax({
    //             url: '<?PHP echo base_url(); ?>orders/load_donation_declarations/'+pageNum+'<?PHP echo $get_data; ?>',
    //             type: 'get',
    //             // dataType: 'json',
    //             success: function(successResponseData){
    //                 $('#declaration_print').empty().append(successResponseData);
    //                 $(".loader_animation").hide();
    //             },
    //             error: function(errorResponseData) {
    //                 $('#declaration_print').empty().append(errorResponseData);
    //                 $(".loader_animation").hide();
    //             }

    //         });
    //     }
    // });
</script>