<div class="alert alert-info hidden-print">
	<strong>All Transactions tab displays all successful, failed and bounced transactions in the Subscription payment flow.</strong>
</div>
<?PHP
$order_items=array();
foreach ($orderData['order_items'] as $itemData)
{
    $order_items[$itemData->id]=$itemData;
}
$total_onetime_tx=0;
$transactions=$this->transaction_model->getTransactionsByOrder($id,0,2);
foreach ($transactions as $transaction)
{
	if(empty($transaction->amount))
	{
		continue;
	}
	$total_onetime_tx++;
}
if($total_onetime_tx)
{
	?>
	<h4 class="modal-title hidden-print bold">One time transactions</h4>
	<table id="txtable" class="display table-bordered hidden-print table-condensed table table-striped table-hover"
		cellspacing="0" width="100%">
        <thead>
            <tr>
                <th width="60">S. No.</th>
                <th width="19%">Tx Date/ID</th>
                <th width="10%">Amount</th>
                <th >Details</th>
                <th width="25%">More Details</th>
                <th width="12%">Mode/Status</th>
            </tr>
        </thead>
        <tbody>
        	<?PHP
        	$sno=1;
        	$receipts_modals='';
        	foreach ($transactions as $transaction)
        	{
        		if(empty($transaction->amount))
        			continue;
        		?>
        		<tr>
        			<td data-title="S. No.">
        				<?PHP echo $sno++; ?>
        			</td>
        			<td data-title="Tx Date/ID">
        				<?PHP
        					echo date("d M Y h:i A",strtotime($transaction->created_on));
        					?>
        					<br>
        					<span class = "error" style="color:green;font-weight: bold;"><?PHP echo date("l",strtotime($transaction->created_on)); ?></span> 
        				<?PHP
        					/*if($transaction->sub_transaction==1)
        					echo $transaction->sub_tx;
        				else*/
        					echo "<br>".$transaction->t2tx;
        				?>
        			</td>
        			<td data-title="Amount">
        				<?PHP echo strtoupper($transaction->currency)." ".$transaction->amount; ?>
        			</td>
        			<td data-title="Details">
        				<?PHP
        				if($transaction->order_item_id)
            			{
            				echo "Setup fee for subscription: ".$order_items[$transaction->order_item_id]->item_name."<br>";
            			}
            			else
            			{
            				echo "One time payment item(s)<br>";
            			}
        				echo nl2br($transaction->note); ?>
        				&nbsp;
        			</td>
        			<td data-title="More Details">
        				<?PHP
        					if($orderData['order']->payment_alt_mode=='cash')
            				{
                				if($transaction->status!='pending' && $transaction->status!='cash_pending')
                				{
	                				if($transaction->payment_mode=="mo" && $transaction->offline_number!='')
	                				{
	                					echo "<p><b>MO #:</b> ".trim(htmlentities($transaction->offline_number))."</p>";
                						echo "<p><b>MO date:</b> ".date("d M Y",strtotime($transaction->offline_date))."</p>";
                						?>
                						<hr style="background: #000; height: 1px; width:150px; max-width:100%;">
                						<?PHP
	                				}
	                				if($transaction->payment_mode=="dd" && $transaction->offline_number!='')
	                				{
	                					echo "<p><b>DD #:</b> ".trim(htmlentities($transaction->offline_number))."</p>";
                						echo "<p><b>DD date:</b> ".date("d M Y",strtotime($transaction->offline_date))."</p>";
                						echo "<p><b>Bank:</b> ".trim(htmlentities($transaction->offline_bank))."</p>";
                						?>
                						<hr style="background: #000; height: 1px; width:150px; max-width:100%;">
                						<?PHP
	                				}
	                				if($transaction->payment_mode=="cheque" && $transaction->offline_number!='')
	                				{
                						echo "<p><b>Cheque #:</b> ".trim(htmlentities($transaction->offline_number))."</p>";
                						echo "<p><b>Cheque date:</b> ".date("d M Y",strtotime($transaction->offline_date))."</p>";
                						echo "<p><b>Bank:</b> ".trim(htmlentities($transaction->offline_bank))."</p>";
                						?>
                						<hr style="background: #000; height: 1px; width:150px; max-width:100%;">
                						<?PHP                					
	                				}
	                				if($transaction->payment_mode=="cashiers_check" && $transaction->offline_number!='')
	                				{
                						echo "<p><b>CC #:</b> ".trim(htmlentities($transaction->offline_number))."</p>";
                						echo "<p><b>Cheque date:</b> ".date("d M Y",strtotime($transaction->offline_date))."</p>";
                						echo "<p><b>Bank:</b> ".trim(htmlentities($transaction->offline_bank))."</p>";
                						?>
                						<hr style="background: #000; height: 1px; width:150px; max-width:100%;">
                						<?PHP
	                				}
	                				if(($transaction->payment_mode=="cc" || $transaction->payment_mode=="dc") && $transaction->offline_number!='')
	                				{
                						echo "<p><b>Card #:</b> **** **** **** ".trim(htmlentities($transaction->offline_number))."</p>";
                						echo "<p><b>Bank:</b> ".trim(htmlentities($transaction->offline_bank))."</p>";
                						?>
                						<hr style="background: #000; height: 1px; width:150px; max-width:100%;">
                						<?PHP
	                				}

	                				echo "<p><b style='color:red;'>Manual transaction:</b> ";
				                        	if($transaction->is_manual_payment==1)
				                        		echo "Yes";
				                        	else
				                        		echo "No";
            						echo "</p>";

	                				if($transaction->is_manual_payment==1)
                					{
                						echo "<p><b>Receipt #:</b> ".trim(htmlentities($transaction->manual_receipt_number))."</p>";
                						echo "<p><b>Receipt date:</b> ";
                						if($transaction->manual_receipt_date)
                							echo date("d M Y",strtotime($transaction->manual_receipt_date));
                						"</p>";
                						?>
                						<hr style="background: #000; height: 1px; width:150px; max-width:100%;">
                						<?PHP
                					}
                					if($transaction->is_manual_payment==0 && $transaction->is_foreign_payment==1)
                					{
                						?>
                						<hr style="background: #000; height: 1px; width:150px; max-width:100%;">
                						<?PHP
                					}

            						echo "<p><b style='color:red;'>Foreign transaction:</b> ";
            						
				                        	if($transaction->is_foreign_payment==1)
				                        		echo "Yes";
				                        	else
				                        		echo "No";
            						echo "</p>";

	                				if($transaction->is_foreign_payment==1)
                					{
                						echo "<p><b>Currency:</b> ".trim(htmlentities($transaction->foreign_currency))."</p>";
                						echo "<p><b>Foreign amount:</b> ".$transaction->foreign_amount."</p>";
                						echo "<p><b>Realized amount:</b> ".$transaction->realized_amount."</p>";
                					}
                					if($transaction->status=='refund')
                					{
                						?>
                						<hr style="background: #000; height: 1px; width:150px; max-width:100%;">
                						<?PHP
                						echo "<p><b style='color:red;'>Refund details:</b><br>";
                						echo "<b>Mode:</b> ".$transaction->refund_mode."<br>";
                						echo "<b>Reference number:</b> ".$transaction->refund_reference."<br>";
                						echo "<b>Date:</b> ".date("d M Y",strtotime($transaction->refund_date))."<br>";

                					}
                				}
                				else
                				{
                					echo "N/A";
                				}
                			}
                			else
                				echo "N/A";
        				?>
        			</td>
        			
        			<td  data-title="Mode/Status">
        				<?PHP
        				$breack_check2 = "";
        				if(!in_array($transaction->status,array("pending","cash_pending")))
        					echo $transaction->payment_mode;

        				if(!in_array($transaction->status,array("pending","cash_pending")))
        				{
        					if($transaction->is_manual_payment==1)
                        	{
                        		$breack_check2 = "";
                        		echo "<br><span class='label label-warning' style='margin-top:5px;'>Manual TX</span>";
                        	}
                        	if($transaction->is_foreign_payment==1)
                        	{
                        		$breack_check2 = "";
                        		echo "<br><span class='label label-danger' style='margin-top:5px;'>Foreign TX</span>";
                        	}
                        	if($transaction->is_manual_payment==0 && ($transaction->payment_mode == "cash" || $transaction->payment_mode == "cheque" || $transaction->payment_mode == "dd" || $transaction->payment_mode == "mo" || $transaction->payment_mode == "cc" || $transaction->payment_mode == "neft" || $transaction->payment_mode == "dc" || $transaction->payment_mode == "cashiers_check" ))
                        	{
                        		$breack_check2 = 1;
                        		echo "<br><span class='label label-grey' style='color:black;background:lightgrey;margin-top:5px;'>Offline TX</span><br>";
                        	}
                        	if($transaction->payment_mode == "paypal" || $transaction->payment_mode == "payu" || $transaction->payment_mode == "razorpay" || $transaction->payment_mode == "stripe")
                        	{
                        		$breack_check2 = 1;
                        		echo "<br><span class='label label-primary' style='margin-top:5px;'>Online TX</span><br>";
                        	}
                            if($transaction->payment_mode == "system" && $transaction->system_generated == 1)
                            {
                                $breack_check2 = 1;
                                echo "<br><span class='label label-warning' style='margin-top:5px;'>System TX</span><br>";
                            }
                        }
                        if($breack_check2 == "")
                        {
                        	echo "<br>";
                        }
        				if(in_array(strtolower($transaction->status),array("completed",'success','release payment','Release Payment','approved','captured','paid')))
        				{
        					?>
        					<span class="label label-success" style='margin-top:5px;'>Paid</span>
        					<?PHP
        				}
        				else if(in_array($transaction->status,array("pending","cash_pending")))
        				{
        					?>
        					<span class="label label-warning" style='margin-top:5px;'>Pending</span>
        					<?PHP
        				}
        				else
        				{
            				if($transaction->status=='inprocess')
            				{
            					?>
            					<span class="label label-warning" style='margin-top:5px;'>In Process</span>
            					<?PHP
            				}
            				else if($transaction->status=='failure')
            				{
            					?>
            					<span class="label label-danger" style='margin-top:5px;'>Failed</span>
            					<?PHP
            				}
            				else if($transaction->status=='bounced')
            				{
            					?>
            					<span class="label label-danger" style='margin-top:5px;'>Bounced</span>
            					<?PHP
            				}
            				else if($transaction->status=='refund')
            				{
            					?>
            					<span class="label label-danger" style='margin-top:5px;'>Refunded</span>
            					<?PHP
            				}
            				else
            				{
            					?>
            					<span class="label label-danger" style='margin-top:5px;'><?PHP echo $transaction->status ?></span>
            					<?PHP
            				}
        				}
        				?>
        			</td>
        			
        		</tr>
        		<?PHP
        	}
        	?>
        </tbody>
    </table>

    <?PHP
	//echo $receipts_modals;
}

foreach ($orderData['order_items'] as $itemData)
{
	$payments=$this->subscription_payments_model->getAllByOrderItem($itemData->order_item_id);
	
	if(count($payments))
	{
		?>
		<?php if($itemData->status == 2) { ?> 
            			
		<h4 class="modal-title bold hidden-print" style="margin-top: 20px;"><?PHP echo htmlentities($itemData->item_name); ?> - Payments <span class = "red" style="color:red;">(Cancelled)</span></h4>
		<?php } else { ?>
		<h4 class="modal-title bold hidden-print" style="margin-top: 20px;"><?PHP echo htmlentities($itemData->item_name); ?> - Payments</h4>
		<?php } ?>
        <table id="subscription-payments-<?PHP echo $itemData->order_item_id; ?>"
        	class="display table-bordered table-condensed table table-striped table-hover hidden-print" cellspacing="0" width="100%" >
            <thead>
                <tr>
                    <th width="7%">Payment #</th>
                    <th width="10%">Payment Date</th>
                    <th width="15%">Tx Date/ID</th>
                    <th width="10%">Amount</th>
                    <th >Details</th>
                    <th width="25%">More Details</th>
                    
                    <th width="8%">Mode/Status</th>
                    
                </tr>
            </thead>
            <tbody>
            	<?PHP
            	$first_date=$itemData->schedule_dates;
            	$sno=1;
            	foreach ($payments as $spayment)
            	{
            		$spayment->date =date("d M Y h:i A",strtotime($spayment->date));
            		$spayment->rdate =date("d M Y",strtotime($spayment->date));
            		$spayment->amount_words=$this->general_model->amountToWords($spayment->amount);
            		$spayment->amount_declare=strtoupper($orderData['order']->currency)." ".$spayment->amount;
            		$period=$itemData->period;
            		$payment_date=date("d M Y",strtotime("+".($spayment->payment_number-1)*$itemData->frequency." ".$period,strtotime($first_date)));
            		?>
            		<?php if($itemData->status == 2 && $spayment->tx_status == "") { ?> 
            			<tr id = "cancel_trans">
            			<style type="text/css">
            				.table-striped tbody{
						    background-color: grey !important;
						}
            			</style>
            		<?php } else { ?> <tr><?php } ?>
            			<td data-title="Payment #">
            				<?PHP echo $spayment->payment_number; ?>
            			</td>
            			<td data-title="Payment Date">
            				<?PHP
            					echo $payment_date;
            				?>
                            <br>
            				<span class = "error" style="color:green;font-weight: bold;"><?PHP echo date("l",strtotime($payment_date)); ?></span> 
            			</td>
            			<td data-title="Tx Date/ID">
            				<?PHP
            				if($spayment->status==0)
            				{
            					echo "-";
            				}
            				else
            				{
                                if(date("d M Y",strtotime($spayment->created_on)) == "01 Jan 1970")
                                {
                                    echo "-";
                                }
                                else
                                {
                                    echo date("d M Y h:i A",strtotime($spayment->created_on));
                                    ?>
                                    <br><span class = "error" style="color:green;font-weight: bold;"><?PHP echo date("l",strtotime($spayment->created_on)); ?></span>
                                    <?php
                                }
            				}

            				if($spayment->status!=0)
            					echo "<br>".$spayment->tx;
            				?>
            			</td>
            			<td data-title="Amount">
            				<?PHP
            					echo strtoupper($orderData['order']->currency)." ".$spayment->amount;
            				?>
            			</td>
            			<td data-title="Details">
            				<?PHP echo nl2br($spayment->note); ?>
            				&nbsp;
            			</td>
            			<td data-title="More Details">
            				<?PHP
            				if($orderData['order']->payment_alt_mode=='cash')
            				{
                				if($spayment->status!='pending' && $spayment->status!='cash_pending')
                				{
	                				if($spayment->payment_mode=="mo" && $spayment->offline_number!='')
	                				{
	                					echo "<p><b>MO #:</b> ".trim(htmlentities($spayment->offline_number))."</p>";
                						echo "<p><b>MO date:</b> ".date("d M Y",strtotime($spayment->offline_date))."</p>";
                						?>
                						<hr style="background: #000; height: 1px; width:150px; max-width:100%;">
                						<?PHP
	                				}
	                				if($spayment->payment_mode=="dd" && $spayment->offline_number!='')
	                				{
	                					echo "<p><b>DD #:</b> ".trim(htmlentities($spayment->offline_number))."</p>";
                						echo "<p><b>DD date:</b> ".date("d M Y",strtotime($spayment->offline_date))."</p>";
                						echo "<p><b>Bank:</b> ".trim(htmlentities($spayment->offline_bank))."</p>";
                						?>
                						<hr style="background: #000; height: 1px; width:150px; max-width:100%;">
                						<?PHP
	                				}
	                				if($spayment->payment_mode=="cheque" && $spayment->offline_number!='')
	                				{
                						echo "<p><b>Cheque #:</b> ".trim(htmlentities($spayment->offline_number))."</p>";
                						echo "<p><b>Cheque date:</b> ".date("d M Y",strtotime($spayment->offline_date))."</p>";
                						echo "<p><b>Bank:</b> ".trim(htmlentities($spayment->offline_bank))."</p>";
                						?>
                						<hr style="background: #000; height: 1px; width:150px; max-width:100%;">
                						<?PHP         					
	                				}
	                				if($spayment->payment_mode=="cashiers_check" && $spayment->offline_number!='')
	                				{
                						echo "<p><b>CC #:</b> ".trim(htmlentities($spayment->offline_number))."</p>";
                						echo "<p><b>Cheque date:</b> ".date("d M Y",strtotime($spayment->offline_date))."</p>";
                						echo "<p><b>Bank:</b> ".trim(htmlentities($spayment->offline_bank))."</p>";
                						?>
                						<hr style="background: #000; height: 1px; width:150px; max-width:100%;">
                						<?PHP
	                				}
	                				if(($spayment->payment_mode=="cc" || $spayment->payment_mode=="dc") && $spayment->offline_number!='')
	                				{
                						echo "<p><b>Card #:</b> **** **** **** ".trim(htmlentities($spayment->offline_number))."</p>";
                						echo "<p><b>Bank:</b> ".trim(htmlentities($spayment->offline_bank))."</p>";
                						?>
                						<hr style="background: #000; height: 1px; width:150px; max-width:100%;">
                						<?PHP
	                				}
		                				
	                				echo "<p><b style='color:red;'>Manual transaction:</b> ";
				                        	if($spayment->is_manual_payment==1)
				                        		echo "Yes";
				                        	else
				                        		echo "No";
            						echo "</p>";

	                				if($spayment->is_manual_payment==1)
                					{
                						echo "<p><b>Receipt #:</b> ".trim(htmlentities($spayment->manual_receipt_number))."</p>";
                						echo "<p><b>Receipt date:</b> ";
                						if($spayment->manual_receipt_date)
                							echo date("d M Y",strtotime($spayment->manual_receipt_date));
                						"</p>";
                						?>
                						<hr style="background: #000; height: 1px; width:150px; max-width:100%;">
                						<?PHP
                					}

            						echo "<p><b style='color:red;'>Foreign transaction:</b> ";
            						
				                        	if($spayment->is_foreign_payment==1)
				                        		echo "Yes";
				                        	else
				                        		echo "No";
            						echo "</p>";

	                				if($spayment->is_foreign_payment==1)
                					{
                						echo "<p><b>Currency:</b> ".trim(htmlentities($spayment->foreign_currency))."</p>";
                						echo "<p><b>Foreign amount:</b> ".$spayment->foreign_amount."</p>";
                						echo "<p><b>Realized amount:</b> ".$spayment->realized_amount."</p>";
                					}
                					if($spayment->tx_status=='refund')
                					{
                						?>
                						<hr style="background: #000; height: 1px; width:150px; max-width:100%;">
                						<?PHP
                						echo "<p><b style='color:red;'>Refund details:</b><br>";
                						echo "<b>Mode:</b> ".$spayment->refund_mode."<br>";
                						echo "<b>Reference number:</b> ".$spayment->refund_reference."<br>";
                						echo "<b>Date:</b> ".date("d M Y",strtotime($spayment->refund_date))."<br>";

                					}
                				}
                				else
                				{
                					echo "N/A";
                				}
                			}
                			else
                				echo "N/A";
            				?>
            			</td>
            			
            			<td data-title="Mode/Status">
            				<?PHP
            					$breack_check1 = "";
            					if($spayment->payment_mode=='') echo ""; else echo $spayment->payment_mode;
            					if($spayment->status != 0)
                				{
                					if($spayment->is_manual_payment==1)
		                        	{
		                        		$breack_check1 = "";
		                        		echo "<br><span class='label label-warning' style='margin-top:5px;'>Manual TX</span>";
		                        	}
		                        	if($spayment->is_foreign_payment==1)
		                        	{
		                        		$breack_check1 = "";
		                        		echo "<br><span class='label label-danger' style='margin-top:5px;'>Foreign TX</span>";
		                        	}
		                        	if($spayment->is_manual_payment==0 && ($spayment->payment_mode == "cash" || $spayment->payment_mode == "cheque" || $spayment->payment_mode == "dd" || $spayment->payment_mode == "mo" ||  $spayment->payment_mode == "cc" || $spayment->payment_mode == "dc" || $spayment->payment_mode == "neft" || $spayment->payment_mode == "cashiers_check" ))
		                        	{
		                        		$breack_check1 = 1;
		                        		echo "<br><span class='label label-grey' style='color:black;background:lightgrey;margin-top:5px;'>Offline TX</span><br>";
		                        	}
		                        	if($spayment->payment_mode == "paypal" || $spayment->payment_mode == "payu" || $spayment->payment_mode == "razorpay" || $spayment->payment_mode == "stripe")
		                        	{
		                        		echo "<br><span class='label label-primary' style='margin-top:5px;'>Online TX</span>";
		                        	}
		                        }
            					echo "<p></p>";
            					if(in_array(strtolower($spayment->tx_status),array("completed",'success','release payment','Release Payment','approved','captured','paid')))
                				{
                					?>
                					<span class="label label-success">Paid</span>
                					<?PHP
                				}
                				else if($spayment->tx_status=='pending' || $spayment->tx_status=='cash_pending')
                				{
                					?>
                					<span class="label label-warning">Pending</span>
                					<?PHP
                				}
                                else if($spayment->tx_status=='failure')
                                {
                                    ?>
                                    <span class="label label-danger">Failed</span>
                                    <?PHP
                                }
                				else if($spayment->tx_status=='inprocess')
                				{
                					?>
                					<span class="label label-warning">In Process</span>
                					<?PHP
                				}
                				else if($spayment->tx_status=='bounced')
                				{
                					?>
                					<span class="label label-danger">Bounced</span>
                					<?PHP
                				}
                				else if($spayment->tx_status=='refund')
                				{
                					?>
                					<span class="label label-danger">Refunded</span>
                					<?PHP
                				}
                				else
                				{
                					if($spayment->tx_status=='')
                					{
                						?>
	                					<span class="label label-warning">Pending</span>
	                					<?PHP
                					}
                					else if($spayment->tx_status=='failure')
                					{
                						?>
	                					<span class="label label-danger">Failed</span>
	                					<?PHP
                					}
                					else
                					{
	                					?>
	                					<span class="label label-danger">Failed</span>
	                					<?PHP
	                				}
                				}
            				?>
            			</td>
            			
            		</tr>
            		<?PHP
            	}
            	?>
            </tbody>
        </table>
        <div class="clearfix"></div>
		<?PHP
	}
}
?>
<div class="clearfix" style="height: 200px;"></div>