<?PHP
$partHeader='Add Note';
if($id)
{
    $partHeader=htmlentities($note_data->title);
}
?>
<input class="current-browser-title" data-title=" User Dashboard  | My Notes | <?PHP echo $partHeader; ?>" type="hidden">
<?PHP
    $this->load->view("notes/user/nav_buttons");
?>
<h3 class="page-title">
    <?PHP
        echo $partHeader; 
    ?>
</h3>
<div class="page-bar">
    <ul class="page-breadcrumb">
        <li>
            <i class="fa fa-home"></i>
            <a href="<?PHP echo base_url; ?>myaccount">Dashboard</a>
            <i class="fa fa-angle-right"></i>
        </li>
        <li>
            <a href="/mynotes">All Notes</a>
            <i class="fa fa-angle-right"></i>
        </li>
        <li><?PHP echo $partHeader; ?></li>
    </ul>
</div>
<?PHP
if($this->session->flashdata("note_error"))
{
	?>
    <div class="alert alert-danger">
        <button class="close" data-dismiss="alert"></button>
        <strong>Error saving changes, please try again.</strong>
    </div>
    <?PHP
}
if($this->session->flashdata("note_created"))
{
	?>
    <div class="alert alert-success">
        <button class="close" data-dismiss="alert"></button>
        <strong>Note created successfully.</strong>
    </div>
    <?PHP
}

if($this->session->flashdata("note_saved"))
{
	?>
    <div class="alert alert-success">
        <button class="close" data-dismiss="alert"></button>
        <strong>Changes saved successfully.</strong>
    </div>
    <?PHP
}
?>

<div class="row-fluid">
<!-- BEGIN SAMPLE TABLE PORTLET-->
	<div class="margin-bottom-40">
		
		<div class="portlet box blue">
			<div class="portlet-title">
				<div class="caption"><?PHP echo $partHeader; ?></div>
				<div class="tools">
					<a href="javascript:;" class="collapse"></a>
				</div>
                
			</div>
            
			<div class="portlet-body">
				<form action="" id="note_form" name="note_form" method="post">

		            <div class="form-group">
		                <label class="control-label">Title
		                </label>
		                <div class="form-content">
		                    <input type="text" class="form-control" name="title" id="title"
		                        value="<?PHP if($id) echo htmlentities($note_data->title); ?>">
		                </div>
		            </div>
		            <div class="form-group">
		                <label class="control-label"> Content
		                </label>
		                <div class="form-content">
		                    <textarea class="form-control" name="content" id="content" rows="6"><?PHP 
		                        if($id) echo htmlentities($note_data->content); ?></textarea>
		                </div>
		            </div>
		            <div class="form-group">
						<div class="form-content">
							<button type="submit" name="add_note" id="add_note" class="btn btn-xs blue"> 
							<i class="fa fa-check"></i> <?PHP if($id) echo "Save"; else echo "Add Note"; ?></button>
							<a href="/mynotes" class="btn btn-xs red"> <i class="fa fa-ban"></i> Cancel</a>
						</div>
					</div>


				</form>
			</div>
		</div>



    </div>
 
</div>

<script type="text/javascript">
				
$( document ).ready(function() 
{			
	$('#note_form').validate({
        errorElement: 'label', //default input error message container
        errorClass: 'help-inline', // default input error message class
        focusInvalid: true, // do not focus the last invalid input
		 onkeyup: false,
       	rules: {
            title: {
                required: true,
                minlength:2,
                maxlength:100
            },
            content:
            {
                required:true,
            	minlength:3,
            	maxlength:5000
            }
        },

        messages: {
            title: {
                required: "Please enter Note Title"
            },
            content: {
                required: "Please enter Content"
            }
        },

    	highlight: function (element) { // hightlight error inputs
            $(element)
                .closest('.form-group').removeClass("has-success").addClass('has-error'); // set error class to the control group   
        },
        success: function (label, element)
        {
            $(element).closest('.form-group').removeClass('has-error').addClass('has-success');
			label.remove();
        },
        errorPlacement: function (error, element)
        {
			error.addClass('help-small no-left-padding').insertAfter(element);
        }
    });
	
});
</script>
