<style type="text/css">
    .radio-section label
    {
        cursor:pointer;
        margin: 0px 10px 0px 0px;
        font-size:14px;
    }
</style>
<input class="current-browser-title" data-title=" Admin Dashboard | Knowledgebase | <?PHP echo $this->kbTypes[$type]; ?> KB | Add/Edit KB" type="hidden">
<?PHP
    $this->load->view("kb/admin/nav_buttons");
?>
<h3 class="page-title">
    <?PHP
        if($id)
        {
            echo $this->kbTypes[$type]." KB - ".htmlentities($kbData->title);
        }
        else
            echo "Add/Edit ".$this->kbTypes[$type]." KB";    
    ?>
</h3>
<div class="page-bar">
    <ul class="page-breadcrumb">
        <li>
            <i class="fa fa-home"></i>
            <a href="/admin">Dashboard</a>
            <i class="fa fa-angle-right"></i>
        </li>
        <li>
            <a href="/knowledgebaseadmin">All KB</a>
            <i class="fa fa-angle-right"></i>
        </li>
        <li class="active">
        	<?PHP
            if($id)
            {
                echo $this->kbTypes[$type]." KB - ".htmlentities($kbData->title);
            }
            else
                echo "Add/Edit ".$this->kbTypes[$type]." KB";
            ?>
        </li>
    </ul>
</div>

<?PHP
if($this->session->flashdata('kb_saved'))
{
    ?>
    <div class="alert alert-success">
        <button class="close" data-dismiss="alert"></button>
        <strong>Changes saved successfully.</strong>
    </div>
    <?PHP
}
if($this->session->flashdata('kb_created'))
{
    ?>
    <div class="alert alert-success">
        <button class="close" data-dismiss="alert"></button>
        <strong>KB created successfully.</strong>
    </div>
    <?PHP
}
if($this->session->flashdata('kb_error'))
{
    ?>
    <div class="alert alert-danger">
        <button class="close" data-dismiss="alert"></button>
        <strong>Invalid request.</strong>
    </div>
    <?PHP
}

?>
<div class="alert alert-info">
    <span class="label label-danger">Please Note:</span><br>
    <span style="font-weight: bold; color:#000;">Images uploaded will not be displayed here in editor due to security reasons. Image can be viewed or verified in public view.</strong>
</div>
<div class="row-fluid">
	
                          
   <div class="portlet box blue">
		<div class="portlet-title">
			<div class="caption">
                <?PHP
                if($id)
                {
                    echo $this->kbTypes[$type]." KB - ".htmlentities($kbData->title);
                }
                else
                    echo "Add/Edit ".$this->kbTypes[$type]." KB";
                ?>         
            </div>
			<div class="tools">
				<a href="javascript:;" class="collapse"></a>
			</div>
            
		</div>
        
		<div class="portlet-body">
            <form action="" id="kb_form" name="kb_form" class="form-horizontal" method="post" enctype="multipart/form-data">
                
                <div class="form-body">
                    
                    <div class="form-group">
                        <label class="control-label">Title
                        </label>
                        <div class="form-content">
                            <input type="text" class="form-control" name="title" id="title"
                                value="<?PHP if($id) echo htmlentities($kbData->title); ?>">
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="control-label">Source URL
                        </label>
                        <div class="form-content">
                            <input type="text" class="form-control" name="source_url" id="source_url"
                                value="<?PHP if($id) echo $kbData->source_url; else if(isset($_GET['source'])) echo $_GET['source']; ?>">
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="control-label">Parent
                        </label>
                        <div class="form-content">
                            <select name="parent" id="parent" class="form-control">
                                <option value="0">None</option>
                                <?PHP
                                $parent=0;
                                if($id && $kbData->parent) $parent=$kbData->parent;
                                $this->knowledgebase_model->buildKbAdminDropdown(0,0,$type,$id,$parent);
                                ?>
                            </select>
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="control-label">Description
                        </label>
                        <div class="form-content">
                            <textarea class="form-control" name="description" id="description"
                                ><?PHP if($id) echo htmlentities($kbData->description); ?></textarea>
                        </div>
                    </div>

                    <div class="form-group">
                        <div class="form-content">
                            <button class="btn btn-xs blue" id="save_kb" name="save_kb" type="submit">
                                <i class="fa fa-check"></i>
                                <?PHP
                                    if($id) echo "Save";
                                    else echo "Add KB";
                                ?>
                            </button>
                            <a class="btn btn-xs red">
                                <i class="fa fa-ban"></i> Cancel
                            </a>
                        </div>
                    </div>


                </div>
            </form>
        
       
        </div>
   </div>   
</div>
<script type="text/javascript" src="<?PHP echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name;; ?>/global/plugins/ckeditor/ckeditor.js"></script>
<script type="text/javascript">
    CKEDITOR.env.isCompatible = true;
    CKEDITOR.replace( 'description',
    {
        height:'500px',
        toolbar :
            [
        { name: 'indent', items : [ 'Source','Bold','Italic','Underline','NumberedList','BulletedList','Outdent','Indent','JustifyLeft','JustifyCenter','JustifyRight','JustifyBlock','Link','Unlink','Image','Table','Smiley','SpecialChar','TextColor','BGColor','TextColor','BGColor','Iframe'] },
                { name: 'styles', items : [ 'Styles','Format','Font','FontSize'] }
            ],
        filebrowserImageUploadUrl : '<?PHP echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name;; ?>/global/plugins/ckeditor/ckfinder/core/connector/php/connector.php?command=QuickUpload&type=KB<?PHP echo $type; ?>',
    });
  
    $(document).ready(function(e)
    {
        jQuery.validator.addMethod("sourceUrl", function(value, element) 
        { 
            $("#source_url").addClass("spinner");
            $.ajaxSetup({async: false});
            var rr=true;
            var rt=$.post('/knowledgebaseadmin/urlcheck/<?PHP echo $id; ?>', {url: value}, function(res) 
              {
                 if(res==0)
                 {
                     rr=false;
                 }
                 $("#source_url").removeClass("spinner");
                
              });
              return rr;

        }, "Source URL already exists");
        
        var form2 = $('#kb_form');

        form2.validate(
        {
            errorElement: 'span', //default input error message container
            errorClass: 'help-block help-block-error', // default input error message class
            focusInvalid: true, // do not focus the last invalid input
            ignore: [],  // validate all fields including form hidden input
            onkeyup: false,
            rules: {
                title:
                {
                    required:true,
                    minlength: 2,
                    maxlength:100
                },
                source_url:
                {
                    required: true,
                    minlength: 2,
                    maxlength:100,
                    sourceUrl:true
                }
            },
            messages:
            {
                title: {
                    required: "Please enter KB Title"
                },
                source_url: {
                    required: "Please enter Source URL"
                }
            },
            errorPlacement: function (error, element)
            {
                var icon = $(element).parent('.input-icon').children('i');
                icon.removeClass('fa-check').addClass("fa-warning");  
                icon.attr("data-original-title", error.text()).tooltip({'container': 'body'});
                error.addClass('help-small no-left-padding').insertAfter(element);
            },
            highlight: function (element) 
            {
                $(element).closest('.form-group').removeClass("has-success").addClass('has-error');
            },
            success: function (label, element)
            {   
                var icon = $(element).parent('.input-icon').children('i');
                $(element).closest('.form-group').removeClass('has-error').addClass('has-success'); // set success class to the control group
                icon.removeClass("fa-warning").addClass("fa-check");
                label.remove();
            }
        });
    });
</script>