<link href="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/datatables_1_10_5/media/css/dataTables.bootstrap.css" rel="stylesheet" type="text/css"/>
<input class="current-browser-title" data-title=" Admin Dashboard | All Mantras | Mantra Japam Report" type="hidden">
<!-- BEGIN PAGE TITLE & BREADCRUMB-->
<?PHP
    $this->load->view("japams/admin/nav_buttons");
?>
<h3 class="page-title">
    <?PHP echo htmlentities($userData->firstname)." ".htmlentities($userData->lastname)." (".$userData->username.")"; ?> - Japam Report
</h3>
<div class="page-bar">
    <ul class="page-breadcrumb">
        <li>
            <i class="fa fa-home"></i>
            <a href="/admin">Dashboard</a>
            <i class="fa fa-angle-right"></i>
        </li>
        <li>
            <a href="/japamadmin">All Mantras</a>
            <i class="fa fa-angle-right"></i>
        </li>
        <li class="active">
            Mantra Japam Report
        </li>
    </ul>
</div>
<!-- END PAGE TITLE & BREADCRUMB-->

<div class="row-fluid">
    
    <form action="" name="" style="margin:0px;" onsubmit="return false" novalidate="" class="form-horizontal row search_form">
        <div class="col-md-2">
            <select name="japam_id" id="japam_id" class="form-control input-inline custom-input" onchange="search(1)">
                <option value="">All Mantras</option>
                <?PHP
                foreach ($japams as $japamData)
                {
                    ?>
                    <option value="<?PHP echo $japamData->id; ?>" 
                        <?php 
                        if(isset($japa_id) && ($japa_id == $japamData->id))
                        { 
                            echo 'selected'; 
                        } 
                        ?>
                    ><?PHP echo htmlentities($japamData->name); ?>
                    </option>
                    <?PHP
                }
                ?>
            </select>
        </div>
       
        <div class="col-md-2">
            <select name="group_by" id="group_by" class="form-control input-inline custom-input" onchange="search(1)">
                <option value="">Total by</option>
                <option value="japam_id">Mantra</option>
            </select>
        </div>
        <br style="clear:both;" class="hidden-sm hidden-xs">
        
        <div class="col-md-2">
            <input type="text" class="datepickerclass form-control input-inline custom-input" id="from_date" placeholder="From date"/>
        </div>
        <div class="col-md-2">
            <input type="text" class="datepickerclass form-control input-inline custom-input" id="to_date" placeholder="To date"/>
        </div>
        <button id="searchButton" class="btn btn-xs blue tooltips" onClick="search(0)"
            type="button" data-container="body" data-placement="bottom" data-original-title="Search">
            <i class="fa fa-search"></i>
        </button>
        <button id="searchClear" class="btn btn-xs red tooltips" style="display:none;" onClick="search_clear() "
            type="button" data-container="body" data-placement="bottom" data-original-title="Clear">
            <i class="fa fa-search-minus"></i>
        </button>
        <button type="button" id="excelButton" class="btn btn-xs green excelButton" ><i class="fa fa-file-excel-o"></i></button>
    </form>
    <br class="hidden-lg hidden-md">
    <div class="portlet box blue">
        <div class="portlet-title">
            <div class="caption">Mantra Japam Report <span id="total_records"></span> </div>
            <div class="tools">
                <a href="javascript:;" class="collapse"></a>
            </div>
            
        </div>
        
        <div class="portlet-body no-more-tables">
            <div class="col-md-12 nopadding column-buttons">
                <a href="javascript:;" data-order="desc" data-column="5" class="sortcolumn btn btn-xs default">Sort by count <i class="fa fa-arrow-down"></i></a>
                <a href="javascript:;" data-order="desc" data-column="6" class="sortcolumn btn btn-xs default">Sort by date <i class="fa fa-arrow-down"></i></a>
            </div>
            <table class="table table-striped table-bordered table-hover table-condensed" id="report_list" style="width:100%;">
                <thead>
                    <tr>
                        <th width="50">S. No.</th>
                        <th>Mantra Name</th>
                        <th>User</th>
                        <th>City</th>
                        <th>Performed by</th>
                        <th>Japam Count</th>
                        <th>Date</th>
                    </tr>
                </thead>
            </table>
            <div style="clear:both;"></div>
        </div>
   </div>
   
   
</div>
<script src="<?php
echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/datatables_1_10_5/media/js/jquery.dataTables.js" type="text/javascript"></script>
<script src="<?php
echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/datatables_1_10_5/media/js/dataTables_custom.js" type="text/javascript"></script>
<script type="text/javascript">

var from_date = '';
var to_date = '';
var japam_id='';
<?php
if($japa_id != "")
{
    ?>
    japam_id = '<?php echo $japa_id;?>';
    <?php
}
?>
var table='';
var group_by='';
function search(flag) 
{
    clearNotifications();
    if(!$("#to_date").length || !$("#from_date").length || !$("#japam_id").length)
    {
        showNotification("ruby","Something went wrong!!! Please refresh page and try again.");
        return;
    }
    if (flag == 0)
    {
        if ($("#from_date").val().trim() == '' && $("#to_date").val().trim() == '') 
        {
            showNotification('ruby','Please select Dates');
            return false;
        }
        if($("#from_date").length && $("#to_date").length && $('#from_date').val().trim()!='' && $('#to_date').val().trim()!='')
        {
            var frm=Date.parse($("#from_date").val());
            var to=Date.parse($("#to_date").val());
            if(frm>to)
            {
                showNotification('ruby','From date cannot be after To date');
                return false
            }
        }
    }
    $(".dataTables_processing").show();
    if($("#japam_id").length)
        japam_id = $("#japam_id").val().trim();
    
    if($("#from_date").length)
        from_date = $("#from_date").val().trim();
    if($("#to_date").length)
        to_date = $("#to_date").val().trim();

    if($("#group_by").length)
        group_by = $("#group_by").val().trim();

    if (to_date != '' || from_date!='')
        $("#searchClear").css("display", "inline-block");
    
    table.fnDraw();
}
function search_clear() 
{
    $(".dataTables_processing").show();
    $("#from_date").val('');
    $("#to_date").val('');
    from_date = '';
    to_date = '';
    japam_id = '';
    group_by='';
    $("#group_by").val($("#group_by:first").val());
    $("#searchClear").css("display", "none");
    table.fnDraw();
}
$(document).ready(function() 
{
    table= $('#report_list').dataTable(
    {
        "processing": true,
        "language": {
            "sProcessing": '<div class="spinnerspin"></div>',
            "emptyTable": "No records found!"
        },
        "sDom": "l<'custom-clear visible-xs'>ptr<'clearfix'>p",
        "sPaginationType": "bootstrap",
        "serverSide": true,
        "iDisplayLength": 50,
        "order": [
            [5, "desc"]
        ],
        "responsive": true,
        "lengthMenu": [
            [20,50,100],
            [20,50,100]
        ],
        "drawCallback": function(settings) 
        {
            var api = this.api();
            var totalrows = api.rows({
                page: 'current'
            }).data().context[0]._iRecordsTotal;
            $("#total_records").html('(' + totalrows + ')');
            $('.tooltips').tooltip();
            sortIdentify();
        },
        "columns": 
        [
            {
                "width": "8%",
                "orderable": false
            },
            {
                "width": "15%",
                "orderable": false
            },
            {
                name:"username",
                "width": "15%",
                "orderable": true
            },
            {
                name:"city",
                "width": "9%",
                "orderable": false
            },
            {
                "width": "15%",
                "orderable": false
            },
            {
                name:"count",
                "width": "12%",
                "orderable": true
            },
            {
                name:"date",
                "width": "12%",
                "orderable": true
            }
        ],
        "ajax": 
        {
            <?PHP
                $tableUrl="/japamadmin/listreport?user_id=".$userData->id;
            ?>
            url: '<?PHP echo $tableUrl; ?>',
            type: 'POST',
            data: function(d)
            {
                if (from_date != '')
                    d.from_date = from_date;
                if (to_date != '')
                    d.to_date = to_date;
                d.japam_id = japam_id;
                d.group_by=group_by;
            },
            error: function (xhr, error, thrown) 
            {
                if(xhr.responseText=='login')
                {
                    window.location="<?PHP echo base_url; ?>"
                }
                else if(xhr.responseText==404 || xhr.responseText=='404' || xhr.responseText=='0')
                {
                   showNotification('ruby',"Invalid request");
                }
                $(".dataTables_processing").hide();
                return false;
            },
            dataSrc:function(res)
            {
                if(res.data.length==0 && res.recordsTotal!=0)
                {
                    oTable.fnDraw();
                }
                return res.data;
            }
        },
        "fnRowCallback": function(nRow, aData, iDisplayIndex, iDisplayIndexFull) 
        {
            var vis = true;
            var ii = 0;
            var sno = 0;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "S. No.");
                ii++;
            }
            sno++;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "Mantra Name");
                ii++;
            }
            sno++;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "User");
                ii++;
            }
            sno++;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "City");
                ii++;
            }
            sno++;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "Performed by");
                ii++;
            }
            sno++;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "Japam Count");
                ii++;
            }
            sno++;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "Date");
                ii++;
            }
        },
        "columnDefs": 
        [
            {
                "render": function(data, type, row) 
                {
                    return row.sno;
                },
                "targets": 0
            }, {
                "render": function(data, type, row) 
                {
                    return '<b>'+row.name+'</b>';
                },
                "targets": 1
            }, {
                "render": function(data, type, row) 
                {
                    var str = '';
                    if(row.ustatus==1)
                    {
                        str+='<i class="fa fa-user pull-right tooltips" style="color:green; margin-top:3px;"\
                        data-original-title="Active" data-placement="bottom"></i>';
                    }
                    else if(row.ustatus==0)
                    {
                        str+='<i class="fa fa-user pull-right tooltips" style="color:orange; margin-top:3px;"\
                        data-original-title="Inactive" data-placement="bottom"></i>';
                    }
                    else if(row.ustatus==2)
                    {
                        str+='<i class="fa fa-user pull-right tooltips" style="color:red; margin-top:3px;"\
                        data-original-title="Suspended" data-placement="bottom"></i>';
                    }
                    if(row.username=='N/A')
                        str+= '<a href="/usersadmin/view/<?PHP echo $userData->id; ?>" target="_blank"><?PHP echo $userData->username; ?></a>';
                    else
                        str+= '<a href="/usersadmin/view/'+row.user_id+'" target="_blank">'+row.username+'</a>';

                    str+= "<br>"+'<?php echo $userData->firstname;?>' +" "+ '<?php echo $userData->lastname;?>';
                    return str;
                },
                "targets": 2
            }, {
                "render": function(data, type, row) 
                {
                    if(row.city != "")
                        return row.city;
                    else
                        return "N/A";
                },
                "targets": 3,
            },{
                "render": function(data, type, row) 
                {
                    if(row.donor_name != "" && row.donor_relation != "")
                        return "<b>"+row.donor_name+"</b>";
                    else
                        return "N/A";
                },
                "targets": 4,
            }, {
                "render": function(data, type, row) 
                {
                    return '<b>'+row.count+'</b>';
                },
                "targets": 5
            }, {
                "render": function(data, type, row) 
                {
                    return row.date;
                },
                "targets": 6
            }
        ]
    });
    $('.columnhide').on('click', function(e) 
    {
        var column = table.api().column( $(this).attr('data-column') );
        var cnum=$(this).attr('data-column');
        
        column.visible( ! column.visible(),true );
        var bVis = table.fnSettings().aoColumns[cnum].bVisible;
        var title = table.fnSettings().aoColumns[cnum].sTitle;
        
        var visibility=table.api().column(cnum).visible();
        table.api().column(cnum).nodes().to$().attr("data-title",title);
        if (visibility == false) 
        {
            $(this).removeClass('blue').addClass('red');
        }
        else 
        {
            $(this).removeClass('red').addClass('blue');
        }
    });
    $(".sortcolumn").on("click",function()
    {
        var currentSort = table.api().rows().context[0].aLastSort[0];   
        var corder=$(this).attr('data-order');
        var cnum=$(this).attr('data-column');
        if(currentSort.col==cnum)
        {
            if(currentSort.dir!=corder)
            {
                table.fnSort([cnum,corder]);
            }
        }
        else
        {
            table.fnSort([cnum,corder]);
        }
        sortIdentify();
    });
});
function sortIdentify()
{
    var currentSort = table.api().rows().context[0].aLastSort[0];
    $(".sortcolumn").each(function(i,ele)
    {
        $(this).removeClass("blue").addClass("default");
        var corder=$(this).attr('data-order');
        var cnum=$(this).attr('data-column');
        if(cnum==currentSort.col)
        {
            $(this).removeClass("default").addClass("blue");
            if(currentSort.dir=='desc')
            {
                $(this).attr("data-order","asc");
                $(this).find("i").removeClass("fa-arrow-up").addClass("fa-arrow-down");
            }
            if(currentSort.dir=='asc')
            {
                $(this).attr("data-order","desc");
                $(this).find("i").removeClass("fa-arrow-down").addClass("fa-arrow-up");
            }
        }
    });
}
$("#excelButton").on("click",function()
{
    $(".loader_animation").show();
    clearNotifications();
    var sortindex=table.fnSettings().aaSorting[0][0];
    var order_by=table.fnSettings().aoColumns[sortindex].name;
    var dir=table.fnSettings().aaSorting[0][1];
    $.post('/japamadmin/listreport/1?user_id=<?php echo $userData->id;?>',
    {
        japam_id:japam_id,group_by:group_by, from_date:from_date,to_date:to_date,order_by:order_by,dir:dir
    },
        function(res)
        {
            var r=$.parseJSON(res);
            if(r.flag==1)
            {
                window.location='<?PHP echo base_url; ?>excelreports/download/'+r.report_id;
            }
            if(r.flag==2)
            {
                showNotification("ruby","Sorry! You have already requested the same report.");
            }
            if(r.flag==0)
            {
                showNotification("ruby","Sorry! Report cannot be generated. Data is empty.");
            }
            $(".loader_animation").hide();
        }
    );
});
</script>
