<!DOCTYPE html>
<html>
	<head>
		<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
	    <meta content="width=device-width, initial-scale=1.0" name="viewport" />
	    <title><?PHP echo site_name_string1; ?> | 5th Generation Devotees</title>
	  	<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css">
		<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>
		<script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/js/bootstrap.min.js"></script>
		<link href="<?php echo base_url."site_theme"; ?>/admin_fonts/google-css-open-sans.css" rel="stylesheet">
		<link href="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/datatables_1_10_5/media/css/dataTables.bootstrap.css" rel="stylesheet" type="text/css"/>
        <link rel="stylesheet" href="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/responsive.min.css">
        <link href="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/font-awesome/css/font-awesome.min.css" rel="stylesheet" type="text/css"/>
        <link href="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/bootstrap-datepicker/css/datepicker.css" rel="stylesheet" type="text/css" />
        <link rel="stylesheet" type="text/css" href="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/bootstrap-select/bootstrap-select.min.css"/>
        <link rel="stylesheet" type="text/css" href="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/select2/select2.css"/>
        <link rel="stylesheet" type="text/css" href="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/jquery-multi-select/css/multi-select.css"/>
        <link href="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/admin/layout/css/custom.css" rel="stylesheet" type="text/css"/>
        <link href="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/css/components.css" rel="stylesheet" type="text/css"/>
        <link rel="stylesheet" type="text/css" href="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/jquery-notific8/jquery.notific8.min.css"/>
        <link href="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/admin/layout/css/layout.css" rel="stylesheet" type="text/css"/>
    </head>
    <body>
        <div class="container">
        	<div class="row-fluid fixedheaderform">
                <h2><strong>5th Generation Devotees</strong></h2>
	  			<h2 style = "color:green;">Total Devotees : <span id="total_records2"></span></h2>
            </div>
        </div>

        <div class="container listRowContainer">
            <div class="row-fluid">
                <div class="portlet box blue">
                    <div class="portlet-title">
                        <div class="caption"> <i class="fa fa-list"></i> 5th Generation Devotees <span id="total_records"></span></div>
                        <div class="tools">
                            <a href="javascript:;" class="collapse"></a>
                        </div>
                    </div>
                    
                    <div class="portlet-body no-more-tables">
                        <table id="rtable" class="display table-bordered table-condensed table table-striped table-hover" cellspacing="0" width="100%" >
                            <thead>
                                <tr>
									<th>S. No.</th>
                                	<th>Photo</th>
									<th>5th Gen</th>
									<th>4th Gen</th>
									<th>3rd Gen</th>
									<th>2nd Gen</th>
									<th>1st Gen</th>
									<th>Gender</th>
									<th>Devotee</th>
                                </tr>
                            </thead>
                        </table>
                        <div style="clear:both;"></div>
                    </div>
                </div>
            </div>
        </div>
    </body>
</html>
<script type="text/javascript">
    var base_url='<?PHP echo base_url(); ?>';
    var theme_folder_name='theme_v361';
    var aws_s3_base_url='<?PHP echo aws_s3_base_url; ?>';
</script>
<script src="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/jquery.min.js" type="text/javascript"></script>
<script src="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/jquery-migrate.min.js" type="text/javascript"></script>
<script src="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/jquery-ui/jquery-ui-1.10.3.custom.min.js" type="text/javascript"></script>
<script src="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/bootstrap/js/bootstrap.min.js" type="text/javascript"></script>
<script src="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/bootstrap-hover-dropdown/bootstrap-hover-dropdown.min.js" type="text/javascript"></script>
<script src="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/pace/pace.js" type="text/javascript"></script>


<script src="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/frontend-2/js/back-to-top.js" type="text/javascript"></script>
<script src="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/bootstrap-touchspin/bootstrap.touchspin.js" type="text/javascript"></script>
<script src="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/jquery-slimscroll/jquery.slimscroll.min.js" type="text/javascript"></script>

<script src="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/bootstrap-datepicker/js/bootstrap-datepicker.js" type="text/javascript"></script>
<script src="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/datatables_1_10_5/media/js/jquery.dataTables.js" type="text/javascript"></script>
<script src="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/datatables_1_10_5/media/js/dataTables_custom.js" type="text/javascript"></script>
<script type="text/javascript" src="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/bootstrap-select/bootstrap-select.min.js"></script>
<script type="text/javascript" src="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/select2/select2.min.js"></script>
<script type="text/javascript" src="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/jquery-multi-select/js/jquery.multi-select.js"></script>
<script src="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/jquery-notific8/jquery.notific8.min.js"></script>
<script type="text/javascript">
var table = '';
var secret_key='<?PHP echo $secret_key; ?>';
function clearNotifications()
{
    $('.jquery-notific8-notification').remove();
}
function showNotification(theme,message)
{
    $.notific8('zindex', 11500);
    $.notific8(message,
    {
        theme:theme,
        sticky: false,
        horizontalEdge:'top',
        verticalEdge:'right',
        life:5000
    });
}

function search(flag) 
{
    clearNotifications();
    table.fnDraw();
}
function search_clear() 
{
    table.fnDraw();
}
$(document).ready(function()
{
    table = $('#rtable').dataTable({
        "processing": true,
        "language": {
            "sProcessing": '<div class="spinnerspin"></div>',
            "emptyTable": "No records found!"
        },
        "sDom": "l<'custom-clear visible-xs'>ptr<'clearfix'>p",
        "sPaginationType": "bootstrap",
        "serverSide": true,
        "iDisplayLength": 50,
        "order": [
            [8, "asc"]
        ],
        "responsive": true,
        "lengthMenu": [
            [20, 50, 100],
            [20, 50, 100]
        ],
        "drawCallback": function(settings) 
        {
            var api = this.api();
            var totalrows = api.rows({
                page: 'current'
            }).data().context[0]._iRecordsTotal;
            $("#total_records").html("("+totalrows+")");
            $("#total_records2").html("("+totalrows+")");
            $('.tooltips').tooltip();
            $("#checkall").prop('checked', false);
            sortIdentify();
        },
        "columns": [
        {
            "width": "5%",
            "orderable": false
        }, {
            "width": "10%",
            "orderable": false
        }, {
            name: "fifth_generation",
            "width": "12%",
            "orderable": true
        }, {
            'name':"fourth_generation",
            "width": "12%",
            "orderable": true
        }, {
            name: "third_generation",
            "width": "12%",
            "orderable": true
        }, {
            'name':"second_generation",
            "width": "12%",
            "orderable": true
        }, {
            name: "first_generation",
            "width": "12%",
            "orderable": true
        }, {
            name: "gender",
            width: "6%",
            "orderable": true
        }, {
            name: "email",
            width: "16%",
            "orderable": true
        }],
        "ajax": {
            url: '/fifthgendevoteesadmin/listPublucResults',
            type: 'POST',
            data: function(d) 
            {
                d.secret_key=secret_key;
            },
            error: function (xhr, error, thrown) 
            {
                if(xhr.responseText=='login')
                {
                    window.location="<?PHP echo base_url; ?>"
                }
                else if(xhr.responseText==404 || xhr.responseText=='404' || xhr.responseText=='0')
                {
                   showNotification('ruby',"Invalid request");
                }
                $(".dataTables_processing").hide();
                return false;
            },
            complete: function (xhr, error, thrown)
            {
                var jdata=$.parseJSON(xhr.responseText);
                $(".loader_animation").hide();
                $("#total_steps").html(jdata.total_steps_count);
                $("#total_submissions").html(jdata.total_submissions);
            },
            dataSrc:function(res)
            {
                if(res.data.length==0 && res.recordsTotal!=0)
                {
                    table.fnDraw();
                }
                return res.data;
            }
        },
        "fnRowCallback": function(nRow, aData, iDisplayIndex, iDisplayIndexFull) 
        {
            var vis = true;
            var ii = 0;
            var sno = 0;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "S. No.");
                ii++;
            }
            sno++;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "Photo");
                ii++;
            }
            sno++;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "5th Gen");
                ii++;
            }
            sno++;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "4th Gen");
                ii++;
            }
            sno++;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "3rd Gen");
                ii++;
            }
            sno++;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "2nd Gen");
                ii++;
            }
            sno++;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "1st Gen");
                ii++;
            }
            sno++;
            if (this.api().column(sno).visible())
            {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "Gender");
                ii++;
            }
            sno++;
            if (this.api().column(sno).visible())
            {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "Devotee");
                ii++;
            }

            return nRow;
        },
        "columnDefs": [
        {
            "render": function(data, type, row) {
                return row.sno;
            },
            "targets": 0
        }, {
            "render": function(data, type, row) 
            {
                var str = '<img src = "'+row.photo+'" width="125px" height="100%"></image>';
                return str;
            },
            "targets": 1
        }, {
            "render": function(data, type, row) 
            {
                return row.fifth_generation;
            },
            "targets": 2
        }, {
            "render": function(data, type, row) 
            {
                return row.fourth_generation;
            },
            "targets": 3
        }, {
            "render": function(data, type, row) 
            {
                return row.third_generation;
            },
            "targets": 4
        }, {
            "render": function(data, type, row) 
            {
                return row.second_generation;
            },
            "targets": 5
        }, {
            "render": function(data, type, row) 
            {
                return row.first_generation;
            },
            "targets": 6
        }, {
            "render": function(data, type, row) 
            {
                return row.gender;
            },
            "targets": 7
        }, {
            "render": function(data, type, row) 
            {
            	var str='';
            	str += "<span style='font-size: 11px;'>"+row.email+"<br>+"+row.country_isd_code+" "+row.phone+"<br>"+row.city+"<br>"+row.country+"</span>";
                return str;
            },
            "targets": 8
        }]
    });
});
function sortIdentify()
{
    var currentSort = table.api().rows().context[0].aLastSort[0];
    $(".sortcolumn").each(function(i,ele)
    {
        $(this).removeClass("blue").addClass("default");
        var corder=$(this).attr('data-order');
        var cnum=$(this).attr('data-column');
        if(cnum==currentSort.col)
        {
            $(this).removeClass("default").addClass("blue");
            if(currentSort.dir=='desc')
            {
                $(this).attr("data-order","asc");
                $(this).find("i").removeClass("fa-arrow-up").addClass("fa-arrow-down");
            }
            if(currentSort.dir=='asc')
            {
                $(this).attr("data-order","desc");
                $(this).find("i").removeClass("fa-arrow-down").addClass("fa-arrow-up");
            }
        }
    });
}
</script>