<?PHP
$partHeader='Add Category';
if($id)
{
    $partHeader=htmlentities($categoryData->name);
}
?>
<input class="current-browser-title" data-title=" Admin Dashboard  | Downloads | <?PHP echo $partHeader; ?>" type="hidden">
<?PHP
    //$this->load->view("ashrams/admin/poojas_nav_buttons");
?>
<h3 class="page-title">
	<?PHP
    	echo $partHeader;
    ?>
</h3>
<div class="page-bar">
    <ul class="page-breadcrumb">
        <li>
            <i class="fa fa-home"></i>
            <a href="/admin">Dashboard</a>
            <i class="fa fa-angle-right"></i>
        </li>
        <li>
            <a href="/downloadsadmin">All Downloads</a>
            <i class="fa fa-angle-right"></i>
        </li>
        <li>
            <a href="/downloadsadmin/categories">All Categories</a>
            <i class="fa fa-angle-right"></i>
        </li>
        <li><?PHP echo $partHeader; ?></li>
    </ul>
</div>
<?PHP
if($this->session->flashdata("cat_error"))
{
	?>
    <div class="alert alert-danger">
        <button class="close" data-dismiss="alert"></button>
        <strong>Error saving changes, please try again.</strong>
    </div>
    <?PHP
}
if($this->session->flashdata("cat_created"))
{
	?>
    <div class="alert alert-success">
        <button class="close" data-dismiss="alert"></button>
        <strong>Category created successfully.</strong>
    </div>
    <?PHP
}

if($this->session->flashdata("cat_saved"))
{
	?>
    <div class="alert alert-success">
        <button class="close" data-dismiss="alert"></button>
        <strong>Changes saved successfully.</strong>
    </div>
    <?PHP
}
?>

<div class="row-fluid">
<!-- BEGIN SAMPLE TABLE PORTLET-->
	<div class="margin-bottom-40">
		
		<div class="portlet box blue">
			<div class="portlet-title">
				<div class="caption"><?PHP echo $partHeader; ?></div>
				<div class="tools">
					<a href="javascript:;" class="collapse"></a>
				</div>
                
			</div>
            
			<div class="portlet-body">
				<form action="" id="cat_form" name="cat_form" method="post">
					<div class="row">
						<div class="col-md-12">
				            <div class="form-group">
				                <label class="control-label">Name
				                </label>
				                <div class="form-content">
				                    <input type="text" class="form-control" name="name" id="name"
				                        value="<?PHP if($id) echo htmlentities($categoryData->name); ?>">
				                </div>
				            </div>
				            
				            <div class="form-group">
								<div class="form-content">
									<button type="submit" name="add_category" id="add_category" class="btn btn-xs blue"> 
									<i class="fa fa-check"></i> <?PHP if($id) echo "Save"; else echo "Add Category"; ?></button>
									<a href="/downloadsadmin/categories" class="btn btn-xs red"> <i class="fa fa-ban"></i> Cancel</a>
								</div>
							</div>
						</div>
					</div>

				</form>
			</div>
		</div>



    </div>
 
</div>

<script type="text/javascript">
				
$( document ).ready(function() 
{
	jQuery.validator.addMethod("pcheck", function(value, element) 
	{ 
		$.ajaxSetup({async: false});
		var rr=true;
        $.post('/downloadsadmin/categorycheckname/<?PHP echo $id; ?>', {name:$('#name').val()}, function(res) 
		{
			if(res==0)
			{
				$.validator.messages.pcheck='Please try another category name';
				rr=false;
			}
			if(res==2)
			{
				$.validator.messages.pcheck='Category already exists';
				rr=false;
			}
		});
		return rr;
	}, "Please try another category name");

	$('#cat_form').validate({
        errorElement: 'label', //default input error message container
        errorClass: 'help-inline', // default input error message class
        focusInvalid: true, // do not focus the last invalid input
		onkeyup: false,
       	rules: {
            name: {
                required: true,
                minlength:3,
                maxlength:100,
                pcheck:true
            }
        },

        messages:
        {
            name:
            {
                required: "Please enter category name"
            }
        },
    	highlight: function (element)
    	{
            $(element)
                .closest('.form-group').removeClass("has-success").addClass('has-error');
        },
         success: function (label, element)
         {
            $(element).closest('.form-group').removeClass('has-error').addClass('has-success');
			label.remove();
        },

         errorPlacement: function (error, element) { // render error placement for each input type
			error.addClass('help-small no-left-padding').insertAfter(element);
        }
    });

});
</script>
