<link href="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/datatables_1_10_5/media/css/dataTables.bootstrap.css" rel="stylesheet" type="text/css"/>
<input class="current-browser-title" data-title=" Admin Dashboard | Daily Posts | All Daily Posts" type="hidden">
<style type="text/css">
    @media only screen and (min-width: 992px) and (max-width: 1450px){
        .buttons{
            padding: 29px 0px 6px 0px;
        }
    }
</style>
<!-- BEGIN PAGE TITLE & BREADCRUMB-->
<?PHP
    $this->load->view("dailyposts/admin/nav_buttons");
?>
<h3 class="page-title">
    All Daily Posts
</h3>
<div class="page-bar">
    <ul class="page-breadcrumb">
        <li>
            <i class="fa fa-home"></i>
            <a href="/admin">Dashboard</a>
            <i class="fa fa-angle-right"></i>
        </li>
        <li class="active">
        	All Daily Posts
        </li>
    </ul>
</div>
<!-- END PAGE TITLE & BREADCRUMB-->


<div class="row-fluid">
	<div class="alert alert-info">
        <strong>Daily Posts public URL:</strong>
        <a href="<?php echo base_url. "dailyposts"; ?>" target="_blank">
        <?php echo base_url . "dailyposts"; ?></a>
    </div>
    <form action="" name="" style="margin:0px;" onsubmit="return false" novalidate="" class="form-horizontal row search_form">
        <div class="col-md-2">
            <select name="type_id" id="type_id" onChange="search(1)" class="form-control input-inline custom-input">
                <option value="">All Post Types</option>
                <?PHP
                $typesString='';
                    foreach ($post_types as $postType)
                    {
                         if ($typesString != '') $typesString.= ",";
                            $typesString.= $postType->id . ":" . $postType->name.":".$postType->slug;
                        ?>
                        <option value="<?PHP echo $postType->id; ?>">
                            <?PHP echo htmlentities($postType->name); ?>
                        </option>
                        <?PHP
                    }
                ?>
            </select>
        </div>
        <br style="clear:both;" class="hidden-sm hidden-xs">
        <div class="col-md-2">
            <input  type="text" id="search_text"  class="form-control input-inline custom-input" 
            placeholder="Type keyword to search..." style="border:1px solid skyblue;" />
        </div>
        <div class="col-md-2">
            <select name="search_col" id="search_col" class="form-control input-inline custom-input">
                <option value="title">Post Title</option>
            </select>
        </div>
       <!--  <div class="col-md-2">
            <select name="wild" id="wild" class="form-control input-inline custom-input">
                <option value="contains">Contains</option>
                <option value="starts">Starts With</option>
                <option value="ends">Ends With</option>
            </select>
        </div> -->
        <div class="col-md-2">
            <input type="text" class="datepickerclass form-control input-inline custom-input" id="from_date" placeholder="From date"/>
        </div>
        <div class="col-md-2">
            <input type="text" class="datepickerclass form-control input-inline custom-input" id="to_date" placeholder="To date"/>
        </div>
        <div class="buttons">
            <button type="button" id="searchButton" class="btn btn-xs blue searchButton"
                onClick="search(0)"><i class="fa fa-search"></i> Search</button>
            <a class="btn btn-xs red" id="searchClear" onClick="search_clear()"
            style="display:none;"><i class="fa fa-search-minus"></i> Clear</a>
            <button type="button" id="excelButton" class="btn btn-xs green excelButton" ><i class="fa fa-file-excel-o"></i> Report</button>
        </div>
    </form>
    <br class="hidden-lg hidden-md">
    <div class="portlet box blue">
		<div class="portlet-title">
			<div class="caption">All Daily Posts <span id="total_records"></span> </div>
			<div class="tools">
				<a href="javascript:;" class="collapse"></a>
			</div>
            
		</div>
        
		<div class="portlet-body no-more-tables">
        
            
            <table class="table table-striped table-bordered table-hover table-condensed" id="post_list" style="width:100%;">
                <thead>
                    <tr>
                        <th width="50">S. No.</th>
                        <th>Post ID</th>
                        <th>Post Title</th>
                        <th>Post Type</th>
                        <th>Posted On</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    
                </tbody>
            </table>
        </div>
   </div>
   
   
</div>
<script src="<?php
echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/datatables_1_10_5/media/js/jquery.dataTables.js" type="text/javascript"></script>
<script src="<?php
echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/datatables_1_10_5/media/js/dataTables_custom.js" type="text/javascript"></script>
<script type="text/javascript">
var table='';
var statusflag=0;
var type_id='';
var temp = Array(); 
var from_date = '';
var to_date = '';
var search_text='';
var search_col='';

    function applyFilter(ele) 
    {
        table.fnDraw();
    }

    function search(flag) 
    {
        clearNotifications();
         if(!$("#from_date").length || !$("#to_date").length || !$("#search_text").length || !$("#search_col").length)
        {
            showNotification("ruby","Something went wrong!!! Please refresh page and try again.");
            return;
        }
        if (flag == 0)
        {  
            if ($("#from_date").length && $("#to_date").length && $("#search_text").length && 
                $("#from_date").val().trim() == '' && $("#to_date").val().trim() == '' && $("#search_text").val().trim() == '') 
            {
                showNotification('ruby','Please enter search keywords or select dates');
                return false;
            }
            if($("#from_date").length && $("#to_date").length && $('#from_date').val().trim()!='' && $('#to_date').val().trim()!='')
            {
                var frm=Date.parse($("#from_date").val());
                var to=Date.parse($("#to_date").val());
                if(frm>to)
                {
                    showNotification('ruby','From date cannot be after To date');
                    return false
                }
            }
        }
        $(".dataTables_processing").show();
        if($("#from_date").length)
            from_date = $("#from_date").val().trim();
        if($("#to_date").length)
            to_date = $("#to_date").val().trim();
        if($("#search_text").length)
            search_text = $("#search_text").val().trim();
        if($("#search_col").length)
            search_col = $("#search_col").val().trim();
        if($("#type_id").length)
            type_id = $("#type_id").val();

        if (from_date != '' || to_date != '' || search_text != '')
            $("#searchClear").css("display", "inline-block");
        
        table.fnDraw();

    }

    function search_clear() 
    {
        $(".dataTables_processing").show();
        $("#from_date").val('');
        from_date = '';
        $("#to_date").val('');
        to_date = '';
        $("#search_text").val('');
        search_text = '';
        search_col = '';
        $("#searchClear").css("display", "none");
        type_id='';
        $("#type_id").val('');
        table.fnDraw();
    }
function deletePost(id)
{
    if(statusflag==1)
        return false;
    statusflag=1;
    $(".dataTables_processing").show();
    $.post('/dailypostsadmin/delete/' + id , {}, function(res) 
    {
        if(res=='login')
        {
            window.location="<?PHP echo base_url; ?>"
        }
        if(res=='access_denied')
        {
            showNotification('ruby',"Access Denied");
            $(".dataTables_processing").hide();
            $("#post" + id).modal('toggle');
            statusflag=0;
            return;
        }
        var r = $.parseJSON(res);
        $(".dataTables_processing").hide();
        if (r.flag == 1) 
        {
            table.fnSettings.bResetDisplay  =false;
            table.fnDraw(table.fnSettings);
            showNotification('ruby', "Post '" + r.title + "' has been deleted successfully ");
        }
        else
        {
            showNotification("ruby", "Error occured. Please try again.");
        }
        $("#post" + id).modal('toggle');
        statusflag=0;
    });
}
$(document).ready(function() 
{
    table= $('#post_list').dataTable(
    {
        "processing": true,
        "language": {
            "sProcessing": '<div class="spinnerspin"></div>',
            "emptyTable": "No records found!"
        },
        "sDom": "l<'custom-clear visible-xs'>ptr<'clearfix'>p",
        "sPaginationType": "bootstrap",
        "serverSide": true,
        "iDisplayLength": 50,
        "order": [
            [1, "desc"]
        ],
        "responsive": true,
        "lengthMenu": [
            [20, 50, 100],
            [20, 50, 100]
        ],
        "drawCallback": function(settings) 
        {
            var api = this.api();
            var totalrows = api.rows({
                page: 'current'
            }).data().context[0]._iRecordsTotal;
            $("#total_records").html('(' + totalrows + ')');
            $('.tooltips').tooltip();
            $("#checkall").prop('checked', false);
        },
        "columns": 
        [
            {
                "width": 60,
                "orderable": false
            },
            {
                "name":"id",
                "width": "10%",
                "orderable": true
            },
            {
                "orderable": false
            },
            {
                "width": "20%",
                "orderable": false
            },
            {
                "name":"date",
                "width": "12%",
                "orderable": true
            },
            {
                "width": "10%",
                "orderable": false
            }
        ],
        "ajax": 
        {
            <?PHP
                $tableUrl="/dailypostsadmin/listposts/";
            ?>
            url: '<?PHP echo $tableUrl; ?>',
            type: 'POST',
            data: function(d)
            {
                if (from_date != '')
                    d.from_date = from_date;
                if (to_date != '')
                    d.to_date = to_date;
                if (search_text != '')
                    d.search_text = search_text;
                d.search_col = search_col;
                d.type_id=type_id;
            },
            error: function (xhr, error, thrown) 
            {
                if(xhr.responseText=='login')
                {
                    window.location="<?PHP echo base_url; ?>"
                }
                else if(xhr.responseText==404 || xhr.responseText=='404' || xhr.responseText=='0')
                {
                   showNotification('ruby',"Invalid request");
                }
                $(".dataTables_processing").hide();
                return false;
            },
            dataSrc:function(res)
            {
                if(res.data.length==0 && res.recordsTotal!=0)
                {
                    oTable.fnDraw();
                }
                return res.data;
            }
        },
        "fnRowCallback": function(nRow, aData, iDisplayIndex, iDisplayIndexFull) 
        {
            var vis = true;
            var ii = 0;
            var sno = 0;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "S. No.");
                ii++;
            }
            sno++;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "Post ID");
                ii++;
            }
            sno++;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "Post Title");
                ii++;
            }
            sno++;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "Post Type");
                ii++;
            }
            sno++;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "Posted On");
                ii++;
            }
            sno++;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "Actions");
                ii++;
            }
        },
        "columnDefs": 
        [
            {
                "render": function(data, type, row) 
                {
                    return row.sno;
                },
                "targets": 0
            }, {
                "render": function(data, type, row) 
                {
                    return row.id;
                },
                "targets": 1
            },
            {
                "render": function(data, type, row) 
                {
                    return '<a href="/dailypostsadmin/add_edit_post/' + row.id + '" target="_blank">'+row.title+'</a>';
                },
                "targets": 2
            },
            {
                "render": function(data, type, row) 
                {
                    return row.type_name;
                },
                "targets": 3
            },
            {
                "render": function(data, type, row) 
                {
                    return row.date;
                },
                "targets": 4
            },
            {
                "render": function(data, type, row) 
                {
                    var str = '<div class="btn-group" id="actions' + row.id + '">' +
                        '<a class="btn red btn-xs" href="#" data-toggle="dropdown"> Actions ' +
                        '<i class="fa fa-angle-down"></i></a>' +
                        '<ul class="dropdown-menu pull-right" style="text-align:left;">' +
                        '<li><a href="/dailypostsadmin/add_edit_post/' + row.id + '" target="_blank"><i class="fa fa-edit"></i> Edit</a></li>';

                    str += '<li><a href="#post' + row.id + '" role="button" data-toggle="modal">' +
                        '<i class="fa fa-trash-o"></i> Delete</a></li>' +

                        '<div id="post' + row.id + '" class="modal fade" tabindex="-1">' +
                        '<div class="modal-header">' +
                        '<button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>' +
                        '<h4 class="modal-title">Delete Confirmation</h4>' +
                        '</div>' +
                        '<div class="modal-body"><div class="pull-left delete-confirmation-icon"' +
                        '><i class="fa fa-exclamation-triangle"></i></div>' +
                        'Do you really want to delete the Post: ' +
                        '<span style="color:red; font-weight:bold;">' + row.title + '</span>?' +
                        '</div>' +
                        '<div class="modal-footer">' +
                        '<button type="button" data-dismiss="modal" class="btn btn-xs close' + row.id + '">' +
                        '<i class="fa fa-remove"></i> Cancel</button>' +
                        '<a onClick="deletePost(' + row.id + ')" class="btn btn-xs red">' +
                        '<i class="fa fa-trash"></i> Delete</a>' +
                        '</div>' +
                        '</div>';

                    return str;
                },
                "targets": 5
            }
        ]
    });
    
});
    $("#excelButton").on("click",function()
    {
        $(".loader_animation").show();
        clearNotifications();
        var sortindex=table.fnSettings().aaSorting[0][0];
        var order_by=table.fnSettings().aoColumns[sortindex].name;
        var dir=table.fnSettings().aaSorting[0][1];
        $.post('/dailypostsadmin/listposts/1',
        {
            from_date:from_date,to_date:to_date,search_text:search_text,search_col:search_col,
            type_id:type_id,order_by:order_by,dir:dir
        },
            function(res)
            {
                var r=$.parseJSON(res);
                if(r.flag==1)
                {
                    window.location='<?PHP echo base_url; ?>excelreports/download/'+r.report_id;
                }
                if(r.flag==2)
                {
                    showNotification("ruby","Sorry! You have already requested the same report.");
                }
                if(r.flag==0)
                {
                    showNotification("ruby","Sorry! Report cannot be generated. Data is empty.");
                }
                $(".loader_animation").hide();
            }
        );
    });
</script>
