<?PHP
$partHeader='Add Post Type';
if($id)
{
    $partHeader=htmlentities($typeData->name);
}
?>
<input class="current-browser-title" data-title=" Admin Dashboard  | Dailyposts | <?PHP echo $partHeader; ?>" type="hidden">
<?PHP
    $this->load->view("dailyposts/admin/nav_buttons");
?>
<h3 class="page-title">
	<?PHP
    	echo $partHeader;
    ?>
</h3>
<div class="page-bar">
    <ul class="page-breadcrumb">
        <li>
            <i class="fa fa-home"></i>
            <a href="/admin">Dashboard</a>
            <i class="fa fa-angle-right"></i>
        </li>
        <li>
            <a href="/dailypostsadmin/post_types">All Post Types</a>
            <i class="fa fa-angle-right"></i>
        </li>
        <li><?PHP echo $partHeader; ?></li>
    </ul>
</div>
<?PHP
if($this->session->flashdata("type_error"))
{
	?>
    <div class="alert alert-danger">
        <button class="close" data-dismiss="alert"></button>
        <strong>Error saving changes, please try again.</strong>
    </div>
    <?PHP
}
if($this->session->flashdata("type_created"))
{
	?>
    <div class="alert alert-success">
        <button class="close" data-dismiss="alert"></button>
        <strong>Post Type created successfully.</strong>
    </div>
    <?PHP
}

if($this->session->flashdata("type_saved"))
{
	?>
    <div class="alert alert-success">
        <button class="close" data-dismiss="alert"></button>
        <strong>Changes saved successfully.</strong>
    </div>
    <?PHP
}
?>

<div class="row-fluid">
<!-- BEGIN SAMPLE TABLE PORTLET-->
	<div class="margin-bottom-40">
		
		<div class="portlet box blue">
			<div class="portlet-title">
				<div class="caption"><?PHP echo $partHeader; ?></div>
				<div class="tools">
					<a href="javascript:;" class="collapse"></a>
				</div>
                
			</div>
            
			<div class="portlet-body">
				<form action="" id="type_form" name="type_form" method="post">

		            <div class="form-group">
		                <label class="control-label">Name
		                </label>
		                <div class="form-content">
		                    <input type="text" class="form-control" name="name" id="name"
		                        value="<?PHP if($id) echo htmlentities($typeData->name); ?>">
		                </div>
		            </div>
		            <div class="form-group">
		                <label class="control-label">Slug
		                </label>
		                <div class="form-content">
		                    <input type="text" class="form-control" name="slug" id="slug" disabled="disabled"
		                        value="<?PHP if($id) echo htmlentities($typeData->slug); ?>">
		                </div>
		            </div>
		            <div class="form-group">
		                <label class="control-label"> Description
		                </label>
		                <div class="form-content">
		                    <textarea class="form-control" name="description" id="description" rows="6"><?PHP 
		                        if($id) echo htmlentities($typeData->description); ?></textarea>
		                </div>
		            </div>
		            <div class="form-group">
						<div class="form-content">
							<button type="submit" name="add_type" id="add_type" class="btn btn-xs blue"> 
							<i class="fa fa-check"></i> <?PHP if($id) echo "Save"; else echo "Add Post Type"; ?></button>
							<a href="/dailypostsadmin/post_types" class="btn btn-xs red"> <i class="fa fa-ban"></i> Cancel</a>
						</div>
					</div>


				</form>
			</div>
		</div>



    </div>
 
</div>

<script type="text/javascript">
				
$( document ).ready(function() 
{
	jQuery.validator.addMethod("pcheck", function(value, element) 
	{ 
		$.ajaxSetup({async: false});
		var rr=true;
        $.post('/dailypostsadmin/posttypecheckname/<?PHP echo $id; ?>', {name:$('#name').val()}, function(res) 
		{
			if(res==0)
			{
				$.validator.messages.pcheck='Please try another Post Type Name';
				rr=false;
			}
			if(res==2)
			{
				$.validator.messages.pcheck='Post Type Name already exists';
				rr=false;
			}
		});
		return rr;
	}, "Please try another Post Type Name");

	jQuery.validator.addMethod("slugcheck", function(value, element) 
	{ 
		$.ajaxSetup({async: false});
		var rr=true;
        $.post('/dailypostsadmin/posttypecheckslug/<?PHP echo $id; ?>', {slug:$('#slug').val()}, function(res) 
		{
		   	if(res==1)
			{
				rr=false
			}
		});
		return rr;

	}, "Slug already exists");

	$('#type_form').validate({
        errorElement: 'label', //default input error message container
        errorClass: 'help-inline', // default input error message class
        focusInvalid: true, // do not focus the last invalid input
		onkeyup: false,
       	rules: {
            name: {
                required: true,
                minlength:6,
                maxlength:100,
                pcheck:true
            },
            description:
            {
            	spaces:true,
            	minlength:3,
            	maxlength:500
            }
        },

        messages:
        {
            name:
            {
                required: "Please enter Post Type Name"
            }
        },
    	highlight: function (element) { // hightlight error inputs
            $(element)
                .closest('.form-group').removeClass("has-success").addClass('has-error'); // set error class to the control group   
        },
         success: function (label, element)
         {
            $(element).closest('.form-group').removeClass('has-error').addClass('has-success');
			label.remove();
        },

         errorPlacement: function (error, element) { // render error placement for each input type
			error.addClass('help-small no-left-padding').insertAfter(element);
        }
    });

});
	</script>
