<?PHP
$partHeader='Add Post';
if($id)
{
    $partHeader=htmlentities($postData->title);
}
?>
<input class="current-browser-title" data-title=" Admin Dashboard  | Daily Posts | <?PHP echo $partHeader; ?>" type="hidden">
<?PHP
    $this->load->view("dailyposts/admin/nav_buttons");
?>
<h3 class="page-title">
	<?PHP
    	echo $partHeader;
    ?>
</h3>
<div class="page-bar">
    <ul class="page-breadcrumb">
        <li>
            <i class="fa fa-home"></i>
            <a href="/admin">Dashboard</a>
            <i class="fa fa-angle-right"></i>
        </li>
        <li>
            <a href="/dailypostsadmin">All Daily Posts</a>
            <i class="fa fa-angle-right"></i>
        </li>
        <li><?PHP echo $partHeader; ?></li>
    </ul>
</div>
<?PHP
if($this->session->flashdata("post_error"))
{
	?>
    <div class="alert alert-danger">
        <button class="close" data-dismiss="alert"></button>
        <strong>Error saving changes, please try again.</strong>
    </div>
    <?PHP
}
if($this->session->flashdata("post_created"))
{
	?>
    <div class="alert alert-success">
        <button class="close" data-dismiss="alert"></button>
        <strong>Post created successfully.</strong>
    </div>
    <?PHP
}

if($this->session->flashdata("post_saved"))
{
	?>
    <div class="alert alert-success">
        <button class="close" data-dismiss="alert"></button>
        <strong>Changes saved successfully.</strong>
    </div>
    <?PHP
}
?>

<div class="row-fluid">
<!-- BEGIN SAMPLE TABLE PORTLET-->
	<div class="margin-bottom-40">
		
		<div class="portlet box blue">
			<div class="portlet-title">
				<div class="caption"><?PHP echo $partHeader; ?></div>
				<div class="tools">
					<a href="javascript:;" class="collapse"></a>
				</div>
                
			</div>
            
			<div class="portlet-body">
				<form action="" id="post_form" name="post_form" method="post">

		            <div class="form-group">
		                <label class="control-label">Post Title
		                </label>
		                <div class="form-content">
		                    <input type="text" class="form-control" name="title" id="title"
		                        value="<?PHP if($id) echo htmlentities($postData->title); ?>">
		                </div>
		            </div>
		            <div class="row">
		            	<div class="col-md-6">
				            <div class="form-group">
				                <label class="control-label">Posted On
				                </label>
				                <div class="form-content">
				                    <input type="text" class="form-control datepickerclass" name="date" id="date"
				                        value="<?PHP if($id) echo date("d M Y",strtotime($postData->date)); ?>">
				                </div>
				            </div>
				        </div>
				        <div class="col-md-6">
				            <div class="form-group">
				                <label class="control-label">Post Type
				                </label>
				                <div class="form-content">
				                    <select name="type_id" id="type_id" class="form-control">
				                    	<?PHP
				                    	foreach ($post_types as $postType)
				                    	{
				                    		?>
				                    		<option value="<?PHP echo $postType->id; ?>"
				                    		<?PHP
				                    		if($id && $postData->type_id==$postType->id)
				                    			echo " selected";
				                    		?>
				                    		>
				                    			<?PHP echo htmlentities($postType->name); ?>
				                    		</option>
				                    		<?PHP
				                    	}
				                    	?>
				                    </select>
				                </div>
				            </div>
				        </div>
				    </div>

		            <div class="form-group">
		                <label class="control-label">Content
		                </label>
		                <div class="form-content">
		                    <textarea class="form-control" name="content" id="content" rows="6"><?PHP 
		                        if($id) echo $postData->content; ?></textarea>
		                </div>
		            </div>
		            <div class="form-group">
						<div class="form-content">
							<button type="submit" name="add_post" id="add_post" class="btn btn-xs blue"> 
							<i class="fa fa-check"></i> <?PHP if($id) echo "Save"; else echo "Add Post"; ?></button>
							<a href="/dailypostsadmin" class="btn btn-xs red"> <i class="fa fa-ban"></i> Cancel</a>
						</div>
					</div>


				</form>
			</div>
		</div>



    </div>
 
</div>
<script type="text/javascript" src="<?PHP echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name;; ?>/global/plugins/ckeditor/ckeditor.js"></script>
<script type="text/javascript">
CKEDITOR.env.isCompatible = true;
CKEDITOR.replace( 'content',
{
    height:'400px',
    toolbar :
        [
    { name: 'indent', items : [ 'Bold','Italic','Underline','NumberedList','BulletedList','Outdent','Indent','JustifyLeft','JustifyCenter','JustifyRight','JustifyBlock','Link','Unlink','Image','Table','Smiley','SpecialChar','TextColor','BGColor','TextColor','BGColor'] },
            { name: 'styles', items : [ 'Styles','Format','Font','FontSize'] }
        ],
    filebrowserImageUploadUrl : '<?PHP echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name;; ?>/global/plugins/ckeditor/ckfinder/core/connector/php/connector.php?command=QuickUpload&type=DAILYPOST',
});
$( document ).ready(function() 
{
	$('#post_form').validate({
        errorElement: 'label', //default input error message container
        errorClass: 'help-inline', // default input error message class
        focusInvalid: true, // do not focus the last invalid input
		onkeyup: false,
       	rules: {
            title: {
                required: true,
                minlength:6,
                maxlength:200
            },
            date:
            {
            	required:true
            }
        },

        messages:
        {
            title:
            {
                required: "Please enter Post Title"
            },
            date:
            {
                required: "Please choose Posted On Date"
            }
        },
    	highlight: function (element)
    	{
            $(element).closest('.form-group').removeClass("has-success").addClass('has-error'); // set error class to the control group   
        },
        success: function (label, element)
        {
            $(element).closest('.form-group').removeClass('has-error').addClass('has-success');
			label.remove();
        },

        errorPlacement: function (error, element) { // render error placement for each input type
			error.addClass('help-small no-left-padding').insertAfter(element);
        }
    });

});
</script>
