<link href="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/datatables_1_10_5/media/css/dataTables.bootstrap.css" rel="stylesheet" type="text/css"/>
<input class="current-browser-title" data-title="Search" type="hidden">
<div class="page-content">
	<!-- BEGIN PAGE HEADER-->
	<h3 class="page-title">
        <i class="icomoon-search"></i>
        <span class="top-line">
            Search
            <span id="sub_title"></span>
        </span>
        <br>
        <span class="caption">
            <?PHP echo site_short_name; ?> Search
        </span>
    </h3>
    <div class="clearfix"></div>
	<div class="page-bar">
		<ul class="page-breadcrumb">
			<li>
				<a href="<?PHP echo base_url; ?>">Home</a>
				<i class="fa fa-angle-right"></i>
			</li>
			<li class="active">
           		Search
            </li>
		</ul>
	</div>
	<style type="text/css">
		h4
		{
			color: #474747;
		}
	</style>
	<!-- END PAGE HEADER-->

	<?PHP
	$searchTextVal = "";
	$searchTypeVal = "";
	if(isset($_GET['search_text']) && $_GET['search_text']!='')
		$searchTextVal = htmlentities($_GET['search_text']);
	if(isset($_GET['search_type']) && $_GET['search_type']!='')
		$searchTypeVal = htmlentities($_GET['search_type']);
	?>

	<form class="search_form margin-bottom-20">
		<div class="col-md-3">
			<input type="text" name="search_text" id="search_text" placeholder="Type keyword to search..." class="form-control input-sm" value="<?PHP echo $searchTextVal; ?>"  />
		</div>
		<div class="col-md-2">
			<select id="search_type" class="form-control input-sm">
				<option value="events" id="events_count" <?PHP if($searchTypeVal=='events') echo 'selected'; ?>>Events</option>
				<?PHP
				if(global_site_flag==1)
				{
					?>
					<option value="speeches" id="speeches_count" <?PHP if($searchTypeVal=='speeches') echo 'selected'; ?>>Speeches</option>
					<option value="sri_swamiji_says" id="posts_count" <?PHP if($searchTypeVal=='sri_swamiji_says') echo 'selected'; ?>>Sri Swamiji Says</option>
					<?PHP
				}
				?>
				<option value="pages" id="pages_count" <?PHP if($searchTypeVal=='pages') echo 'selected'; ?>>Pages</option>
				<!-- <option value="articles" id="articles_count" <?PHP if($searchTypeVal=='articles') echo 'selected'; ?>>Articles</option> -->
				<?PHP
                if($GLOBALS['site_settings']['poojas']==1)
                {
                	?>
					<option value="poojas" id="poojas_count" <?PHP if($searchTypeVal=='poojas') echo 'selected'; ?>>Poojas</option>
					<?PHP
				}
				if($GLOBALS['site_settings']['donations']==1)
                {
					?>
					<option value="donations" id="donations_count" <?PHP if($searchTypeVal=='donations') echo 'selected'; ?>>Donations</option>
					<?PHP
				}
				if($GLOBALS['site_settings']['subscriptions']==1)
                {
					?>
					<option value="subscriptions" id="subscriptions_count" <?PHP if($searchTypeVal=='subscriptions') echo 'selected'; ?>>Subscriptions</option>
					<?PHP
				}
				if($GLOBALS['site_settings']['store']==1)
                {
					?>
					<option value="store_items" id="store_items_count" <?PHP if($searchTypeVal=='store_items') echo 'selected'; ?>>Store Items</option>
					<?PHP
				}
				?>
				<option value="calendar" id="calendar_count" <?PHP if($searchTypeVal=='calendar') echo 'selected'; ?>>Calendar</option>
				<?PHP
				if(global_site_flag==1)
				{
					?>
					<option value="bhajans" id="bhajans_count" <?PHP if($searchTypeVal=='bhajans') echo 'selected'; ?>>Bhajans</option>
					<option value="ashram_centers" id="ashramcenters_count" <?PHP if($searchTypeVal=='ashram_centers') echo 'selected'; ?>>Ashram Centers</option>
					<?PHP
				}
				?>
				<option value="quick_links" id="quick_links_count" <?PHP if($searchTypeVal=='quick_links') echo 'selected'; ?>>Quick Links</option>
			</select>
		</div>
		<div class="col-md-2">
			<button type="button" id="searchButton" class="btn btn-sm blue searchButton"><i class="fa fa-search"></i> Search</button>
	        <a class="btn btn-sm red" id="searchClear" onClick="search_clear()" style="display:none;"><i class="fa fa-search-minus"></i> Clear</a>
	    </div>
	    <div class="clearfix"></div>
	</form>
	<div class="row margin-bottom-40" style="min-height: 400px;">
		<div class="col-md-12 no-more-tables" id="search-results">
			<table id="list" class="display table-bordered table-striped table-condensed table" cellspacing="0" width="100%" >
                <thead>
                    <tr>
                        <th>S. No.</th>
                        <th></th>
                    </tr>
                </thead>
                <?PHP
                if(!isset($_GET['search_text']) || (isset($_GET['search_text']) && $_GET['search_text']==''))
                {
                	?>
                	<tbody>
                		<tr>
                			<td colspan="2" align="center">No Results found</td>
                		</tr>
                	</tbody>
                	<?PHP
                }
                ?>
                
            </table>
		</div>
	</div>
	
	<div class="clearfix">
	</div>
</div>
<script src="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/datatables_1_10_5/media/js/jquery.dataTables.js" type="text/javascript"></script>
<script src="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/datatables_1_10_5/media/js/dataTables_custom.js" type="text/javascript"></script>
<script type="text/javascript">
	$('#search_text').keypress(function(event)
	{
		var keycode = (event.keyCode ? event.keyCode : event.which);
		if(keycode == '13')
		{
			event.preventDefault();
			search();
		}
	});
	var search_text='';
	var search_type='';
	var table='';
	function search()
	{
		clearNotifications();
	    if(!$("#search_text").length || !$("#search_type").length)
	    {
	        showNotification("ruby","Something went wrong!!! Please refresh page and try again.");
	        return;
	    }
	    if($("#search_text").length && $("#search_text").val().trim() == '') 
        {
            showNotification('ruby','Please enter search keywords');
            return false;
        }
	    $(".dataTables_processing").show();
	    if($("#search_type").length)
	        search_type = $("#search_type").val();
	    if($("#search_text").length)
	        search_text = $("#search_text").val().trim();

	    if (search_text != '')
            $("#searchClear").css("display", "inline-block");

	    if($.fn.DataTable.isDataTable( '#list' ))
	    {
	    	table.fnDestroy();
	    }
	    $("#list").show();
	    init(search_type);
	}

	function search_clear() 
    {
        window.location="<?PHP echo base_url; ?>search";
    }

	function init(search_type)
	{
		var titleName = "";
		var PageName = "";
		if(search_type=='pages')
		{
			titleName = "Page Title";
			PageName = "Pages";
		}
		if(search_type=='events')
		{
			titleName = "Event Title";
			PageName = "Events";
		}
		if(search_type=='sri_swamiji_says')
		{
			titleName = "Sri Swamiji Says Title";
			PageName = "Sri Swamiji Says";
		}
		if(search_type=='speeches')
		{
			titleName = "Speech Title";
			PageName = "Speechs";
		}
		if(search_type=='articles')
		{
			titleName = "Article Title";
			PageName = "Articles";
		}
		if(search_type=='poojas')
		{
			titleName = "Pooja Title";
			PageName = "Poojas";
		}
		if(search_type=='donations')
		{
			titleName = "Donation Title";
			PageName = "Donations";
		}
		if(search_type=='subscriptions')
		{
			titleName = "Subscription Title";
			PageName = "Subscriptions";
		}
		if(search_type=='store_items')
		{
			titleName = "Store Item Title";
			PageName = "Store Items";
		}
		if(search_type=='calendar')
		{
			titleName = "Calendar Title";
			PageName = "Calendar";
		}
		if(search_type=='bhajans')
		{
			titleName = "Bhajans Title";
			PageName = "Bhajans";
		}
		if(search_type=='ashram_centers')
		{
			titleName = "Ashram Centers Title";
			PageName = "Ashram Centers";
		}
		if(search_type=='quick_links')
		{
			titleName = "Quick Link Title";
			PageName = "Quick Link";
		}
		var search_type_arr = ['pages','events','sri_swamiji_says','speeches','articles','poojas','donations','subscriptions','store_items','calendar','bhajans','ashram_centers','quick_links'];
		if($.inArray(search_type, search_type_arr) >  -1)
		{
			table = $('#list').dataTable(
			{
	            "processing": true,
	            "language": {
	                "sProcessing": '<div class="spinnerspin"></div>',
	                "emptyTable": "No records found!"
	            },
	            "sDom": "l<'custom-clear visible-xs'>ptr<'clearfix'>p",
	            "sPaginationType": "bootstrap",
	            "serverSide": true,
	            "iDisplayLength": 20,
	            "order": [
	                [1, "asc"]
	            ],
	            "responsive": true,
	            "lengthMenu": [
	                [20, 50],
	                [20, 50]
	            ],
	            "drawCallback": function(settings) 
	            {
	                var api = this.api();
	                var context=api.rows({
	                    page: 'current'
	                }).data().context[0];

	                var totalrows = context._iRecordsTotal;
	                $("#events_count").html('Events ('+context.json.total_events+')');
	                $("#pages_count").html('Pages ('+context.json.total_pages+')');
	                <?PHP
					if(global_site_flag==1)
					{
						?>
		                $("#posts_count").html('Sri Swamiji Says ('+context.json.total_posts+')');
		                $("#speeches_count").html('Speeches ('+context.json.total_speeches+')');
		                <?PHP
					}
					?>
	                // $("#articles_count").html('Articles ('+context.json.total_articles+')');
	                <?PHP
	                if($GLOBALS['site_settings']['poojas']==1)
	                {
	                	?>
		                $("#poojas_count").html('Poojas ('+context.json.total_poojas+')');
		                <?PHP
					}
					if($GLOBALS['site_settings']['donations']==1)
	                {
						?>
		                $("#donations_count").html('Donations ('+context.json.total_donations+')');
		                <?PHP
					}
					if($GLOBALS['site_settings']['subscriptions']==1)
	                {
						?>
		                $("#subscriptions_count").html('Subscriptions ('+context.json.total_subscriptions+')');
		                <?PHP
					}
					if($GLOBALS['site_settings']['store']==1)
	                {
						?>
		                $("#store_items_count").html('Store Items ('+context.json.total_store_items+')');
		                <?PHP
					}
					?>
	                $("#calendar_count").html('Calendar ('+context.json.total_calendars+')');
	                <?PHP
					if(global_site_flag==1)
					{
						?>
		                $("#bhajans_count").html('Bhajans ('+context.json.total_bhajans+')');
		                $("#ashramcenters_count").html('Ashram Centers ('+context.json.total_ashramcenters+')');
		                <?PHP
					}
					?>
					$("#quick_links_count").html('Quick Links ('+context.json.total_quick_links+')');

	                $("#sub_title").html('- '+PageName+' (' + totalrows + ')');
	            },
	            "columns": [
	            {
	                "width": "5%",
	                "orderable": false
	            }, {
	                "orderable": false
	            }],
	            "ajax": {
	                url: '/search/listresults',
	                type: 'POST',
	                data: function(d) 
	                {
	                    d.search_text = search_text;
	                    d.search_type=search_type
	                },
	                error: function (xhr, error, thrown) 
	                {
	                    $(".dataTables_processing").hide();
	                    return false;
	                }
	            },
	            "fnRowCallback": function(nRow, aData, iDisplayIndex, iDisplayIndexFull) {
	                var vis = true;
	                var ii = 0;
	                var sno = 0;

	                if (this.api().column(sno).visible()) {
	                    $('td:eq(' + ii + ')', nRow).attr('data-title', "S. No.");
	                    ii++;
	                }
	                sno++;
	                if (this.api().column(sno).visible()) {
	                    $('td:eq(' + ii + ')', nRow).attr('data-title', titleName);
	                    ii++;
	                }
	               
	                return nRow;
	            },
	            "columnDefs": [
	            {
	                "render": function(data, type, row) {
	                    return row.sno;
	                },
	                "targets": 0
	            }, {
	                "render": function(data, type, row) 
	                {
	                	var str = '';
	                	if(search_type=='pages')
						{
							str = '<a href="<?PHP echo base_url; ?>page/view/'+row.slug+'" target="_blank"\
	                    			style="text-decoration:none;">'+row.name + '</a>';
						}
						if(search_type=='events')
						{
							str = '<a href="<?PHP echo base_url; ?>events/'+row.year+'/'+row.slug+'" target="_blank"\
	                    			style="text-decoration:none;">'+row.name + '</a>';
						}
						if(search_type=='sri_swamiji_says')
						{
							str = '<a href="<?PHP echo base_url; ?>'+row.type+'/'+row.year+'/'+row.month+'" target="_blank"\
                    				style="text-decoration:none;">'+row.title + '</a>';
						}
						if(search_type=='speeches')
						{
							str = '<a href="<?PHP echo base_url; ?>speeches/'+row.year+'/'+row.month+'/'+row.day+'/'+row.slug+'" target="_blank"\
                    				style="text-decoration:none;">'+row.name + '</a>';
						}
						if(search_type=='articles')
						{
							str = '<a href="<?PHP echo base_url; ?>articles/'+row.year+'/'+row.month+'/'+row.day+'/'+row.slug+'" target="_blank"\
                    				style="text-decoration:none;">'+row.name + '</a>';
						}
						if(search_type=='poojas')
						{
							str = '<a href="<?PHP echo base_url; ?>poojas?ashram_id='+row.ashram_id+'" \
										target="_blank" style="text-decoration:none;">'+row.pooja_name + '</a>';
						}
						if(search_type=='donations')
						{
							str = '<a href="<?PHP echo base_url; ?>donations?ashram_id='+row.ashram_id+'" \
										target="_blank" style="text-decoration:none;">'+row.donation_name + '</a>';
						}
						if(search_type=='subscriptions')
						{
							str = '<a href="<?PHP echo base_url; ?>subscriptions?ashram_id='+row.ashram_id+'" \
										target="_blank" style="text-decoration:none;">'+row.subscription_name + '</a>';
						}
						if(search_type=='store_items')
						{
							str = '<a href="<?PHP echo base_url; ?>store?ashram_id='+row.ashram_id+'" \
										target="_blank" style="text-decoration:none;">'+row.item_name + '</a>';
						}
						if(search_type=='calendar')
						{
							str = '<a href="'+row.calendar_url+'" target="_blank" style="text-decoration:none;">'+row.event_name + '</a>';
						}
						if(search_type=='bhajans')
						{
				  			var files=row.files.split(",");
			                files.sort();
			                // var sizes=row.sizes.split(",");
			                var ff=0;
			                var cnt=0;
			                var color='';
			                $.each(files,function(i,fname)
			                {
			                    if(cnt%2==0)
			                    {
			                        color='#000';
			                    }
			                    else
			                    {
			                        color="#3b5998";
			                    }
			                    if(fname.indexOf('_telugu')>-1)
			                    {
			                        if(ff==1) str+=' | ';
			                        str+='<a href="'+row.aws_s3_base_url+'content/bhajans/'+fname+'" style="color:'+color+'" target="_blank">Telugu</a>';
			                        ff=1;
			                    }
			                    if(fname.indexOf('_english')>-1)
			                    {
			                        if(ff==1) str+=' | ';
			                        str+='<a href="'+row.aws_s3_base_url+'content/bhajans/'+fname+'" style="color:'+color+'" target="_blank">English</a>';
			                        ff=1;
			                    }
			                    if(fname.indexOf('_hindi')>-1)
			                    {
			                        if(ff==1) str+=' | ';
			                        str+='<a href="'+row.aws_s3_base_url+'content/bhajans/'+fname+'" style="color:'+color+'" target="_blank">Hindi</a>';
			                        ff=1;
			                    }
			                    if(fname.indexOf('_kannada')>-1)
			                    {
			                        if(ff==1) str+=' | ';
			                        str+='<a href="'+row.aws_s3_base_url+'content/bhajans/'+fname+'" style="color:'+color+'" target="_blank">Kannada</a>';
			                        ff=1;
			                    }
			                    if(fname.indexOf('_tamil')>-1)
			                    {
			                        if(ff==1) str+=' | ';
			                        str+='<a href="'+row.aws_s3_base_url+'content/bhajans/'+fname+'" style="color:'+color+'" target="_blank">Tamil</a>';
			                        ff=1;
			                    }
			                    if(fname.indexOf('_malayalam')>-1)
			                    {
			                        if(ff==1) str+=' | ';
			                        str+='<a href="'+row.aws_s3_base_url+'content/bhajans/'+fname+'" style="color:'+color+'" target="_blank">Malayalam</a>';
			                        ff=1;
			                    }
			                    if(fname.indexOf('_oriya')>-1)
			                    {
			                        if(ff==1) str+=' | ';
			                        str+='<a href="'+row.aws_s3_base_url+'content/bhajans/'+fname+'" style="color:'+color+'" target="_blank">Oriya</a>';
			                        ff=1;
			                    }
			                    if(fname.indexOf('_bengali')>-1)
			                    {
			                        if(ff==1) str+=' | ';
			                        str+='<a href="'+row.aws_s3_base_url+'content/bhajans/'+fname+'" style="color:'+color+'" target="_blank">Bengali</a>';
			                        ff=1;
			                    }
			                    if(fname.indexOf('_gujarati')>-1)
			                    {
			                        if(ff==1) str+=' | ';
			                        str+='<a href="'+row.aws_s3_base_url+'content/bhajans/'+fname+'" style="color:'+color+'" target="_blank">Gujarati</a>';
			                        ff=1;
			                    }
			                    if(fname.indexOf('_punjabi')>-1)
			                    {
			                        if(ff==1) str+=' | ';
			                        str+='<a href="'+row.aws_s3_base_url+'content/bhajans/'+fname+'" style="color:'+color+'" target="_blank">Punjabi</a>';
			                    }
			                    cnt++;
			                });

			                var template='\
								  			<div class="an-row margin-bottom-30 bhajan-row col-md-6">\
										        <h2 class="an-title">\
										        	<i class="icomoon-file-pdf" style="font-size:14px;"></i> '+row.description+'\
										        </h2>\
										        <div class="links">\
										            '+str+'\
												</div>\
											</div>';
								  			
				  			str = template;
						}
						if(search_type=='ashram_centers')
						{
							str = '<a href="<?PHP echo base_url; ?>ashramcenters/'+row.slug+'" \
										target="_blank" style="text-decoration:none;">'+row.name + '</a>';
						}
						if(search_type=='quick_links')
						{
							str = '<a href="'+row.link+'" \
										target="_blank" style="text-decoration:none;">'+row.title + '</a>';
						}
	                    return str;
	                },
	                "targets": 1,
	                "title":titleName
	            }]
	        });
		}
	}
	$("#search_type").on("change",function()
    {
    	var searchType = $(this).val();
    	window.location="<?PHP echo base_url; ?>search?search_text="+search_text+"&search_type="+searchType;
    });

    $("#searchButton").on("click",function()
    {
    	search_text = $("#search_text").val().trim();
    	search_type = $("#search_type").val();
    	clearNotifications();
		if ($("#search_text").length && $("#search_text").val().trim() == '') 
	    {
	        showNotification('ruby','Please enter search keywords');
	        return false;
	    }
	    else
    		window.location="<?PHP echo base_url; ?>search?search_text="+search_text+"&search_type="+search_type;
    });
	<?PHP
		if(isset($_GET['search_text']) && $_GET['search_text']!='')
		{
			?>
			$(document).ready(function()
			{
				search();
			});
			<?PHP
		}
	?>
</script>