
<input class="current-browser-title" data-title="Contact" type="hidden">
<div class="page-content">
    <!-- BEGIN PAGE HEADER-->
    <h3 class="page-title">
        <i class="icomoon-phone"></i>
        <span class="top-line">
            Contact
        </span>
        <br>
        <span class="caption">
            <?PHP echo site_short_name; ?> Contact
        </span>
    </h3>
    <div class="clearfix"></div>
    <div class="page-bar">
        <ul class="page-breadcrumb">
            <li>
                <a href="<?PHP echo base_url; ?>">Home</a>
                <i class="fa fa-angle-right"></i>
            </li>
            <li class="active">
                Contact
            </li>
        </ul>
    </div>
    <!-- END PAGE HEADER-->
    <?PHP
    $name='';
    $email='';
    if($this->session->userdata('id'))//if admin
    {
        $name=$this->session->userdata('admin_data')->firstname;
        $email=$this->session->userdata('admin_data')->email;
    }
    if($this->session->userdata('user_id'))//if user && override admin
    {
        $name=$this->session->userdata('user_data')->firstname;
        $email=$this->session->userdata('user_data')->email;
    }
    ?>

    <?PHP
    if(global_site_flag==4)
    {
        ?>
        <style type="text/css">
            .adminside-bar {
                background: #fcfcfc;
                padding: 10px;
                border: 1px solid #c3c3c3;
                margin-bottom: 20px;
            }
        </style>
        <div class="row">
            <div class="col-md-4">
                <div class="service-box-heading adminside-bar front-lists-v1">
                    <div class="widget">
                        <div class="widget_title">
                            <h3>Texas</h3>
                        </div>
                        <div class="tb_widget_recent_list clearfix quick-links">
                            <div class="row col-md-12">
                                <p>
                                    SGS Birds Paradise</br>
                                    12030 Independence Pkwy</br>
                                    Frisco, TX - 75035</br>
                                    Tel: +1 (908) 745 1779</br>
                                    Email: sgsbirds@yahoo.com
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-4">
                <div class="service-box-heading adminside-bar front-lists-v1">
                    <div class="widget">
                        <div class="widget_title">
                            <h3>New Jersey</h3>
                        </div>
                        <div class="tb_widget_recent_list clearfix quick-links">
                            <div class="row col-md-12">
                                <p>
                                    SGS Birds Paradise</br>
                                    PO BOX 250</br>
                                    Plainsboro, NJ - 08536</br>
                                    Tel: +1 (609) 286 9634</br>
                                    Email: sgsbirds@yahoo.com
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-4">
                <div class="service-box-heading adminside-bar front-lists-v1">
                    <div class="widget">
                        <div class="widget_title">
                            <h3>Mysore</h3>
                        </div>
                        <div class="tb_widget_recent_list clearfix quick-links">
                            <div class="row col-md-12">
                                <p>
                                    Avadhoota Datta Peetham </br>
                                    Sri Ganapathy Sachchidananda Ashrama, Dattanagar</br>
                                    Mysore - 570 025, India</br>
                                    Tel: +91 (821) 2486 486</br>
                                    Email: sgsbirds@yahoo.com
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?PHP
    }
    ?>
    
    <div class="row">
        <div class="col-md-6">
            <div class="alert alert-info">
                <b>Please use Contact page for personal requests and messages to the Ashrama.</b><br>
                For all website application / program issues kindly use the <a href="<?php echo base_url;?>techsupport"><b>Feedback / Support option</b></a>.
            </div>
        <form class="contact_form form-horizontal" novalidate style="padding:10px; border:1px solid #c3c3c3;">
            <div class="form-group">
                <label class="control-label" style="text-align:left;">Name <span class="required">*</span></label>
                <div class="controls" >
                    <input type="text" name="name" class="form-control"
                    <?PHP if($this->session->userdata('loggedIn')) echo "disabled"; ?>
                    value="<?PHP echo htmlentities($name); ?>" 
                    id="name" autocomplete="off" placeholder="Enter your Name">
                 </div>
            </div>

            <div class="form-group">
                <label class="control-label" style="text-align:left;">Email ID <span class="required">*</span></label>
                <div class="controls" >
                    <input type="text" name="email" class="form-control" id="email"
                    <?PHP if($this->session->userdata('loggedIn')) echo "disabled"; ?>
                    value="<?PHP echo htmlentities($email); ?>" placeholder="Enter your Email ID">
                </div>
            </div>

            <div class="form-group">
                <label class="control-label" style="text-align:left;">Phone</label>
                <div class="row">
                    <div class="col-md-2 col-sm-2 col-xs-3">
                        <div class="controls">
                        <input type="hidden" name="c_country_code" id="c_country_code" value="IN">
                            <div class="btn-group" style="display: block;">
                                <button class="btn btn-default dropdown-toggle" id="cnt-country-code-button" type="button" data-toggle="dropdown" aria-expanded="false" style="width: 100%; text-align: left;">
                                +91
                                </button>
                                <ul class="dropdown-menu" role="menu" style="max-height: 150px; overflow: auto; margin-top: 35px;">
                                    <?PHP
                                    $countries=$this->locations_model->getCountries();
                                    foreach ($countries as $country)
                                    {
                                        ?>
                                        <li data-code="<?PHP echo $country->country_code; ?>" data-isd="<?PHP echo $country->isd_code; ?>">
                                            <a href="javascript:;" class="c_country_item"><?PHP echo $country->country_name." +".$country->isd_code; ?></a>
                                        </li>
                                        <?PHP
                                    }
                                    ?>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-10 col-sm-10 col-xs-9">
                        <div class="controls" >
                            <input type="text" name="phone" class="form-control"
                            id="phone" autocomplete="off" placeholder="Enter your Phone">
                         </div>
                    </div>
                </div>
            </div>

            <div class="form-group">
                <label class="control-label" style="text-align:left;">Purpose</label>
                <div class="controls" >
                    <select name="purpose" id="purpose" class="form-control">
                        <option>Personal Request</option>
                        <option>Abuse</option>
                        <option>Complaint</option>
                        <option>Other</option>
                    </select>
                 </div>
            </div>

            <div class="form-group">
                <label class="control-label" style="text-align:left;">Message <span class="required">*</span></label>
                <div class="controls">
                    <textarea name="message" id="message" placeholder="Enter your Message" rows="6"
                    style="resize:none;" class="form-control"></textarea>
                 </div>
            </div>

            <div class="form-group">
                <div class="controls">
                    <button type="submit" value="Send" class="btn blue btn-xs" id="contact-submit"><i class="fa fa-check"></i> Send</button>
                </div>
            </div>
        </form>
        </div>
        <div class="col-md-6">
            
            <div id="map_canvas" style="height:630px;" class=""></div>
        </div>
    </div>
    
    <div class="clearfix">
    </div>
</div>
<script src="https://maps.googleapis.com/maps/api/js?key=<?PHP echo google_api_key; ?>&sensor=false"></script>
<script>
function initialize()
{
    var c_long = "<?php echo contact_latitude;?>";
    var c_lat = "<?php echo contact_longitude;?>";
    var myLatlng = new google.maps.LatLng(c_long, c_lat);
    var map_canvas = document.getElementById('map_canvas');
    var map_options = { center: new google.maps.LatLng(c_long, c_lat), zoom: 15, mapTypeId: google.maps.MapTypeId.ROADMAP }
    var contentString = '\
            <div id="content">\
                <div id="siteNotice">\
            </div>\
            <h3 id="firstHeading" class="firstHeading">Sri Ganapathy Sachchidananda Ashrama</h3>\
                <div id="bodyContent">\
                    <p><b>Mysore</b></p>\
                    <p>\
                        <a href="<?PHP echo base_url; ?>">\
                            <?PHP echo base_url; ?>\
                        </a>\
                    </p>\
                </div>\
            </div>';
    var infowindow = new google.maps.InfoWindow({ content: contentString });
    var map = new google.maps.Map(map_canvas, map_options)
    var marker = new google.maps.Marker({ position: myLatlng, map: map, title: '<?PHP echo site_short_name; ?>, Mysore' });
    google.maps.event.addListener(marker, 'click', function()
    {
        infowindow.open(map,marker);
    });
}
google.maps.event.addDomListener(window, 'load', initialize);


$(document).ready(function()
{
    $(".c_country_item").on("click",function()
    {
        var isd=$(this).parent().attr("data-isd");
        var code=$(this).parent().attr("data-code");
        $("#cnt-country-code-button").html("+"+isd);
        $("#c_country_code").val(code);
    });
    $('.contact_form').validate(
    {
        errorElement: 'span', //default input error message container
        errorClass: 'help-block help-block-error', // default input error message class
        focusInvalid: true, // do not focus the last invalid input
        rules: 
        {
            name: 
            {
                required: true,
                minlength: 3,
                maxlength:100
            },
            email:
            {
                required:true,
                no_uppercase:true,
                email_validate:true,
                minlength:6,
                maxlength:200
            },
            phone:
            {
                spaces:true,
                minlength:5,
                maxlength:100
            },
            purpose:
            {
                required:true
            },
            message:
            {
                required:true,
                maxlength:500
            }
        },

        messages:
        {
            name:
            {
                required: "Please enter your Name"
            },
            purpose:
            {
                required: "Please select Purpose"
            },
            email:
            {
                required: "Please enter your Email ID"
            },
            message:
            {
                required:"Please enter Message"
            }
        },
        highlight: function (element) 
        {
            $(element).closest('.form-group').removeClass("has-success").addClass('has-error');
        },
        success: function (label,element) 
        {
            $(element).closest('.form-group').removeClass('has-error').addClass('has-success');
            label.remove();
            
        },
        errorPlacement: function (error, element) 
        {
            error.addClass('help-small no-left-padding').insertAfter(element);
        },
        submitHandler:function()
        {
            $(".loader_animation").show();
            $("#contact-submit").prop("disabled",true);
            jQuery.post('/contact/send',$(".contact_form").serialize(), function(res) 
            {

                try
                {
                    var r=$.parseJSON(res);
                }
                catch(err)
                {
                    $("#contact-submit").prop("disabled",false);
                    $(".loader_animation").hide();
                    showNotification('ruby',"Something wrong, please refresh the page and try again.");
                    return false;
                }

                if(r.flag==1)
                {
                    <?PHP
                    if(!$this->session->userdata('loggedIn'))  
                    {
                        ?>
                        $("#email").val('');
                        $("#name").val('');
                        $("#phone").val('');
                        <?PHP
                    }
                    ?>
                    $("#purpose").val($("#purpose option:first").val());
                    $("#message").val('');
                    showNotification("lime","Your request has been sent");
                }
                else if(r.flag==2)
                {
                    showNotification('ruby',"Your are loggedin as Admin and cannot send contact message.");
                }
                else
                {
                    showNotification('ruby',"Something wrong, please refresh the page and try again.");
                }
                $("#contact-submit").prop("disabled",false);
                $(".loader_animation").hide();
            });
        }

    });

});
</script>

