<div id="bulk-users-modal" class="modal fade" data-width="800" tabindex="-1">
    <form class="validate-users-form" id="validate-users-form">
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
            <h4 class="modal-title" style="color:#fff;">Enter Email IDs (comma separated/new line)</h4>
        </div>
        <div class="modal-body">
            <div class="form-group">
                <textarea class="form-control" rows="6" name="users_string" id="users_string" placeholder="Enter Email IDs each in new line or comma separated"></textarea>
            </div>
            <div class="alert alert-info">
                Only subscribed and valid users will be added
            </div>
        </div>
        <div class="modal-footer">
            <button type="button" data-dismiss="modal" class="btn btn-xs">
                <i class="fa fa-remove"></i> Close
            </button>
            <button type="submit" class="btn btn-xs blue">
                <i class="fa fa-check"></i> Submit
            </button>
        </div>
    </form>
</div>
<script type="text/javascript">
$(document).ready(function()
{
    jQuery.validator.addMethod("multiemail",function (value, element)
    {
        emailValByCommaSeperate()
        value=$("#users_string").val();
        var email = value.split(/[,]+/); // split element by , and ;
        valid = true;
        
        for (var i in email) 
        {
            value = email[i];
            valid = valid && jQuery.validator.methods.email_validate.call(this, $.trim(value), element);
            if(value.length<6)
            {
                jQuery.validator.messages.multiemail = "Enter at least 6 characters for each Email ID";
                return false;
            }
            if(value.length>200)
            {
                jQuery.validator.messages.multiemail = "Enter not more than 200 characters for each Email ID";
                return false;
            }
        }
        if(email.length>500)
        {
            jQuery.validator.messages.multiemail = "Maximum of 500 Email IDs are allowed";
            return false;
        }
       

        return valid;
    },"Please enter valid Email IDs seperated with commas");

    $('#validate-users-form').validate({
        errorElement: 'span',
        errorClass: 'help-block',
        focusInvalid: true,
        rules:
        {
            users_string:
            {
                required: true,
                multiemail:true
            }
        },
        messages: {
            users_string: {
                required: "Please enter at least one Email ID"
            }
        },
        highlight: function(element)
        {
            $(element).closest('.form-group').addClass('has-error');
        },
        success: function(label)
        {
            label.closest('.form-group').removeClass('has-error');
            label.remove();
        },
        errorPlacement: function(error, element)
        {
            error.insertAfter(element);
            error.addClass('help-small no-left-padding').insertAfter(element);
        },

        submitHandler: function(form)
        {
            $(".loader_animation").show();
            $.post('/<?PHP echo $slug; ?>/validate_users',$('.validate-users-form').serialize(),
            function(res)
            {
                if(res.length>0)
                {
                    $("#bulk-users-modal").modal("hide");
                    $("#users_string").val('');
                    $("#userids").select2('data',res);
                }
                else
                {
                    showNotification("ruby","No users found. Please try again.");
                }
                $(".loader_animation").hide();
            });
            return false;
        }
    });
});
function emailValByCommaSeperate()
{
    var tt=$("#users_string").val().trim();
    var ee=$("#users_string").val();
    var em= ee.match(/([a-zA-Z0-9._-]+@[a-zA-Z0-9._-]+\.[a-zA-Z0-9._-]+)/gi);

    if(em && em.length>=1)
    {
        $("#users_string").val(em.join(','));
        return true;
    }
}
</script>