<link href="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/datatables_1_10_5/media/css/dataTables.bootstrap.css" rel="stylesheet" type="text/css"/>
<input class="current-browser-title" data-title=" Admin Dashboard | All Checklists" type="hidden">
<!-- BEGIN PAGE TITLE & BREADCRUMB-->
<?PHP
    $this->load->view("checklists/admin/nav_buttons");
?>
<h3 class="page-title">
    All Checklists
</h3>
<div class="page-bar">
    <ul class="page-breadcrumb">
        <li>
            <i class="fa fa-home"></i>
            <a href="/admin">Dashboard</a>
            <i class="fa fa-angle-right"></i>
        </li>
        <li class="active">
        	All Checklists
        </li>
    </ul>
</div>
<!-- END PAGE TITLE & BREADCRUMB-->


<div class="row-fluid">
	<form action="" name="" style="margin:0px;" onsubmit="return false" novalidate="" class="form-horizontal row search_form">
        <div class="col-md-2">
            <select id="role" class="input-inline form-control custom-input" onchange="search(1)">
                <option value="">All Roles</option>
                <?PHP
                $rolesString='';
                foreach ($roles as $rrole) 
                {
                    ?>
                    <option value="<?PHP echo $rrole->id; ?>">
                        <?PHP echo $rrole->role; ?>
                    </option>
                    <?PHP
                    if($rolesString!='') $rolesString.=",";
                        $rolesString.=$rrole->id.":".$rrole->role;
                }
                ?>
            </select>
        </div>
        <br class="hidden-sm hidden-xs" style="clear:both;">
        <div class="col-md-2">
            <input  type="text" id="search_text"  class="form-control input-inline custom-input" 
            placeholder="Type keyword to search..." style="border:1px solid skyblue;" />
        </div>
        <div class="col-md-2">
            <select name="search_col" id="search_col" class="form-control input-inline custom-input">
                <option value="topic">Topic</option>
            </select>
        </div>
       <!--  <div class="col-md-2">
            <select name="wild" id="wild" class="form-control input-inline custom-input">
                <option value="contains">Contains</option>
                <option value="starts">Starts With</option>
                <option value="ends">Ends With</option>
            </select>
        </div> -->
        <button id="searchButton" class="btn btn-xs blue tooltips" onClick="search(0)" 
            type="button" data-container="body" data-placement="bottom" data-original-title="Search">
            <i class="fa fa-search"></i> Search
        </button>
        <button id="searchClear" class="btn btn-xs red tooltips" style="display:none;" 
            type="button" data-container="body" data-placement="bottom" data-original-title="Clear">
            <i class="fa fa-search-minus"></i> Clear
        </button>
        <button type="button" id="excelButton" class="btn btn-xs green excelButton" ><i class="fa fa-file-excel-o"></i> Report</button>
    </form>
    <br class="hidden-lg hidden-md">

   <div class="portlet box blue">
		<div class="portlet-title">
			<div class="caption">All Checklists <span id="total_records"></span></div>
			<div class="tools">
				<a href="javascript:;" class="collapse"></a>
			</div>
            
		</div>
        
		<div class="portlet-body no-more-tables">
        
            <table class="table table-striped table-bordered table-hover table-condensed" id="ck_list" style="width:100%;">
                <thead>
                    <tr>
                        <th width="50">S. No.</th>
                        <th>Topic</th>
                        <th>Role</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    
                </tbody>
            </table>
        </div>
   </div>
   
   
</div>
<script src="<?php
echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/datatables_1_10_5/media/js/jquery.dataTables.js" type="text/javascript"></script>
<script src="<?php
echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/datatables_1_10_5/media/js/dataTables_custom.js" type="text/javascript"></script>
<script type="text/javascript">
var sflag=0;
var table='';
var search_text='';
var search_col='';
var role='';
function search(flag)
{
    clearNotifications();
    if(!$("#search_text").length || !$("#search_col").length || !$("#role").length)
    {
        showNotification("ruby","Something went wrong!!! Please refresh page and try again.");
        return;
    }
    if (flag == 0)
    {
        
        if ($("#search_text").length && $("#search_text").val().trim() == '') 
        {
            showNotification('ruby','Please enter search keywords or select dates');
            return false;
        }
    }
    $(".dataTables_processing").show();
    if($("#search_text").length)
        search_text = $("#search_text").val().trim();
    if($("#search_col").length)
        search_col = $("#search_col").val().trim();
    if($("#role").length)
        role = $("#role").val().trim();
    if (search_text != '')
        $("#searchClear").css("display", "inline-block");
    
    table.fnDraw();
}
$(document).ready(function() 
{
    

    $("#searchClear").on("click",function()
    {
        $(".dataTables_processing").show();
        $("#search_text").val('');
        search_text = '';
        search_col = '';
        $("#searchClear").css("display", "none");
        table.fnDraw();
    });
    var statusflag=0;
    $(".delete-button").live("click",function()
    {
        if(statusflag==1)
            return false;
        statusflag=1;
        var pid=$(this).attr("data-id");
        $(".dataTables_processing").show();
        $.post('/checklistadmin/delete/'+ pid, {}, function(res) 
        {
            var r = $.parseJSON(res);
            if (r.flag == 1) 
            {
                table.fnSettings.bResetDisplay  =false;
                table.fnDraw(table.fnSettings);
                showNotification('ruby', "Checklist '" + r.topic + "' deleted successfully.");
            }
            else 
            {
                $(".dataTables_processing").hide();
                showNotification("ruby", "Error occured. Please try again.");
            }
            $("#ck"+pid).modal("toggle");
            $(".dataTables_processing").hide();
            statusflag=0;
        });
    });

    if(sflag==1)
        return;
    sflag=1;
    
    table= $('#ck_list').dataTable(
    {
        "processing": true,
        "language": {
            "sProcessing": '<div class="spinnerspin"></div>',
            "emptyTable": "No records found!"
        },
        "sDom": "l<'custom-clear visible-xs'>ptr<'clearfix'>p",
        "sPaginationType": "bootstrap",
        "serverSide": true,
        "iDisplayLength": 50,
        "order": [
            [1, "asc"]
        ],
        "responsive": true,
        "lengthMenu": [
            [20, 50, 100],
            [20, 50, 100]
        ],
        "drawCallback": function(settings) 
        {
            var api = this.api();
            var totalrows = api.rows({
                page: 'current'
            }).data().context[0]._iRecordsTotal;
            $("#total_records").html('(' + totalrows + ')');
        },
        "columns": 
        [
            {
                "width": 50,
                "orderable": false
            },
            {
                "name":"topic",
                "orderable": true
            },
            {
                "width": "20%",
                "orderable": false
            },
            {
                "width": "10%",
                "orderable": false
            }
        ],
        "ajax": 
        {
            <?PHP
            $tableUrl="/checklistadmin/listrecords/";
            ?>
            url: '<?PHP echo $tableUrl; ?>',
            type: 'POST',
            data: function(d)
            {
                if (search_text != '')
                    d.search_text = search_text;
                d.search_col = search_col;
                d.role=role;
            },
            error: function (xhr, error, thrown) 
            {
                if(xhr.responseText=='login')
                {
                    window.location="<?PHP echo base_url; ?>"
                }
                else if(xhr.responseText==404 || xhr.responseText=='404' || xhr.responseText=='0')
                {
                   showNotification('ruby',"Invalid request");
                }
                $(".dataTables_processing").hide();
                return false;
            },
            dataSrc:function(res)
            {
                if(res.data.length==0 && res.recordsTotal!=0)
                {
                    oTable.fnDraw();
                }
                return res.data;
            }
        },
        "fnRowCallback": function(nRow, aData, iDisplayIndex, iDisplayIndexFull) 
        {
            var vis = true;
            var ii = 0;
            var sno = 0;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "S. No.");
                ii++;
            }
            sno++;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "Topic");
                ii++;
            }
            sno++;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "Role");
                ii++;
            }
            sno++;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "Actions");
                ii++;
            }
        },
        "columnDefs": 
        [
            {
                "render": function(data, type, row) 
                {
                    return row.sno;
                },
                "targets": 0
            }, {
                "render": function(data, type, row) 
                {
                    var str='';
                    var str='<a href="/checklistadmin/add_edit_checklist/'+row.id+'" target="_blank">'+row.topic+'</a>';
                    return str;
                },
                "targets": 1
            },
            {
                "render": function(data, type, row) 
                {
                    return row.role;
                },
                "targets": 2
            },
            {
                "render": function(data, type, row) 
                {
                    var str = '<div class="btn-group" id="actions' + row.id + '">' +
                        '<a class="btn red btn-xs" href="#" data-toggle="dropdown"> Actions ' +
                        '<i class="fa fa-angle-down"></i></a>' +
                        '<ul class="dropdown-menu pull-right" style="text-align:left;">' +
                        '<li><a href="/checklistadmin/add_edit_checklist/' + row.id + '" target="_blank"><i class="fa fa-eye"></i> Edit</a></li>';
            
                    str += '<li><a href="#ck' + row.id + '" role="button" data-toggle="modal">' +
                        '<i class="fa fa-trash-o"></i> Delete</a></li>' +

                        '<div id="ck' + row.id + '" class="modal fade" tabindex="-1">' +
                        '<div class="modal-header">' +
                        '<button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>' +
                        '<h4 class="modal-title">Delete Confirmation</h4>' +
                        '</div>' +
                        '<div class="modal-body"><div class="pull-left delete-confirmation-icon"' +
                        '><i class="fa fa-exclamation-triangle"></i></div>' +
                        'Do you really want to delete the Checklist: ' +
                        '<span style="color:red; font-weight:bold;">' + row.topic + '</span>?' +
                        '</div>' +
                        '<div class="modal-footer">' +
                        '<button type="button" data-dismiss="modal" class="btn btn-xs close' + row.id + '">' +
                        '<i class="fa fa-remove"></i> Cancel</button>' +
                        '<a class="btn btn-xs red delete-button" data-id="'+row.id+'">' +
                        '<i class="fa fa-trash"></i> Delete</a>' +
                        '</div>' +
                        '</div>';

                    return str;
                },
                "targets": 3
            }
        ]
    });
    
});
    $("#excelButton").on("click",function()
    {
        $(".loader_animation").show();
        clearNotifications();
        var sortindex=table.fnSettings().aaSorting[0][0];
        var order_by=table.fnSettings().aoColumns[sortindex].name;
        var dir=table.fnSettings().aaSorting[0][1];
        $.post('/checklistadmin/listrecords/1',
        {
            search_text:search_text,search_col:search_col,order_by:order_by,dir:dir,role:role
        },
            function(res)
            {
                var r=$.parseJSON(res);
                if(r.flag==1)
                {
                    window.location='<?PHP echo base_url; ?>excelreports/download/'+r.report_id;
                }
                if(r.flag==2)
                {
                    showNotification("ruby","Sorry! You have already requested the same report.");
                }
                if(r.flag==0)
                {
                    showNotification("ruby","Sorry! Report cannot be generated. Data is empty.");
                }
                $(".loader_animation").hide();
            }
        );
    });
</script>