<link href="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/datatables_1_10_5/media/css/dataTables.bootstrap.css" rel="stylesheet" type="text/css"/>
<input class="current-browser-title" data-title=" Admin Dashboard | My Checklists" type="hidden">
<?PHP echo $this->general_model->help_link(); ?>
<!-- BEGIN PAGE TITLE & BREADCRUMB-->
<h3 class="page-title">
My Checklists
</h3>
<div class="page-bar">
    <ul class="page-breadcrumb">
        <li>
            <i class="fa fa-home"></i>
            <a href="/admin">Dashboard</a>
            <i class="fa fa-angle-right"></i>
        </li>
        <li class="active">
        	My Checklists
        </li>
    </ul>
</div>
<!-- END PAGE TITLE & BREADCRUMB-->


<div class="row-fluid">

    <form action="" name="" style="margin:0px;" onsubmit="return false" novalidate="" class="form-horizontal row search_form">
        <div class="col-md-2">
            <input  type="text" id="search_text"  class="form-control input-inline custom-input" 
            placeholder="Type keyword to search..." style="border:1px solid skyblue;" />
        </div>
        <div class="col-md-2">
            <select name="search_col" id="search_col" class="form-control input-inline custom-input">
                <option value="topic">Topic</option>
            </select>
        </div>
        <div class="col-md-2">
            <select name="wild" id="wild" class="form-control input-inline custom-input">
                <option value="contains">Contains</option>
                <option value="starts">Starts With</option>
                <option value="ends">Ends With</option>
            </select>
        </div>
        <button id="searchButton" class="btn btn-xs blue tooltips"
            type="button" data-container="body" data-placement="bottom" data-original-title="Search">
            <i class="fa fa-search"></i> Search
        </button>
        <button id="searchClear" class="btn btn-xs red tooltips" style="display:none;" 
            type="button" data-container="body" data-placement="bottom" data-original-title="Clear">
            <i class="fa fa-search-minus"></i> Clear
        </button>
    </form>
    <br class="hidden-lg hidden-md">
    <div class="portlet box blue">
		<div class="portlet-title">
			<div class="caption">My Checklists <span id="total_records"></span></div>
			<div class="tools">
				<a href="javascript:;" class="collapse"></a>
			</div>
            
		</div>
        
		<div class="portlet-body">
        
            <table class="table table-striped table-bordered table-hover table-condensed" id="ck_list" style="width:100%;">
                <thead>
                    <tr>
                        <th width="50">S. No.</th>
                        <th>Topic</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    
                </tbody>
            </table>
        
       
        </div>
   </div>
</div>
<script src="<?php
echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/datatables_1_10_5/media/js/jquery.dataTables.js" type="text/javascript"></script>
<script src="<?php
echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/datatables_1_10_5/media/js/dataTables_custom.js" type="text/javascript"></script>
<script type="text/javascript">
var sflag=0;
$(document).ready(function() 
{
    $("#searchButton").on("click",function()
    {
        clearNotifications();
        if(!$("#search_text").length || !$("#search_col").length || !$("#wild").length)
        {
            showNotification("ruby","Something went wrong!!! Please refresh page and try again.");
            return;
        }
        //if (flag == 0)
        //{
            
            if($("#search_text").length && $("#search_text").val().trim() == '') 
            {
                showNotification('ruby','Please enter search keywords or select dates');
                return false;
            }
        //}
        $(".dataTables_processing").show();
        if($("#search_text").length)
            search_text = $("#search_text").val().trim();
        if($("#search_col").length)
            search_col = $("#search_col").val().trim();
        if($("#wild").length)
            wild = $("#wild").val().trim();
        if (search_text != '')
            $("#searchClear").css("display", "inline-block");
        
        table.fnDraw();

    });

    $("#searchClear").on("click",function()
    {
        $(".dataTables_processing").show();
        $("#search_text").val('');
        search_text = '';
        search_col = '';
        wild = '';
        $("#searchClear").css("display", "none");
        status='';
        $("#status").val('');
        table.fnDraw();
    });
    if(sflag==1)
        return;
    sflag=1;
    var search_text='';
    var wild='';
    var search_col='';
    var table= $('#ck_list').dataTable(
    {
        "processing": true,
        "language": {
            "sProcessing": '<div class="spinnerspin"></div>',
            "emptyTable": "No records found!"
        },
        "sDom": "l<'custom-clear visible-xs'>ptr<'clearfix'>p",
        "sPaginationType": "bootstrap",
        "serverSide": true,
        "iDisplayLength": 50,
        "order": [
            [1, "desc"]
        ],
        "responsive": true,
        "lengthMenu": [
            [20, 50, 100],
            [20, 50, 100]
        ],
        "drawCallback": function(settings) 
        {
            var api = this.api();
            var totalrows = api.rows({
                page: 'current'
            }).data().context[0]._iRecordsTotal;
            $("#total_records").html('(' + totalrows + ')');
        },
        "columns": 
        [
            {
                "width": 50,
                "orderable": false
            },
            {
                "name":"topic",
                "orderable": true
            },
            {
                "width": "10%",
                "orderable": false
            }
        ],
        "ajax": 
        {
            <?PHP
            $tableUrl="/checklists/listrecords/";
            ?>
            url: '<?PHP echo $tableUrl; ?>',
            type: 'POST',
            data: function(d)
            {
                d.search_text = search_text;
                d.search_col = search_col;
                d.wild = wild;
            },
            error: function (xhr, error, thrown) 
            {
                if(xhr.responseText=='login')
                {
                    window.location="<?PHP echo base_url; ?>"
                }
                else if(xhr.responseText==404 || xhr.responseText=='404' || xhr.responseText=='0')
                {
                   showNotification('ruby',"Invalid request");
                }
                $(".dataTables_processing").hide();
                return false;
            },
            dataSrc:function(res)
            {
                if(res.data.length==0 && res.recordsTotal!=0)
                {
                    oTable.fnDraw();
                }
                return res.data;
            }
        },
        "fnRowCallback": function(nRow, aData, iDisplayIndex, iDisplayIndexFull) 
        {
            var vis = true;
            var ii = 0;
            var sno = 0;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "S. No.");
                ii++;
            }
            sno++;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "Topic");
                ii++;
            }
            sno++;
            if (this.api().column(sno).visible()) {
                $('td:eq(' + ii + ')', nRow).attr('data-title', "Actions");
                ii++;
            }
        },
        "columnDefs":
        [
            {
                "render": function(data, type, row) 
                {
                    return row.sno;
                },
                "targets": 0
            }, {
                "render": function(data, type, row) 
                {
                    var str='';
                    var str='<a href="/checklists/view/'+row.id+'" target="_blank">'+row.topic+'</a>';
                    return str;
                },
                "targets": 1
            },
            {
                "render": function(data, type, row) 
                {
                    var str ='<a href="/checklists/view/' + row.id + '" target="_blank" class="btn btn-xs blue"><i class="fa fa-eye"></i> View</a>';

                    return str;
                },
                "targets": 2
            }
        ]
    });
    
});
</script>