<link href="<?PHP echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name;; ?>/global/plugins/datatables_1_10_5/media/css/dataTables.bootstrap.css" rel="stylesheet" type="text/css"/> 
<!-- BEGIN PAGE HEADER--> 
<!-- BEGIN PAGE TITLE & BREADCRUMB-->
<?PHP
$tempTitle="Add Category";
if($id)
	$tempTitle=stripslashes($categoryData->category);
?>
<input class="current-browser-title" data-title=" Admin Dashboard | Categories | <?PHP echo $tempTitle; ?>" type="hidden">
<?PHP $this->load->view("categories/admin/nav_buttons"); ?>
<h3 class="page-title">
    <?PHP echo $tempTitle; ?>
</h3>
<div class="page-bar">
    <ul class="page-breadcrumb">
        <li>
            <i class="fa fa-home"></i>
            <a href="<?PHP echo base_url; ?>admin">Dashboard</a>
            <i class="fa fa-angle-right"></i>
        </li>
        <li>
            <a href="/categoriesadmin">All Categories</a>
            <i class="fa fa-angle-right"></i>
        </li>
        <li>
            <?PHP echo $tempTitle; ?>
        </li>
	</ul>
</div>
<!-- END PAGE TITLE & BREADCRUMB-->
<!-- END PAGE HEADER-->
<?PHP
if($this->session->flashdata('category_saved'))
{
	?>
    <div class="alert alert-success">
        <button class="close" data-dismiss="alert"></button>
        <strong>Changes saved successfully.</strong>
    </div>
    <?PHP
}
if($this->session->flashdata('category_created'))
{
	?>
    <div class="alert alert-success">
        <button class="close" data-dismiss="alert"></button>
        <strong>Category created successfully.</strong>
    </div>
    <?PHP
}

?>
<style>
@media (max-width: 1010px) 
{
	.controls
	{
		margin-left:auto !important;
	}
}
.form-control::-ms-clear {
 display:none;
 width : 0;
  height: 0;
 }

</style>
<div class="row-fluid">
    <div class="portlet box blue">
        <div class="portlet-title">
            <div class="caption"> <i class="fa fa-list"></i> <?PHP echo $tempTitle; ?> <span id="total_records"></span></div>
            <div class="tools">
                <a href="javascript:;" class="collapse"></a>
            </div>
        </div>
        
        <div class="portlet-body no-more-tables">
            <form name="editcat" id="editcat" method="post" action="" class="editcat">
          
                <div class="form-body">
                    <?PHP
                    if(in_array(global_site_flag, [2,4]))
                    {
                        ?>
                        <input type="hidden" name="ashram_id" id="ashram_id" value="<?php echo default_ashram_id; ?>">
                        <?PHP
                    }
                    else
                    {
                        ?>
                        <div class="form-group">
                            <label class="control-label">Ashram Name
                            </label>
                            <div class="form-content">
                                <?PHP
                                if(($this->currentUser->roles==1 || $this->currentUser->roles==7) && $id==0)
                                {
                                    ?>
                                    <select name="ashram_id" id="ashram_id" onChange="switchAshram(this.value)" class="form-control">
                                        <option value="">Select Ashram</option>
                                        <?PHP
                                        foreach ($ashrams as $ashramData)
                                        {
                                            ?>
                                            <option value="<?PHP echo $ashramData->id; ?>"
                                            <?PHP
                                            if($this->session->userdata("ashramId")==$ashramData->id)
                                                echo " selected";
                                            ?>
                                            >
                                                <?PHP echo $ashramData->name; ?>
                                            </option>
                                            <?PHP
                                        }
                                        ?>
                                    </select>
                                    <script>
                                        function switchAshram(ashram_id)
                                        {
                                            $.post("/ashramadmin/switchashram/"+ashram_id,{},function(res)
                                            {
                                                window.location.reload();
                                            });
                                        }
                                    </script>
                                    <?PHP
                                }
                                else
                                {
                                    $ashramName = isset($ashramData->name)?$ashramData->name:"N/A";
                                    echo htmlentities($ashramName);
                                }
                                ?>
                            </div>
                        </div>
                        <?PHP
                    }
                    ?>               
                    <div class="form-group">
                        <label class="control-label">Category Name</label>
                        <div class="form-content">
                            <input name="category" id="category" type="text" 
                            value="<?PHP
                                if(isset($_POST['category'])) echo htmlentities($_POST['category']);
                                else if($id) echo htmlentities($categoryData->category); ?>"   class="form-control">
                        </div>
                        <p class="description">The name is how it appears on your site.</p>
                    </div>
                
                    <?PHP
                    if($id)
                    {
                        ?>
                        <div class="form-group">
                            <label class="control-label">Category Slug</label>
                            <div class="form-content">
                                <input name="slug" id="slug" type="text"  disabled
                                value="<?PHP if(isset($_POST['slug'])) echo $_POST['slug'];
                                else if($id) echo $categoryData->slug; ?>" class="form-control" />
                            </div>
                            <p class="description">The "slug" is the URL-friendly version of the name. It is usually all 
                            lowercase and contains only letters, numbers, and hyphens.</p>
                        </div>
                        <?PHP
                    }
                    ?>
                             
                    <div class="form-group">
                        <label class="control-label">Parent</label>
                        <div class="form-content">
                            <input type="hidden" name="id" value="<?PHP echo $id; ?>" />
                            <select name="parent" id="parent" class="form-control">
                                <option value="0">None</option>
                                <?PHP
                                $this->categories_model->buildCategoryDropdown(0,1,$id);
                                ?>
                            </select>
                            <script type="text/javascript">
                              var elmnt=document.getElementById("parent")
                              var val="<?PHP if($id) echo $categoryData->parent; ?>"
                              for(var i=0; i < elmnt.options.length; i++)
                              {
                                if(elmnt.options[i].value == val)
                                  elmnt.selectedIndex=i;
                              }
                            </script>
                        <p class="description">Categories, unlike tags, can have a hierarchy. 
                        You might have a Jazz category, and under that have children categories for Bebop and Big Band. Totally optional.</p>
                        </div>
                    </div>
                                                      
                    <div class="form-group">
                        <label class="control-label">Category Description</label>
                        <div class="form-content">
                            <textarea name="description" id="description" rows="5" cols="50" class="form-control"
                                ><?PHP if(isset($_POST['description'])) echo $_POST['description'];
                                else if($id) echo $categoryData->description; ?></textarea>
                            <p class="description">The description is not prominent by default; however, some themes may show it.</p>
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="control-label"></label>
                        <div class="form-content">
                            <button type="submit" name="add_category" id="submit" class="btn btn-xs blue"> 
                            <i class="fa fa-check"></i> <?PHP if($id) echo "Save"; else echo "Add Category"; ?></button>
                            <a href="/categoriesadmin" class="btn btn-xs red"> <i class="fa fa-ban"></i> Cancel</a>
                        </div>
                    </div>
                    
                </div>

            </form>
        </div>
    </div>
</div>

<script src="<?PHP echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name;; ?>/global/plugins/datatables_1_10_5/media/js/jquery.dataTables.js" type="text/javascript"></script>
<script src="<?PHP echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name;; ?>/global/plugins/datatables_1_10_5/media/js/dataTables_custom.js" type="text/javascript"></script>
<script type="text/javascript">

$(document).ready(function() 
{
	jQuery.validator.addMethod("catcheck", function(value, element) 
	{ 
	
		$.ajaxSetup({async: false});
		$('#category').addClass("spinner");
		var rr=true;
		var rt=$.post('/categoriesadmin/category_exists/<?PHP echo $id; ?>', {name: value}, function(res) 
		{
			 if(res==0)
			 {
			 	$.validator.messages.catcheck = 'Category already exists';
				 rr=false;
			 }
			 else if(res==2)
			 {
			 	$.validator.messages.catcheck = 'Please try different Category Name';
			 	rr=false;
			 }
			
		});
		$('#category').removeClass("spinner");
		return rr;

	}, "Category already exists");
	
	
	$('.editcat').validate(
    {
        errorElement: 'label', //default input error message container
        errorClass: 'help-inline', // default input error message class
        focusInvalid: true, // do not focus the last invalid input
		onkeyup: false,
        rules: {
            ashram_id:{
                required: true
            },
            category: {
                required: true,
				minlength:3,
				maxlength:100,
				name_validate11:true,
				catcheck:true
            },
			description:
			{
				maxlength:500
			}
        },

        messages: {
            ashram_id:
            {
                required: "Please select Ashram"
            },
            category:
            {
                required: "Please enter Category name"
            }
        },
    	highlight: function (element)
        {
            $(element).closest('.form-group').removeClass("has-success").addClass('has-error');
        },
        success: function (label, element)
        {
			label.remove();
        },
        errorPlacement: function (error, element) 
        {
    		error.addClass('help-small no-left-padding').insertAfter(element);
        }
    });
    
});
</script>
