<link href="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/datatables_1_10_5/media/css/dataTables.bootstrap.css" rel="stylesheet" type="text/css"/>
<input class="current-browser-title" data-title=" Admin Dashboard | Calendar | All Calendar Events" type="hidden">
<style type="text/css">
    @media only screen and (min-width: 992px) and (max-width: 1450px){
        .buttons{
            padding: 29px 0px 6px 0px;
        }
    }
</style>
<!-- BEGIN PAGE TITLE & BREADCRUMB-->
<?PHP
    $this->load->view("calendar/admin/nav_buttons");
?>
<h3 class="page-title">
    All Calendar Events
</h3>
<div class="page-bar">
    <ul class="page-breadcrumb">
        <li>
            <i class="fa fa-home"></i>
            <a href="/admin">Dashboard</a>
            <i class="fa fa-angle-right"></i>
        </li>
        <li>All Calendar Events</li>
    </ul>
</div>
<!-- END PAGE TITLE & BREADCRUMB-->

<div class="row-fluid">
    <div class="alert alert-info">
        <strong>Calendar public URL:</strong>
        <a href="<?php echo base_url. "calendar"; ?>" target="_blank">
        <?php echo base_url . "calendar"; ?></a>
    </div>
    
    <form action="" method="get" name="" style="margin:0px;" onsubmit="return false"
        class="form-horizontal row search_form">
        
        <div class="col-md-2">
            <select name="type" id="type" onChange="search(1)" class="form-control input-inline custom-input">
                <option value="">All Calendar Types</option>
                <option value="1">Swamiji Calendar</option>
                <option value="2">Bala Swamiji Calendar</option>
                <option value="3"><?PHP echo site_short_name; ?> Calendar</option>
            </select>
        </div>
        <br style="clear:both;" class="hidden-sm hidden-xs">
        
        <div class="col-md-2">
            <input type="text" name="search_text" id="search_text" placeholder="Type keyword to search..."
            class="input-inline form-control custom-input" />
        </div>
        <div class="col-md-2">
            <select name="search_col" id="search_col" class=" input-inline form-control custom-input">
                <option value="event_name">Calendar Event</option>
            </select>
        </div>
        <div class="col-md-2" style="display:none">
            <select name="wild" id="wild" class="input-inline form-control custom-input">
                <option value="contains">Contains</option>
                <option value="starts">Starts with</option>
                <option value="ends">Ends with</option>
            </select>
        </div>
        <div class="col-md-2">
            
            <input type="text" class="datepickerclass form-control input-inline custom-input"  name="from_date" id="from_date"
            placeholder="From date"/>
        </div>
        <div class="col-md-2">
            <input type="text" class="datepickerclass form-control input-inline custom-input"  name="to_date" id="to_date"
            placeholder="To date" />
        </div>
        <div class="buttons">
            <button type="button" id="searchButton" class="btn btn-xs blue searchButton"
            onClick="search(0)"><i class="fa fa-search"></i> Search</button>
            <a class="btn btn-xs red" id="searchClear" onClick="search_clear()"
            style="display:none;"><i class="fa fa-search-minus"></i> Clear</a>
            <button type="button" id="excelButton" class="btn btn-xs green excelButton" ><i class="fa fa-file-excel-o"></i> Report</button>
        </div>
    </form>
    <br class="hidden-lg hidden-md">
    
    <div class="portlet box blue">
        <div class="portlet-title">
            <div class="caption"> <i class="fa fa-list"></i> All Calendar Events <span id="total_records"></span></div>
            <div class="tools">
                <a href="javascript:;" class="collapse"></a>
            </div>
        </div>
        
        <div class="portlet-body no-more-tables">
        
                <table id="calendartable" class="display table-bordered table-condensed table table-striped table-hover" cellspacing="0" width="100%" >
                    <thead>
                        <tr>
                            <th>S. No.</th>
                            <th>Calendar ID</th>
                            <th>Calendar Event</th>
                            <th>Calendar Type</th>
                            <th>Notification</th>
                            <th>Start Date</th>
                            <th>End Date</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    
                </table>
            <div style="clear:both;"></div>
        </div>
    </div>
</div>
<script src="<?php
echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/datatables_1_10_5/media/js/jquery.dataTables.js" type="text/javascript"></script>
<script src="<?php
echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/datatables_1_10_5/media/js/dataTables_custom.js" type="text/javascript"></script>
<script type = "text/javascript">
        var type = '';
        var from_date = '';
        var to_date = '';
        var search_text = '';
        var search_col = '';
        var wild = '';
        var table = '';

        function applyFilter(ele) 
        {
            table.fnDraw();
        }

        function search(flag) 
        {
            clearNotifications();
             if(!$("#from_date").length || !$("#to_date").length || !$("#search_text").length || !$("#search_col").length ||
                !$("#wild").length)
            {
                showNotification("ruby","Something went wrong!!! Please refresh page and try again.");
                return;
            }
            if (flag == 0)
            {  
                if ($("#from_date").length && $("#to_date").length && $("#search_text").length && 
                    $("#from_date").val().trim() == '' && $("#to_date").val().trim() == '' && $("#search_text").val().trim() == '') 
                {
                    showNotification('ruby','Please enter search keywords or select dates');
                    return false;
                }
                if($("#from_date").length && $("#to_date").length && $('#from_date').val().trim()!='' && $('#to_date').val().trim()!='')
                {
                    var frm=Date.parse($("#from_date").val());
                    var to=Date.parse($("#to_date").val());
                    if(frm>to)
                    {
                        showNotification('ruby','From date cannot be after To date');
                        return false
                    }
                }
            }
            $(".dataTables_processing").show();
            if($("#from_date").length)
                from_date = $("#from_date").val().trim();
            if($("#to_date").length)
                to_date = $("#to_date").val().trim();
            if($("#search_text").length)
                search_text = $("#search_text").val().trim();
            if($("#search_col").length)
                search_col = $("#search_col").val().trim();
            if($("#wild").length)
                wild = $("#wild").val().trim();
            if($("#type").length)
                type = $("#type").val();

            if (from_date != '' || to_date != '' || search_text != '')
                $("#searchClear").css("display", "inline-block");
            
            table.fnDraw();

        }

        function search_clear() 
        {
            $(".dataTables_processing").show();
            $("#from_date").val('');
            from_date = '';
            $("#to_date").val('');
            to_date = '';
            $("#search_text").val('');
            search_text = '';
            search_col = '';
            wild = '';
            $("#searchClear").css("display", "none");
            type='';
            $("#type").val('');
            table.fnDraw();
        }

        var statusflag=0;
        function deleteEvent(id)
        {
            if(statusflag==1)
                return false;
            statusflag=1;
            $(".dataTables_processing").show();
            $.post('/calendaradmin/delete/' + id , {}, function(res) 
            {
                if(res=='login')
                {
                    window.location="<?PHP echo base_url; ?>"
                }
                if(res=='access_denied')
                {
                    showNotification('ruby',"Access Denied");
                    $(".dataTables_processing").hide();
                    $("#cal" + id).modal('toggle');
                    statusflag=0;
                    return;
                }
                var r = $.parseJSON(res);
                $(".dataTables_processing").hide();
                if (r.flag == 1) 
                {
                    table.fnSettings.bResetDisplay  =false;
                    table.fnDraw(table.fnSettings);
                    showNotification('ruby', "Calendar Event '" + r.event_name + "' has been deleted successfully ");
                }
                else
                {
                    showNotification("ruby", "Error occured. Please try again.");
                }
                $("#cal" + id).modal('toggle');
                statusflag=0;
            });
        }
        $(document).ready(function()
        {
            $("#search_text").val('');
            $("#from_date").val('');
            $("#to_date").val('');
            $("#type").val($("#type option:first").val());
            $("#wild").val($("#wild option:first").val());
            $("#search_col").val($("#search_col option:first").val());

            table = $('#calendartable').dataTable({
                "processing": true,
                "language": {
                    "sProcessing": '<div class="spinnerspin"></div>',
                    "emptyTable": "No records found!"
                },
                "sDom": "l<'custom-clear visible-xs'>ptr<'clearfix'>p",
                "sPaginationType": "bootstrap",
                "serverSide": true,
                "iDisplayLength": 50,
                "order": [
                    [5, "desc"]
                ],
                "responsive": true,
                "lengthMenu": [
                    [20, 50, 100],
                    [20, 50, 100]
                ],
                "drawCallback": function(settings) 
                {
                    var api = this.api();
                    var totalrows = api.rows({
                        page: 'current'
                    }).data().context[0]._iRecordsTotal;
                    $("#total_records").html('(' + totalrows + ')');
                    $('.tooltips').tooltip();
                },
                "columns": [
                {
                    "width": "7%",
                    "orderable": false
                }, {
                    name: "id",
                    "width": "9%",
                    "orderable": false
                }, {
                    name: "event_name",
                    "orderable": true
                }, {
                    "width": "15%",
                    "orderable": false
                },
                {
                    "width": "10%",
                    "orderable": false
                }, {
                    name: "start_date",
                    "width": "12%",
                    "orderable": true
                }, {
                    name: "end_date",
                    "width": "12%",
                    "orderable": true
                }, {
                    width: "7%",
                    "orderable": false
                }],
                "ajax": {
                    url: '/calendaradmin/listc',
                    type: 'POST',
                    data: function(d) 
                    {
                        if (from_date != '')
                            d.from_date = from_date;
                        if (to_date != '')
                            d.to_date = to_date;
                        if (search_text != '')
                            d.search_text = search_text;
                        d.search_col = search_col;
                        d.type = type;
                        d.wild = wild;
                    },
                    error: function (xhr, error, thrown) 
                    {
                        if(xhr.responseText=='login')
                        {
                            window.location="<?PHP echo base_url; ?>"
                        }
                        else if(xhr.responseText==404 || xhr.responseText=='404' || xhr.responseText=='0')
                        {
                           showNotification('ruby',"Invalid request");
                        }
                        $(".dataTables_processing").hide();
                        return false;
                    },
                    dataSrc:function(res)
                    {
                        if(res.data.length==0 && res.recordsTotal!=0)
                        {
                            table.fnDraw();
                        }

                        return res.data;
                    }
                },
                "fnRowCallback": function(nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                    var vis = true;
                    var ii = 0;
                    var sno = 0;
                    if (this.api().column(sno).visible()) {
                        $('td:eq(' + ii + ')', nRow).attr('data-title', "S. No.");
                        ii++;
                    }
                    sno++;
                    if (this.api().column(sno).visible()) {
                        $('td:eq(' + ii + ')', nRow).attr('data-title', "Calendar ID");
                        ii++;
                    }
                    sno++;
                    if (this.api().column(sno).visible()) {
                        $('td:eq(' + ii + ')', nRow).attr('data-title', "Calendar Event");
                        ii++;
                    }
                    sno++;
                    if (this.api().column(sno).visible()) {
                        $('td:eq(' + ii + ')', nRow).attr('data-title', "Calendar Type");
                        ii++;
                    }
                    sno++;
                    if (this.api().column(sno).visible()) {
                        $('td:eq(' + ii + ')', nRow).attr('data-title', "Start Date");
                        ii++;
                    }
                    sno++;
                    if (this.api().column(sno).visible()) {
                        $('td:eq(' + ii + ')', nRow).attr('data-title', "End Date");
                        ii++;
                    }
                    sno++;
                    if (this.api().column(sno).visible())
                        $('td:eq(' + ii + ')', nRow).attr('data-title', "Actions");
                    return nRow;
                },
                "columnDefs": [
                {
                    "render": function(data, type, row) {
                        return row.sno;
                    },
                    "targets": 0
                }, {
                    "render": function(data, type, row) 
                    {
                        var str = "<b>"+row.id + '</b>';
                        return str;
                    },
                    "targets": 1
                }, {
                    "render": function(data, type, row) 
                    {
                        var str = '';
                        str += "<a href='/calendaradmin/add_edit_calendar/" + row.id + "' target='_blank'>"+row.event_name + '</a>';
                        return str;
                    },
                    "targets": 2
                }, {
                    "render": function(data, type, row) 
                    {
                        var first=0;
                        var str='';
                        if(row.swamiji==1)
                        {
                            str+='<span class="label label-danger margin-bottom-10" style="background-color:orangered;">Swamiji Calendar</span>';
                            first=1;
                        }
                        if(row.balaswamiji==1)
                        {
                            if(first==1)
                                str+='<div style="height:10px; clear:both;"></div>';
                            first=1;
                            str+='<span class="label label-success">Bala Swamiji Calendar</span>';
                        }
                        if(row.dattapeetham==1)
                        {
                            if(first==1)
                                str+='<div style="height:10px; clear:both;"></div>';
                            str+='<span class="label label-info custom-clear"><?PHP echo site_short_name; ?> Calendar</span>';
                        }
                        return str;
                    },
                    "targets": 3
                },{
                    "render": function(data, type, row) {
                        var str = "";
                        if(row.notification_id == 0){
                            str = "<p style='color:gray'><i class='fa fa-bell'></i></p>";
                        }
                        if(row.notification_id > 0){
                            //str = "<a style='color:black' onclick='sendNotificationConfirmation(row.id)'><i class='fa fa-bell'></i></a>";
                            str = '<div class="btn-group" id="notification-actions' + row.notification_id + '">';
                        
                            str += '<span id="bell_icon_'+row.notification_id+'"><a href="#notification' + row.notification_id + '" role="button" data-toggle="modal">' +
                            '<i class="fa fa-bell"></i></a></span>' +

                            '<div id="notification' + row.notification_id + '" class="modal fade" tabindex="-1"> \
                                <div class="modal-header"> \
                                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button> \
                                    <h4 class="modal-title">Notification Confirmation</h4> \
                                </div> \
                                <div class="modal-body"> \
                                    <div class="pull-left delete-confirmation-icon"> \
                                    </div> \
                                    Do you really want to send the notification: \
                                </div> \
                                <div class="modal-footer"> \
                                    <button type="button" data-dismiss="modal" class="btn btn-xs close' + row.notification_id + '"> \
                                        <i class="fa fa-remove"></i> Cancel \
                                    </button> \
                                    <a class="btn btn-xs red send-notification-button" data-id="'+row.notification_id+'"> \
                                        <i class="fa fa-bell"></i> Send \
                                    </a> \
                                </div> \
                            </div>';
                        
                        str+='</div>';
                        }
                    return str;
                    },
                    "targets": 4
                }, {
                    "render": function(data, type, row) {
                        return row.start_date;
                    },
                    "targets": 5
                }, {
                    "render": function(data, type, row) {
                        return row.end_date;
                    },
                    "targets": 6
                }, {
                    "render": function(data, type, row) 
                    {
                        var str = '<div class="btn-group" id="actions' + row.id + '">' +
                            '<a class="btn red btn-xs" href="#" data-toggle="dropdown"> Actions ' +
                            '<i class="fa fa-angle-down"></i></a>' +
                            '<ul class="dropdown-menu pull-right" style="text-align:left;">' +
                            '<li><a href="/calendaradmin/add_edit_calendar/' + row.id + '" target="_blank"><i class="fa fa-eye"></i> Edit</a></li>';

                        str += '<li><a href="#cal' + row.id + '" role="button" data-toggle="modal">' +
                            '<i class="fa fa-trash-o"></i> Delete</a></li>' +

                            '<div id="cal' + row.id + '" class="modal fade" tabindex="-1">' +
                            '<div class="modal-header">' +
                            '<button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>' +
                            '<h4 class="modal-title">Delete Confirmation</h4>' +
                            '</div>' +
                            '<div class="modal-body"><div class="pull-left delete-confirmation-icon"' +
                            '><i class="fa fa-exclamation-triangle"></i></div>' +
                            'Do you really want to delete the Calendar Event: ' +
                            '<span style="color:red; font-weight:bold;">' + row.event_name + '</span>?' +
                            '</div>' +
                            '<div class="modal-footer">' +
                            '<button type="button" data-dismiss="modal" class="btn btn-xs close' + row.id + '">' +
                            '<i class="fa fa-remove"></i> Cancel</button>' +
                            '<a onClick="deleteEvent(' + row.id + ')" class="btn btn-xs red">' +
                            '<i class="fa fa-trash"></i> Delete</a>' +
                            '</div>' +
                            '</div>';

                        return str;
                    },
                    "targets": 7
                }]
            });
            $('.columnhide').on('click', function(e) 
            {
                var column = table.api().column( $(this).attr('data-column') );
                var cnum=$(this).attr('data-column');
                
                column.visible( ! column.visible(),true );
                var bVis = table.fnSettings().aoColumns[cnum].bVisible;
                var title = table.fnSettings().aoColumns[cnum].sTitle;
                
                var visibility=table.api().column(cnum).visible();
                table.api().column(cnum).nodes().to$().attr("data-title",title);
                if (visibility == false) 
                {
                    $(this).removeClass('blue').addClass('red');
                }
                else 
                {
                    $(this).removeClass('red').addClass('blue');
                }
            });
        });
$("#excelButton").on("click",function()
{
    $(".loader_animation").show();
    clearNotifications();
    var sortindex=table.fnSettings().aaSorting[0][0];
    var order_by=table.fnSettings().aoColumns[sortindex].name;
    var dir=table.fnSettings().aaSorting[0][1];
    $.post('/calendaradmin/listc/1',
    {
        from_date:from_date,to_date:to_date,search_text:search_text,wild:wild,search_col:search_col,
        type:type,order_by:order_by,dir:dir
    },
        function(res)
        {
            var r=$.parseJSON(res);
            if(r.flag==1)
            {
                window.location='<?PHP echo base_url; ?>excelreports/download/'+r.report_id;
            }
            if(r.flag==2)
            {
                showNotification("ruby","Sorry! You have already requested the same report.");
            }
            if(r.flag==0)
            {
                showNotification("ruby","Sorry! Report cannot be generated. Data is empty.");
            }
            $(".loader_animation").hide();
        }
    );
});
    //sending notification confirmation
    $(".send-notification-button").live("click",function()
{
    var notification_id = $(this).attr("data-id");
    $(".dataTables_processing").show();
    $.post('/sendmobilenotifications/sendNotifications/'+ notification_id, {}, function(res) 
    {
    var r = $.parseJSON(res);
    $("#notification"+notification_id).modal("toggle");
    $(".dataTables_processing").hide();
    if (r == 1) {
        showNotification('lime', "Sent Successfully");
        table.fnDraw();
    }
    if (r == 2) {
        showNotification('ruby', "Invlid notification id");
    }
    if (r == 3) {
        showNotification('ruby', "No Devices to send");
    }
    if (r == 4) {
        showNotification('ruby', "Notification not sent");
    }
    });
});
</script>