<?PHP
$partHeader="SGS Posts - AppJi contributions";
?>
<input class="current-browser-title" data-title="<?PHP echo $partHeader; ?>" type="hidden">
<div class="page-content">
    <!-- BEGIN PAGE HEADER-->
    <h3 class="page-title">
        <div class="left-block">
            <i class="icomoon-moneybag"></i>
            <span class="top-line">
                <?PHP echo $partHeader; ?>
            </span>
        </div>
    </h3>
    <div class="clearfix"></div>
    <div class="page-bar">
        <ul class="page-breadcrumb">
            <li>
                <a href="/">Home</a>
                <i class="fa fa-angle-right"></i>
            </li>
            <li class="active">
                <?PHP echo $partHeader; ?>
            </li>
        </ul>
    </div>
    <!-- END PAGE HEADER-->
    <?PHP
    if($GLOBALS['site_settings']['enable_orders']==0)
    {
        ?>
        <div class="alert alert-danger" id="CartLockError">
            <button class="close" data-dismiss="alert"></button>
            <i class="fa fa-exclamation-triangle" style="color:red;"></i>
            <strong>Website is under maintenance, please try after some time.</strong>
        </div>
        <?PHP
    }
    ?>

    <h3 class="shop-heading page-title">
        <span style="margin-right: 20px; min-width: 120px; display: inline-block;">
            SGS Posts - AppJi contributions <span id="subscription_count"></span>
        </span>
    </h3>
    <?PHP
    if(isset($showErrorMessage) && $showErrorMessage!='')
    {
        ?>
        <div class="row">
            <div class="col-md-12" style="margin-top: 10px;">
                <div class="alert alert-danger" id="CartLockError">
                    <?PHP echo $showErrorMessage; ?>
                </div>
            </div>
        </div>
        <?PHP
    }
    ?>
    <div id="alert-box">
    </div>
    
    <div class="margin-bottom-10 clearfix"></div>
    <div class="shop-form row">
    </div>
    <div class="cart-block stickycart" id="cart_content">
        
    </div>
    <?PHP
    if($this->session->userdata("loggedIn"))
    {
        if($this->currentUser->admin==1)
        {
            $this->load->view("users/admin/_user_lookup_public");
        }
    }
    ?>
    <div class="row nomarginrow">
        <div class="col-md-12 pagination-holder" align="right">
        </div>
        <div class="col-md-9 list_section items_list subscriptions_items">

        </div>
        <div class="col-md-3 listcartright">

        </div>
        <div class="col-md-12 pagination-holder" align="right">
        </div>
    </div>
    <div class="clearfix">
    </div>

    <div id="clearCartModal" class="modal fade">
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-hidden="true" style="color: #fff;"></button>
            <h4 class="modal-title" style="color: #fff;">Clear Cart Confirmation</h4>
        </div>
        <div class="modal-body" style="min-height: 60px;">
            <div class="pull-left delete-confirmation-icon" style="margin-top: 0;"><i class="fa fa-exclamation-triangle"></i></div>
            Do you really want to clear Cart?
        </div>
        <div class="modal-footer">
            <button type="button" data-dismiss="modal" class="btn btn-xs close23">
                <i class="fa fa-remove"></i> Cancel
            </button>
            <a onclick="clearCart();" class="btn btn-xs red"> <i class="fa fa-trash"></i> Clear Cart</a>
        </div>
    </div>
</div>

<script type="text/javascript">
function clearCart(key)
{
    $("#clearCartModal").modal('hide');
    $("#alert-box").html('');
    $(".loader_animation").show();
    $.post('/subscriptions/clearCart',{}, function(res)
    {
        try
        {
            var r=$.parseJSON(res);
        }
        catch(err)
        {
            $(".loader_animation").hide();
            showNotification('ruby',"Something wrong, please refresh the page and try again.");
            return false;
        }

        if(r.flag==0)
        {
            $(".loader_animation").hide();
            showNotification("ruby","Invalid request");
        }
        else if(r.flag==1)
        {
            $(".loader_animation").hide();
            clearNotifications();
            showNotification("ruby","Cart has been emptied");
        }
        else if(r.flag==2)
        {
            $(".loader_animation").hide();
            showNotification("ruby","Item does not exist in cart");
        }
        else if(r.flag==11)
        {
            $(".loader_animation").hide();
            $("#CartLockError").hide();
            $("#alert-box").html('\
                <div class="alert alert-danger">\
                    <button class="close" data-dismiss="alert"></button>\
                    <span style="font-size:20px;">\
                        Sorry! A transaction initiated by you, is already in progress.<br>\
                        If you want to cancel previous transaction, please \
                        <a href="javascript:;" class="btn btn-danger btn-sm" onClick="cancelPrevTransaction()">Click Here</a>\
                    </span>\
                </div>');
            Metronic.scrollTo($('.page-title'));
            return false;
        }
        location.reload();
    });
}

function cancelPrevTransaction()
{
    $("#alert-box").html('');
    $(".loader_animation").show();
    $.post('/subscriptions/cancelprevious/',{}, function(res)
    {
        try
        {
            var r=$.parseJSON(res);
        }
        catch(err)
        {
            $(".loader_animation").hide();
            showNotification('ruby',"Something wrong, please refresh the page and try again.");
            return false;
        }
        if(r.flag==1)
        {
            $("#alert-box").html('\
                <div class="alert alert-success">\
                    <button class="close" data-dismiss="alert"></button>\
                    <strong>Your previous transaction has been discarded. Requested item is being added to cart...</strong>\
                </div>');
            Metronic.scrollTo($('.page-title'));
        }
        else
        {
            showNotification('ruby',"Invalid request");
        }
        $(".loader_animation").hide();
        location.reload();
    });
}
</script>


