<?PHP
$partHeader='Add Edit Satsang Email Settings';
?>
<input class="current-browser-title" data-title=" Admin Dashboard  | Website Admin | <?PHP echo $partHeader; ?>" type="hidden">
<h3 class="page-title">
    <?PHP
        echo $partHeader;
    ?>
</h3>
<div class="page-bar">
    <ul class="page-breadcrumb">
        <li>
            <i class="fa fa-home"></i>
            <a href="/admin">Dashboard</a>
            <i class="fa fa-angle-right"></i>
        </li>
        <li>
            <a href="/website_settings/email_settings/satsangs">Email Settings</a>
            <i class="fa fa-angle-right"></i>
        </li>
        <li><?PHP echo $partHeader; ?></li>
    </ul>
</div>
<?PHP
if($this->session->flashdata("satsang_email_setting_error"))
{
    ?>
    <div class="alert alert-danger">
        <button class="close" data-dismiss="alert"></button>
        <strong>Error saving changes, please try again.</strong>
    </div>
    <?PHP
}
if($this->session->flashdata("satsang_email_setting_created"))
{
    ?>
    <div class="alert alert-success">
        <button class="close" data-dismiss="alert"></button>
        <strong>Email Setting created successfully.</strong>
    </div>
    <?PHP
}

if($this->session->flashdata("satsang_email_setting_saved"))
{
    ?>
    <div class="alert alert-success">
        <button class="close" data-dismiss="alert"></button>
        <strong>Email Setting saved successfully.</strong>
    </div>
    <?PHP
}
?>

<div class="row-fluid">
	<div class="alert alert-warning">
	    <strong>
	        <span style="color:red;">Report Emails in Email settings should be in below format<br></span>
	        <span style="color:green;">eg: abc@test.com,def@gmail.com</span>
	    </strong>
	</div>
    <div class="portlet box blue">
        <div class="portlet-title">
            <div class="caption">
                Add Edit Satsang Email Setting
            </div>
            <div class="tools">
                <a href="javascript:;" class="collapse"></a>
            </div>
            
        </div>
        
        <div class="portlet-body">
			<form action="" id="save_email_setting_form" name="save_email_setting_form" method="post" enctype="multipart/form-data">
				<div class="row">
					<?PHP
					if($id)
					{
						?>
						<div class="col-md-12">
							<div class="col-md-12">
					            <div class="form-group">
					                <label class="control-label">
					                	Satsang Name:
					                </label>
					                <?PHP if(isset($emailSettingsData->ashram_name) && $emailSettingsData->ashram_name!=''){ echo $emailSettingsData->ashram_name; } ?>
					            </div>
					            <div class="form-group">
					                <label class="control-label">
					                	Service Slug: 
					                </label>
					                <?PHP if(isset($emailSettingsData->service_slug) && $emailSettingsData->service_slug!=''){ echo $emailSettingsData->service_slug; } ?>
					            </div>
					        </div>
					    </div>
						<?PHP
					}
					else
					{
						?>
						<div class="col-md-6">
							<div class="col-md-12">
								<div class="form-group">
					                <label class="control-label">Satsang
					                </label>
					                <div class="form-content">
										<select name="email_setting_satsang_id" id="email_setting_satsang_id" class="form-control">
											<option value="">Select Satsang</option>
											<?PHP
											foreach ($satsangs as $this_satsang)
											{
												?>
												<option value="<?PHP echo $this_satsang->id; ?>">
													<?PHP echo $this_satsang->name; ?>
												</option>
												<?PHP
											}
											?>
											<option value="0">General Satsang</option>
										</select>
									</div>
								</div>
							</div>
						</div>
						<div class="col-md-6">
					        <div class="col-md-12">
					            <div class="form-group">
					                <label class="control-label">Service Slug<span class="required">*</span>
					                </label>
					                <div class="form-content">
					                    <input class="form-control" type="text" name="email_setting_service_slug" id="email_setting_service_slug" value="">
					                </div>
					            </div>
					        </div>
					    </div>
				        <?PHP
				    }
				    ?>

			        <div class="col-md-6">
				        <div class="col-md-12">
				            <div class="form-group">
				                <label class="control-label">From Email<span class="required">*</span>
				                </label>
				                <div class="form-content">
				                    <input class="form-control" type="text" name="email_setting_from_email" id="email_setting_from_email" value="<?PHP if($id) echo htmlentities($emailSettingsData->from_email); ?>">
				                </div>
				            </div>
				        </div>

				         <div class="col-md-12">
				            <div class="form-group">
				                <label class="control-label">From Name<span class="required">*</span>
				                </label>
				                <div class="form-content">
				                    <input class="form-control" type="text" name="email_setting_from_name" id="email_setting_from_name" value="<?PHP if($id) echo htmlentities($emailSettingsData->from_name); ?>">
				                </div>
				            </div>
				        </div>

				        <div class="col-md-12">
				            <div class="form-group">
				                <label class="control-label">Report Emails
				                </label>
				                <div class="form-content">
				                    <input class="form-control" type="text" name="email_setting_report_emails" id="email_setting_report_emails" value="<?PHP if($id) echo htmlentities($emailSettingsData->report_emails); ?>">
				                </div>
				            </div>
				        </div>
				        
				    </div>

				    <div class="col-md-6">
				        <div class="col-md-12">
				            <div class="form-group">
				                <label class="control-label">Signature
				                </label>
				                <div class="form-content">
				                	<textarea class="form-control" name="email_setting_signature" id="email_setting_signature" rows="3">
				                		<?PHP if($id) echo $emailSettingsData->signature; ?>
				                	</textarea>
				                </div>
				            </div>
				        </div>
				    </div>

			    </div>

			    <br>
			    <div class="row">
			    	<div class="col-md-12">
				        <div class="col-md-12">
				            <div class="form-group">
				                <div class="form-content">
				                    <button name="save_email_setting_btn" class="btn btn-xs blue pull-right" type="submit" id="save_email_setting_btn">
				                        <i class="fa fa-check"></i>
				                        <?PHP
	                                        if($id) echo "Save";
	                                        else
	                                            echo "Create";
	                                    ?>
				                    </button>
				                    <a href="#" class="btn btn-xs red pull-right" style="margin-right: 10px;">
				                        <i class="fa fa-ban"></i> Cancel
				                    </a>
				                </div>
				            </div>
				        </div>
				    </div>
			    </div>
			</form>
		</div>
    </div>
</div>
<script type="text/javascript" src="<?PHP echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name;; ?>/global/plugins/ckeditor/ckeditor.js"></script>
<!-- The File Upload user interface plugin -->
<script type="text/javascript">
CKEDITOR.env.isCompatible = true;
CKEDITOR.replace( 'email_setting_signature',
{
    height:'150px',
    toolbar :
        [
    { name: 'indent', items : [ 'Bold','Italic','Underline'] }
        ]
});
$( document ).ready(function() {

	jQuery.validator.addMethod("multiEmailCheck", function(value, element)
	{
		if (this.optional(element)) // return true on optional element 
		 	return true;
		var emails = value.split(/[;,]+/); // split element by , and ;
		valid = true;
		for (var i in emails) {
		 	value = emails[i];
		 	valid = valid && jQuery.validator.methods.email.call(this, $.trim(value), element);
		}
		return valid;
 	},
    jQuery.validator.messages.email
	);

    $('#save_email_setting_form').validate(
        {
            errorElement: 'label', //default input error message container
            errorClass: 'help-inline', // default input error message class
            focusInvalid: true, // do not focus the last invalid input
            onkeyup: false,
            ignore: [], 
            rules:
            {
            	email_setting_from_email:
            	{
            		required: true,
                    minlength:2,
                    maxlength:200
            	},
            	email_setting_from_name:
            	{
            		required: true,
                    minlength:2,
                    maxlength:120
            	},
            	email_setting_report_emails:
				{
	                multiEmailCheck:true
				},
                <?PHP
                if(!$id)
                {
                	?>
                	email_setting_ashram_id:
	                {
	                    required: true
	                },
	                email_setting_service_slug:
	                {
	                    required: true,
	                    minlength:2,
	                    maxlength:200
	                },
                	<?PHP
                }
                ?>
            },
            messages:
            {
            	email_setting_from_email:
            	{
            		required: "Please enter from email"
            	},
            	email_setting_from_name:
            	{
            		required: "Please enter from name"
            	},
	            email_setting_report_emails:
				{
					required:"Please enter valid report email ids with , seperated"
				},
                <?PHP
                if(!$id)
                {
                	?>
                	email_setting_ashram_id:
	                {
	                    required: "Please select Ashram"
	                },
	                email_setting_service_slug:
	                {
	                    required: "Please enter Service Slug"
	                },
                	<?PHP
                }
                ?>
            },
            highlight: function (element)
            {
                $(element).closest('.form-group').removeClass("has-success").addClass('has-error');
            },
            success: function (label, element)
            {
                $(element).closest('.form-group').removeClass('has-error').addClass('has-success');
                label.remove();
            },
            errorPlacement: function (error, element)
            { 
                error.addClass('help-small no-left-padding').insertAfter(element);
            },
            submitHandler: function(form) 
            {
                $('#save_email_setting_btn').hide();
                form.submit();
            }
    });
})
</script>