<?PHP
$partHeader='Add Calendar Event';
if($id)
{
    $partHeader=htmlentities($calendarData->event_name);
}
?>
<input class="current-browser-title" data-title=" Admin Dashboard  | Ashram Admin | All Calendar Events | <?PHP echo $partHeader; ?>" type="hidden">
<?PHP
	$this->load->view("ashrams/admin/calendar_nav_buttons");
?>
<h3 class="page-title">
	<?PHP
    	echo $partHeader;
    ?>
</h3>
<div class="page-bar">
    <ul class="page-breadcrumb">
        <li>
            <i class="fa fa-home"></i>
            <a href="/admin">Dashboard</a>
            <i class="fa fa-angle-right"></i>
        </li>
        <li>
            <a href="/ashramadmin/calendar">All Calendar Events</a>
            <i class="fa fa-angle-right"></i>
        </li>
        <li><?PHP echo $partHeader; ?></li>
    </ul>
</div>
<?PHP
if($this->session->flashdata("calendar_error"))
{
	?>
    <div class="alert alert-danger">
        <button class="close" data-dismiss="alert"></button>
        <strong>Error saving changes, please try again.</strong>
    </div>
    <?PHP
}
if($this->session->flashdata("calendar_created"))
{
	?>
    <div class="alert alert-success">
        <button class="close" data-dismiss="alert"></button>
        <strong>Calendar Event created successfully.</strong>
    </div>
    <?PHP
}

if($this->session->flashdata("calendar_saved"))
{
	?>
    <div class="alert alert-success">
        <button class="close" data-dismiss="alert"></button>
        <strong>Changes saved successfully.</strong>
    </div>
    <?PHP
}
?>

<div class="row-fluid">
<!-- BEGIN SAMPLE TABLE PORTLET-->
	<div class="margin-bottom-40">
		
		<div class="portlet box blue">
			<div class="portlet-title">
				<div class="caption"><?PHP echo $partHeader; ?></div>
				<div class="tools">
					<a href="javascript:;" class="collapse"></a>
				</div>
                
			</div>
            
			<div class="portlet-body">
				<form action="" id="calendar_form" name="calendar_form" method="post">
                            <?PHP
							if(is_single_ashram_site)
							{ 
							?>
								<input type="hidden" name="ashram_id" id="ashram_id" value="<?php echo default_ashram_id; ?>">
							<?PHP
							}
							else if($this->currentUser->roles==1 && $id==0)
					        {
					            ?>
						<div class="form-group">
								<label class="control-label">Ashram Name
								</label>
							<div class="form-content">
				                <select name="ashram_id" id="ashram_id" onChange="switchAshram(this.value)" class="form-control">
				                    <option value="0">Select Ashram</option>
				                    <?PHP
				                    foreach ($ashrams as $ashramData)
				                    {
				                        ?>
				                        <option value="<?PHP echo $ashramData->id; ?>"
				                        <?PHP
				                        if($this->session->userdata("ashramId")==$ashramData->id)
				                            echo " selected";
				                        ?>
				                        >
				                            <?PHP echo $ashramData->name; ?>
				                        </option>
				                        <?PHP
				                    }
				                    ?>
				                </select>
								</div>
                    		</div>
					            <script>
					                function switchAshram(ashram_id)
					                {
					                    $.post("/ashramadmin/switchashram/"+ashram_id,{},function(res)
					                    {
					                        window.location.reload();
					                    });
					                }
					            </script>
					            <?PHP
					        }
					        else
					        { ?>
							<div class="form-group">
								<label class="control-label">Ashram Name
								</label>
							<div class="form-content">
					        	<?PHP echo htmlentities($ashramData->name); ?>
								</div>
                    		</div>
					        <?PHP }
					        ?>
		            <div class="form-group">
		                <label class="control-label">Calendar Event
		                </label>
		                <div class="form-content">
		                    <div class="input-icon right">
		                        <i class="fa"></i>
		                        <input type="text" class="form-control" name="event_name" id="event_name"
		                        value="<?PHP if($id) echo htmlentities($calendarData->event_name); ?>">
		                    </div>
		                </div>
		            </div>
		            <div class="form-group">
		                <label class="control-label">Description
		                </label>
		                <div class="form-content">
		                    <div class="input-icon right">
		                        <i class="fa"></i>
		                        <textarea class="form-control" name="description" id="description" rows="6"><?PHP 
		                        if($id) echo $calendarData->description; ?></textarea>
		                    </div>
		                </div>
		            </div>
		            <div class="form-group">
		                <label class="control-label">Start Date
		                </label>
		                <div class="form-content">
	                        <input type="text" class="form-control datepickerclass" name="start_date" id="start_date"
	                        value="<?PHP if($id) echo date("d M Y",strtotime($calendarData->start_date)); ?>">
		                </div>
		            </div>
		            <div class="form-group">
		                <label class="control-label"> End Date
		                </label>
		                <div class="form-content">
	                        <input type="text" class="form-control datepickerclass" name="end_date" id="end_date"
	                        value="<?PHP if($id) echo date("d M Y",strtotime($calendarData->end_date)); ?>">
		                </div>
		            </div>
		            <div class="form-group">
						<label class="control-label">
							
						</label>
						<div class="form-content">
							<button type="submit" name="save_calendar" id="save_calendar" class="btn btn-xs blue"> 
							<i class="fa fa-check"></i> <?PHP if($id) echo "Save"; else echo "Add Calendar Event"; ?></button>
							<a href="/ashramadmin/calendar" class="btn btn-xs red"> <i class="fa fa-ban"></i> Cancel</a>
						</div>
					</div>
				</form>
			</div>
		</div>



    </div>
 
</div>
<script type="text/javascript" src="<?PHP echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name;; ?>/global/plugins/ckeditor/ckeditor.js"></script>
<script type="text/javascript">
CKEDITOR.env.isCompatible = true;
CKEDITOR.replace( 'description',
{
    height:'400px',
    toolbar :
        [
    { name: 'indent', items : [ 'Bold','Italic','Underline','NumberedList','BulletedList','JustifyLeft','JustifyCenter','JustifyRight','JustifyBlock','Link','Unlink','Table'] }
        ]
});
$( document ).ready(function() 
{
	jQuery.validator.addMethod("datevalid", function(value, element) 
	{ 
		var startDate = new Date($("#start_date").val())
		var endDate = new Date($("#end_date").val())
		if(startDate>endDate)
		{
			return false
		}
		else return true
	}, "End date cannot be before Start date");

	$('#calendar_form').validate(
	{
		errorElement: 'label', //default input error message container
        errorClass: 'help-inline', // default input error message class
        focusInvalid: true, // do not focus the last invalid input
		onkeyup: false,
       	rules:
       	{
            event_name: {
                required: true,
                minlength:6,
                maxlength:200
            },
			start_date:
			{
				required:true
			},
			end_date:
			{
				required:true,
				datevalid:true
			}
        },

        messages:
        {
            event_name:
            {
                required: "Please enter Calendar Event Name"
            },
            start_date:
			{
				required:"Please select Start Date"
			},
			end_date:
			{
				required:"Please select End Date"
			}
        },
    	highlight: function (element)
    	{
            $(element).closest('.form-group').removeClass("has-success").addClass('has-error');
        },
        success: function (label, element)
        {
			label.remove();
        },
        errorPlacement: function (error, element)
        {
			error.addClass('help-small no-left-padding').insertAfter(element);
        }
    });
	
});
</script>
