<?PHP
$partHeader='Add Announcement';
if($id)
{
    $partHeader=htmlentities($announcementData->title);
}
?>
<input class="current-browser-title" data-title=" Admin Dashboard  | Ashram Admin | All Announcements | <?PHP echo $partHeader; ?>" type="hidden">
<?PHP
    $this->load->view("ashrams/admin/announcements_nav_buttons");
?>
<h3 class="page-title">
	<?PHP
    	if($id)
    	{
	    	if($announcementData->status==1)
	    	{
	    		?>
	    		<span class="label label-success pull-right margin-right-10">Active</span>
	    		<?PHP
	    	}
	    	if($announcementData->status==0)
	    	{
	    		?>
	    		<span class="label label-danger pull-right">Inactive</span>
	    		<?PHP
	    	}
	    }
        echo $partHeader;
    ?>
</h3>
<div class="page-bar">
    <ul class="page-breadcrumb">
        <li>
            <i class="fa fa-home"></i>
            <a href="/admin">Dashboard</a>
            <i class="fa fa-angle-right"></i>
        </li>
        <li>
            <a href="/ashramadmin/announcements">All Announcements</a>
            <i class="fa fa-angle-right"></i>
        </li>
        <li><?PHP echo $partHeader; ?></li>
    </ul>
</div>
<?PHP
if($this->session->flashdata("announcement_error"))
{
	?>
    <div class="alert alert-danger">
        <button class="close" data-dismiss="alert"></button>
        <strong>Error saving changes, please try again.</strong>
    </div>
    <?PHP
}
if($this->session->flashdata("announcement_created"))
{
	?>
    <div class="alert alert-success">
        <button class="close" data-dismiss="alert"></button>
        <strong>Announcement created successfully.</strong>
    </div>
    <?PHP
}

if($this->session->flashdata("announcement_saved"))
{
	?>
    <div class="alert alert-success">
        <button class="close" data-dismiss="alert"></button>
        <strong>Changes saved successfully.</strong>
    </div>
    <?PHP
}
?>

<div class="row-fluid">

	<div class="portlet box blue">
		<div class="portlet-title">
			<div class="caption">
				<?PHP echo $partHeader; ?>
			</div>
			<div class="tools">
				<a href="javascript:;" class="collapse"></a>
			</div>
            
		</div>
        
		<div class="portlet-body">
        	<form action="" id="announcement_form" name="announcement_form" method="post" enctype="multipart/form-data">
				
                <?PHP
                if(is_single_ashram_site)
                { 
                ?>
                    <input type="hidden" name="ashram_id" id="ashram_id" value="<?php echo default_ashram_id; ?>">
                <?PHP
                }
                else if($this->currentUser->roles==1 && $id==0)
                {
                    ?>
                    <div class="form-group">
                        <label class="control-label">Ashram Name
                        </label>
                        <div class="form-content">
                            <select name="ashram_id" id="ashram_id" onChange="switchAshram(this.value)" class="form-control">
                                <option value="0">Select Ashram</option>
                                <?PHP
                                foreach ($ashrams as $ashramData)
                                {
                                    ?>
                                    <option value="<?PHP echo $ashramData->id; ?>"
                                    <?PHP
                                    if($this->session->userdata("ashramId")==$ashramData->id)
                                        echo " selected";
                                    ?>
                                    >
                                        <?PHP echo $ashramData->name; ?>
                                    </option>
                                    <?PHP
                                }
                                ?>
                            </select>
                        </div>
                    </div>
                    <script>
                        function switchAshram(ashram_id)
                        {
                            $.post("/ashramadmin/switchashram/"+ashram_id,{},function(res)
                            {
                                window.location.reload();
                            });
                        }
                    </script>
                    <?PHP
                }
                else
                { ?>
                <div class="form-group">
	                <label class="control-label">Ashram Name
	                </label>
	                <div class="form-content">
                        <?PHP echo htmlentities($ashramData->name); ?>
                    </div>
                </div>
                <?PHP } ?>

				<div class="form-group">
	                <label class="control-label">Title
	                </label>
	                <div class="form-content">
                        <input type="text" class="form-control" name="title" id="title"
                        	value="<?PHP if($id) echo htmlentities($announcementData->title); ?>">
	                </div>
	            </div>

	            <div class="form-group">
	                <label class="control-label">Publish Date
	                </label>
	                <div class="form-content">
                        <input type="text" class="form-control datepickerclass input-inline" name="published_on" id="published_on"
                        	value="<?PHP if($id) echo date("d M Y",strtotime($announcementData->published_on)); ?>">
	                </div>
	            </div>

	            <div class="form-group">
	                <label class="control-label">
	                	Content
	                </label>
	                <div class="form-content">
	                	<textarea class="form-control" name="content" id="content" rows="4"
			                ><?PHP if($id) echo $announcementData->content; ?></textarea>
	                </div>
	            </div>

				<div style="clear:both;"></div>

	            <div class="form-group">
	                <div class="form-content">
	                	<button name="save_announcement" class="btn btn-xs blue" type="submit" id="save_announcement">
	                		<i class="fa fa-check"></i> 
	                		<?PHP
	                			if($id) echo "Save";
	                			else
	                				echo "Create Announcement";
	                		?>
	                	</button>
	                	<a href="/ashramadmin/announcements" class="btn btn-xs red">
	                		<i class="fa fa-ban"></i> Cancel
	                	</a>
	                </div>
	            </div>

			</form>
		</div>
    </div>

</div>
<script type="text/javascript" src="<?PHP echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name;; ?>/global/plugins/ckeditor/ckeditor.js"></script>
<script type="text/javascript">
CKEDITOR.env.isCompatible = true;
CKEDITOR.replace( 'content',
{
    height:'400px',
    toolbar :
        [
    { name: 'indent', items : [ 'Bold','Italic','Underline','NumberedList','BulletedList','Link','Unlink'] }
        ]
});
$( document ).ready(function() 
{
	$('#announcement_form').validate(
	{
		errorElement: 'label', //default input error message container
        errorClass: 'help-inline', // default input error message class
        focusInvalid: true, // do not focus the last invalid input
		onkeyup: false,
       	rules:
       	{
            title:
            {
                required: true,
                minlength:6,
                maxlength:200
            },
            published_on:
            {
            	required:true
            }
        },

        messages:
        {
            title:
            {
                required: "Please enter Announcement Title"
            },
            published_on:
            {
            	required:"Please choose Publish Date"
            }
        },
    	highlight: function (element)
    	{
            $(element).closest('.form-group').removeClass("has-success").addClass('has-error');
        },
        success: function (label, element)
        {
        	$(element).closest('.form-group').removeClass('has-error').addClass('has-success');
			label.remove();
        },
        errorPlacement: function (error, element)
        {
			error.addClass('help-small no-left-padding').insertAfter(element);
        }
    });
	
});
</script>