<link href="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/datatables_1_10_5/media/css/dataTables.bootstrap.css" rel="stylesheet" type="text/css"/>
<style type="text/css">
	.a-row
	{
		padding-left: 0;
		margin-top: 15px;
	}
	.a-row .img-holder
	{
	  width: 7%;
	  float: left;
	}
	.a-row blockquote,
	.article-row blockquote {
	    padding: 0 0 0 5px;
	}
	.a-row .content-holder {
		width: 93%;
		padding-left: 10px;
		float: left;
		height: 145px;
		overflow: hidden;
	}
	.a-row .address .label, .a-row .contact .label
	{
		color: #000;
	}
	@media (max-width:768px)
	{
		.a-row .img-holder {
	        width: 20%!important;
	    }
	    .a-row .content-holder {
		  width: 80% !important;
		}
	}
	@media (max-width:991px)
	{
		.a-row .content-holder
		{
		  height: auto;
		}
	}
</style>
<?PHP
$partHeader="Ashram Centers";
?>
<input class="current-browser-title" data-title="<?PHP echo $partHeader; ?>" type="hidden">
<div class="page-content">
	<!-- BEGIN PAGE HEADER-->
	<h3 class="page-title">
		<div class="left-block">
	        <i class="icomoon-office"></i>
	        <span class="top-line">
	            <?PHP echo $partHeader; ?>
	            <span id="sub-title"></span>
	        </span>
	        <br>
	        <span class="caption">
	            <?PHP echo site_short_name; ?> <?PHP echo $partHeader; ?>
	        </span>
	    </div>
        <div class=" hidden-sm hidden-xs right-block">
        	<?PHP echo site_name_string1; ?> Ashram Centers worldwide
        </div>
    </h3>
    <div class="clearfix"></div>
	
	<div class="page-bar">
		<ul class="page-breadcrumb">
			<li>
				<a href="/">Home</a>
				<i class="fa fa-angle-right"></i>
			</li>
			<li>
				Ashram Centers
			</li>
		</ul>
	</div>
	<!-- END PAGE HEADER-->
	<div class="row">
		<div class="col-md-9">
			<form action="" method="get" name="" onsubmit="return false" class="form-horizontal search_form margin-bottom-10">
		        <div class="col-md-2 col-sm-3">
		            <select name="category" id="category" class="form-control input-sm" onchange="search(1)">
		            	<option value="">All Categories</option>
		                <?PHP
		                $staticCategories = [
                                                'shodasha-datta-kshetras' => 'Shodasha Datta Kshetras',
                                                'navanatha-kshetras' => 'Navanatha Kshetras',
                                                'centers-in-india' => 'Centers in India',
                                                'centers-outside-india' => 'Centers outside India'
                                            ];
		                foreach ($staticCategories as $key => $thisCat)
		                {
		                    ?>
		                    <option value="<?PHP echo $thisCat; ?>" <?PHP if(isset($_GET['category']) && $_GET['category']==$key) echo "selected"; ?> categoryKey="<?PHP echo $key; ?>">
		                    	<?PHP echo $thisCat; ?>
		                    </option>
		                    <?PHP
		                }
		                ?>
		            </select>
		        </div>
		        <div class="col-md-2 col-sm-3">
		            <select name="country" id="country" class="form-control input-sm" onchange="search(1)">
		            	<option value="">All Countries</option>
		                <?PHP
		                foreach ($dyc_countries as $dycCountry)
		                {
		                    ?>
		                    <option value="<?PHP echo $dycCountry->country_id; ?>" <?PHP if(isset($_GET['country']) && $_GET['country']==strtolower($dycCountry->country_id)) echo "selected"; ?>>
		                    	<?PHP echo $dycCountry->country_name; ?>
		                    </option>
		                    <?PHP
		                }
		                ?>
		            </select>
		        </div>
		        <div class="col-md-3 col-sm-3">
		            <input type="text" name="search_text" id="search_text" placeholder="Type keyword to search..."
		            class="form-control input-sm" value="<?PHP if(isset($_GET['text'])) echo $_GET['text']; ?>" />
		        </div>
		        <button type="button" id="searchButton" class="btn btn-sm blue searchButton"><i class="fa fa-search"></i> Search</button>
		        <?PHP
		        $showClearButton = 0;
		        if((isset($_GET['category']) && $_GET['category']!="") || (isset($_GET['country']) && $_GET['country']!="") || (isset($_GET['text']) && $_GET['text']!=""))
		        {
		        	$showClearButton = 1;
		        }
		        ?>
		        <a class="btn btn-sm red" id="searchClear" onClick="search_clear()" style="display:<?PHP if($showClearButton) echo 'inline-block;'; else echo 'none;';?>"><i class="fa fa-search-minus"></i> Clear</a>
		    </form>
			<div class="clearfix"></div>
			<div class="pagination-holder">
			</div>
			<div class="no-more-tables list_section">
			</div>
			<div class="pagination-holder">
			</div>
			<div class="clearfix">
			</div>
		</div>
		<div class="col-md-3">
			<?PHP
	        $this->load->view("common/public/site_".global_site_flag."/_internal_sidebar");
	        ?>
		</div>
	</div>
</div>
<script src="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/datatables_1_10_5/media/js/jquery.dataTables.js" type="text/javascript"></script>
<script src="<?php echo base_url."site_theme/site_".global_site_flag."/".theme_folder_name; ?>/global/plugins/datatables_1_10_5/media/js/dataTables_custom.js" type="text/javascript"></script>
<script type="text/javascript">
var table='';
var country=$("#country").val();
var category=$("#category").val();
var search_text=$("#search_text").val().trim();
var perpage='';

function search(flag) 
{
    clearNotifications();
     if(!$("#category").length || !$("#country").length || !$("#search_text").length)
    {
        showNotification("ruby","Something went wrong!!! Please refresh page and try again.");
        return;
    }
    if (flag == 0)
    {  
        if ($("#search_text").length && $("#search_text").val().trim() == '') 
        {
            showNotification('ruby','Please enter search keywords');
            return false;
        }
    }
    $(".dataTables_processing").show();
    if($("#country").length)
        country = $("#country").val();
    if($("#category").length)
        category = $("#category").val();
    if($("#search_text").length)
        search_text = $("#search_text").val().trim();
    
    if (search_text != '')
        $("#searchClear").css("display", "inline-block");
    
    applyFilter(1);
}

$("#category,#country").on("change",function()
{
    goAndSearchUrl();
});
$("#searchButton").on("click",function()
{
	clearNotifications();
	if ($("#search_text").length && $("#search_text").val().trim() == '') 
    {
        showNotification('ruby','Please enter search keywords');
        return false;
    }
    else
    	goAndSearchUrl();
});
function goAndSearchUrl()
{ 
    var searchCategory = $('#category').find('option:selected').attr("categoryKey");
    var searchCountry = $('#country').val();
    var searchText = $('#search_text').val();
    window.location="<?PHP echo base_url; ?>ashramcenters?category="+searchCategory+"&country="+searchCountry.toLowerCase()+"&text="+searchText;
}

function search_clear() 
{
	window.location="<?PHP echo base_url; ?>ashramcenters";
}
function paginateMe(ele)
{
	clearNotifications();
	var v=$(ele).find('a').attr('href').split("per_page=");
	perpage=v[1];
	applyFilter(1);
	scrolltotop.scrollup();
}
function applyFilter(flag)
{
	$(".loader_animation").show();
	var paginate='';
	if($("#paginate").val())
	{
		paginate=$("#paginate").val();
	}
	if(flag==0)
		$(".list_section").html("<p align='center'>Loading...</p>");
	$.post('/ashramcenters/listc/', 
		{
			start:perpage,
			per_page:perpage,
			search_text:search_text,
			country:country,
			category:category
		}, 
	  	function(res) 
	  	{
	  		$(".list_section").html("");
	  		var r=$.parseJSON(res);
	  		$(".loader_animation").hide();
	  		$("#sub-title").html("("+r.num+")");
	  		if(r.num>10)
	  			$(".pagination-holder").html('<ul class="pagination">'+r.links+'</ul>');
	  		if(r.links)
			{
				$(".pagination-holder").show();
				$(".pagination-holder").closest(".pagination-section").show();
			}
			else
			{
				$(".pagination-holder").hide();
				$(".pagination-holder").closest(".pagination-section").hide();
			}

	  		$.each( r.res, function( key,c)
	  		{
	  			var thumbUrl='<?PHP echo aws_s3_base_url; ?>images/ashramcenter_images/default-ashramcenter.jpg';
	  			if(c.image!='' && c.image!=null)
	  			{
	  				thumbUrl='<?PHP echo aws_s3_base_url; ?>images/ashramcenter_images/thumb_'+c.image;
	  			}
	  			var template='\
	  			<div class="a-row col-md-6">\
				    <blockquote class="'+c.color+'">\
				    	<div class="img-holder" style="padding:0px;">\
				    		<img src="'+thumbUrl+'" style="width:100%;">\
				    	</div>\
				    	<div class="content-holder">\
					        <h2 class="a-title">\
					        	<a href="/ashramcenters/'+c.slug+'" target="_blank">'+c.name+'</a>\
					        </h2>\
					        <div class="location">\
					            <i class="fa fa-map-marker"></i>\
					            '+c.location+'\
							</div>\
					        <div class="content row">\
					        	<div class="col-md-12 col-sm-12 contact" style="margin-top:5px;">\
									<span class="label"><i class="fa fa-phone-square"></i> <b>Contact:</b></span>\
									<br>\
									'+c.contact_person+'<br>\
									'+c.contact_phone+'<br>\
									'+c.contact_email+'\
								</div>\
					        </div>\
				        </div>\
				        <div style="clear:both;"></div>\
				    </blockquote>\
				</div>';
	  			
	  			$(".list_section").append(template);
	  		});
			if(r.num==0)
			{
				$(".list_section").append('<div class="alert alert-info" style="margin:10px 0px;">No records found</div>');
			}

			$(document).ready(function()
            {
                $(".a-title").dotdotdot();
                $(".address").dotdotdot();
                $(".contact").dotdotdot();
            });

		
	  	});
}
applyFilter(0);
</script>