<?PHP
$partHeader='Add Contact';
if($id)
{
    $partHeader=htmlentities($contact_data->name);
}
?>
<input class="current-browser-title" data-title=" User Dashboard  | My Address Book | <?PHP echo $partHeader; ?>" type="hidden">
<?PHP
	$this->load->view("address_book/user/nav_buttons");
?>
<h3 class="page-title">
	<?PHP echo $partHeader; ?>
</h3>
<div class="page-bar">
    <ul class="page-breadcrumb">
        <li>
            <i class="fa fa-home"></i>
            <a href="/myaccount">Dashboard</a>
            <i class="fa fa-angle-right"></i>
        </li>
        <li>
            <a href="/myaddress_book">All Contacts</a>
            <i class="fa fa-angle-right"></i>
        </li>
        <li><?PHP echo $partHeader; ?></li>
    </ul>
</div>
<?PHP
if($this->session->flashdata("contact_error"))
{
	?>
    <div class="alert alert-danger">
        <button class="close" data-dismiss="alert"></button>
        <strong>Error saving changes, please try again.</strong>
    </div>
    <?PHP
}
if($this->session->flashdata("contact_created"))
{
	?>
    <div class="alert alert-success">
        <button class="close" data-dismiss="alert"></button>
        <strong>Contact created successfully.</strong>
    </div>
    <?PHP
}

if($this->session->flashdata("contact_saved"))
{
	?>
    <div class="alert alert-success">
        <button class="close" data-dismiss="alert"></button>
        <strong>Changes saved successfully.</strong>
    </div>
    <?PHP
}
?>

<div class="row-fluid">
<!-- BEGIN SAMPLE TABLE PORTLET-->
	<div class="margin-bottom-40">
		
		<div class="portlet box blue">
			<div class="portlet-title">
				<div class="caption"><?PHP echo $partHeader; ?></div>
				<div class="tools">
					<a href="javascript:;" class="collapse"></a>
				</div>
                
			</div>
            
			<div class="portlet-body">
				<form action="" id="contact_form" name="contact_form" method="post">
				<div class="row">
				<div class="col-md-6">
		            <div class="form-group">
		                <label class="control-label">Name
		                </label>
		                <div class="form-content">
		                    <input type="text" class="form-control" name="name" id="name"
		                        value="<?PHP if($id) echo htmlentities($contact_data->name); ?>">
		                </div>
		            </div>
		            <div class="form-group">
		                <label class="control-label">Email ID
		                </label>
		                <div class="form-content">
		                    <input type="text" class="form-control" name="email" id="email"
		                        value="<?PHP if($id) echo htmlentities($contact_data->email); ?>">
		                </div>
		            </div>
		            <div class="form-group">
		                <label class="control-label">Phone
		                </label>
		                <div class="form-content">
		                    <input type="text" class="form-control" name="phone" id="phone"
		                        value="<?PHP if($id) echo htmlentities($contact_data->phone); ?>">
		                </div>
		            </div>
		            <div class="form-group">
		                <label class="control-label"> Address
		                </label>
		                <div class="form-content">
		                    <textarea class="form-control" name="address" id="address" rows="6"><?PHP 
		                        if($id) echo htmlentities($contact_data->address); ?></textarea>
		                </div>
		            </div>
		            <div class="form-group">
						<div class="form-content">
							<button type="submit" name="add_contact" id="add_contact" class="btn btn-xs blue"> 
							<i class="fa fa-check"></i> <?PHP if($id) echo "Save"; else echo "Add Contact"; ?></button>
							<a href="/myaddress_book" class="btn btn-xs red"> <i class="fa fa-ban"></i> Cancel</a>
						</div>
					</div>
				</div>
				</div>

				</form>
			</div>
		</div>



    </div>
 
</div>

<script type="text/javascript">
				
$( document ).ready(function() 
{			
	$('#contact_form').validate({
        errorElement: 'label', //default input error message container
        errorClass: 'help-inline', // default input error message class
        focusInvalid: true, // do not focus the last invalid input
		 onkeyup: false,
       rules: {
            name: {
                required: true,
                minlength:2,
                maxlength:100
            },
			email: 
			{
				spaces:true,
                minlength:6,
                maxlength:100,
                email_validate:true
            },
			phone: 
			{
				spaces:true,
				minlength:10,
				maxlength:100
            },
            address:
            {
            	spaces:true,
            	minlength:3,
            	maxlength:500
            }
        },

        messages: {
            name: {
                required: "Please enter Name"
            }
        },
    	highlight: function (element) { // hightlight error inputs
            $(element)
                .closest('.form-group').removeClass("has-success").addClass('has-error'); // set error class to the control group   
        },
         success: function (label, element)
         {
            $(element).closest('.form-group').removeClass('has-error').addClass('has-success');
			label.remove();
        },

         errorPlacement: function (error, element) { // render error placement for each input type
			error.addClass('help-small no-left-padding').insertAfter(element);
        }
    });

});
	</script>
