<?PHP
class Vishwashantipadayatra2022_count_model extends CI_Model 
{
	var $db = "";
	var $tableName="vishwashantipadayatra2022_count";
    function __construct()
    {
        parent::__construct();
        //Load misc Database
        $this->db=$this->load->database("misc_services",true,false);
    }

    public function getYatraCountryCodes()
    {
    	$toBeReturnArray = [];
    	$this->db->select('DISTINCT(country)');
    	$this->db->from($this->tableName);
    	$queryres = $this->db->get()->result_array();
    	if(count($queryres)>0)
    	{
    		foreach($queryres as $thisCountry)
    		{
    			array_push($toBeReturnArray,$thisCountry['country']);
    		}
    	}
    	return $toBeReturnArray;
    }

    public function getCount()
	{
		return $this->db->get($this->tableName)->num_rows();
	}

	public function listAllsummaries()
	{
		$q = $this->db->select("id as all_entries")->from($this->tableName)->get()->num_rows();

		$q1 = $this->db->select("id as total_records_by_city")->from($this->tableName)->group_by("city")->get()->num_rows();

		$q2 = $this->db->select("id as total_records_by_country")->from($this->tableName)->group_by("country")->get()->num_rows();

		$q3 = $this->db->select("id as total_records_by_date")->from($this->tableName)->group_by("DATE_FORMAT(yatra_date,'%Y%m%d')")->get()->num_rows();

		$q4 = $this->db->select("sum(steps_count) as india_total")->from($this->tableName)->where("country","IN")->get()->result();

		$q5 = $this->db->select("sum(steps_count) as foreign_total")->from($this->tableName)->where("country!=","IN")->get()->result();

		$data = array();

		$data['all_entries'] 				= $q;
		$data['total_records_by_city'] 		= $q1;
		$data['total_records_by_country'] 	= $q2;
		$data['total_records_by_date'] 		= $q3;
		$data['india_total'] 				= $q4[0]->india_total;
		$data['foreign_total'] 				= $q5[0]->foreign_total;

		return $data;
	}

    public function topCitiesAdmin()
    {
    	$this->db->select("count(id) as submissions, city, country as country_code, name, sum(steps_count) as submission_count");
    	$this->db->where("steps_count >",0);
		$this->db->from($this->tableName." as p");
		$this->db->group_by("city");
		$this->db->order_by("submission_count","desc");
		$query = $this->db->get();
		if($query->num_rows() > 0)
			return $query->result_array();
		else
			return false;
    }
	
	public function getHanumanChalisaParayanaCount()
	{
		$this->db->select('sum(steps_count) as c');
		$q=$this->db->get($this->tableName)->row();
		if($q->c)
			return $q->c;
		else
			return "0";
	}

	public function update($data='',$where='')
	{
		if($data && $where)
		{
			$this->db->where("id",$where);
    		$this->db->update($this->tableName,$data);
    		return true;
		}
	}

    public function listAdmin($excel=0)
	{
		$countries=$this->locations_model->getCountries(true);
		$i=0;
		$query1=$this->db;
		if($excel==0)
			$query1->select("count(p.id) as c,sum(steps_count) total_steps_count");
		step1:
		$i++;
		if($excel==1 || $i==2)
		{
			if(isset($_POST['group_by']) && in_array($_POST['group_by'],array("yatra_date","item_name","city","country","participant_name","user_id")))

				$query1->select("name,phone,email,count(id) as submissions,country,vishwashantipadayatra2022_count_id,participant_name,country_name,city,sum(steps_count) as steps_count,created_on as submission_date,yatra_date,address_1,address_2,address_3,state, order_item_id, item_name");
			else
				$query1->select("name,phone,email,id,'1' as submissions,country,vishwashantipadayatra2022_count_id,participant_name,country_name,city,steps_count,created_on as submission_date,yatra_date,address_1,address_2,address_3,state, order_item_id, item_name");
		}
		$query1->from($this->tableName." as p");

		$preData="Search Keywords: ";
				
		if(isset($_POST['search_text']) && trim($_POST['search_text'])!='' && 
		in_array($_POST['search_col'],$GLOBALS['current_acl']['search_columns']))
		{
			$preData.=$GLOBALS['current_acl']['excel_columns'][$_POST['search_col']];
			$query1->like($_POST['search_col'],trim($_POST['search_text']));
				$preData.=" containing ";
			/* if($_POST['wild']=='starts')
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']),'after');
				$preData.=" starting with ";
			}
			else if($_POST['wild']=='ends')
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']),'before');
				$preData.=" ending with ";
			}
			else
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']));
				$preData.=" containing ";
			} */
			$preData.='"'.$_POST['search_text'].'"';
		}

		$preData.="Total By:";
		if(isset($_POST['group_by']) && in_array($_POST['group_by'],array("yatra_date","item_name","city","country","participant_name","user_id")))
		{
			$query1->group_by($_POST['group_by']);
			if($_POST['group_by']=='participant_name')
			{
				$query1->group_by("user_id");
			}
			if($_POST['group_by']=='yatra_date')
			{
				$preData.="Yatra Date";
			}
			if($_POST['group_by']=='item_name')
			{
				$preData.="Seva Name";
			}
			if($_POST['group_by']=='city')
			{
				$preData.="City";
			}
			if($_POST['group_by']=='country')
			{
				$preData.="Country";
			}
			if($_POST['group_by']=='participant_name')
			{
				$preData.="Yatra Participant";
			}
			if($_POST['group_by']=='user_id')
			{
				$preData.="Devotee";
			}
		}

		$preData.="\nFrom Date: ";
		if(isset($_POST['from_date']) && $_POST['from_date']!='')
		{
			$query1->where("DATE(yatra_date) >=",date("Y-m-d",strtotime($_POST['from_date'])));
			$preData.=$_POST['from_date'];
		}
		
		$preData.="\nTo Date: ";
		if(isset($_POST['to_date']) && $_POST['to_date']!='')
		{
			$query1->where("DATE(yatra_date) <=",date("Y-m-d",strtotime($_POST['to_date'])));
			$preData.=$_POST['to_date'];
		}
		$preData.="\nCountry: ";
		if(isset($_POST['country']) && $_POST['country']!='')
		{
			$query1->where("country",$_POST['country']);
			$preData.=$_POST['country'];
		}
		if($excel==1)
		{
			if(isset($_POST['order_by']) && in_array($_POST['order_by'],$GLOBALS['current_acl']['sort_columns']))
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
				{
					if($_POST['order_by'] == "name")
					{
						$query1->order_by($_POST['order_by'],$_POST['dir']);
						$query1->order_by("country",$_POST['dir']);
						$query1->order_by("city",$_POST['dir']);
					}
					else if($_POST['order_by'] == "country")
					{
						$query1->order_by($_POST['order_by'],$_POST['dir']);
						$query1->order_by("city",$_POST['dir']);
						$query1->order_by("name",$_POST['dir']);
					}
					else if($_POST['order_by'] == "city")
					{
						$query1->order_by($_POST['order_by'],$_POST['dir']);
						$query1->order_by("country",$_POST['dir']);
						$query1->order_by("name",$_POST['dir']);
					}
					else if($_POST['order_by'] == "steps_count")
					{
						$query1->order_by($_POST['order_by'],$_POST['dir']);
						$query1->order_by("country",$_POST['dir']);
						$query1->order_by("city",$_POST['dir']);
						$query1->order_by("name",$_POST['dir']);
					}
					else
						$query1->order_by($_POST['order_by'],$_POST['dir']);
				}
			}
			else
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by('yatra_date',$_POST['dir']);
				else
					$query1->order_by('yatra_date',"asc");
			}
			$sql=$query1->get_compiled_select();

			$requestResp=$this->excel_exports_model->makeRequest('default',"model","vishwashantipadayatra2022/vishwashantipadayatra2022_count_model",$sql,$this->currentUser,"misc_services",$_POST,"All Vishwashantipadayatra2022 Details",$preData);
			return $requestResp;
		}
		
		
		if($i==1)
		{
			if(isset($_POST['group_by']) && in_array($_POST['group_by'],array("yatra_date","item_name","city","country","participant_name","user_id")))
			{
				$temp_result = $query1->get()->result_array();
				$rtn['recordsTotal'] = count($temp_result);
				$rtn['recordsFiltered'] = count($temp_result);
				$total_steps_count = 0;
				$total_submissions = 0;
				foreach ($temp_result as $key => $value) 
				{
					$total_steps_count+= $value["total_steps_count"];
					$total_submissions+= $value["c"];
				}
				$rtn['total_steps_count'] = $total_steps_count;
				$rtn['total_submissions'] = $total_submissions;
			}
			else
			{
				$temp_result = $query1->get()->row();
				$rtn['recordsTotal'] = $temp_result->c;
				$rtn['total_submissions'] = $temp_result->c;
				$rtn['total_steps_count'] = $temp_result->total_steps_count;
				$rtn['recordsFiltered'] = $temp_result->c;
			}
			goto step1;
		}

		$dir='desc';

		if(isset($_POST['order'][0]['dir']) && in_array($_POST['order'][0]['dir'],$GLOBALS['current_acl']['dir']))
			$dir=$_POST['order'][0]['dir'];

		$order_by='';
		if(isset($_POST['order'][0]['column']) && is_numeric($_POST['order'][0]['column']))
		{
			$col_num=round(abs($_POST['order'][0]['column']));
			$col_name=$_POST['columns'][$col_num]['name'];
			if($col_num && in_array($col_name,$GLOBALS['current_acl']['sort_columns']))
			{
				if($col_num == "name")
				{
					$query1->order_by($col_name,$dir);
					$query1->order_by("country",$dir);
					$query1->order_by("city",$dir);
				}
				else if($col_name == "country")
				{
					$query1->order_by($col_name,$dir);
					$query1->order_by("city",$dir);
					$query1->order_by("name",$dir);
				}
				else if($col_name == "city")
				{
					$query1->order_by($col_name,$dir);
					$query1->order_by("country",$dir);
					$query1->order_by("name",$dir);
				}
				else if($col_name == "steps_count")
				{
					$query1->order_by($col_name,$dir);
					$query1->order_by("country",$dir);
					$query1->order_by("city",$dir);
					$query1->order_by("name",$dir);
				}
				else
					$query1->order_by($col_name,$dir);
			}
			else
				$query1->order_by('yatra_date',$dir);
		}
		else
		{
			$query1->order_by('yatra_date',$dir);
		}

		$start=0;
		$length=10;
		if(isset($_POST['start']) && is_numeric($_POST['start']))
		{
			if(round(abs($_POST['start']))%10==0)
			$start=round(abs($_POST['start']));
		}
		if(isset($_POST['length']) && is_numeric($_POST['length']) && in_array($_POST['length'],array(10,20,50,100)))
		{
			$length=abs($_POST['length']);
			if(!$length)
				$length=10;
		}

		$query1->limit($length,$start);

		$rtn['data']=$query1->get()->result_array();
		$rtn['q']=$query1->last_query();
		$temp=array();
		$ids=array();
		$sno=$start+1;
		$c=0;
		$total_steps_count = 0;
		foreach ($rtn['data'] as $row) 
		{
			$rtn['data'][$c]=$row;
			// $ids[] = $row['id'];
			$rtn['data'][$c]['sno']=$sno;
			$rtn['data'][$c]['yatra_date']=date("d M Y",strtotime($row['yatra_date']));
			$rtn['data'][$c]['address']="";
			$address = '';
			if($row['address_1'] != "")
				$address .= $row['address_1']."<br>";
			if($row['address_2'] != "")
				$address .= $row['address_2']."<br>";
			if($row['address_3'] != "")
				$address .= $row['address_3']."<br>";
			if($row['city'] != "")
				$address .= $row['city']."<br>";
			if($row['state'] != "")
				$address .= $row['state']."<br>";
			if($row['country'] != "")
				$address .= $row['country_name'];

			$rtn['data'][$c]['address']=$address;
			if(!empty($row['country']))
				$rtn['data'][$c]['phone']="+".$countries[$row['country']]->isd_code." ".$row['phone'];
			else
				$rtn['data'][$c]['phone']=$row['phone'];


			if(isset($_POST['group_by']) && $_POST['group_by']=="yatra_date")
			{
				$rtn['data'][$c]['name'] = "N/A";
				$rtn['data'][$c]['username']="N/A";
				$rtn['data'][$c]['firstname']="N/A";
				$rtn['data'][$c]['lastname']="N/A";
				$rtn['data'][$c]['phone'] = "N/A";
				$rtn['data'][$c]['email'] = "N/A";
				$rtn['data'][$c]['city'] = "N/A";
				$rtn['data'][$c]['country_name'] = "N/A";
				$rtn['data'][$c]['item_name'] = "N/A";
				$rtn['data'][$c]['participant_name'] = "N/A";
			}

			if(isset($_POST['group_by']) && $_POST['group_by']=="item_name")
			{
				$rtn['data'][$c]['name'] = "N/A";
				$rtn['data'][$c]['username']="N/A";
				$rtn['data'][$c]['firstname']="N/A";
				$rtn['data'][$c]['lastname']="N/A";
				$rtn['data'][$c]['phone'] = "N/A";
				$rtn['data'][$c]['email'] = "N/A";
				$rtn['data'][$c]['city'] = "N/A";
				$rtn['data'][$c]['country_name'] = "N/A";
				$rtn['data'][$c]['yatra_date'] = "N/A";
				$rtn['data'][$c]['participant_name'] = "N/A";
			}

			if(isset($_POST['group_by']) && $_POST['group_by']=="city")
			{
				$rtn['data'][$c]['name'] = "N/A";
				$rtn['data'][$c]['username']="N/A";
				$rtn['data'][$c]['firstname']="N/A";
				$rtn['data'][$c]['lastname']="N/A";
				$rtn['data'][$c]['phone'] = "N/A";
				$rtn['data'][$c]['email'] = "N/A";
				$rtn['data'][$c]['yatra_date'] = "N/A";
				$rtn['data'][$c]['participant_name'] = "N/A";
				$rtn['data'][$c]['item_name'] = "N/A";
			}

			if(isset($_POST['group_by']) && $_POST['group_by']=="country")
			{
				$rtn['data'][$c]['name'] = "N/A";
				$rtn['data'][$c]['username']="N/A";
				$rtn['data'][$c]['firstname']="N/A";
				$rtn['data'][$c]['lastname']="N/A";
				$rtn['data'][$c]['phone'] = "N/A";
				$rtn['data'][$c]['email'] = "N/A";
				$rtn['data'][$c]['yatra_date'] = "N/A";
				$rtn['data'][$c]['participant_name'] = "N/A";
				$rtn['data'][$c]['item_name'] = "N/A";
				$rtn['data'][$c]['city'] = "N/A";
			}

			if(isset($_POST['group_by']) && $_POST['group_by']=="participant_name")
			{
				$rtn['data'][$c]['yatra_date'] = "N/A";
				$rtn['data'][$c]['item_name'] = "N/A";
			}

			if(isset($_POST['group_by']) && $_POST['group_by']=="user_id")
			{
				$rtn['data'][$c]['yatra_date'] = "N/A";
				$rtn['data'][$c]['participant_name'] = "N/A";
				$rtn['data'][$c]['item_name'] = "N/A";
			}
			
			$sno++;
			$c++;
		}
		$rtn['page_records']=$c;
		return $rtn;
	}


	public function listPublic($excel=0)
	{
		$countries=$this->locations_model->getCountries(true);
		$i=0;
		$query1=$this->db;
		if($excel==0)
			$query1->select("count(p.id) as c,sum(steps_count) total_steps_count");
		step1:
		$i++;
		if($excel==1 || $i==2)
		{
			if(isset($_POST['group_by']) && in_array($_POST['group_by'],array("yatra_date","item_name","city","country","participant_name","user_id")))

				$query1->select("name,phone,email,count(id) as submissions,country,vishwashantipadayatra2022_count_id,participant_name,country_name,city,sum(steps_count) as steps_count,created_on as submission_date,yatra_date,address_1,address_2,address_3,state, order_item_id, item_name");
			else
				$query1->select("name,phone,email,id,'1' as submissions,country,vishwashantipadayatra2022_count_id,participant_name,country_name,city,steps_count,created_on as submission_date,yatra_date,address_1,address_2,address_3,state, order_item_id, item_name");
		}
		$query1->from($this->tableName." as p");

		$preData="Search Keywords: ";
				
		if(isset($_POST['search_text']) && trim($_POST['search_text'])!='')
		{
			$preData.=$_POST['search_col'];
			$query1->like($_POST['search_col'],trim($_POST['search_text']));
			$preData.=" containing ";
			$preData.='"'.$_POST['search_text'].'"';
		}

		$preData.="Total By:";
		if(isset($_POST['group_by']) && in_array($_POST['group_by'],array("yatra_date","item_name","city","country","participant_name","user_id")))
		{
			$query1->group_by($_POST['group_by']);
			if($_POST['group_by']=='participant_name')
			{
				$query1->group_by("user_id");
			}
			if($_POST['group_by']=='yatra_date')
			{
				$preData.="Yatra Date";
			}
			if($_POST['group_by']=='item_name')
			{
				$preData.="Seva Name";
			}
			if($_POST['group_by']=='city')
			{
				$preData.="City";
			}
			if($_POST['group_by']=='country')
			{
				$preData.="Country";
			}
			if($_POST['group_by']=='participant_name')
			{
				$preData.="Yatra Participant";
			}
			if($_POST['group_by']=='user_id')
			{
				$preData.="Devotee";
			}
		}

		$preData.="\nFrom Date: ";
		if(isset($_POST['from_date']) && $_POST['from_date']!='')
		{
			$query1->where("DATE(yatra_date) >=",date("Y-m-d",strtotime($_POST['from_date'])));
			$preData.=$_POST['from_date'];
		}
		
		$preData.="\nTo Date: ";
		if(isset($_POST['to_date']) && $_POST['to_date']!='')
		{
			$query1->where("DATE(yatra_date) <=",date("Y-m-d",strtotime($_POST['to_date'])));
			$preData.=$_POST['to_date'];
		}
		$preData.="\nCountry: ";
		if(isset($_POST['country']) && $_POST['country']!='')
		{
			$query1->where("country",$_POST['country']);
			$preData.=$_POST['country'];
		}
		
		if($i==1)
		{
			if(isset($_POST['group_by']) && in_array($_POST['group_by'],array("yatra_date","item_name","city","country","participant_name","user_id")))
			{
				$temp_result = $query1->get()->result_array();
				$rtn['recordsTotal'] = count($temp_result);
				$rtn['recordsFiltered'] = count($temp_result);
				$total_steps_count = 0;
				$total_submissions = 0;
				foreach ($temp_result as $key => $value) 
				{
					$total_steps_count+= $value["total_steps_count"];
					$total_submissions+= $value["c"];
				}
				$rtn['total_steps_count'] = $total_steps_count;
				$rtn['total_submissions'] = $total_submissions;
			}
			else
			{
				$temp_result = $query1->get()->row();
				$rtn['recordsTotal'] = $temp_result->c;
				$rtn['total_submissions'] = $temp_result->c;
				$rtn['total_steps_count'] = $temp_result->total_steps_count;
				$rtn['recordsFiltered'] = $temp_result->c;
			}
			goto step1;
		}

		$dir='desc';

		if(isset($_POST['order'][0]['dir']))
			$dir=$_POST['order'][0]['dir'];

		$order_by='';
		if(isset($_POST['order'][0]['column']) && is_numeric($_POST['order'][0]['column']))
		{
			$col_num=round(abs($_POST['order'][0]['column']));
			$col_name=$_POST['columns'][$col_num]['name'];
			if($col_num)
			{
				if($col_num == "name")
				{
					$query1->order_by($col_name,$dir);
					$query1->order_by("country",$dir);
					$query1->order_by("city",$dir);
				}
				else if($col_name == "country")
				{
					$query1->order_by($col_name,$dir);
					$query1->order_by("city",$dir);
					$query1->order_by("name",$dir);
				}
				else if($col_name == "city")
				{
					$query1->order_by($col_name,$dir);
					$query1->order_by("country",$dir);
					$query1->order_by("name",$dir);
				}
				else if($col_name == "steps_count")
				{
					$query1->order_by($col_name,$dir);
					$query1->order_by("country",$dir);
					$query1->order_by("city",$dir);
					$query1->order_by("name",$dir);
				}
				else
					$query1->order_by($col_name,$dir);
			}
			else
				$query1->order_by('yatra_date',$dir);
		}
		else
		{
			$query1->order_by('yatra_date',$dir);
		}

		$start=0;
		$length=10;
		if(isset($_POST['start']) && is_numeric($_POST['start']))
		{
			if(round(abs($_POST['start']))%10==0)
			$start=round(abs($_POST['start']));
		}
		if(isset($_POST['length']) && is_numeric($_POST['length']) && in_array($_POST['length'],array(10,20,50,100)))
		{
			$length=abs($_POST['length']);
			if(!$length)
				$length=10;
		}

		$query1->limit($length,$start);

		$rtn['data']=$query1->get()->result_array();
		$rtn['q']=$query1->last_query();
		$temp=array();
		$ids=array();
		$sno=$start+1;
		$c=0;
		$total_steps_count = 0;
		foreach ($rtn['data'] as $row) 
		{
			$rtn['data'][$c]=$row;
			// $ids[] = $row['id'];
			$rtn['data'][$c]['sno']=$sno;
			$rtn['data'][$c]['yatra_date']=date("d M Y",strtotime($row['yatra_date']));
			$rtn['data'][$c]['address']="";
			$address = '';
			if($row['address_1'] != "")
				$address .= $row['address_1']."<br>";
			if($row['address_2'] != "")
				$address .= $row['address_2']."<br>";
			if($row['address_3'] != "")
				$address .= $row['address_3']."<br>";
			if($row['city'] != "")
				$address .= $row['city']."<br>";
			if($row['state'] != "")
				$address .= $row['state']."<br>";
			if($row['country'] != "")
				$address .= $row['country_name'];

			$rtn['data'][$c]['address']=$address;
			if(!empty($row['country']))
				$rtn['data'][$c]['phone']="+".$countries[$row['country']]->isd_code." ".$row['phone'];
			else
				$rtn['data'][$c]['phone']=$row['phone'];


			if(isset($_POST['group_by']) && $_POST['group_by']=="yatra_date")
			{
				$rtn['data'][$c]['name'] = "N/A";
				$rtn['data'][$c]['username']="N/A";
				$rtn['data'][$c]['firstname']="N/A";
				$rtn['data'][$c]['lastname']="N/A";
				$rtn['data'][$c]['phone'] = "N/A";
				$rtn['data'][$c]['email'] = "N/A";
				$rtn['data'][$c]['city'] = "N/A";
				$rtn['data'][$c]['country_name'] = "N/A";
				$rtn['data'][$c]['item_name'] = "N/A";
				$rtn['data'][$c]['participant_name'] = "N/A";
			}

			if(isset($_POST['group_by']) && $_POST['group_by']=="item_name")
			{
				$rtn['data'][$c]['name'] = "N/A";
				$rtn['data'][$c]['username']="N/A";
				$rtn['data'][$c]['firstname']="N/A";
				$rtn['data'][$c]['lastname']="N/A";
				$rtn['data'][$c]['phone'] = "N/A";
				$rtn['data'][$c]['email'] = "N/A";
				$rtn['data'][$c]['city'] = "N/A";
				$rtn['data'][$c]['country_name'] = "N/A";
				$rtn['data'][$c]['yatra_date'] = "N/A";
				$rtn['data'][$c]['participant_name'] = "N/A";
			}

			if(isset($_POST['group_by']) && $_POST['group_by']=="city")
			{
				$rtn['data'][$c]['name'] = "N/A";
				$rtn['data'][$c]['username']="N/A";
				$rtn['data'][$c]['firstname']="N/A";
				$rtn['data'][$c]['lastname']="N/A";
				$rtn['data'][$c]['phone'] = "N/A";
				$rtn['data'][$c]['email'] = "N/A";
				$rtn['data'][$c]['yatra_date'] = "N/A";
				$rtn['data'][$c]['participant_name'] = "N/A";
				$rtn['data'][$c]['item_name'] = "N/A";
			}

			if(isset($_POST['group_by']) && $_POST['group_by']=="country")
			{
				$rtn['data'][$c]['name'] = "N/A";
				$rtn['data'][$c]['username']="N/A";
				$rtn['data'][$c]['firstname']="N/A";
				$rtn['data'][$c]['lastname']="N/A";
				$rtn['data'][$c]['phone'] = "N/A";
				$rtn['data'][$c]['email'] = "N/A";
				$rtn['data'][$c]['yatra_date'] = "N/A";
				$rtn['data'][$c]['participant_name'] = "N/A";
				$rtn['data'][$c]['item_name'] = "N/A";
				$rtn['data'][$c]['city'] = "N/A";
			}

			if(isset($_POST['group_by']) && $_POST['group_by']=="participant_name")
			{
				$rtn['data'][$c]['yatra_date'] = "N/A";
				$rtn['data'][$c]['item_name'] = "N/A";
			}

			if(isset($_POST['group_by']) && $_POST['group_by']=="user_id")
			{
				$rtn['data'][$c]['yatra_date'] = "N/A";
				$rtn['data'][$c]['participant_name'] = "N/A";
				$rtn['data'][$c]['item_name'] = "N/A";
			}
			
			$sno++;
			$c++;
		}
		$rtn['page_records']=$c;
		return $rtn;
	}

	public function userReport($excel=0)
	{
		$i=0;
		$query1=$this->db;
		if($excel==0)
		{
			$query1->select("count(id) as c,sum(steps_count) as total_steps_count");
		}
		step1:
		$i++;
		if($i==2 || $excel==1)
		{
			$query1->select("*,sum(steps_count) as total_steps_count");
		}
		$query1->from($this->tableName);

		$query1->group_start();
		$query1->where("user_id",$this->currentUser->id);
		$query1->or_where("email",$this->currentUser->email);
		$query1->group_end();
		$query1->where("steps_count >",0);

		$preData="";
		$preData.="\nFrom Date: ";
		if(isset($_POST['from_date']) && $_POST['from_date']!='')
		{
			$query1->where("yatra_date >=",date("Y-m-d",strtotime($_POST['from_date'])));
			$preData.=$_POST['from_date'];
		}
		
		$preData.="\nTo Date: ";
		if(isset($_POST['to_date']) && $_POST['to_date']!='')
		{
			$query1->where("yatra_date <=",date("Y-m-d",strtotime($_POST['to_date'])));
			$preData.=$_POST['to_date'];
		}
		if($excel==1)
		{
			$query1->order_by('yatra_date',$_POST['dir']);
			if(isset($_POST['order_by']) && in_array($_POST['order_by'],$GLOBALS['current_acl']['sort_columns']))
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by($_POST['order_by'],$_POST['dir']);
				else
					$query1->order_by($_POST['order_by'],'desc');
			}
			else
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by('yatra_date',$_POST['dir']);
				else
					$query1->order_by('yatra_date',"desc");
			}
			$query1->group_by("order_item_id");
			$query1->group_by("yatra_date");
			$sql=$query1->get_compiled_select();

			$requestResp=$this->excel_exports_model->makeRequest('default',"model","vishwashantipadayatra2022/vishwashantipadayatra2022_count_model",$sql,$this->currentUser,"misc_services",$_POST,"Vishwashanti Yatra 2022 Steps count Report",$preData,2);
			return $requestResp;
		}
		
		if($i==1)
		{
			$query1->group_by("order_item_id");
			$query1->group_by("yatra_date");
			$temp_result = $query1->get()->result();
			$t_total=0;
			$total_steps_count = 0;
			$t_cur_total = 0;
			foreach ($temp_result as $temp_row)
			{
				$t_total+=$temp_row->c;
				$t_cur_total+=$temp_row->total_steps_count;
			}
			$rtn['recordsTotal'] = count($temp_result);
			$rtn['recordsFiltered'] = count($temp_result);
			$rtn['total_steps_count'] = $t_cur_total;
			goto step1;
		}

		$dir='desc';
		if(isset($_POST['order'][0]['dir']) && in_array($_POST['order'][0]['dir'],$GLOBALS['current_acl']['dir']))
			$dir=$_POST['order'][0]['dir'];

		$order_by='';
		if(isset($_POST['order'][0]['column']) && is_numeric($_POST['order'][0]['column']))
		{
			$col_num=round(abs($_POST['order'][0]['column']));
			$col_name=$_POST['columns'][$col_num]['name'];
			if($col_num && in_array($col_name,$GLOBALS['current_acl']['sort_columns']))
				$query1->order_by($col_name,$dir);
			else
				$query1->order_by('yatra_date',$dir);
		}
		else
		{
			$query1->order_by('yatra_date',$dir);
		}
		$query1->group_by("order_item_id");
		$query1->group_by("yatra_date");
		$start=0;
		$length=10;
		if(isset($_POST['start']) && is_numeric($_POST['start']))
		{
			if(round(abs($_POST['start']))%10==0)
			$start=round(abs($_POST['start']));
		}
		if(isset($_POST['length']) && is_numeric($_POST['length']) && in_array($_POST['length'],array(10,20)))
		{
			$length=abs($_POST['length']);
			if(!$length)
				$length=10;
		}

		$query1->limit($length,$start);

		$rtn['data']=$query1->get()->result_array();
		$sno=$start+1;
		$c=0;
		foreach ($rtn['data'] as $row)
		{
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['sno']=$sno;
			if(empty($rtn['data'][$c]['yatra_date']) || $rtn['data'][$c]['yatra_date'] == "1970-01-01")
			{
				$rtn['data'][$c]['yatra_date']='N/A';
				$rtn['data'][$c]['day']='N/A';
				$rtn['data'][$c]['yatra_u_date']='';
			}
			else
			{
				$rtn['data'][$c]['yatra_date']=date("d M Y",strtotime($rtn['data'][$c]['yatra_date']));
				$rtn['data'][$c]['day']=date("l",strtotime($rtn['data'][$c]['yatra_date']));
				$rtn['data'][$c]['yatra_u_date']=urlencode(date("d M Y",strtotime($rtn['data'][$c]['yatra_date'])));
			}
			if(empty($rtn['data'][$c]['participant_name']))
			{
				$rtn['data'][$c]['participant_name']="N/A";
			}
			else
			{
				$rtn['data'][$c]['participant_name'] = nl2br($rtn['data'][$c]['participant_name']);
			}
			
			$sno++;
			$c++;
		}
		return $rtn;
	}

	public function guestReport($mobile_no="",$excel=0)
	{
		$i=0;
		$query1=$this->db;
		if($excel==0)
		{
			$query1->select("count(id) as c,sum(steps_count) as total_steps_count");
		}
		step1:
		$i++;
		if($i==2 || $excel==1)
		{
			$query1->select("*,sum(steps_count) as total_steps_count");
		}
		$query1->from($this->tableName);
		$query1->where("phone",$mobile_no);
		$query1->where("steps_count >",0);

		$preData="";
		$preData.="\nFrom Date: ";
		if(isset($_POST['from_date']) && $_POST['from_date']!='')
		{
			$query1->where("yatra_date >=",date("Y-m-d",strtotime($_POST['from_date'])));
			$preData.=$_POST['from_date'];
		}
		
		$preData.="\nTo Date: ";
		if(isset($_POST['to_date']) && $_POST['to_date']!='')
		{
			$query1->where("yatra_date <=",date("Y-m-d",strtotime($_POST['to_date'])));
			$preData.=$_POST['to_date'];
		}
		if($excel==1)
		{
			$query1->order_by('yatra_date',$_POST['dir']);
			if(isset($_POST['order_by']) && in_array($_POST['order_by'],$GLOBALS['current_acl']['sort_columns']))
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by($_POST['order_by'],$_POST['dir']);
				else
					$query1->order_by($_POST['order_by'],'desc');
			}
			else
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by('yatra_date',$_POST['dir']);
				else
					$query1->order_by('yatra_date',"desc");
			}
			$query1->group_by("order_item_id");
			$query1->group_by("yatra_date");
			$sql=$query1->get_compiled_select();

			$requestResp=$this->excel_exports_model->makeRequest('default',"model","vishwashantipadayatra2022/vishwashantipadayatra2022_count_model",$sql,$this->currentUser,"misc_services",$_POST,"Vishwashanti Yatra 2022 Steps count Report",$preData,3);
			return $requestResp;
		}
		
		if($i==1)
		{
			$query1->group_by("order_item_id");
			$query1->group_by("yatra_date");
			$temp_result = $query1->get()->result();
			$t_total=0;
			$total_steps_count = 0;
			$t_cur_total = 0;
			foreach ($temp_result as $temp_row)
			{
				$t_total+=$temp_row->c;
				$t_cur_total+=$temp_row->total_steps_count;
			}
			$rtn['recordsTotal'] = count($temp_result);
			$rtn['recordsFiltered'] = count($temp_result);
			$rtn['total_steps_count'] = $t_cur_total;
			goto step1;
		}

		$dir='desc';
		if(isset($_POST['order'][0]['dir']) && in_array($_POST['order'][0]['dir'],$GLOBALS['current_acl']['dir']))
			$dir=$_POST['order'][0]['dir'];

		$order_by='';
		if(isset($_POST['order'][0]['column']) && is_numeric($_POST['order'][0]['column']))
		{
			$col_num=round(abs($_POST['order'][0]['column']));
			$col_name=$_POST['columns'][$col_num]['name'];
			if($col_num && in_array($col_name,$GLOBALS['current_acl']['sort_columns']))
				$query1->order_by($col_name,$dir);
			else
				$query1->order_by('yatra_date',$dir);
		}
		else
		{
			$query1->order_by('yatra_date',$dir);
		}
		$query1->group_by("order_item_id");
		$query1->group_by("yatra_date");
		$start=0;
		$length=10;
		if(isset($_POST['start']) && is_numeric($_POST['start']))
		{
			if(round(abs($_POST['start']))%10==0)
			$start=round(abs($_POST['start']));
		}
		if(isset($_POST['length']) && is_numeric($_POST['length']) && in_array($_POST['length'],array(10,20)))
		{
			$length=abs($_POST['length']);
			if(!$length)
				$length=10;
		}

		$query1->limit($length,$start);

		$rtn['data']=$query1->get()->result_array();
		$sno=$start+1;
		$ids = array();
		$c=0;
		foreach ($rtn['data'] as $row)
		{
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['sno']=$sno;
			$ids[] = $row['id'];
			if(empty($rtn['data'][$c]['yatra_date']) || $rtn['data'][$c]['yatra_date'] == "1970-01-01")
			{
				$rtn['data'][$c]['yatra_date']='N/A';
				$rtn['data'][$c]['day']='N/A';
				$rtn['data'][$c]['yatra_u_date']='';
			}
			else
			{
				$rtn['data'][$c]['yatra_date']=date("d M Y",strtotime($rtn['data'][$c]['yatra_date']));
				$rtn['data'][$c]['day']=date("l",strtotime($rtn['data'][$c]['yatra_date']));
				$rtn['data'][$c]['yatra_u_date']=urlencode(date("d M Y",strtotime($rtn['data'][$c]['yatra_date'])));
			}
			if(empty($rtn['data'][$c]['participant_name']))
				$rtn['data'][$c]['participant_name']="N/A";
			
			$sno++;
			$c++;
		}
		return $rtn;
	}

	public function getguestDatabyDate($mobile_no,$date)
	{
		if(empty($date))
			return false;

		$this->db->select("*");
		$this->db->where("p.yatra_date",date("Y-m-d",strtotime($date)));
		$this->db->where("p.phone",$mobile_no);
		$this->db->where("steps_count >",0);
		$this->db->from($this->tableName." as p");
		$query = $this->db->get();
		if($query->num_rows() > 0)
			return $query->result_array();
		else
			return false;
	}

	public function getDatabyDate($date)
	{
		if(empty($date))
			return false;

		$this->db->select("*");
		$this->db->where("p.yatra_date",date("Y-m-d",strtotime($date)));
		$this->db->group_start();
		$this->db->where("p.user_id",$this->currentUser->id);
		$this->db->or_where("p.email",$this->currentUser->email);
		$this->db->group_end();
		$this->db->where("steps_count >",0);
		$this->db->from($this->tableName." as p");
		$query = $this->db->get();
		if($query->num_rows() > 0)
		{
			return $query->result_array();
		}
		else
		{
			return false;
		}
	}
	
	function vishwashantipadayatra2022Data($id)
	{
		$this->db->select("*");
		$this->db->where("p.id",$id);
		$this->db->from($this->tableName." as p");
		$query = $this->db->get();
		return $query->row();
	}

	public function delete($id)
	{
		$this->db->where("id",$id)->delete($this->tableName);
		return true;
	}

	public function getTotalRecords($limit=0,$offset=0)
	{
		$this->db->select("*")->from($this->tableName)->order_by("id","desc");
		if(!empty($limit) && $limit > 0)
			$this->db->limit($limit,$offset);
		$q = $this->db->get();
		if($q->num_rows() > 0)
		{
			$r = $q->result_array();
			return $r;
		}
		else
		{
			return false;
		}
	}

	public function getDatabyPhone($phone)
    {
    	$this->db->where("phone",$phone);
        $query=$this->db->get($this->tableName);
        if($query->num_rows())
		{
			return $query->row();
        }
        return 0;
    }

	public function phoneCheck($phone)
    {
    	$this->db->where("phone",$phone);
        $query=$this->db->get($this->tableName);
        if($query->num_rows())
		{
			return 1;
        }
        return 0;
    }

    public function publicphoneCheck($phone)
    {
    	$this->db->select("name");
    	$this->db->where("phone",$phone);
        $query=$this->db->get($this->tableName);
        if($query->num_rows())
		{
			return $query->row();
        }
        return 0;
    }

	public function getTotalRecordsByCity($limit = 0,$offset = 0)
	{
		$this->db->select("count(id) as submissions,city,country_name,sum(steps_count) as steps_count")->from($this->tableName)->order_by("steps_count","desc");
		if(!empty($limit) && $limit > 0)
			$this->db->limit($limit,$offset);
		$q = $this->db->group_by("city")->get();
		if($q->num_rows() > 0)
		{
			$sno=1;
			$r = $q->result_array();
			foreach ($r as $key=>$value) 
			{
				$r[$key]['rank']=$sno;
				$sno++;
			}
			return $r;
		}
		else
		{
			return false;
		}
	}

	public function getTotalRecordsByCountry($limit = 0,$offset = 0)
	{
		$this->db->select("count(id) as submissions,city,country as country_code,country_name,sum(steps_count) as steps_count")->from($this->tableName)->group_by("country")->order_by("steps_count","desc");
		if(!empty($limit) && $limit > 0)
			$this->db->limit($limit,$offset);
		$q = $this->db->get();
		if($q->num_rows() > 0)
		{
			$sno=1;
			$r = $q->result_array();
			foreach ($r as $key=>$value) 
			{
				$r[$key]['rank']=$sno;
				$sno++;
			}
			return $r;
		}
		else
		{
			return false;
		}
	}

	public function getTopCities()
	{
		$q = $this->db->select("count(id) as submissions,city,country as country_code,country_name,sum(steps_count) as steps_count")->from($this->tableName)->group_by("city")->order_by("steps_count","desc")->limit(10)->get();
		if($q->num_rows() > 0)
		{
			$sno=1;
			$r = $q->result_array();
			foreach ($r as $key=>$value) 
			{
				$r[$key]['rank']=$sno;
				$sno++;
			}
			return $r;
		}
		else
		{
			return false;
		}
	}

	public function gettodaysTotalRecords()
	{
		$q = $this->db->select("name,phone,email,count(id) as submissions,country as country_code,country_name,city,sum(steps_count) as steps_count,created_on as submission_date")->from($this->tableName)->group_by("phone")->order_by("steps_count","desc")->get();
		if($q->num_rows() > 0)
		{
			$sno=1;
			$r = $q->result_array();
			foreach ($r as $key=>$value) 
			{
				$r[$key]['rank']=$sno;
				$sno++;
			}
			return $r;
		}
		else
		{
			return false;
		}
	}

	public function getTotalRecordsbyDate()
	{
		$q = $this->db->select("count(id) as submissions,sum(steps_count) as steps_count,yatra_date,city,created_on as submission_date")->from($this->tableName)->group_by("DATE_FORMAT(yatra_date,'%Y%m%d')")->order_by("yatra_date","desc")->get();
		if($q->num_rows() > 0)
		{
			$sno=1;
			$r = $q->result_array();
			foreach ($r as $key=>$value) 
			{
				$r[$key]['rank']=$sno;
				$sno++;
			}
			return $r;
		}
		else
		{
			return false;
		}
	}
	
	public function save($info)
	{	
		$user_id=0;
		$username='';
		if($this->session->userdata('user_id'))
		{
		    $user_id=$this->session->userdata('user_id');
		    $username=$this->session->userdata('user_data')->username;
		}

		$users=$this->users_model->getUsersByEmails(array($info['email']));
		if(!empty($users))
		{
			$user_id=$users[0]->id;
		    $username=$users[0]->username;
		}
		$app=0;
		if(isset($GLOBALS['app']) && $GLOBALS['app']==1)
		{
			$app=1;
		}
		$participant_name = trim($info['participant_name']);

		if($participant_name == "")
		{
			$participant_name = trim($info['name']);
		}

		$item_name = "";
		$item_id = 0;

		if(trim($info['order_item_id'])>0)
		{
			$defaultDb=$this->load->database("default",true,false);
			$defaultDb->select("oi.item_id, oi.item_name");
			$defaultDb->from("order_items as oi");
			$defaultDb->where("oi.id",$info['order_item_id']);
			$itemDetails = $defaultDb->get()->row_array();
			if(isset($itemDetails['item_name']) && $itemDetails['item_name']!="")
			{
				$item_name = $itemDetails['item_name'];
			}
			if(isset($itemDetails['item_id']) && $itemDetails['item_id']>0)
			{
				$item_id = $itemDetails['item_id'];
			}
		}


		$countryData=$this->locations_model->getCountryByCode($info["country_code"]);
		$query=$this->db->insert($this->tableName,
                            	array(
                            			'name' =>trim($info['name']),
                            			'email' =>strtolower(trim($info['email'])),
                            			'phone' =>trim($info['phone']),
                            			'country' =>trim($info['country_code']),
                            			'country_name' =>$countryData->country_name,
                            			'address_1' =>trim($info['address1']),
                            			'address_2' =>trim($info['address2']),
                            			'address_3' =>trim($info['address3']),
                            			'state' =>trim($info['state']),
                            			'city' =>trim($info['city']),
                            			'zipcode'=>trim($info['zipcode']),
                            			'order_item_id'=>trim($info['order_item_id']),
                            			'participant_name' => $participant_name,
                            			'yatra_date'=>date("Y-m-d",strtotime($info['yatra_date'])),
                            			'steps_count'=>trim($info['steps_count']),
                            			'user_id'=>$user_id,
                            			'username'=>$username,
                            			'item_name'=>$item_name,
                            			'item_id'=>$item_id,
                            			'app'=>$app,
                            			'created_on'=>date("Y:m:d H:i:s")
									)
								);
		if($query)
		{
			$last_id=$this->db->insert_id();
			$pid="VSY-".date("Y")."-".date("m")."-100".$last_id;
			$this->db->where("id",$last_id);
			$this->db->update($this->tableName,
							array("vishwashantipadayatra2022_count_id"=>$pid)
						);

			return 1;
		}
		else return 0;
	}

	public function excelReportUser($excelData,$objPHPExcel)
	{
		if($excelData->page_number==3)
		{
			$objPHPExcel=$this->excelReportGuestUser($excelData,$objPHPExcel);
			return $objPHPExcel;
		}
		$q=$this->db->query($excelData->query);

		$objPHPExcel->setActiveSheetIndex(0);
		$objPHPExcel->getActiveSheet()->SetCellValue('A1',$excelData->page_name);

		$styleArray = array(
							'font' => array(
							'bold' => true
							)
						);

		$objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('A2',"Report Date: ".date("d M Y h:i A"));

		$j=3;
		$pre_data=explode("\n",$excelData->pre_data);
		foreach ($pre_data as $filter)
		{
			$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,$filter);
			$j++;
		}

		$request_data=unserialize($excelData->request_data);

		$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,"Total Records: ".$q->num_rows());

		$j=$j+2;

		$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,"S. No.");
		$objPHPExcel->getActiveSheet()->getStyle('A'.$j)->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('B'.$j,"Yatra Date");
		$objPHPExcel->getActiveSheet()->getStyle('B'.$j)->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('C'.$j,"Seva Name");
		$objPHPExcel->getActiveSheet()->getStyle('C'.$j)->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('D'.$j,"Devotee Name");
		$objPHPExcel->getActiveSheet()->getStyle('D'.$j)->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('E'.$j,"Yatra Participant");
		$objPHPExcel->getActiveSheet()->getStyle('E'.$j)->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('F'.$j,"Total Steps Count");
		$objPHPExcel->getActiveSheet()->getStyle('F'.$j)->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('G'.$j,"Day");
		$objPHPExcel->getActiveSheet()->getStyle('G'.$j)->applyFromArray($styleArray);

		$i=$j+1;
		$sno=1;
		foreach ($q->result() as $reportrow)
		{
			if(empty($reportrow->yatra_date) || $reportrow->yatra_date == "1970-01-01")
			{
				$reportrow->yatra_date='N/A';
				$reportrow->day='N/A';
			}
			else
			{
				$reportrow->yatra_date=date("d M Y",strtotime($reportrow->yatra_date));
				$reportrow->day=date("l",strtotime($reportrow->yatra_date));
			}
			$objPHPExcel->getActiveSheet()->SetCellValue('A'.$i,$sno);
			$objPHPExcel->getActiveSheet()->SetCellValue('B'.$i,date("d M Y",strtotime($reportrow->yatra_date)));
			$objPHPExcel->getActiveSheet()->SetCellValue('C'.$i,$reportrow->item_name);
			$objPHPExcel->getActiveSheet()->SetCellValue('D'.$i,$reportrow->name);
			$objPHPExcel->getActiveSheet()->SetCellValue('E'.$i,$reportrow->participant_name);
			$objPHPExcel->getActiveSheet()->SetCellValue('F'.$i,$reportrow->total_steps_count);
			$objPHPExcel->getActiveSheet()->SetCellValue('G'.$i,$reportrow->day);
			$i++;
			$sno++;
		}
		return $objPHPExcel;
	}

	public function excelReportGuestUser($excelData,$objPHPExcel)
	{
		$q=$this->db->query($excelData->query);

		$objPHPExcel->setActiveSheetIndex(0);
		$objPHPExcel->getActiveSheet()->SetCellValue('A1',$excelData->page_name);

		$styleArray = array(
							'font' => array(
							'bold' => true
							)
						);

		$objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('A2',"Report Date: ".date("d M Y h:i A"));

		$j=3;
		$pre_data=explode("\n",$excelData->pre_data);
		foreach ($pre_data as $filter)
		{
			$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,$filter);
			$j++;
		}

		$request_data=unserialize($excelData->request_data);

		$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,"Total Records: ".$q->num_rows());

		$j=$j+2;

		$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,"S. No.");
		$objPHPExcel->getActiveSheet()->getStyle('A'.$j)->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('B'.$j,"Devotee Name");
		$objPHPExcel->getActiveSheet()->getStyle('B'.$j)->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('C'.$j,"Email");
		$objPHPExcel->getActiveSheet()->getStyle('C'.$j)->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('D'.$j,"Phone");
		$objPHPExcel->getActiveSheet()->getStyle('D'.$j)->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('E'.$j,"Yatra Participant");
		$objPHPExcel->getActiveSheet()->getStyle('E'.$j)->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('F'.$j,"Steps Count");
		$objPHPExcel->getActiveSheet()->getStyle('F'.$j)->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('G'.$j,"Day");
		$objPHPExcel->getActiveSheet()->getStyle('G'.$j)->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('H'.$j,"Yatra Date");
		$objPHPExcel->getActiveSheet()->getStyle('H'.$j)->applyFromArray($styleArray);

		$i=$j+1;
		$sno=1;
		foreach ($q->result() as $reportrow)
		{
			if(empty($reportrow->yatra_date) || $reportrow->yatra_date == "1970-01-01")
			{
				$reportrow->yatra_date='N/A';
				$reportrow->day='N/A';
			}
			else
			{
				$reportrow->yatra_date=date("d M Y",strtotime($reportrow->yatra_date));
				$reportrow->day=date("l",strtotime($reportrow->yatra_date));
			}
			$objPHPExcel->getActiveSheet()->SetCellValue('A'.$i,$sno);
			$objPHPExcel->getActiveSheet()->SetCellValue('B'.$i,$reportrow->name);
			$objPHPExcel->getActiveSheet()->SetCellValue('C'.$i,$reportrow->email);
			$objPHPExcel->getActiveSheet()->SetCellValue('D'.$i,$reportrow->phone);
			$objPHPExcel->getActiveSheet()->SetCellValue('E'.$i,$reportrow->participant_name);
			$objPHPExcel->getActiveSheet()->SetCellValue('F'.$i,$reportrow->total_steps_count);
			$objPHPExcel->getActiveSheet()->SetCellValue('G'.$i,$reportrow->day);
			$objPHPExcel->getActiveSheet()->SetCellValue('H'.$i,date("d M Y",strtotime($reportrow->yatra_date)));
			$i++;
			$sno++;
		}
		return $objPHPExcel;
	}

	public function excelReport($excelData,$objPHPExcel)
	{
		if($excelData->page_number==2)
		{
			$objPHPExcel=$this->excelReportUser($excelData,$objPHPExcel);
			return $objPHPExcel;
		}
		if($excelData->page_number==3)
		{
			$objPHPExcel=$this->excelReportGuestUser($excelData,$objPHPExcel);
			return $objPHPExcel;
		}
		$countries=$this->locations_model->getCountries(true);

		$q=$this->db->query($excelData->query);

		$objPHPExcel->setActiveSheetIndex(0);
		$objPHPExcel->getActiveSheet()->SetCellValue('A1',$excelData->page_name);

		$styleArray = array(
							'font' => array(
							'bold' => true
							)
						);

		$objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('A2',"Report Date: ".date("d M Y h:i A"));

		$j=3;
		$pre_data=explode("\n",$excelData->pre_data);
		foreach ($pre_data as $filter)
		{
			$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,$filter);
			$j++;
		}

		$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,"Total Records: ".$q->num_rows());

		$requestData=unserialize($excelData->request_data);

		$j=$j+2;

		$alpha="A";
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"S. No.");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Devotee Name");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Phone");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Email");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"City");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Country");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Seva Name");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Yatra Participant");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Steps Count");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Submisions");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Day");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Yatra Date");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$i=$j+1;
		$sno=1;
		foreach ($q->result() as $reportrow)
		{
			if(empty($reportrow->yatra_date) || $reportrow->yatra_date == "1970-01-01")
			{
				$reportrow->yatra_date='N/A';
				$reportrow->day='N/A';
			}
			else
			{
				$reportrow->yatra_date=date("d M Y",strtotime($reportrow->yatra_date));
				$reportrow->day=date("l",strtotime($reportrow->yatra_date));
			}
			$alpha="A";
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$sno);



			if(isset($requestData['group_by']) && $requestData['group_by']=="yatra_date")
			{
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,"N/A");
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,"N/A");
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,"N/A");
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,"N/A");
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,"N/A");
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,"N/A");
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,"N/A");
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->steps_count);
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->submissions);
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->day);
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("d M Y",strtotime($reportrow->yatra_date)));
			}
			else if(isset($requestData['group_by']) && $requestData['group_by']=="item_name")
			{
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,"N/A");
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,"N/A");
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,"N/A");
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,"N/A");
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,"N/A");
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->item_name);
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,"N/A");
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->steps_count);
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->submissions);
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,"N/A");
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,"N/A");
			}
			else if(isset($requestData['group_by']) && $requestData['group_by']=="city")
			{
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,"N/A");
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,"N/A");
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,"N/A");
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->city);
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$countries[$reportrow->country]->country_name);
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,"N/A");
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,"N/A");
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->steps_count);
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->submissions);
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,"N/A");
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,"N/A");
			}
			else if(isset($requestData['group_by']) && $requestData['group_by']=="country")
			{
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,"N/A");
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,"N/A");
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,"N/A");
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,"N/A");
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$countries[$reportrow->country]->country_name);
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,"N/A");
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,"N/A");
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->steps_count);
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->submissions);
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,"N/A");
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,"N/A");
			}
			else if(isset($requestData['group_by']) && $requestData['group_by']=="participant_name")
			{
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->name);
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,"+".$countries[$reportrow->country]->isd_code." ".$reportrow->phone);
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->email);
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->city);
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$countries[$reportrow->country]->country_name);
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,"N/A");
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->participant_name);
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->steps_count);
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->submissions);
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,"N/A");
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,"N/A");
			}
			else if(isset($requestData['group_by']) && $requestData['group_by']=="user_id")
			{
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->name);
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,"+".$countries[$reportrow->country]->isd_code." ".$reportrow->phone);
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->email);
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->city);
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$countries[$reportrow->country]->country_name);
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,"N/A");
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,"N/A");
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->steps_count);
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->submissions);
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,"N/A");
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,"N/A");
			}
			else
			{
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->name);
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,"+".$countries[$reportrow->country]->isd_code." ".$reportrow->phone);
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->email);
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->city);
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$countries[$reportrow->country]->country_name);
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->item_name);
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->participant_name);
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->steps_count);
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->submissions);
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->day);
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("d M Y",strtotime($reportrow->yatra_date)));
			}

			$i++;
			$sno++;
		}
		return $objPHPExcel;
	}


	public function getVishwashantiOrderItems($donation_ids=array())
	{
		$toBeReturnArray = [];
		if(is_array($donation_ids) && count($donation_ids)>0)
		{
			$defaultDb=$this->load->database("default",true,false);
			$defaultDb->select("o.order_number, oi.id as order_item_id, oi.order_id, oi.order_type, oi.item_id, oi.item_name, oi.price, oi.schedule_dates, oi.family_member_details, oi.gift_friend_name, oi.name_of_family_type, oi.pooja_on_swamiji, oi.pooja_on_teertha_swamiji, oi.family_members, oi.friend_or_other_1, oi.friend_or_other_2, oi.friend_or_other_3, oi.friend_or_other_4, oi.friend_or_other_5, oi.friend_or_other_6, oi.friend_or_other_7, oi.friend_or_other_8, oi.friend_or_other_9, oi.friend_or_other_10, oi.appji_member_name, oi.order_id");
			$defaultDb->from("order_items as oi");
			$defaultDb->join("orders as o","o.id = oi.order_id", 'left');
	    	$defaultDb->where_in("oi.item_id", $donation_ids);
	    	$defaultDb->where("oi.order_type",2);
	    	$defaultDb->where("o.payment_status",1);
	    	$defaultDb->where("o.user_id",$this->currentUser->id);
			$toBeReturnArray = $defaultDb->get()->result_array();
		}
		return $toBeReturnArray;
	}

	public function getVishwashantiOrderItemDetails($order_item_id=0)
	{
		$toBeReturnArray = [];
		if($order_item_id>0)
		{
			$defaultDb=$this->load->database("default",true,false);
			$defaultDb->select("oi.id as order_item_id, oi.order_id, oi.order_type, oi.item_id, oi.item_name, oi.price, oi.schedule_dates, oi.family_member_details, oi.gift_friend_name, oi.name_of_family_type, oi.pooja_on_swamiji, oi.pooja_on_teertha_swamiji, oi.family_members, oi.friend_or_other_1, oi.friend_or_other_2, oi.friend_or_other_3, oi.friend_or_other_4, oi.friend_or_other_5, oi.friend_or_other_6, oi.friend_or_other_7, oi.friend_or_other_8, oi.friend_or_other_9, oi.friend_or_other_10, oi.appji_member_name, oi.order_id");
			$defaultDb->from("order_items as oi");
	    	$defaultDb->where("oi.id", $order_item_id);
			$toBeReturnArray = $defaultDb->get()->row_array();

			if(!empty($toBeReturnArray))
			{
				$toBeReturnArray['participant_name'] = $toBeReturnArray['family_member_details'];
				if($toBeReturnArray['participant_name']=="" && $toBeReturnArray['name_of_family_type']==0)
				{
					$toBeReturnArray['participant_name'] = "Sri Ganapathy Sachchidananda Swamiji";
				}
				if($toBeReturnArray['participant_name']=="" && $toBeReturnArray['name_of_family_type']==1)
				{
					$toBeReturnArray['participant_name'] = "Sri Datta Vijayananda Teertha Swamiji";
				}
			}
		}
		return $toBeReturnArray;
	}
}
?>