<?PHP
class Vedoktashanti_admin_user_replies_model extends CI_Model {

    var $tableName="vedoktashanti_admin_user_replies";
    var $vedoktaShantiDB='';
    function __construct()
    {
        parent::__construct();
        $this->vedoktaShantiDB=$this->load->database("site_services",true,false);
    }
    public function delete($fid)
    {
        $this->vedoktaShantiDB->where("vedoktashanti_id",$fid);
        $this->vedoktaShantiDB->delete($this->tableName);
    }
    public function getReplies($fid)
    {
        $this->vedoktaShantiDB->where("vedoktashanti_id",$fid);
        $this->vedoktaShantiDB->order_by("date","desc");
        $q=$this->vedoktaShantiDB->get($this->tableName);

        $result['replies']= $q->result();
        $result['users']=array();

        $userIds=array();
        foreach ($q->result() as $row)
        {
            unset($row->subject);
            if(!in_array($row->userid,$userIds))
                $userIds[]=$row->userid;
        }
        if(!empty($userIds))
        {
            $userRecords=$this->users_model->getUsersByIds($userIds);
            foreach ($userRecords as $userRecord)
            {
                unset($userRecord->pass_hash);
                unset($userRecord->address);
                unset($userRecord->dob);
                unset($userRecord->deleted);
                unset($userRecord->suspended);
                unset($userRecord->ashram_id);
                unset($userRecord->satsang_id);
                unset($userRecord->birthstar);
                unset($userRecord->raasi);
                unset($userRecord->gender);
                unset($userRecord->status);
                unset($userRecord->admin);
                if($this->currentUser->profilepic!="")
                    $userRecord->profilepic=$this->currentUser->profilepic;
                unset($userRecord->user_title);
                $result['users'][$userRecord->id]=$userRecord;
            }
        }
        return $result;
    }
    public function captureReply($fid,$message,$vedoktashantiData,$admin=0)
    {
        $app=0;
        if(isset($GLOBALS['app']) && $GLOBALS['app']==1)
        {
            $app=1;
        }

        $this->vedoktaShantiDB->insert('vedoktashanti_admin_user_replies',
                        array('vedoktashanti_id' => $fid,
                                'userid' =>$this->currentUser->id,
                                'content' =>$message,
                                'date' =>date("Y:m:d H:i:s"),
                                'admin' =>$admin,
                                'app'=>$app
                                )
                        );
        $last_insert_id = $this->vedoktaShantiDB->insert_id();
        if(isset($_FILES['file1']) || isset($_FILES['file2']) || isset($_FILES['file3']))
        {
            $this->load->library("s3",array("accessKey"=>aws_s3_access_key, "secretKey"=>aws_s3_secret_key, "useSSL"=>false, "endpoint"=>"s3.amazonaws.com"));
            if(isset($_FILES['file1']))
            {
                $fname=$_FILES['file1']['name'];
                $ext=pathinfo ($_FILES['file1']['name'],PATHINFO_EXTENSION);
                $ext = strtolower($ext);
                $newname='vedokta_reply_'.$fid.'_'.substr(md5(mt_rand()), 0, 16).".".$ext;
                $tempPath=$_FILES['file1']['tmp_name'];
                $tempName=basename($_FILES['file1']['tmp_name']);
                $amazonUri="vedokta_replies/".date("Y")."/";
                $this->s3->putObjectFile($tempPath,aws_s3_bucket_name,$amazonUri.$newname,S3::ACL_PUBLIC_READ, array(), array());
                $this->vedoktaShantiDB->where("id",$last_insert_id);
                $this->vedoktaShantiDB->update($this->tableName, array( "file"=>$newname ));
            }
            if(isset($_FILES['file2']))
            {
                $fname=$_FILES['file2']['name'];
                $ext=pathinfo ($_FILES['file2']['name'],PATHINFO_EXTENSION);
                $ext = strtolower($ext);
                $newname='vedokta_reply_'.$fid.'_'.substr(md5(mt_rand()), 0, 16).".".$ext;
                $tempPath=$_FILES['file2']['tmp_name'];
                $tempName=basename($_FILES['file2']['tmp_name']);
                $amazonUri="vedokta_replies/".date("Y")."/";
                $this->s3->putObjectFile($tempPath,aws_s3_bucket_name,$amazonUri.$newname,S3::ACL_PUBLIC_READ, array(), array());
                $this->vedoktaShantiDB->where("id",$last_insert_id);
                $this->vedoktaShantiDB->update($this->tableName, array( "file2"=>$newname ));
            }
            if(isset($_FILES['file3']))
            {
                $fname=$_FILES['file3']['name'];
                $ext=pathinfo ($_FILES['file3']['name'],PATHINFO_EXTENSION);
                $ext = strtolower($ext);
                $newname='vedokta_reply_'.$fid.'_'.substr(md5(mt_rand()), 0, 16).".".$ext;
                $tempPath=$_FILES['file3']['tmp_name'];
                $tempName=basename($_FILES['file3']['tmp_name']);
                $amazonUri="vedokta_replies/".date("Y")."/";
                $this->s3->putObjectFile($tempPath,aws_s3_bucket_name,$amazonUri.$newname,S3::ACL_PUBLIC_READ, array(), array());
                $this->vedoktaShantiDB->where("id",$last_insert_id);
                $this->vedoktaShantiDB->update($this->tableName, array( "file3"=>$newname ));
            }
        }

        if($admin==0)
        {
            $this->vedoktashanti_model->messageRead($fid,0);
            if($vedoktashantiData->fstatus==3)
                $this->vedoktashanti_model->changeStatus($fid,$vedoktashantiData,2);
        }
        else
        {
            $this->vedoktashanti_model->messageReadUser($fid,0);
            if($vedoktashantiData->fstatus!=4)
                $this->vedoktashanti_model->changeStatus($fid,$vedoktashantiData,3);
        }
        $this->load->library("email_extension");
        $data['content']=$message;
        $data['vedoktashantiData']=$vedoktashantiData;
        $data['replyData']=$this->replyData($last_insert_id);
        $data['repliesData']=$this->vedoktashanti_admin_user_replies_model->getReplies($fid);
        ob_start();
        $this->load->view("vedoktashanti/admin/_email_reply_user",$data);
        $content=ob_get_clean();
        $subject="Your VedoktaShanti request has been updated: ".$vedoktashantiData->vedoktashanti_id;
        $this->email_extension->sendMail($this->service,$vedoktashantiData->user_id,$subject,$content,1);

        $data['ReplyMailToAdmin']= 'Yes';
        ob_start();
        $this->load->view("vedoktashanti/admin/_email_reply_user",$data);
        $content=ob_get_clean();
        $adminemailsarr = vedoktashanti_cc_emails;
        if(vedoktashanti_admin_email && vedoktashanti_admin_email!='')
        {
            array_push($adminemailsarr,vedoktashanti_admin_email);
        }
        foreach($adminemailsarr as $this_aminemail)
        {
            $this->email_extension->sendMailGuest('vedoktashanti',"Admin",$this_aminemail, site_name_string1." -  Update to VedoktaShanti request: ".$vedoktashantiData->vedoktashanti_id,$content,"",1);
        }
            
        $this->updatevedoktashantiCount($fid);
        return date("d M Y h:i A");
    }
    public function captureMailReply($fid,$vedoktashantiData,$subject,$content)
    {
        $this->vedoktaShantiDB->insert('vedoktashanti_admin_user_replies',
                        array('vedoktashanti_id' => $fid,
                                'userid' =>$this->currentUser->id,
                                'content' =>$content,
                                'subject'=>$subject,
                                'date' =>date("Y:m:d H:i:s"),
                                'admin' =>1
                                )
                        );
        $last_insert_id = $this->vedoktaShantiDB->insert_id();
        if(isset($_FILES['file1']) || isset($_FILES['file2']) || isset($_FILES['file3']))
        {
            $this->load->library("s3",array("accessKey"=>aws_s3_access_key, "secretKey"=>aws_s3_secret_key, "useSSL"=>false, "endpoint"=>"s3.amazonaws.com"));
            if(isset($_FILES['file1']) && !empty($_FILES['file1']['name']))
            {
                $fname=$_FILES['file1']['name'];
                $ext=pathinfo ($_FILES['file1']['name'],PATHINFO_EXTENSION);
                $ext = strtolower($ext);
                $newname='vedokta_reply_'.$fid.'_'.substr(md5(mt_rand()), 0, 16).".".$ext;
                $tempPath=$_FILES['file1']['tmp_name'];
                $tempName=basename($_FILES['file1']['tmp_name']);
                $amazonUri="vedokta_replies/".date("Y")."/";
                $this->s3->putObjectFile($tempPath,aws_s3_bucket_name,$amazonUri.$newname,S3::ACL_PUBLIC_READ, array(), array());
                $this->vedoktaShantiDB->where("id",$last_insert_id);
                $this->vedoktaShantiDB->update($this->tableName, array( "file"=>$newname ));
            }
            if(isset($_FILES['file2']) && !empty($_FILES['file2']['name']) )
            {
                $fname=$_FILES['file2']['name'];
                $ext=pathinfo ($_FILES['file2']['name'],PATHINFO_EXTENSION);
                $ext = strtolower($ext);
                $newname='vedokta_reply_'.$fid.'_'.substr(md5(mt_rand()), 0, 16).".".$ext;
                $tempPath=$_FILES['file2']['tmp_name'];
                $tempName=basename($_FILES['file2']['tmp_name']);
                $amazonUri="vedokta_replies/".date("Y")."/";
                $this->s3->putObjectFile($tempPath,aws_s3_bucket_name,$amazonUri.$newname,S3::ACL_PUBLIC_READ, array(), array());
                $this->vedoktaShantiDB->where("id",$last_insert_id);
                $this->vedoktaShantiDB->update($this->tableName, array( "file2"=>$newname ));
            }
            if(isset($_FILES['file3']) && !empty($_FILES['file3']['name']))
            {
                $fname=$_FILES['file3']['name'];
                $ext=pathinfo ($_FILES['file3']['name'],PATHINFO_EXTENSION);
                $ext = strtolower($ext);
                $newname='vedokta_reply_'.$fid.'_'.substr(md5(mt_rand()), 0, 16).".".$ext;
                $tempPath=$_FILES['file3']['tmp_name'];
                $tempName=basename($_FILES['file3']['tmp_name']);
                $amazonUri="vedokta_replies/".date("Y")."/";
                $this->s3->putObjectFile($tempPath,aws_s3_bucket_name,$amazonUri.$newname,S3::ACL_PUBLIC_READ, array(), array());
                $this->vedoktaShantiDB->where("id",$last_insert_id);
                $this->vedoktaShantiDB->update($this->tableName, array( "file3"=>$newname ));
            }
        }
        $this->load->library("email_extension");
        $data['content']=$content;
        $data['vedoktashantiData']=$vedoktashantiData;
        $data['replyData']=$this->replyData($last_insert_id);
        $data['repliesData']=$this->vedoktashanti_admin_user_replies_model->getReplies($fid);
        ob_start();
        $this->load->view("vedoktashanti/admin/_email_reply_guest",$data);
        $content=ob_get_clean();
        $this->email_extension->sendMailGuest($this->service,$vedoktashantiData->name,$vedoktashantiData->email, site_name_string1." -  Update to VedoktaShanti request: ".$vedoktashantiData->vedoktashanti_id,$content);
        $data['ReplyMailToAdmin']= 'Yes';
        ob_start();
        $this->load->view("vedoktashanti/admin/_email_reply_user",$data);
        $content=ob_get_clean();
        $adminemailsarr = vedoktashanti_cc_emails;
        if(vedoktashanti_admin_email && vedoktashanti_admin_email!='')
        {
            array_push($adminemailsarr,vedoktashanti_admin_email);
        }
        foreach($adminemailsarr as $this_aminemail)
        {
            $this->email_extension->sendMailGuest('vedoktashanti',"Admin",$this_aminemail, site_name_string1." -  Update to VedoktaShanti request: ".$vedoktashantiData->vedoktashanti_id, $content);
        }
        $this->updatevedoktashantiCount($fid);
        return 1;
    }
    private function updatevedoktashantiCount($fid)
    {
        $this->vedoktaShantiDB->where("vedoktashanti_id",$fid);
        $count=$this->vedoktaShantiDB->count_all_results($this->tableName);
        $this->vedoktashanti_model->updateCount($fid,$count);
    }

    public function replyData($replyId)
    {
        $q = $this->vedoktaShantiDB->where("id",$replyId)->get($this->tableName);
        if($q->num_rows()>0)
        {
            return $q->row();
        }
        else
        {
            return false;
        }
    }
}
?>