<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Users_model extends CI_Model 
{
	var $tableName='users';
	var $auth_check="";
	public function __construct() 
	{
		if(isset($this->agent))
		{
			if ($this->agent->is_browser())
			{
				$this->bagent = $this->agent->browser().' '.$this->agent->version();
			}
			elseif ($this->agent->is_robot())
			{
				$this->bagent= $this->agent->robot();
			}
			elseif ($this->agent->is_mobile())
			{
				$this->bagent= $this->agent->mobile();
			}
			else
			{
				$this->bagent= 'Unidentified User Agent';
			}
		}
		else
		{
			$this->bagent= 'Unidentified User Agent';
		}
		
		parent::__construct();
		$this->auth_check=$this->load->database("sso_auth",true);
    }
    public function getCount()
	{
		$this->db->select('count(id) as c');
		$this->db->where("admin",0);
		$this->db->where('deleted',0);
		$q=$this->db->get($this->tableName)->row();
		return $q->c;
	}
	public function getSSOUserID($user_id)
	{
		$this->db->select('sso_user_id');
		$this->db->where("id",$user_id);
		$q=$this->db->get($this->tableName)->row();
		return $q->sso_user_id;
	}
	public function getAdminCount()
	{
		$this->db->select('count(id) as c');
		$this->db->where("admin",1);
		$this->db->where('deleted',0);
		$q=$this->db->get($this->tableName)->row();
		return $q->c;

	}
	public function getCountries()
	{
		$this->db->select("country_id,country");
		$this->db->from($this->tableName);
		$this->db->group_by("country_id");
		$this->db->where("country !=",'');
		$this->db->where("country_id !=",'');
		$q=$this->db->get();
		return $q->result();
	}
	public function getCountriesDeleted()
	{
		$this->db->select("country_id,country");
		$this->db->from($this->tableName);
		$this->db->group_by("country_id");
		$this->db->where("country !=",'');
		$this->db->where("country_id !=",'');
		$this->db->where("deleted",1);
		$q=$this->db->get();
		return $q->result();
	}

	public function updateProfileaddress($userId,$updateData)
	{
		$this->db->where("id",$userId);
		$uq = $this->db->get($this->tableName);
		$r=$uq->row();
		if($r)
		{
			$this->db->where("id",$userId);
			$this->db->update($this->tableName,$updateData);
			$this->auth_check->where("id",$r->sso_user_id);
			$this->auth_check->update("users",$updateData);

			$this->load->library("dattaid_api");
        	$response = $this->dattaid_api->call($r->sso_user_id);
		}
	}
    public function listUsersAjaxAdmin($admin=0,$excel=0)
	{
		$countries=$this->locations_model->getCountries(true);

		$roles=$this->getRoles();
		$rolesArray=array();
		foreach ($roles as $rl)
		{
			$rolesArray[$rl->id]=$rl->role;
		}
			
		$i=0;
		$query1=$this->db;
		if($excel==0)
			$query1->select("count(id) as c");
		step1:
		$i++;
		if($i==2 || $excel==1)
		{
			$query1->select("*");
		}
		$query1->where("admin",$admin);
		$query1->where("deleted",0);
		$query1->where("id !=",0);

		$query1->from($this->tableName);

		$preData="Search Keywords: ";
				
		if(isset($_POST['search_text']) && trim($_POST['search_text'])!='' && 
		in_array($_POST['search_col'],$GLOBALS['current_acl']['search_columns']))
		{
			if(isset($_POST['search_col']) && ($_POST['search_col']=='id'))
			{
				$preData.="Admin UID";
			}
			else
			{
				$preData.=$GLOBALS['current_acl']['excel_columns'][$_POST['search_col']];
			}
			$query1->like($_POST['search_col'],trim($_POST['search_text']));
				$preData.=" containing ";
			/* if($_POST['wild']=='starts')
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']),'after');
				$preData.=" starting with ";
			}
			else if($_POST['wild']=='ends')
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']),'before');
				$preData.=" ending with ";
			}
			else
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']));
				$preData.=" containing ";
			} */
			$preData.='"'.$_POST['search_text'].'"';
		}

		$preData.="\nNot logged in since: ";
		if(isset($_POST['notloggedin']) && in_array($_POST['notloggedin'],array(1,7,30,60,90)))
		{
			$this->db->where("last_logged_in <",date("Y:m:d H:i:s",strtotime("-".$_POST['notloggedin']." Days")));
			$preData.=$_POST['notloggedin']." Day(s)";
		}
		else
		{
			$preData.="-";
		}
		

		$preData.="\nCountry: ";

		if(isset($_POST['country']) && $_POST['country']!='')
		{
			$countryData=$this->locations_model->getCountryByCode($_POST['country']);
			if(!empty($countryData))
			{
				$preData.=$countryData->country_name;
				$query1->where("country_id",$_POST['country']);
			}
		}

		$preData.="\nRegistered from: ";

		if(isset($_POST['registered_site']) && $_POST['registered_site']!='')
		{
			$preData.=$_POST['registered_site'];
			$query1->where("registered_site",$_POST['registered_site']);
		}

		$preData.="\nEmail Verified: ";
		if(isset($_POST['email_verified']) && is_numeric($_POST['email_verified']) && in_array($_POST['email_verified'],array(0,1)))
		{
			$query1->where("email_verified",$_POST['email_verified']);
			if($_POST['email_verified']==0)
			{
				$preData.="Not Verified";
			}
			else
			{
				$preData.="Verified";
			}
		}
		else
		{
			$preData.="All Status";
		}

		$preData.="\nUser Status: ";
		if(isset($_POST['status']) && is_numeric($_POST['status']) && in_array($_POST['status'],array(0,1,2)))
		{
			$query1->where("status",$_POST['status']);
			if($_POST['status']==0)
			{
				$preData.="Inactive";
			}
			else if($_POST['status']==2)
			{
				$preData.="Suspended";
			}
			else
			{
				$preData.="Active";
			}
		}
		else
		{
			$preData.="All Status ";
		}

		$preData.="\nFrom Date: ";
		if(isset($_POST['from_date']) && $_POST['from_date']!='')
		{
			$query1->where("date(registered_on) >=",date("Y-m-d",strtotime($_POST['from_date'])));
			$preData.=$_POST['from_date'];
		}
		
		$preData.="\nTo Date: ";
		if(isset($_POST['to_date']) && $_POST['to_date']!='')
		{
			$query1->where("date(registered_on) <=",date("Y-m-d",strtotime($_POST['to_date'])));
			$preData.=$_POST['to_date'];
		}

		if($admin==1)
		{
			$preData.="\nRole: ";
			if(isset($_POST['role']) && is_numeric($_POST['role']))
			{
				$query1->where("FIND_IN_SET(".$_POST['role'].",roles) !=",'null');
				$preData.=$rolesArray[$_POST['role']];
			}
			else
			{
				$preData.="All Roles";
			}
		}

		if($excel==1)
		{
			if(isset($_POST['order_by']) && in_array($_POST['order_by'],$GLOBALS['current_acl']['sort_columns']))
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by($_POST['order_by'],$_POST['dir']);
				else
					$query1->order_by($_POST['order_by'],'asc');
			}
			else
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by('username',$_POST['dir']);
				else
					$query1->order_by('username',"asc");
			}
			$sql=$query1->get_compiled_select();

			if($admin==0)
			$requestResp=$this->excel_exports_model->makeRequest('default',"model","user/users_model",$sql,$this->currentUser,"default",$_POST,"All Users",$preData);
			else
				$requestResp=$this->excel_exports_model->makeRequest('default',"model","user/users_model",$sql,$this->currentUser,"default",$_POST,"All Admin Users",$preData,2);
			return $requestResp;
		}
		
		if($i==1)
		{
			$temp_result = $query1->get()->row();
			$rtn['recordsTotal'] = $temp_result->c;
			$rtn['recordsFiltered'] = $temp_result->c;
			goto step1;
		}

		$dir='asc';

		if(isset($_POST['order'][0]['dir']) && in_array($_POST['order'][0]['dir'],$GLOBALS['current_acl']['dir']))
			$dir=$_POST['order'][0]['dir'];

		$order_by='';
		if(isset($_POST['order'][0]['column']) && is_numeric($_POST['order'][0]['column']))
		{
			$col_num=round(abs($_POST['order'][0]['column']));
			$col_name=$_POST['columns'][$col_num]['name'];
			if($col_num && in_array($col_name,$GLOBALS['current_acl']['sort_columns']))
				$query1->order_by($col_name,$dir);
			else
				$query1->order_by('username',$dir);
		}
		else
		{
			$query1->order_by('username',$dir);
		}

		$start=0;
		$length=10;
		if(isset($_POST['start']) && is_numeric($_POST['start']))
		{
			if(round(abs($_POST['start']))%10==0)
			$start=round(abs($_POST['start']));
		}
		if(isset($_POST['length']) && is_numeric($_POST['length']) && in_array($_POST['length'],array(10,20,50,100)))
		{
			$length=abs($_POST['length']);
			if(!$length)
				$length=10;
		}

		$query1->limit($length,$start);

		$rtn['data']=$query1->get()->result_array();

		if($admin==1)
		{
			$satsangIds=array();
			$qs=$this->db->get("satsangs");
			foreach ($qs->result() as $satsangRow)
			{
				$satsangIds[$satsangRow->id]=$satsangRow->name;
			}
			
			$ashramIds=array();
			$qa=$this->db->get("ashrams");
			foreach ($qa->result() as $ashramRow)
			{
				$ashramIds[$ashramRow->id]=$ashramRow->name;
			}
		}

		$temp=array();
		$sno=$start+1;
		$c=0;
		foreach ($rtn['data'] as $row) 
		{
			unset($rtn['data'][$c]['pass']);
			unset($rtn['data'][$c]['conf_key']);
			unset($rtn['data'][$c]['forgot_key']);
			unset($rtn['data'][$c]['pin']);
			unset($rtn['data'][$c]['pin_copy']);

			$rtn['data'][$c]=$row;
			if($row['country_id']!='')
			{
				$cntid=$row['country_id'];
				if(isset($countries[$cntid]->isd_code))
					$rtn['data'][$c]['isd_code']=$countries[$cntid]->isd_code;
				else
					$rtn['data'][$c]['isd_code']="N/A";
			}
			$rtn['data'][$c]['sno']=$sno;
			$rtn['data'][$c]['registered_on']=date("d M Y",strtotime($row['registered_on']));
			$rtn['data'][$c]['ashram_satsang_name']='N/A';
			if($admin==1)
			{
				if($row['ashram_id'] && isset($ashramIds[$row['ashram_id']]))
					$rtn['data'][$c]['ashram_satsang_name']=$ashramIds[$row['ashram_id']];
				if($row['satsang_id'] && isset($satsangIds[$row['satsang_id']]))
					$rtn['data'][$c]['ashram_satsang_name']=$satsangIds[$row['satsang_id']];
			}
			$sno++;
			$c++;
		}
		$rtn['page_records']=$c;
		return $rtn;
	}

	public function listUsersPublicAdmin()
	{			
		$i=0;
		$query1=$this->db;
		$query1->select("count(id) as c");
		step1:
		$i++;
		if($i==2)
		{
			$query1->select("*");
		}
		$query1->where("admin",0);
		$query1->where("status",1);
		$query1->where("deleted",0);

		$query1->from($this->tableName);

		if(isset($_POST['search_text']) && trim($_POST['search_text'])!='' && 
		in_array($_POST['search_col'],$GLOBALS['current_acl']['search_columns']))
		{
			$query1->like($_POST['search_col'],trim($_POST['search_text']));
			/* if($_POST['wild']=='starts')
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']),'after');
			}
			else if($_POST['wild']=='ends')
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']),'before');
			}
			else
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']));
			} */
		}


		if($i==1)
		{
			$temp_result = $query1->get()->row();
			$rtn['recordsTotal'] = $temp_result->c;
			$rtn['recordsFiltered'] = $temp_result->c;
			goto step1;
		}

		$dir='asc';

		if(isset($_POST['order'][0]['dir']) && in_array($_POST['order'][0]['dir'],$GLOBALS['current_acl']['dir']))
			$dir=$_POST['order'][0]['dir'];

		$order_by='';
		if(isset($_POST['order'][0]['column']) && is_numeric($_POST['order'][0]['column']))
		{
			$col_num=round(abs($_POST['order'][0]['column']));
			$col_name=$_POST['columns'][$col_num]['name'];
			if($col_num && in_array($col_name,$GLOBALS['current_acl']['sort_columns']))
				$query1->order_by($col_name,$dir);
			else
				$query1->order_by('username',$dir);
		}
		else
		{
			$query1->order_by('username',$dir);
		}

		$start=0;
		$length=10;
		if(isset($_POST['start']) && is_numeric($_POST['start']))
		{
			if(round(abs($_POST['start']))%10==0)
			$start=round(abs($_POST['start']));
		}
		if(isset($_POST['length']) && is_numeric($_POST['length']) && in_array($_POST['length'],array(10,20,50,100)))
		{
			$length=abs($_POST['length']);
			if(!$length)
				$length=10;
		}

		$query1->limit($length,$start);

		$rtn['data']=$query1->get()->result_array();
		$rtn['q']=$query1->last_query();
		$temp=array();
		$sno=$start+1;
		$c=0;
		foreach ($rtn['data'] as $row) 
		{
			unset($rtn['data'][$c]['pass']);
			unset($rtn['data'][$c]['conf_key']);
			unset($rtn['data'][$c]['forgot_key']);
			unset($rtn['data'][$c]['pin']);
			unset($rtn['data'][$c]['pin_copy']);
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['sno']=$sno;
			$sno++;
			$c++;
		}
		$rtn['page_records']=$c;
		return $rtn;
	}
	public function listDeletedUsers($excel=0)
	{

		$roles=$this->getRoles();
		$rolesArray=array();
		foreach ($roles as $rl)
		{
			$rolesArray[$rl->id]=$rl->role;
		}

		$i=0;
		$query1=$this->db;
		if($excel==0)
			$query1->select("count(id) as c");
		step1:
		$i++;
		if($excel==1 || $i==2)
		{
			$query1->select("*");
		}

		$query1->where("deleted",1);

		$query1->from($this->tableName);

		$preData="Search Keywords: ";
				
		if(isset($_POST['search_text']) && trim($_POST['search_text'])!='' && 
		in_array($_POST['search_col'],$GLOBALS['current_acl']['search_columns']))
		{
			$preData.=$GLOBALS['current_acl']['excel_columns'][$_POST['search_col']];
			$query1->like($_POST['search_col'],trim($_POST['search_text']));
				$preData.=" containing ";
			/* if($_POST['wild']=='starts')
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']),'after');
				$preData.=" starting with ";
			}
			else if($_POST['wild']=='ends')
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']),'before');
				$preData.=" ending with ";
			}
			else
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']));
				$preData.=" containing ";
			} */
			$preData.='"'.$_POST['search_text'].'"';
		}

		$preData.="\nCountry: ";

		if(isset($_POST['country']) && $_POST['country']!='')
		{
			$countryData=$this->locations_model->getCountryByCode($_POST['country']);
			if(!empty($countryData))
			{
				$preData.=$countryData->country_name;
				$query1->where("country_id",$_POST['country']);
			}
		}

		$preData.="\nFrom Date: ";
		if(isset($_POST['from_date']) && $_POST['from_date']!='')
		{
			$query1->where("date(deleted_on) >=",date("Y-m-d",strtotime($_POST['from_date'])));
			$preData.=$_POST['from_date'];
		}
		
		$preData.="\nTo Date: ";
		if(isset($_POST['to_date']) && $_POST['to_date']!='')
		{
			$query1->where("date(deleted_on) <=",date("Y-m-d",strtotime($_POST['to_date'])));
			$preData.=$_POST['to_date'];
		}


		$preData.="\nRole: ";
		if(isset($_POST['role']) && is_numeric($_POST['role']))
		{
			$query1->where("FIND_IN_SET(".$_POST['role'].",roles) !=",'null');
			$preData.=$rolesArray[$_POST['role']];
		}
		else
		{
			$preData.="All Roles";
		}

		if($excel==1)
		{
			if(isset($_POST['order_by']) && in_array($_POST['order_by'],$GLOBALS['current_acl']['sort_columns']))
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by($_POST['order_by'],$_POST['dir']);
				else
					$query1->order_by($_POST['order_by'],'desc');
			}
			else
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by('username',$_POST['dir']);
				else
					$query1->order_by('username',"desc");
			}
			$sql=$query1->get_compiled_select();

			$requestResp=$this->excel_exports_model->makeRequest('default',"model","user/users_model",$sql,$this->currentUser,"default",$_POST,"All Deleted Users",$preData,3);
			return $requestResp;
		}
		
		if($i==1)
		{
			$temp_result = $query1->get()->row();
			$rtn['recordsTotal'] = $temp_result->c;
			$rtn['recordsFiltered'] = $temp_result->c;
			goto step1;
		}

		$dir='desc';

		if(isset($_POST['order'][0]['dir']) && in_array($_POST['order'][0]['dir'],$GLOBALS['current_acl']['dir']))
			$dir=$_POST['order'][0]['dir'];

		$order_by='';
		if(isset($_POST['order'][0]['column']) && is_numeric($_POST['order'][0]['column']))
		{
			$col_num=round(abs($_POST['order'][0]['column']));
			$col_name=$_POST['columns'][$col_num]['name'];
			if($col_num && in_array($col_name,$GLOBALS['current_acl']['sort_columns']))
				$query1->order_by($col_name,$dir);
			else
				$query1->order_by('username',$dir);
		}
		else
		{
			$query1->order_by('username',$dir);
		}

		$start=0;
		$length=10;
		if(isset($_POST['start']) && is_numeric($_POST['start']))
		{
			if(round(abs($_POST['start']))%10==0)
			$start=round(abs($_POST['start']));
		}
		if(isset($_POST['length']) && is_numeric($_POST['length']) && in_array($_POST['length'],array(10,20,50,100)))
		{
			$length=abs($_POST['length']);
			if(!$length)
				$length=10;
		}

		$query1->limit($length,$start);

		$rtn['data']=$query1->get()->result_array();
		//$rtn['q']=$query1->last_query();
		$temp=array();
		$sno=$start+1;
		$c=0;
		foreach ($rtn['data'] as $row) 
		{
			unset($rtn['data'][$c]['pass']);
			unset($rtn['data'][$c]['conf_key']);
			unset($rtn['data'][$c]['forgot_key']);
			unset($rtn['data'][$c]['pin']);
			unset($rtn['data'][$c]['pin_copy']);
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['sno']=$sno;
			$rtn['data'][$c]['deleted_on']=date("d M Y h:i A",strtotime($row['deleted_on']));
			$sno++;
			$c++;
		}
		$rtn['page_records']=$c;
		return $rtn;
	}

	//0 = All, 1 = Admin, 2 = User
	public function getRoles($flag=0)
	{
		if($flag==1)
		{
			$this->db->where("admin",1);
		}
		else if($flag==2)
		{
			$this->db->where("admin",2);
		}
		$q=$this->db->get("user_roles");
		return $q->result();
	}

	public function ssouserData($id)
	{
		$this->auth_check->select("id,username,profilepic,user_title,email,role,roles,firstname,middlename,lastname,profession,gothram,birthstar,raasi,gender,dob,address,address1,address2,country_id,city,state,block_sms,country,zipcode,phoneno,lang_id,admin,first_logged_in,status,last_logged_in,profile_complete,security_complete,currency,email_verified,suspended,deleted,family_details,conf_key,receive_newsletters,ashram_id,satsang_id,allow_global,email_changed_on,pan_number,is_currency_specific,currencies,aadhaar_number,tin_number,passport_number,voter_epic_number,driving_license_number,ration_card_number,email_bounce_count");
		$this->auth_check->where("id",$id);
		$this->auth_check->where("deleted",0);
		$q=$this->auth_check->get($this->tableName);
		return $q->row();
	}

	public function userData($id)
	{
		$this->db->select("id,username,profilepic,user_title,email,role,roles,firstname,middlename,lastname,profession,gothram,birthstar,raasi,gender,dob,address,address1,address2,country_id,city,state,block_sms,country,zipcode,phoneno,lang_id,admin,first_logged_in,status,last_logged_in,profile_complete,security_complete,currency,email_verified,suspended,deleted,family_details,conf_key,receive_newsletters,sso_user_id,ashram_id,satsang_id,allow_global,pan_number,is_currency_specific,currencies,aadhaar_number,tin_number,passport_number,voter_epic_number,driving_license_number,ration_card_number,email_bounce_count");
		$this->db->where("id",$id);
		$this->db->where("deleted",0);
		$q=$this->db->get($this->tableName);
		return $q->row();
	}

	public function ProfileuserData($id)
	{
		$this->db->select("id,username,sso_user_id,profilepic,user_title,email,role,roles,firstname,middlename,lastname,profession,gothram,birthstar,raasi,gender,dob,address,address1,address2,country_id,city,state,block_sms,country,zipcode,phoneno,lang_id,admin,first_logged_in,status,last_logged_in,profile_complete,security_complete,currency,email_verified,suspended,deleted,family_details,conf_key,receive_newsletters,ashram_id,satsang_id,allow_global,pan_number,is_currency_specific,currencies,aadhaar_number,tin_number,passport_number,voter_epic_number,driving_license_number,ration_card_number,email_bounce_count");
		$this->db->where("sso_user_id",$id);
		$this->db->where("deleted",0);
		$q=$this->db->get($this->tableName);
		return $q->row();
	}

	public function adminUserData($id)
	{
		$this->db->select("id,username,profilepic,user_title,email,role,roles,firstname,middlename,lastname,profession,gothram,birthstar,raasi,gender,dob,address,address1,address2,country_id,city,state,block_sms,country,zipcode,phoneno,lang_id,admin,first_logged_in,status,last_logged_in,profile_complete,security_complete,currency,email_verified,suspended,deleted,family_details,conf_key,receive_newsletters,ashram_id,satsang_id,sso_user_id,pan_number,is_currency_specific,currencies,aadhaar_number,tin_number,passport_number,voter_epic_number,driving_license_number,ration_card_number,email_bounce_count");
		$this->db->where("id",$id);
		$this->db->where("deleted",0);
		$q=$this->db->get($this->tableName);
		return $q->row();
	}
	public function userDataByEmail($email)
	{
		$this->db->select("id,username,profilepic,user_title,email,role,roles,firstname,middlename,lastname,profession,gothram,birthstar,raasi,gender,dob,address,address1,address2,country_id,city,state,country,zipcode,phoneno,lang_id,admin,first_logged_in,status,last_logged_in,profile_complete,security_complete,currency,email_verified,suspended,deleted,family_details,receive_newsletters,sso_user_id,is_currency_specific,currencies,aadhaar_number,tin_number,passport_number,voter_epic_number,driving_license_number,ration_card_number,email_bounce_count");
		$this->db->where("email",$this->db->escape_str($email));
		$this->db->where("deleted",0);
		$q=$this->db->get($this->tableName);
		return $q->row();
	}
	public function userDataByUsername($username)
	{
		$this->db->select("id,sso_user_id,username,profilepic,user_title,email,role,roles,firstname,middlename,lastname,profession,gothram,birthstar,raasi,gender,dob,address,address1,address2,country_id,city,state,country,zipcode,phoneno,lang_id,admin,first_logged_in,status,last_logged_in,profile_complete,security_complete,currency,email_verified,suspended,deleted,family_details,receive_newsletters,sso_user_id,is_currency_specific,currencies,aadhaar_number,tin_number,passport_number,voter_epic_number,driving_license_number,ration_card_number,email_bounce_count");

		$this->db->where("username",$this->db->escape_str($username));
		$this->db->where("deleted",0);
		$q=$this->db->get($this->tableName);
		return $q->row();
	}

	public function ssouserDataByEmailorUsername($str)
	{
		$this->auth_check->select("id,username,profilepic,user_title,email,role,roles,firstname,middlename,lastname,profession,gothram,birthstar,raasi,gender,dob,address,address1,address2,country_id,city,state,country,zipcode,phoneno,lang_id,admin,first_logged_in,status,last_logged_in,profile_complete,security_complete,currency,email_verified,suspended,deleted,family_details,receive_newsletters,pan_number,is_currency_specific,currencies,aadhaar_number,tin_number,passport_number,voter_epic_number,driving_license_number,ration_card_number,email_bounce_count");
		$this->auth_check->group_start();
		$this->auth_check->where("email",$this->auth_check->escape_str($str));
		$this->auth_check->or_where("username",$this->auth_check->escape_str($str));
		$this->auth_check->group_end();
		$this->auth_check->where("deleted",0);
		$q=$this->auth_check->get($this->tableName);
		return $q->row();
	}

	public function userDataByEmailorUsername($str)
	{
		$this->db->select("id,username,profilepic,user_title,email,role,roles,firstname,middlename,lastname,profession,gothram,birthstar,raasi,gender,dob,address,address1,address2,country_id,city,state,country,zipcode,phoneno,lang_id,admin,first_logged_in,status,last_logged_in,profile_complete,security_complete,currency,email_verified,suspended,deleted,family_details,receive_newsletters,sso_user_id,pan_number,is_currency_specific,currencies,aadhaar_number,tin_number,passport_number,voter_epic_number,driving_license_number,ration_card_number,email_bounce_count");
		$this->db->group_start();
		$this->db->where("email",$this->db->escape_str($str));
		$this->db->or_where("username",$this->db->escape_str($str));
		$this->db->group_end();
		$this->db->where("deleted",0);
		$q=$this->db->get($this->tableName);
		return $q->row();
	}

	public function userDataByEmailorUsernameAuthCheck($str)
	{
		$this->auth_check->select("id,username,profilepic,user_title,email,role,roles,firstname,middlename,lastname,profession,gothram,birthstar,raasi,gender,dob,address,address1,address2,country_id,city,state,country,zipcode,phoneno,lang_id,admin,first_logged_in,status,last_logged_in,profile_complete,security_complete,currency,email_verified,suspended,deleted,family_details,receive_newsletters,sso_user_id,pan_number,is_currency_specific,currencies,aadhaar_number,tin_number,passport_number,voter_epic_number,driving_license_number,ration_card_number,email_bounce_count");
		$this->auth_check->group_start();
		$this->auth_check->where("email",$this->auth_check->escape_str($str));
		$this->auth_check->or_where("username",$this->auth_check->escape_str($str));
		$this->auth_check->group_end();
		$this->auth_check->where("deleted",0);
		$q=$this->auth_check->get($this->tableName);
		return $q->row();
	}

	public function userDataByIDorUsername($str)
	{
		$this->db->select("id,username,profilepic,user_title,email,role,roles,firstname,middlename,lastname,profession,gothram,birthstar,raasi,gender,dob,address,address1,address2,country_id,city,state,country,zipcode,phoneno,lang_id,admin,first_logged_in,status,last_logged_in,profile_complete,security_complete,currency,email_verified,suspended,deleted,family_details,receive_newsletters,sso_user_id,pan_number,is_currency_specific,currencies,aadhaar_number,tin_number,passport_number,voter_epic_number,driving_license_number,ration_card_number,email_bounce_count");
		$this->db->group_start();
		$this->db->where("id",$this->db->escape_str($str));
		$this->db->or_where("username",$this->db->escape_str($str));
		$this->db->group_end();
		$this->db->where("deleted",0);
		$q=$this->db->get($this->tableName);
		return $q->row();
	}

	public function userDataByForgotKey($key)
	{
		$this->db->select("id,username,profilepic,user_title,email,role,roles,firstname,middlename,lastname,profession,gothram,birthstar,raasi,gender,dob,address,address1,address2,country_id,city,state,country,zipcode,phoneno,lang_id,admin,first_logged_in,status,last_logged_in,profile_complete,security_complete,currency,email_verified,forgot_key_expires_on,suspended,deleted,family_details,receive_newsletters,is_currency_specific,currencies,aadhaar_number,tin_number,passport_number,voter_epic_number,driving_license_number,ration_card_number,email_bounce_count");
		$this->db->where("forgot_key",$this->db->escape_str($key));
		$q=$this->db->get($this->tableName);
		return $q->row();
	}
	public function searchUser($text,$field)
	{
		$this->db->where($field,$text);
		$this->db->where("deleted",0);
		$this->db->where("admin",0);
		$q=$this->db->get($this->tableName);
		return $q->row();
	}

	public function createAdmin($username,$firstname,$lastname,$roles,$ashramId=0,$satsangId=0)
	{
		$this->load->helper('string');
		$password=random_string('alpha', 16);
		$password=$this->generatePasswordHash($password);
		if($ashramId!=0)
		{
			$this->auth_check->insert('users',
            array(
            	'username' =>$username,
            	'email' =>$username.email_domain,
            	'firstname' =>$firstname,
				'lastname' =>$lastname,
				'pass_hash'=>$password,
				'admin'=>1,
				'roles'=>$roles,
				'email_verified'=>1,
				'ashram_id'=>$ashramId,
				'registered_on' =>date("Y:m:d H:i:s")
			)
			);
            $idd=$this->auth_check->insert_id();
            $datta_id = date("Y").$idd;
            $this->auth_check->where("id", $idd);
			$this->auth_check->update('users', array('datta_unique_id' => $datta_id) );

			$query=$this->db->insert($this->tableName,
                                array(
                                	'sso_user_id'=>$idd,
                                	'username' =>$username,
                                	'email' =>$username.email_domain,
                                	'firstname' =>$firstname,
									'lastname' =>$lastname,
									'pass_hash'=>$password,
									'admin'=>1,
									'roles'=>$roles,
									'email_verified'=>1,
									'ashram_id'=>$ashramId,
									'registered_on' =>date("Y:m:d H:i:s")
								)
								);
		}
		else if($satsangId!=0)
		{
			$this->auth_check->insert('users',
	            array(
                	'username' =>$username,
                	'email' =>$username.email_domain,
                	'firstname' =>$firstname,
					'lastname' =>$lastname,
					'pass_hash'=>$password,
					'admin'=>1,
					'roles'=>$roles,
					'email_verified'=>1,
					'satsang_id'=>$satsangId,
					'registered_on' =>date("Y:m:d H:i:s")
				)
			);
            $idd=$this->auth_check->insert_id();
            $datta_id = date("Y").$idd;
            $this->auth_check->where("id", $idd);
			$this->auth_check->update('users', array('datta_unique_id' => $datta_id) );

			$query=$this->db->insert($this->tableName,
                                array(
                                	'sso_user_id'=>$idd,
                                	'username' =>$username,
                                	'email' =>$username.email_domain,
                                	'firstname' =>$firstname,
									'lastname' =>$lastname,
									'pass_hash'=>$password,
									'admin'=>1,
									'roles'=>$roles,
									'email_verified'=>1,
									'satsang_id'=>$satsangId,
									'registered_on' =>date("Y:m:d H:i:s")
								)
								);
		}
	}
	public function deleteSatsangAdmin($satsangId=0)
	{
		$this->db->where("satsang_id",$satsangId);
		$this->db->delete($this->tableName);
	}

	public function changeStatus($id,$userData,$newStatus)
	{
		//Update status First
		$this->db->where("id",$id);
		$this->db->update($this->tableName,array('status'=>$newStatus));
		$this->auth_check->where("id",$userData->sso_user_id);
		$this->auth_check->update($this->tableName,array('status'=>$newStatus));
		if($userData->admin==0)
			$this->sendStatusChangeMail($userData,$newStatus,$userData->status);

		$this->updateJapamUser($id);

		return 1;
	}
	private function sendStatusChangeMail($userData,$newStatus,$oldStatus=0)
	{
		$this->load->library("email_extension");
		if($newStatus==1)
		{
			if($oldStatus==0)
			{
				$subject="Your account on ".site_name_string1." is now active : ".$userData->username;
				$data['userData']=$userData;
				ob_start();
				$this->load->view("users/admin/_email_active_firsttime",$data);
				$content=ob_get_clean();
				$this->email_extension->sendMail($this->service,$userData->id,$subject,$content);
			}
			else
			{
				$subject="Your account at ".site_name_string1." is activated: ".$userData->username;
				$data['userData']=$userData;
				ob_start();
				$this->load->view("users/admin/_email_active",$data);
				$content=ob_get_clean();
				$this->email_extension->sendMail($this->service,
											$userData->id,
											$subject,
											$content
											);
			}
		}
		else if($newStatus==2) //Suspended
		{
			$subject="Your account at ".site_name_string1." has been suspended: ".$userData->username;
			$data['userData']=$userData;
			ob_start();
			$this->load->view("users/admin/_email_suspended",$data);
			$content=ob_get_clean();
			$this->email_extension->sendMail($this->service,
										$userData->id,
										$subject,
										$content
										);
		}
		else if($newStatus==7) //Deleted
		{
			$subject="Your account at ".site_name_string1." has been deleted: ".$userData->username;
			$data['userData']=$userData;
			ob_start();
			$this->load->view("users/admin/_email_deleted",$data);
			$content=ob_get_clean();
			$this->email_extension->sendMail($this->service,
										$userData->id,
										$subject,
										$content
										);
		}
	}

	public function deleteUser($userData)
	{
		if($userData->admin==0)
			$this->sendStatusChangeMail($userData,7,2);

		$this->auth_check->where("id",$userData->sso_user_id);
		$this->auth_check->update($this->tableName,array(
												'deleted'=>1,
												'deleted_by'=>$this->currentUser->id,
												'deleted_on'=>date("Y:m:d H:i:s")
											));

		$this->db->where("id",$userData->id);
		$this->db->update($this->tableName,array(
												'deleted'=>1,
												'deleted_by'=>$this->currentUser->id,
												'deleted_on'=>date("Y:m:d H:i:s")
											));

		// $this->updateJapamUser($id);
		$this->updateJapamUser($userData->id);
		$this->subscriptions_email_model->delete_by_email($userData->email);
	}

	public function hardDeleteUser($userData)
	{
		$this->load->library("email_extension");

		$subject="Account deleted at ".site_name_string1.": ".$userData->username;
		$data['userData']=$userData;
		$content=$this->load->view("users/admin/_email_deleted_invalid",$data,true);
		$this->email_extension->sendMail($this->service,
									$userData->id,
									$subject,
									$content,
									1
								);

		$this->db->where("id",$userData->id);
		$this->db->delete($this->tableName);
		$this->auth_check->where("id",$userData->sso_user_id);
		$this->auth_check->delete($this->tableName);
		$this->logaction->log("users","User removed from database - User ID: ".$userData->username);
		$this->subscriptions_email_model->delete_by_email($userData->email);
	}


	public function usernameCheck($username) 
    {
    	$this->db->where("username",$username);    
        $query=$this->db->get($this->tableName);
        if($query->num_rows())
		{
			return 1;
        }
        return 0;
    }
    public function adminusernameCheck($username,$id) 
    {
    	$this->auth_check->where("username",$username);
    	$this->auth_check->where("id != ",$id);  
        $query=$this->auth_check->get($this->tableName);
        if($query->num_rows())
		{
			return 1;
        }
        return 0;
    }
    public function emailCheck($email,$id)
    {
    	$this->load->model("emails_sns_notifications_model");
    	$bounceCheck = $this->emails_sns_notifications_model->checkExistBounceMail($email);
    	$this->auth_check->where("email",$email);
    	$this->auth_check->where("id != ",$id);
        $query=$this->auth_check->get($this->tableName);
        if($query->num_rows())
		{
			return 1;
        }
        if($bounceCheck["status"] == 1)
        {
        	return 1;
        }
        return 0;
    }
    public function phoneCheck($phone,$id) 
    {
    	$this->auth_check->where("phoneno",$phone);
    	$this->auth_check->where("id != ",$id);
        $query=$this->auth_check->get($this->tableName);
        if($query->num_rows())
		{
			return 1;
        }
        return 0;
    }

    public function sendResetPasswordLink($uid=0)
	{
		$user=$this->userData($uid);
		if(empty($user))
		{
			$data['msg']="User does not exist";
			return $data;
		}

		$expires_on=date("Y:m:d H:i:s",strtotime("+7 Days"));
		$randomString=random_string('alnum', 12);
		$this->db->where("username",$user->username);
		$this->db->update($this->tableName,
						array("forgot_key"=>$randomString,
								"forgot_key_expires_on"=>$expires_on));
		
		$data['user']=$user;
		$data['random_string']=$randomString;
		$content=$this->load->view("users/admin/_email_reset_password",$data,true);
		$subject="Reset Password link for your account at ".site_name_string1." | Email ID: ".$user->email;
		$this->load->library("email_extension");
		$dd=$this->email_extension->sendMailGuest("users",$user->firstname." ".$user->lastname,$user->email,$subject,$content,'',1);
	}

	public function sendSSOResetPasswordLink($uid=0)
	{
		$user=$this->ssouserData($uid);
		if(empty($user))
		{
			$data['msg']="User does not exist";
			return $data;
		}

		$expires_on=date("Y:m:d H:i:s",strtotime("+7 Days"));
		$randomString=random_string('alnum', 12);
		$this->db->where("username",$user->username);
		$this->db->update($this->tableName,
						array("forgot_key"=>$randomString,
								"forgot_key_expires_on"=>$expires_on));
		
		$data['user']=$user;
		$data['random_string']=$randomString;
		$content=$this->load->view("users/admin/_email_reset_password",$data,true);
		$subject="Reset Password link for your account at ".site_name_string1." | Email ID: ".$user->email;
		$this->load->library("email_extension");
		$dd=$this->email_extension->sendMailGuest("users",$user->firstname." ".$user->lastname,$user->email,$subject,$content,'',1);
	}

	public function resetPassword($id,$key,$pass)
	{
		$this->db->where("id",$id);
		$this->db->where("forgot_key",$key);
		$u=$this->db->get($this->tableName)->row();
		
		if($u->pass_hash=='')
		{
			if($u->pass==md5($pass))
			{
				return 2;
			}
		}
		else
		{
			if($this->verifyPasswordHash($pass,$u->pass_hash))
			{
				return 2;
			}
		}

		$newPassword=$this->generatePasswordHash($pass);
        $this->db->where("id",$id);
        $this->db->update($this->tableName,
        						array(
        								"pass_hash"=>$newPassword,
        								"forgot_key"=>''
        							));
        $this->auth_check->where("id",$u->sso_user_id);
        $this->auth_check->update($this->tableName,
        						array(
        								"pass_hash"=>$newPassword,
        								"forgot_key"=>''
        							));
        return 1;
    }

    public function resetAdminPassword($userData,$pass)
	{
		$newPassword=$this->generatePasswordHash($pass);
		$this->auth_check->where("id",$userData->sso_user_id);
        $this->auth_check->update($this->tableName,
        						array(
        								"pass_hash"=>$newPassword,
        								"forgot_key"=>''
        							));
        $this->db->where("id",$userData->id);
        $this->db->update($this->tableName,
        						array(
        								"pass_hash"=>$newPassword,
        								"forgot_key"=>''
        							));
        $this->load->model("user/password_changing_history_model");
    	$this->password_changing_history_model->save($userData->id);
        if($userData->admin==0)
        {
        	$this->load->library("email_extension");
			$subject="Account update - Your password changed : ".$userData->username;
			$data['userData']=$userData;
			$content=$this->load->view("users/admin/_email_admin_password_reset",$data,true);
			$this->email_extension->sendMail($this->service,$userData->id,$subject,$content);
        }
        return 1;
    }

    public function verifyPasswordHash($password,$hash)
	{
		return password_verify($password,$hash);
	}
	public function generatePasswordHash($password)
	{
		return password_hash($password,PASSWORD_DEFAULT);
	}
	
    /*public function verifyUserPin($uid,$pin)
    {
    	$this->db->where("id",$uid);
    	$this->db->where("user_pin",md5($pin));
    	$this->db->where("deleted",0);
        $q=$this->db->get($this->tableName);
        return $q->num_rows();
    }*/
    public function validateUsersByEmail($userlistString)
	{
		$usersList=array_filter(explode(",",$userlistString));

			$this->db->select("u.id as uid,u.username as uusername,email,phoneno,firstname,lastname,profilepic,status,role");
			$this->db->where("deleted",0);
			$this->db->where("status",1);
			$this->db->where("admin",0);
			$this->db->where_in("email",$usersList);
			$this->db->where("email_verified",1);
			$this->db->from("users as u");
		$q=$this->db->get()->result();

		$users=array();
		foreach ($q as $row)
		{
			$users[]=array("id"=>$row->uid,"text"=>$row->firstname." ".$row->lastname." (".$row->uusername.")");
		}
		return $users;
	}

    public function searchUsers($string,$flag=0)
	{
		$this->db->select("u.id as uid,u.username as uusername,email,phoneno,firstname,lastname,profilepic,status,role,address,address1,address2,city,state,country_id,zipcode,sso_user_id");
		$this->db->from($this->tableName." as u");
		$this->db->where("status",1);
		$this->db->where("deleted",0);
		$this->db->where("email_verified",1);
		if($flag==0 || 1)
		{
			$this->db->group_start();
			$this->db->like("u.username",$string);
			$this->db->or_like("u.firstname",$string,'match');
			$this->db->or_like("u.lastname",$string,'match');
			$this->db->or_like("email",$string,'match');
			$this->db->or_like("phoneno",$string,'match');
			$this->db->group_end();
		}
		if($flag==2)
		{
			$this->db->where("admin",1);
		}
		$this->db->limit(10);
		return $this->db->get()->result_array();
	}
	public function getSecurityQuestions($uid)
	{
		$this->db->where("user_id",$uid);
		$this->db->join("security_questions as s","s.id=u.question_id");
		$q=$this->db->get("user_security_questions as u");
		return $q->result();
	}

	public function getUserSecurityQuestions($uid)
	{
		$this->db->where("user_id",$uid);
		$q=$this->db->get("user_security_questions");
		return $q->result();
	}

	public function getSecurityQuestionsGroups()
	{
		$result=array();
		$this->db->where("group",0);
		$q=$this->db->get("security_questions");
		$result['group0']=$q->result();

		$this->db->where("group",1);
		$q=$this->db->get("security_questions");
		$result['group1']=$q->result();

		return $result;
	}
	public function searchUsersByData($searchData,$selectColumns='')
	{
		if($selectColumns=='')
			$this->db->select("id,username,email,firstname,lastname,gender,country_id,status");
		else
			$this->db->select($selectColumns);
		if(is_array($searchData))
		{
			foreach ($searchData as $colName => $value)
			{
				if(is_array($value))
					$this->db->where_in($colName,$value);
				else
					$this->db->where($colName,$value);
			}
		}
		$this->db->where('deleted',0);
		$q=$this->db->get($this->tableName);
		return $q->result();
	}

	public function getUsersByEmails($emails)
	{
		$this->db->select("id,username,firstname,lastname,profession,gothram,birthstar,raasi,email,gender,profilepic,phoneno,status,user_title,country_id,suspended,state_id,city_id,admin,address,address1,address2,dob,md5(id) as md5u,deleted");
		$this->db->where_in("email",$emails);
		$this->db->where("status",1);
		$this->db->where("deleted",0);
		$q=$this->db->get($this->tableName);
		return $q->result();
	}
	public function getUsersByFields($fields)
	{
		$this->db->select("id,username,firstname,lastname,profession,gothram,birthstar,raasi,email,gender,profilepic,phoneno,status,user_title,country_id,suspended,state_id,city_id,admin,address,address1,address2,dob,md5(id) as md5u,deleted");
		foreach ($fields as $fieldRow)
		{
			$this->db->where($fieldRow['colName'],$fieldRow['value']);
		}
		
		$this->db->where("status",1);
		$this->db->where("deleted",0);
		$q=$this->db->get($this->tableName);
		return $q->result();
	}

	public function getUsersByIds($ids)
	{
		$this->db->select("id,username,firstname,lastname,profession,gothram,birthstar,raasi,email,gender,profilepic,phoneno,status,user_title,country_id,suspended,state_id,city_id,admin,address,address1,address2,dob,md5(id) as md5u,deleted,sso_user_id");
		$this->db->where_in("id",$ids);
		$this->db->where("status",1);
		$this->db->where("deleted",0);
		$q=$this->db->get($this->tableName);
		return $q->result();
	}

	public function searchUsersByService($string,$serviceSlug='')
	{
		$this->db->select("u.id as uid,u.username as uusername,email,phoneno,firstname,lastname,profession,gothram,birthstar,raasi,profilepic,u.status as ustatus,role");
		$this->db->from($this->tableName." as u");
		if($serviceSlug!='')
		{
			$this->db->join("user_screen_names as s","s.user_id=u.id");
			$this->db->where("s.service",$serviceSlug);
		}
		$this->db->where("u.status",1);
		$this->db->like("u.username",$string);
		$this->db->or_like("email",$string);
		$this->db->or_like("phoneno",$string);
		return $this->db->get()->result_array();
	}

	public function updateProfile($userId,$vars,$app=0)
	{		
		$this->db->where("id",$userId);
		$uq = $this->db->get($this->tableName);
		$r=$uq->row();
		if($r->email!=$vars['user_email'])
		{
			if($r->email_verified==1)
			{
				$subject="Your Email ID has been changed - ".$r->username;
				ob_start();
				$this->load->view("users/admin/_email_change_notification");
				$content=ob_get_clean();
				$this->load->library("email_extension");
				$this->email_extension->sendMail("users",$userId,$subject,$content,1);
			}
			$emailVerified=0;
			$emailParts=explode("@",$vars['user_email']);
			if("@".$emailParts[1]==no_email_domain)
			{
				$emailVerified=1;
			}
			$this->db->where("id",$userId);
			$this->db->update("users",array('email_verified'=>$emailVerified,"email_changed_on"=>date("Y:m:d H:i:s"),"email_bounce_count"=>0));
			$this->subscriptions_email_model->update($r->email,$vars['user_email']);
		}
		
		if($vars['dob']!='')
			$dob=date("Y:m:d",strtotime($vars['dob']));
		else $dob='';

		if($vars['country'] == '')
		{
			$vars['country'] = 'IN';
		}
		
		$country_name='';
		if($vars['country']!='')
		{
			$countryData=$this->locations_model->getCountryByCode($vars['country']);
			$country_name=$countryData->country_name;
		}

		$receive_newsletters=0;
		if(isset($vars['receive_newsletters']))
		{
			$receive_newsletters=1;
		}
		$block_sms=0;
		if(isset($vars['block_sms']))
		{
			$block_sms=1;
		}
		$this->db->where("id",$userId);
		$this->db->update("users",array(
						"firstname"=>ucwords(strtolower($this->general_model->filtertext(trim($vars['first_name'])))),
						"middlename"=>ucwords(strtolower($this->general_model->filtertext(trim($vars['middlename'])))),
						"lastname"=>ucwords(strtolower($this->general_model->filtertext(trim($vars['last_name'])))),
						"profession"=>trim($vars['profession']),
						"birthstar"=>trim($vars['star']),
						"raasi"=>trim($vars['raasi']),
						"gothram"=>trim($vars['gothram']),
						"gender"=>trim($vars['gender']),
						"dob"=>trim($dob),
						"block_sms"=>$block_sms,
						"address"=>$this->general_model->filtertext(trim($vars['address'])),
						"address1"=>$this->general_model->filtertext(trim($vars['address1'])),
						"address2"=>$this->general_model->filtertext(trim($vars['address2'])),
						"country_id"=>trim($vars['country']),
						'country'=>$country_name,
						"state"=>trim($vars['state']),
						"city"=>trim($vars['city']),
						"zipcode"=>trim($vars['zip']),
						"phoneno"=>trim($vars['phone']),
						"pan_number"=>trim($vars['pan_number']),
						"aadhaar_number"=>trim($vars['aadhaar_number']),
						"tin_number"=>trim($vars['tin_number']),
						"passport_number"=>trim($vars['passport_number']),
						"voter_epic_number"=>trim($vars['voter_epic_number']),
						"driving_license_number"=>trim($vars['driving_license_number']),
						"ration_card_number"=>trim($vars['ration_card_number']),
						"lang_id"=>trim($vars['lang']),
						"profile_complete"=>1,
						"profilepic"=>$r->profilepic,
						"email"=>strtolower(trim($_POST['user_email'])),
						"receive_newsletters"=>$receive_newsletters
						));
		$this->subscriptions_email_model->update_name($vars['user_email'],$vars['first_name']." ".$vars['last_name']);
		if($r->email!=$vars['user_email'])
		{
			$emailParts=explode("@",$vars['user_email']);
			if("@".$emailParts[1]!=no_email_domain)
			{
				$this->userutil->sendUpdatedEmailVerificationLink($userId,$vars['user_email']);
			}
		}
		
		$this->load->library("s3",array("accessKey"=>sso_aws_s3_access_key,
											"secretKey"=>sso_aws_s3_secret_key,
											"useSSL"=>false,
											"endpoint"=>"s3.amazonaws.com"));
		$uname=strtolower($r->username);
		$first_letter=$uname[0];
		
		if($r->profilepic!='' && !isset($_POST['imgupl']))
		{
			$this->db->where("id",$userId);
			$this->db->update("users",array('profilepic'=>''));
			$this->auth_check->where("id",$r->sso_user_id);
			$this->auth_check->update("users",array('profilepic'=>""));
			
			$path=$_SERVER['DOCUMENT_ROOT']."/users_profiles/$first_letter/".md5($r->sso_user_id)."/".$r->profilepic;
			$tpath=$_SERVER['DOCUMENT_ROOT']."/users_profiles/$first_letter/".md5($r->sso_user_id)."/thumb_".$r->profilepic;
			$tpath50=$_SERVER['DOCUMENT_ROOT']."/users_profiles/$first_letter/".md5($r->sso_user_id)."/thumb50_".$r->profilepic;
			if(file_exists($path))
				unlink($path);
			if(file_exists($tpath))
				unlink($tpath);
		}
		if($app==0)
		{
			if(isset($_FILES['profile_image']))
			if($_FILES['profile_image']['name']!='')
			{
				$this->load->helper('image');
				$name=$_FILES['profile_image']['name'];
				$pre=explode(".",$name);
				$ncnt=count($pre);
				$ext=$pre[$ncnt-1];
				
				//$filename=$r->username.".".$ext;
				$filename=substr(md5(mt_rand()), 0, 16).".".$ext;
				
				$basePath=$_SERVER['DOCUMENT_ROOT']."/users_profiles/$first_letter/".md5($r->sso_user_id)."/";
				if(!is_dir($basePath))
				{
					mkdir($basePath,0777,true);
				}
				
				$path=$_SERVER['DOCUMENT_ROOT']."/users_profiles/$first_letter/".md5($r->sso_user_id)."/".$filename;
				$tpath=$_SERVER['DOCUMENT_ROOT']."/users_profiles/$first_letter/".md5($r->sso_user_id)."/thumb_".$filename;
				$tpath50=$_SERVER['DOCUMENT_ROOT']."/users_profiles/$first_letter/".md5($r->sso_user_id)."/thumb50_".$filename;
				
				
				move_uploaded_file($_FILES['profile_image']['tmp_name'],$path);
				
				$this->general_model->create_thumb_150($path,$tpath);
				$this->general_model->create_thumb50($path,$tpath50);
				$image = new SimpleImage();
				$image->load($path);
				$img_width=$image->getWidth();
		    	$img_height=$image->getHeight();
		    	$ratio=$img_width/$img_height;
		     
				if($ratio>=1)
				{
					if($img_width>800)
						$image->resizeToWidth(800);
				}
				else
				{
					if($img_height>800)
						$image->resizeToHeight(800);
				}
				$image->save($path);
				$amazonUri="users_profiles/$first_letter/".md5($r->sso_user_id)."/".$filename;
				$amazonUriThumb="users_profiles/$first_letter/".md5($r->sso_user_id)."/thumb_".$filename;
				$amazonUriThumb50="users_profiles/$first_letter/".md5($r->sso_user_id)."/thumb50_".$filename;
				$this->s3->putObjectFile($path,sso_aws_s3_bucket_name,$amazonUri,S3::ACL_PUBLIC_READ, array(), array());
				$this->s3->putObjectFile($tpath,sso_aws_s3_bucket_name,$amazonUriThumb,S3::ACL_PUBLIC_READ, array(), array());
				$this->s3->putObjectFile($tpath50,sso_aws_s3_bucket_name,$amazonUriThumb50,S3::ACL_PUBLIC_READ, array(), array());
				unlink($path);
				unlink($tpath);
				unlink($tpath50);
				$this->auth_check->where("id",$r->sso_user_id);
				$this->auth_check->update("users",array('profilepic'=>$filename));
				$this->db->where("id",$userId);
				$this->db->update("users",array('profilepic'=>$filename));
			}
		}
		else
		{
			if(isset($_POST['profile_image']) && $_POST['profile_image']!='')
			{
				$this->load->helper('image');
				
				if (preg_match('/^data:image\/(\w+);base64,/', $_POST['profile_image'], $type)) {
				    $image_data = substr($_POST['profile_image'], strpos($_POST['profile_image'], ',') + 1);
				    $type = strtolower($type[1]); // jpg, png, gif
				    if (!in_array($type, [ 'jpg', 'jpeg','png' ])) {
				    	goto end;
				    }
				    $image_data = base64_decode($image_data);
				    if ($image_data === false) {
				        goto end;
				    }
				}
				$ext=$type;
				$temp_path=$_SERVER['DOCUMENT_ROOT']."/temp/".substr(md5(mt_rand()), 0, 16).".".$ext;
				file_put_contents($temp_path, $image_data);
				
				//$filename=$r->username.".".$ext;
				$filename=substr(md5(mt_rand()), 0, 16).".".$ext;
				
				$basePath=$_SERVER['DOCUMENT_ROOT']."/users_profiles/$first_letter/".md5($r->sso_user_id)."/";
				if(!is_dir($basePath))
				{
					mkdir($basePath,0777,true);
				}
				
				$path=$_SERVER['DOCUMENT_ROOT']."/users_profiles/$first_letter/".md5($r->sso_user_id)."/".$filename;
				$tpath=$_SERVER['DOCUMENT_ROOT']."/users_profiles/$first_letter/".md5($r->sso_user_id)."/thumb_".$filename;
				$tpath50=$_SERVER['DOCUMENT_ROOT']."/users_profiles/$first_letter/".md5($r->sso_user_id)."/thumb50_".$filename;
				
				
				copy($temp_path,$path);
				
				$this->general_model->create_thumb_150($path,$tpath);
				$this->general_model->create_thumb50($path,$tpath50);
				$image = new SimpleImage();
				$image->load($path);
				$img_width=$image->getWidth();
		    	$img_height=$image->getHeight();
		    	$ratio=$img_width/$img_height;
		     
				if($ratio>=1)
				{
					if($img_width>800)
						$image->resizeToWidth(800);
				}
				else
				{
					if($img_height>800)
						$image->resizeToHeight(800);
				}
				$image->save($path);
				
				$amazonUri="users_profiles/$first_letter/".md5($r->sso_user_id)."/".$filename;
				$amazonUriThumb="users_profiles/$first_letter/".md5($r->sso_user_id)."/thumb_".$filename;
				$amazonUriThumb50="users_profiles/$first_letter/".md5($r->sso_user_id)."/thumb50_".$filename;
				$this->s3->putObjectFile($path,sso_aws_s3_bucket_name,$amazonUri,S3::ACL_PUBLIC_READ, array(), array());
				$this->s3->putObjectFile($tpath,sso_aws_s3_bucket_name,$amazonUriThumb,S3::ACL_PUBLIC_READ, array(), array());
				$this->s3->putObjectFile($tpath50,sso_aws_s3_bucket_name,$amazonUriThumb50,S3::ACL_PUBLIC_READ, array(), array());
				unlink($path);
				unlink($tpath);
				unlink($tpath50);
				unlink($temp_path);
				
				$this->db->where("id",$userId);
				$this->db->update("users",array('profilepic'=>$filename));
				$this->auth_check->where("id",$r->sso_user_id);
				$this->auth_check->update("users",array('profilepic'=>$filename));
			}
		}
		end:
		{
		}
		$this->updateSSOProfile($r->sso_user_id,$vars,$app);
		$this->updateJapamUser($r->id);

		if(isset($_POST['updateSelfDonor']) && $_POST['updateSelfDonor']=="Yes")
		{
			$this->updateSelfDonor($r->sso_user_id);
		}

		$this->load->library("dattaid_api");
        $response = $this->dattaid_api->call($r->sso_user_id);
    }

    public function updateSelfDonor($userId)
    {
    	$this->auth_check->where("id",$userId);
		$uq = $this->auth_check->get($this->tableName);
		$userData=$uq->row();
		if($userData)
		{
			$donor_dob_day = "";
			$donor_dob_month = "";
			if($userData->dob!="0000-00-00" && $userData->dob!="")
			{
				$donor_dob_day = date("j", strtotime($userData->dob));
				$donor_dob_month = date("n", strtotime($userData->dob));
			}

			$donorData = [
							'donor_name' => ucwords(strtolower($userData->firstname." ".$userData->lastname)),
							'donor_email' => $userData->email,
							'modified_on' => date("Y:m:d H:i:s"),
						];

			if(isset($userData->address) && $userData->address!="")
			{
				$donorData['donor_address'] = $userData->address;
			}
			if(isset($userData->address1) && $userData->address1!="")
			{
				$donorData['donor_address1'] = $userData->address1;
			}
			if(isset($userData->address2) && $userData->address2!="")
			{
				$donorData['donor_address2'] = $userData->address2;
			}
			if(isset($userData->city) && $userData->city!="")
			{
				$donorData['donor_city'] = $userData->city;
			}
			if(isset($userData->state) && $userData->state!="")
			{
				$donorData['donor_state'] = $userData->state;
			}
			if(isset($userData->country_id) && $userData->country_id!="")
			{
				$donorData['donor_address_country_id'] = $userData->country_id;
			}
			if(isset($userData->country_name) && $userData->country_name!="")
			{
				$donorData['donor_address_country'] = $userData->country_name;
			}
			if(isset($userData->zipcode) && $userData->zipcode!="")
			{
				$donorData['donor_zipcode'] = $userData->zipcode;
			}
			if(isset($userData->country_id) && $userData->country_id!="")
			{
				$donorData['donor_country_id'] = $userData->country_id;
			}
			if(isset($userData->isd_code) && $userData->isd_code!="")
			{
				$donorData['donor_country_isd'] = $userData->isd_code;
			}
			if(isset($userData->country_name) && $userData->country_name!="")
			{
				$donorData['donor_country'] = $userData->country_name;
			}
			if(isset($userData->birthstar) && $userData->birthstar!="")
			{
				$donorData['donor_star'] = $userData->birthstar;
			}
			if(isset($userData->phoneno) && $userData->phoneno!="")
			{
				$donorData['donor_phone'] = $userData->phoneno;
			}
			if(isset($userData->raasi) && $userData->raasi!="")
			{
				$donorData['donor_raasi'] = $userData->raasi;
			}
			if(isset($userData->profession) && $userData->profession!="")
			{
				$donorData['donor_profession'] = $userData->profession;
			}
			if(isset($donor_dob_day) && $donor_dob_day!="")
			{
				$donorData['donor_dob_day'] = $donor_dob_day;
			}
			if(isset($donor_dob_month) && $donor_dob_month!="")
			{
				$donorData['donor_dob_month'] = $donor_dob_month;
			}

			$this->auth_check->where("user_id",$userId)->where("donor_relation",'Self')->where("is_user",1)->update("donors", $donorData);
		}
    }

    public function updateJapamUser($userId)
    {
    	$this->db->where("id",$userId);
		$uq = $this->db->get($this->tableName);
		$userData=$uq->row();
		if($userData)
		{
			$siteServicesDB = $this->load->database("site_services",true);
	    	$siteServicesDB->where("user_id",$userId)->update("japam_user",
				array(
				"username"=>$userData->username,
				"firstname"=>$userData->firstname,
				"lastname"=>$userData->lastname,
				"deleted"=>$userData->deleted,
				"user_status"=>$userData->status,
				"gender"=>$userData->gender,
				"city"=>$userData->city,
				"country"=>$userData->country,
				"country_id"=>$userData->country_id)
			);
		}
    }

    public function updateSSOProfile($userId,$vars,$app=0)
	{
		$this->auth_check->where("id",$userId);
		$uq = $this->auth_check->get($this->tableName);
		$r=$uq->row();
		
		if($r->email!=$vars['user_email'])
		{
			$emailVerified=0;
			$emailParts=explode("@",$vars['user_email']);
			if("@".$emailParts[1]==no_email_domain)
			{
				$emailVerified=1;
			}
			$this->auth_check->where("id",$userId);
			$this->auth_check->update("users",array('email_verified'=>$emailVerified,"email_changed_on"=>date("Y:m:d H:i:s"),"email_bounce_count"=>0));
		}
		
		if($vars['dob']!='')
			$dob=date("Y:m:d",strtotime($vars['dob']));
		else $dob='';
		
		$country_name='';
		if($vars['country']!='')
		{
			$countryData=$this->locations_model->getCountryByCode($vars['country']);
			$country_name=$countryData->country_name;
		}

		$receive_newsletters=0;
		if(isset($vars['receive_newsletters']))
		{
			$receive_newsletters=1;
		}
		$block_sms=0;
		if(isset($vars['block_sms']))
		{
			$block_sms=1;
		}
		$this->auth_check->where("id",$userId);
		$this->auth_check->update("users",array(
						"firstname"=>ucwords(strtolower(trim($vars['first_name']))),
						"middlename"=>ucwords(strtolower(trim($vars['middlename']))),
						"lastname"=>ucwords(strtolower(trim($vars['last_name']))),
						"profession"=>trim($vars['profession']),
						"birthstar"=>trim($vars['star']),
						"raasi"=>trim($vars['raasi']),
						"gothram"=>trim($vars['gothram']),
						"gender"=>trim($vars['gender']),
						"block_sms"=>$block_sms,
						"dob"=>trim($dob),
						"address"=>trim($vars['address']),
						"address1"=>trim($vars['address1']),
						"address2"=>trim($vars['address2']),
						"country_id"=>trim($vars['country']),
						'country'=>$country_name,
						"state"=>trim($vars['state']),
						"city"=>trim($vars['city']),
						"zipcode"=>trim($vars['zip']),
						"phoneno"=>trim($vars['phone']),
						"pan_number"=>trim($vars['pan_number']),
						"aadhaar_number"=>trim($vars['aadhaar_number']),
						"tin_number"=>trim($vars['tin_number']),
						"passport_number"=>trim($vars['passport_number']),
						"voter_epic_number"=>trim($vars['voter_epic_number']),
						"driving_license_number"=>trim($vars['driving_license_number']),
						"ration_card_number"=>trim($vars['ration_card_number']),
						"lang_id"=>trim($vars['lang']),
						"profile_complete"=>1,
						"email"=>strtolower(trim($vars['user_email'])),
						"receive_newsletters"=>$receive_newsletters
						));
    }

    public function updateSecurityQuestions($userId,$vars)
    {
    	$userData=$this->userData($userId);
    	if(!empty($userData))
    	{
			
			$this->db->where("user_id",$userId);
			$this->db->limit(2);
			$qa=$this->db->get("user_security_questions");
			if($qa->num_rows()==0)
			{
				$this->db->insert('user_security_questions',
		                            array('question_id' => $vars["q1"],
										'answer' => md5(trim($vars["ans1"])),
										'user_id' => $userId,
										'created_on' => date("Y:m:d H:i:s")
									)
									);
				
				$this->db->insert('user_security_questions',
		                            array('question_id' => $vars["q2"],
										'answer' => md5(trim($vars["ans2"])),
										'user_id' => $userId,
										'created_on' => date("Y:m:d H:i:s")
									)
									);
			}
			else
			{
				$questions=$qa->result();
				$id1=$questions[0]->id;
				$id2=$questions[1]->id;

				$this->db->where("id",$id1);
				$this->db->update('user_security_questions',
		                            array('question_id' => $vars["q1"],
										'answer' => md5(trim($vars["ans1"])),
										'user_id' => $userId,
										'created_on' => date("Y:m:d H:i:s")
									)
									);

				$this->db->where("id",$id2);
				$this->db->update('user_security_questions',
		                            array('question_id' => $vars["q2"],
										'answer' => md5(trim($vars["ans2"])),
										'user_id' => $userId,
										'created_on' => date("Y:m:d H:i:s")
									)
									);
			}
		
			$this->db->where("id",$userId);			
			$this->db->update($this->tableName,array('security_complete'=>1));
			
			if($userData->security_complete==0)
			{
				return 1;
			}
			else
				return 2;
    	}
    	else
    		return 0;
    }
    /*public function updatePinUser($userId,$newPin)
    {
		$this->db->where("id",$userId);
		$this->db->update($this->tableName,
					array('user_pin'=>md5($newPin),
						   'pin_set'=>1
						   ));
		return 1;
    }*/
    public function verifyPassword($userId,$password)
    {
    	$this->db->where("id",$userId);
    	$q=$this->db->get("users");
    	if($q->num_rows())
    	{
    		$r=$q->row();
    		if($r->pass_hash=='')
    		{
    			if($r->pass!=md5($password))
    			{
    				return 0;
    			}
    		}
    		else
    		{
    			if(!$this->verifyPasswordHash($password,$r->pass_hash))
    			{
    				return 0;
    			}
    		}
    		return 1;
    	}
    	else
    		return 0;
    }

    public function updatePassword($userId,$currentPassword,$newPassword)
    {
    	$this->db->where("id",$userId);
    	$q=$this->db->get("users");
    	if($q->num_rows())
    	{
    		$r=$q->row();
    		if($r->pass_hash=='')
    		{
    			if($r->pass!=md5($currentPassword))
    			{
    				return 2;
    			}
    		}
    		else
    		{
    			if(!$this->verifyPasswordHash($currentPassword,$r->pass_hash))
    			{
    				return 2;
    			}
    		}
    		$newPassword=$this->generatePasswordHash($newPassword);
    		$this->db->where("id",$userId);
    		$this->db->update("users",
    					array('pass_hash'=>$newPassword
    						   ));
    		$this->auth_check->where("id",$r->sso_user_id);
    		$this->auth_check->update("users",
    					array('pass_hash'=>$newPassword
    						   ));
    		$this->load->model("user/password_changing_history_model");
    		$this->password_changing_history_model->save($userId);
    		return 1;
    	}
    	else
    		return 2;
    }

    public function updatePasswordForced($userId,$newPassword)
    {
    	$newPassword=$this->generatePasswordHash($newPassword);
		$this->db->where("id",$userId);
		$this->db->update("users",
					array('pass_hash'=>$newPassword
						   ));
		$this->db->where("id",$userId);
    	$q=$this->db->get("users");
    	if($q->num_rows())
    	{
    		$r=$q->row();
			$this->auth_check->where("id",$r->sso_user_id);
			$this->auth_check->update("users", array('pass_hash'=>$newPassword ));
		}
		$this->load->model("user/password_changing_history_model");
		$this->password_changing_history_model->save($userId);
    	return 1;
    }


    public function activateUser($username)
	{
		$userData=$this->userDataByUsername($username);
		
		if(!empty($userData))
		{
			if($userData->status==0)
			{
				$this->db->where("id",$userData->id);
				$this->db->update($this->tableName,
								array(
									'email_verified'=>1,
									'status'=>1
									));
				$this->auth_check->where("id",$userData->sso_user_id);
				$this->auth_check->update($this->tableName,
								array(
									'email_verified'=>1,
									'status'=>1
									));
				$this->subscriptions_email_model->activate($userData->email);
				$this->session->set_flashdata("email_verified",1);
				$this->load->model("subscriptions/donors_model");
	            $this->donors_model->createDefault($userData->sso_user_id);
				return 1;
			}
			else if($userData->status==1 && $userData->email_verified==0)
			{
				$this->db->where("id",$userData->id);
				$this->db->update($this->tableName,
								array(
									'email_verified'=>1
									));
				$this->auth_check->where("id",$userData->sso_user_id);
				$this->auth_check->update($this->tableName,
								array(
									'email_verified'=>1
									));
				$this->session->set_flashdata("email_verified",1);
				$this->load->model("subscriptions/donors_model");
	            $this->donors_model->createDefault($userData->sso_user_id);
				return 2;
			}
			else
			{
				return 3;
			}

			$this->updateJapamUser($userData->id);
		}
		else
			return 0;
	}

	public function getDeletedUsers($date) 
    {
    	$this->db->select("user_id");
    	$this->db->where("status",2);
    	$this->db->where("DATE(date) ",date("Y:m:d",strtotime($date)));
        $query=$this->db->get("users_deleted");
        $result=array();
        foreach ($query->result() as $row)
        {
        	$result[]=$row->user_id;
        }
        return $result;
    }
    public function getSuspendedUsers()
    {
    	$this->db->select("user_id");
    	$this->db->where("status",1);
        $query=$this->db->get("users_deleted");
        $result=array();
        foreach ($query->result() as $row)
        {
        	$result[]=$row->user_id;
        }
        return $result;
    }
	//-===============================================================================================================================
	//-===============================================================================================================================
	//-===============================================================================================================================
	//-===============================================================================================================================
	//-===============================================================================================================================


   /* public function generateRandomString($length = 10) 
	{
        $characters = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $randomString = '';
        for ($i = 0; $i < $length; $i++) 
		{
                $randomString .= $characters[rand(0, strlen($characters) - 1)];
        }
        return $randomString;
    }*/
	
  
    
    public function getLanguage() 
	{
        $this->db->select( '*' );
        $this->db->from( 'languages' );
        $query = $this->db->get();
        if($query->num_rows() > 0) 
		{
            foreach ($query->result() as $row) 
			{
                $rows[] = $row;
            }
        } 
		else $rows = 0;
        return $rows;
    }
    
	 /*public function reset_pin($key) 
	 {
        $q = $this->db->query("select * from user where forgot_key='".$key."'");
        $row = $q->result();
        $uid = $row[0]->id;
        $r = $this->db->query("update user set user_pin='".md5($_POST['pin'])."',forgot_key='' where id=".$uid);
        if($r)
		{
			$this->logaction->log_action("PIN reset attempt with Key - ".$key.
						" Rest PIN successfull");
			$this->db->insert("login_record",array(
								'date'=>date("Y:m:d H:i:s"),
								'ip_address'=>$_SERVER['REMOTE_ADDR'],
								'browser'=>$this->bagent,
								'username'=>$row[0]->username,
								'username'=>$row[0]->email,
								'action'=>"PIN Reset attempt with key: ".$key,
								'key'=>'pin_reset'
								));
			return 1;
		}
        else return 0;
    }*/

	public function updateLastSessionId($userId,$sessionId)
	{
		$this->db->where("id",$userId);
		$this->db->update($this->tableName,
									array(
											'last_session_id'=>$sessionId
										)
							);
	}

	public function sendReminderNotLoggedInUsers()
	{
		$this->db->select("id,email,firstname,lastname,last_logged_in");
		$this->db->where("last_logged_in <",date("Y:m:d H:i:s",strtotime("-30 Days")));
		$this->db->where("status",1);
		$this->db->where("admin",0);
		$this->db->where("email_verified",1);
		$q=$this->db->get($this->tableName);

		foreach ($q->result() as $row)
		{
			$eData['user']=$row;
			$body=$this->load->view("users/admin/_email_login30days_reminder",$eData,true);


			$subject=htmlentities($row->firstname)." ".htmlentities($row->lastname).', its been more than 30 days you logged in';
			$this->email_extension->sendMailGuest(
													'users',
													htmlentities($row->firstname)." ".htmlentities($row->lastname),
													$row->email,
													$subject,
													$body,
													'',
													1);
		}
	}

	public function sendEmailActivationReminder()
	{
		$this->db->select("id,email,firstname,lastname,last_logged_in");
		$this->db->where("email_changed_on <",date("Y:m:d H:i:s",strtotime("-2 Days")));
		$this->db->where_in("status",array(0,1));
		$this->db->where("email_verified",0);
		$this->db->where("deleted",0);
		$this->db->where("suspended",0);
		$this->db->where("admin",0);
		$q=$this->db->get($this->tableName);
		foreach ($q->result() as $row)
		{
			$this->userutil->sendEmailVerificationLink($row->id);
		}
	}

	public function user_device($player_id,$action)
	{
		$playerData=$this->one_signal->getInfoByPlayerId($player_id);
		if(isset($playerData->errors))
		{
			return 0;
		}
		else
		{
			$deviceData=$this->user_devices_model->deviceDataByPlayerID($player_id);
			if(empty($deviceData))
			{
				if($action=='add')
					$this->user_devices_model->add($playerData);
			}
			else
			{
				if($action=='add')
					$this->user_devices_model->update($playerData);	
				else
					$this->user_devices_model->remove($playerData);
			}
		}
	}

	public function unsubscribe($id)
	{
		$this->db->where("id",$id);
		$this->db->update($this->tableName,
								array(
									"receive_newsletters"=>0
								)
							);
	}

	public function excelReport($excelData,$objPHPExcel)
	{
		if($excelData->page_number==2)
		{
			$objPHPExcel=$this->adminUsersExcelReport($excelData,$objPHPExcel);
			return $objPHPExcel;
		}
		if($excelData->page_number==3)
		{
			$objPHPExcel=$this->deletedUsersExcelReport($excelData,$objPHPExcel);
			return $objPHPExcel;
		}

		$countries=$this->locations_model->getCountries(true);

		$q=$this->db->query($excelData->query);

		$objPHPExcel->setActiveSheetIndex(0);
		$objPHPExcel->getActiveSheet()->SetCellValue('A1',$excelData->page_name);

		$styleArray = array(
							'font' => array(
							'bold' => true
							)
						);

		$objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('A2',"Report Date: ".date("d M Y h:i A"));

		$j=3;
		$pre_data=explode("\n",$excelData->pre_data);
		foreach ($pre_data as $filter)
		{
			$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,$filter);
			$j++;
		}

		$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,"Total Records: ".$q->num_rows());

		$requestData=unserialize($excelData->request_data);

		$j=$j+2;

		$alpha="A";
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"S No.");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"User UID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"User ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Status");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Email ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Email ID verified?");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Phone");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

 		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"PAN Number");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Aadhaar Number");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"TIN Number");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Passport Number");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Voter EPIC Number");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Driving License Number");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Ration Card Number");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"First Name");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray( $styleArray );

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Middle Name");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Last Name");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Address Line 1");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Address Line 2");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Address Line 3");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"City");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"State");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Country");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Registered On");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Registered IP Address");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$i=$j+1;
		$sno=1;
		foreach ($q->result() as $reportrow)
		{
			$alpha="A";
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$sno);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->id);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->username);
			$status="Inactive";
			if($reportrow->status==1)
				$status="Active";
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$status);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->email);
			$emailVerified="No";
			if($reportrow->email_verified==1)
				$emailVerified="Yes";
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$emailVerified);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->phoneno);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->pan_number);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->aadhaar_number);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->tin_number);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->passport_number);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->voter_epic_number);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->driving_license_number);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->ration_card_number);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->firstname);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->middlename);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->lastname);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->address);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->address1);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->address2);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->city);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->state);

			$isd_code='';
			if($reportrow->country_id!='')
			{
				$cid=$reportrow->country_id;
				$isd_code=" +".$countries[$cid]->isd_code;
			}

			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->country.$isd_code);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("d M Y",strtotime($reportrow->registered_on)));
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->registered_from_ip);
			
			$i++;
			$sno++;
		}
		return $objPHPExcel;
	}

	private function adminUsersExcelReport($excelData,$objPHPExcel)
	{
		$roles=$this->getRoles();
		$rolesArray=array();
		foreach ($roles as $rl)
		{
			$rolesArray[$rl->id]=$rl->role;
		}

		$q=$this->db->query($excelData->query);

		$objPHPExcel->setActiveSheetIndex(0);
		$objPHPExcel->getActiveSheet()->SetCellValue('A1',$excelData->page_name);

		$styleArray = array(
							'font' => array(
							'bold' => true
							)
						);

		$objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('A2',"Report Date: ".date("d M Y h:i A"));

		$j=3;
		$pre_data=explode("\n",$excelData->pre_data);
		foreach ($pre_data as $filter)
		{
			$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,$filter);
			$j++;
		}

		$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,"Total Records: ".$q->num_rows());

		$requestData=unserialize($excelData->request_data);

		$j=$j+2;

		$alpha="A";
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"S No.");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"User UID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"User ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Status");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Email ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"First Name");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Last Name");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Role");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$i=$j+1;
		$sno=1;
		foreach ($q->result() as $reportrow)
		{
			$alpha="A";
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$sno);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->id);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->username);
			$status="Inactive";
			if($reportrow->status==1)
				$status="Active";
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$status);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->email);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->firstname);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->lastname);
			$aRoles=array_filter(explode(",",$reportrow->roles));
			$rolesString='';
			foreach ($aRoles as $roleId)
			{
				if($rolesString!='') $rolesString.=", ";
				$rolesString.=$rolesArray[$roleId];
			}
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$rolesString);
			
			$i++;
			$sno++;
		}
		return $objPHPExcel;
	}

	private function deletedUsersExcelReport($excelData,$objPHPExcel)
	{
		$roles=$this->getRoles();
		$rolesArray=array();
		foreach ($roles as $rl)
		{
			$rolesArray[$rl->id]=$rl->role;
		}

		$q=$this->db->query($excelData->query);

		$objPHPExcel->setActiveSheetIndex(0);
		$objPHPExcel->getActiveSheet()->SetCellValue('A1',$excelData->page_name);

		$styleArray = array(
							'font' => array(
							'bold' => true
							)
						);

		$objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('A2',"Report Date: ".date("d M Y h:i A"));

		$j=3;
		$pre_data=explode("\n",$excelData->pre_data);
		foreach ($pre_data as $filter)
		{
			$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,$filter);
			$j++;
		}

		$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,"Total Records: ".$q->num_rows());

		$requestData=unserialize($excelData->request_data);

		$j=$j+2;

		$alpha="A";
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"S No.");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"User UID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"User ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Status");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Email ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Email ID Verified?");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Phone");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"First Name");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Middle Name");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Last Name");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Address Line 1");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Address Line 2");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Address Line 3");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"City");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"State");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Country");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Role");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$i=$j+1;
		$sno=1;
		foreach ($q->result() as $reportrow)
		{
			$alpha="A";
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$sno);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->id);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->username);
			$status="Inactive";
			if($reportrow->status==1)
				$status="Active";
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$status);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->email);
			$emailVerified="No";
			if($reportrow->email_verified==1)
				$emailVerified="Yes";
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$emailVerified);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->phoneno);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->firstname);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->middlename);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->lastname);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->address);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->address1);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->address2);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->city);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->state);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->country);
			$aRoles=array_filter(explode(",",$reportrow->roles));
			$rolesString='';
			foreach ($aRoles as $roleId)
			{
				if($rolesString!='') $rolesString.=", ";
				$rolesString.=$rolesArray[$roleId];
			}
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$rolesString);
			
			$i++;
			$sno++;
		}
		return $objPHPExcel;
	}

	public function updateReceiveNewslettersStatus($id, $status)
	{
		if($id>0 && ($status==0 || $status==1) )
        {
        	$this->db->where('id',$id);
			$this->db->update($this->tableName, array('receive_newsletters'=>$status));
            return true;
        }
        else
        {
            return false;
        }
		
	}
}
?>