<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Newsletter_images_model extends CI_Model
{
	var $tableName="newsletter_images";
	public function __construct()
	{
		parent::__construct();
	}
	public function insert($data)
	{
		$this->db->insert($this->tableName,$data);
	}
	
	public function getImagesByNewsletterId($newsletterId,$multiple=false,$columns=array())
	{
		if(empty($columns))
			$this->db->select("*");
		else
			$this->db->select(implode(",", $columns));
		$this->db->from($this->tableName);
		if($multiple==true)
			$this->db->where_in("newsletter_id",$newsletterId);
		else
		$this->db->where("newsletter_id",$newsletterId);
		$q=$this->db->get();
		return $q->result();
	}
	public function deleteImage($newsletterId,$imageId)
	{
		$this->db->where(array("id"=>$imageId,"newsletter_id"=>$newsletterId));
		$query = $this->db->get($this->tableName);
		if($query->num_rows())
		{
			$this->load->library("s3",array("accessKey"=>aws_s3_access_key,
											"secretKey"=>aws_s3_secret_key,
											"useSSL"=>false,
											"endpoint"=>"s3.amazonaws.com"));

			$r=$query->row();
			$file=$r->filename;
			$amazonUri="content/newsletter/";
			$this->s3->deleteObject(aws_s3_bucket_name,$amazonUri.$r->filename);

			$this->db->where(array("id"=>$imageId,"newsletter_id"=>$newsletterId));
			$this->db->delete($this->tableName);
			return 1;
		}
		else
			return 0;
	}
}
?>