<?PHP
class User_files_model extends CI_Model 
{
	var $tableName="user_files";
	public function __construct()
	{
		parent::__construct();
	}
	public function getFilesUser($userId)
	{
		$this->db->where("user_id",$userId);
		$this->db->order_by("order","asc");
		$q=$this->db->get($this->tableName);
		return $q->result();
	}
	public function getFiles()
	{
		$this->db->order_by("order","asc");
		$q=$this->db->get($this->tableName);
		return $q->result();
	}

	public function attachmentData($id)
	{
		$this->db->where("id",$id);
		$q=$this->db->get($this->tableName);
		return $q->row();
	}

	public function uploadFile($userId)
	{
		$fname=$_FILES['files']['name'][0];
		$ext=pathinfo ($_FILES['files']['name'][0],PATHINFO_EXTENSION);
		$newname='dattapeetham_'.md5(mt_rand() . microtime()).".".$ext;
		$tempPath=$_FILES['files']['tmp_name'][0];
		$tempName=basename($_FILES['files']['tmp_name'][0]);

		$this->load->library("s3",array("accessKey"=>aws_s3_access_key,
											"secretKey"=>aws_s3_secret_key,
											"useSSL"=>false,
											"endpoint"=>"s3.amazonaws.com"));

		$amazonUri="private_files/user_swamiji_files/".$userId."/";
		$this->s3->putObjectFile($tempPath,aws_s3_bucket_name,$amazonUri.$newname,S3::ACL_PRIVATE, array(), array());
		$fileSize=filesize($tempPath);
		$this->db->insert($this->tableName,
						array(
								"filename"=>$newname,
								'date'=>date("Y:m:d H:i:s"),
								'user_id'=>$userId,
								'description'=>$fname,
								'size'=>$fileSize
							));
		$data['fileid']=$this->db->insert_id();
		$data['filename']=$newname;
		$data['description']=$fname;
		return $data;
	}

	public function delete($attachmentData)
	{
		$this->load->library("s3",array("accessKey"=>aws_s3_access_key,
											"secretKey"=>aws_s3_secret_key,
											"useSSL"=>false,
											"endpoint"=>"s3.amazonaws.com"));
		$amazonUri="private_files/user_swamiji_files/".$attachmentData->user_id."/".$attachmentData->filename;
		$this->s3->deleteObject(aws_s3_bucket_name,$amazonUri);
		$this->db->where("id",$attachmentData->id);
		$this->db->delete($this->tableName);
		return 1;
	}
	public function updateInfo($id,$colName,$value)
	{
		$this->db->where("id",$id);
		if($colName=='order')
			$this->db->update($this->tableName,array($colName=>abs($value)));
		else
			$this->db->update($this->tableName,array($colName=>$value));
	}

	public function listAdmin($excel=0)
	{
		$i=0;
		$query1=$this->db;
		if($excel==0)
			$query1->select("user_id,username,sum(size) as size,count(f.id) as file_count,firstname,lastname,deleted,status");
		step1:
		$i++;
		if($i==2 || $excel==1)
		{
			$query1->select("user_id,username,sum(size) as size,count(f.id) as file_count,firstname,lastname,deleted,status");
		}

		$query1->from($this->tableName." as f");
		$query1->join("users as u","u.id=f.user_id",'left');
		$query1->group_by("user_id");
				
		$preData="Search Keywords: ";

		if(isset($_POST['search_text']) && trim($_POST['search_text'])!='' && 
		in_array($_POST['search_col'],$GLOBALS['current_acl']['search_columns']))
		{
			$preData.=$GLOBALS['current_acl']['excel_columns'][$_POST['search_col']];
			$query1->like($_POST['search_col'],$this->db->escape_str(trim($_POST['search_text'])));
				$preData.=" containing ";
			/* if($_POST['wild']=='starts')
			{
				$query1->like($_POST['search_col'],$this->db->escape_str(trim($_POST['search_text'])),"after");
				$preData.=" starting with ";
			}
			else if($_POST['wild']=='ends')
			{
				$query1->like($_POST['search_col'],$this->db->escape_str(trim($_POST['search_text'])),'before');
				$preData.=" ending with ";
			}
			else
			{
				$query1->like($_POST['search_col'],$this->db->escape_str(trim($_POST['search_text'])));
				$preData.=" containing ";
			} */
			$preData.='"'.$_POST['search_text'].'"';
		}

		if($excel==1)
		{
			if(isset($_POST['order_by']) && in_array($_POST['order_by'],$GLOBALS['current_acl']['sort_columns']))
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by($_POST['order_by'],$_POST['dir']);
				else
					$query1->order_by($_POST['order_by'],'asc');
			}
			else
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by('username',$_POST['dir']);
				else
					$query1->order_by('username',"asc");
			}
			$sql=$query1->get_compiled_select();

			$requestResp=$this->excel_exports_model->makeRequest('default',"model","swamijifiles/user_files_model",$sql,$this->currentUser,"default",$_POST,"File Upload Admin",$preData);
			return $requestResp;
		}
		
		if($i==1)
		{
			$temp_result = $query1->get()->num_rows();
			$rtn['recordsTotal'] = $temp_result;
			$rtn['recordsFiltered'] = $temp_result;
			goto step1;
		}

		$dir='asc';

		if(isset($_POST['order'][0]['dir']) && in_array($_POST['order'][0]['dir'],$GLOBALS['current_acl']['dir']))
			$dir=$_POST['order'][0]['dir'];

		$order_by='';
		if(isset($_POST['order'][0]['column']) && is_numeric($_POST['order'][0]['column']))
		{
			$col_num=round(abs($_POST['order'][0]['column']));
			$col_name=$_POST['columns'][$col_num]['name'];
			if($col_num && in_array($col_name,$GLOBALS['current_acl']['sort_columns']))
				$query1->order_by($col_name,$dir);
			else
				$query1->order_by('username',$dir);
		}
		else
		{
			$query1->order_by('username',$dir);
		}

		$start=0;
		$length=10;
		if(isset($_POST['start']) && is_numeric($_POST['start']))
		{
			if(round(abs($_POST['start']))%10==0)
			$start=round(abs($_POST['start']));
		}
		if(isset($_POST['length']) && is_numeric($_POST['length']) && in_array($_POST['length'],array(10,20,50,100)))
		{
			$length=abs($_POST['length']);
			if(!$length)
				$length=10;
		}

		$query1->limit($length,$start);

		$rtn['data']=$query1->get()->result_array();

		$temp=array();
		$sno=$start+1;
		$c=0;
		foreach ($rtn['data'] as $row) 
		{
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['sno']=$sno;
			if(abs($rtn['data'][$c]['size']))
				$rtn['data'][$c]['size']=$this->general_model->fileSizeConvert($rtn['data'][$c]['size']);
			else
				$rtn['data'][$c]['size']="0 KB";
			$sno++;
			$c++;
		}
		$rtn['page_records']=$c;
		return $rtn;
	}

	public function listFiles($userData,$excel=0)
	{
		$i=0;
		$query1=$this->db;
		if($excel==0)
			$query1->select("count(id) as c");
		step1:
		$i++;
		if($i==2 || $excel==1)
		{
			$query1->select("*");
		}

		$query1->from($this->tableName);
		$query1->where("user_id",$userData->id);
				
		$preData="Search Keywords: ";

		if(isset($_POST['search_text']) && trim($_POST['search_text'])!='' && 
		in_array($_POST['search_col'],$GLOBALS['current_acl']['search_columns']))
		{
			$preData.=$GLOBALS['current_acl']['excel_columns'][$_POST['search_col']];
			$query1->like($_POST['search_col'],$this->db->escape_str(trim($_POST['search_text'])));
				$preData.=" containing ";
			/* if($_POST['wild']=='starts')
			{
				$query1->like($_POST['search_col'],$this->db->escape_str(trim($_POST['search_text'])),"after");
				$preData.=" starting with ";
			}
			else if($_POST['wild']=='ends')
			{
				$query1->like($_POST['search_col'],$this->db->escape_str(trim($_POST['search_text'])),'before');
				$preData.=" ending with ";
			}
			else
			{
				$query1->like($_POST['search_col'],$this->db->escape_str(trim($_POST['search_text'])));
				$preData.=" containing ";
			} */
			$preData.='"'.$_POST['search_text'].'"';
		}

		$preData.="\nFrom Date: ";
		if(isset($_POST['from_date']) && $_POST['from_date']!='')
		{
			$query1->where("DATE(date) >=",date("Y-m-d",strtotime($_POST['from_date'])));
			$preData.=$_POST['from_date'];
		}
		
		$preData.="\nTo Date: ";
		if(isset($_POST['to_date']) && $_POST['to_date']!='')
		{
			$query1->where("DATE(date) <=",date("Y-m-d",strtotime($_POST['to_date'])));
			$preData.=$_POST['to_date'];
		}

		if($excel==1)
		{
			if(isset($_POST['order_by']) && in_array($_POST['order_by'],$GLOBALS['current_acl']['sort_columns']))
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by($_POST['order_by'],$_POST['dir']);
				else
					$query1->order_by($_POST['order_by'],'desc');
			}
			else
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by('date',$_POST['dir']);
				else
					$query1->order_by('date',"desc");
			}
			$sql=$query1->get_compiled_select();

			$requestResp=$this->excel_exports_model->makeRequest('default',"model","swamijifiles/user_files_model",$sql,$this->currentUser,"default",$_POST,"Files Uploaded by '".$userData->firstname." ".$userData->lastname." (".$userData->username.")'",$preData,2);
			return $requestResp;
		}
		
		if($i==1)
		{
			$temp_result = $query1->get()->row();
			$rtn['recordsTotal'] = $temp_result->c;
			$rtn['recordsFiltered'] = $temp_result->c;
			goto step1;
		}

		$dir='desc';

		if(isset($_POST['order'][0]['dir']) && in_array($_POST['order'][0]['dir'],$GLOBALS['current_acl']['dir']))
			$dir=$_POST['order'][0]['dir'];

		$order_by='';
		if(isset($_POST['order'][0]['column']) && is_numeric($_POST['order'][0]['column']))
		{
			$col_num=round(abs($_POST['order'][0]['column']));
			$col_name=$_POST['columns'][$col_num]['name'];
			if($col_num && in_array($col_name,$GLOBALS['current_acl']['sort_columns']))
				$query1->order_by($col_name,$dir);
			else
				$query1->order_by('date',$dir);
		}
		else
		{
			$query1->order_by('date',$dir);
		}

		$start=0;
		$length=10;
		if(isset($_POST['start']) && is_numeric($_POST['start']))
		{
			if(round(abs($_POST['start']))%10==0)
			$start=round(abs($_POST['start']));
		}
		if(isset($_POST['length']) && is_numeric($_POST['length']) && in_array($_POST['length'],array(10,20,50,100)))
		{
			$length=abs($_POST['length']);
			if(!$length)
				$length=10;
		}

		$query1->limit($length,$start);

		$rtn['data']=$query1->get()->result_array();

		$temp=array();
		$sno=$start+1;
		$c=0;
		foreach ($rtn['data'] as $row) 
		{
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['sno']=$sno;
			$rtn['data'][$c]['date']=date("d M Y h:i A",strtotime($rtn['data'][$c]['date']));
			if(abs($rtn['data'][$c]['size']))
				$rtn['data'][$c]['size']=$this->general_model->fileSizeConvert($rtn['data'][$c]['size']);
			else
				$rtn['data'][$c]['size']="0 KB";
			$sno++;
			$c++;
		}
		$rtn['page_records']=$c;
		return $rtn;
	}

	public function excelReport($excelData,$objPHPExcel)
	{
		if($excelData->page_number==2)
		{
			$objPHPExcel=$this->filesReport($excelData,$objPHPExcel);
			return $objPHPExcel;
		}
		$q=$this->db->query($excelData->query);

		$objPHPExcel->setActiveSheetIndex(0);
		$objPHPExcel->getActiveSheet()->SetCellValue('A1',$excelData->page_name);

		$styleArray = array(
							'font' => array(
							'bold' => true
							)
						);

		$objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('A2',"Report Date: ".date("d M Y h:i A"));

		$j=3;
		$pre_data=explode("\n",$excelData->pre_data);
		foreach ($pre_data as $filter)
		{
			$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,$filter);
			$j++;
		}

		$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,"Total Records: ".$q->num_rows());

		$requestData=unserialize($excelData->request_data);

		$j=$j+2;

		$alpha="A";
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"S No.");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"User ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"User Status");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"First Name");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Last Name");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"File Count");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Total Size");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$i=$j+1;
		$sno=1;
		foreach ($q->result() as $reportrow)
		{
			$alpha="A";
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$sno);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->username);
			$status="Active";
			if($reportrow->deleted==0)
			{
				if($status==2)
					$status="Suspended";
			}
			else
				$status="Deleted";
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$status);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->firstname);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->lastname);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->file_count);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$this->general_model->fileSizeConvert($reportrow->size));
			
			$i++;
			$sno++;
		}
		return $objPHPExcel;
	}

	private function filesReport($excelData,$objPHPExcel)
	{
		$q=$this->db->query($excelData->query);

		$objPHPExcel->setActiveSheetIndex(0);
		$objPHPExcel->getActiveSheet()->SetCellValue('A1',$excelData->page_name);

		$styleArray = array(
							'font' => array(
							'bold' => true
							)
						);

		$objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('A2',"Report Date: ".date("d M Y h:i A"));

		$j=3;
		$pre_data=explode("\n",$excelData->pre_data);
		foreach ($pre_data as $filter)
		{
			$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,$filter);
			$j++;
		}

		$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,"Total Records: ".$q->num_rows());

		$requestData=unserialize($excelData->request_data);

		$j=$j+2;

		$alpha="A";
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"S No.");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"File Name");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Description");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Upload Date");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Size");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$i=$j+1;
		$sno=1;
		foreach ($q->result() as $reportrow)
		{
			$alpha="A";
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$sno);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->filename);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->description);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("d M Y h:i A",strtotime($reportrow->date)));
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$this->general_model->fileSizeConvert($reportrow->size));
			
			$i++;
			$sno++;
		}
		return $objPHPExcel;
	}
}
?>