<?PHP
class Satsangs_Model extends CI_Model 
{
	var $tableName="satsangs";
	public function __construct()
	{
		parent::__construct();
	}
	public function satsangData($id)
	{
		$this->db->where("id",$id);
		$q=$this->db->get($this->tableName);
		$result=$q->row();
		return $result;
	}
	public function getCount()
	{
		return $this->db->get($this->tableName)->num_rows();
	}
	public function satsangDataBySlug($slug)
	{
		$this->db->where("slug",$slug);
		$q=$this->db->get($this->tableName);
		$result=$q->row();
		return $result;
	}
	public function getCountries()
	{
		$this->db->from($this->tableName." as a");
		$this->db->select("a.country_id as country_id,a.country_name as country_name,loc.isd_code as isd_code");
		$this->db->group_by("country_id");
		$this->db->join(db_prefix."locations.countries_list as loc","a.country_id=loc.country_code");
		$q=$this->db->get();
		$result=$q->result();
		return $result;
	}
	public function getList()
	{
		$this->db->select("*");
		$q=$this->db->get($this->tableName);
		$result=$q->result();
		return $result;
	}

	public function listPublic()
	{
		$i=0;

		$query1=$this->db;
		
		$query1->select("count(id) as c");

		step1:
		$i++;
		if($i==2)
		{
			$query1->select("*");
		}
		
		$query1->from($this->tableName);

		if(isset($_POST['country']) && $_POST['country']!='')
		{
			$countryData=$this->locations_model->getCountryByCode($_POST['country']);
			if(!empty($countryData))
			{
				$query1->where("country_id",$_POST['country']);
			}
		}
		
		if(isset($_POST['search_text']) && trim($_POST['search_text'])!='')
		{
			$query1->group_start();
			$query1->like("name",trim($_POST['search_text']));
			$query1->or_like("contact_person",$_POST['search_text']);
			$query1->or_like("state_name",$_POST['search_text']);
			$query1->or_like("city",$_POST['search_text']);
			$query1->or_like("address",$_POST['search_text']);
			$query1->group_end();
		}
		
		$per_page=10;
		if($i==1)
		{
			$temp_result = $query1->get()->row();
			$rtn['num']=$temp_result->c;
			$_GET['per_page']='';
			if(isset($_POST['per_page']))
				$_GET['per_page']=$_POST['per_page'];

			$rtn['links']=$this->general_model->ajaxPaginationCreateLinks($rtn['num'],$per_page);
			goto step1;
		}
		
		if(isset($_POST['per_page']) && is_numeric($_POST['per_page']) && $_POST['per_page'])
		{
			$last=ceil($rtn['num']/$per_page)-1;
			if($last<0) $last=0;
			if($last<abs($_POST['per_page']))
			{
				$n=($last)*$per_page;
			}
			else
			{
				if(abs($_POST['per_page'])==0)
				$n=0;
				else
				$n=(abs($_POST['per_page'])-1)*$per_page;
			}
		}
		else
		{
			$n=0;
		}

		$query1->order_by("name","asc");

		$rtn['n']=$n;

		$query1->limit($per_page,$n);

		$rtn['res']=$query1->get()->result();
		$colors=array("red","blue","orange","green","purple");
		$ii=0;
		$ids=array();
		foreach ($rtn['res'] as $key=> $row) 
		{
			if($ii==5)
				$ii=0;
			$rtn['res'][$key]->color=$colors[$ii];
			$rtn['res'][$key]->location='';
			if($row->city!='')
				$rtn['res'][$key]->location.=$row->city;
			if($row->state_name!='')
			{
				if($rtn['res'][$key]->location!='') $rtn['res'][$key]->location.=", ";
				$rtn['res'][$key]->location.=$row->state_name;
			}
			if($rtn['res'][$key]->location!='') $rtn['res'][$key]->location.=", ";
			$rtn['res'][$key]->location.=$row->country_name;
			$rtn['res'][$key]->address=nl2br($row->address);
			$ii++;
		}

		return $rtn;
	}
	public function listAdmin($excel=0)
	{
		$i=0;
		$query1=$this->db;
		if($excel==0)
			$query1->select("count(id) as c");

		step1:
		$i++;
		if($i==2 || $excel==1)
		{
			$query1->select("*");
		}
		$query1->from($this->tableName);
		$preData="Search Keywords: ";
		
		if(isset($_POST['search_text']) && isset($_POST['search_col']) && trim($_POST['search_text'])!='' &&
			in_array($_POST['search_col'],$GLOBALS['current_acl']['search_columns']))
		{
			$preData.=$GLOBALS['current_acl']['excel_columns'][$_POST['search_col']];
			$query1->like($_POST['search_col'],trim($_POST['search_text']));
				$preData.=" containing ";
			/* if($_POST['wild']=='starts')
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']),'after');
				$preData.=" starting with ";
			}
			else if($_POST['wild']=='ends')
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']),'before');
				$preData.=" ending with ";
			}
			else
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']));
				$preData.=" containing ";
			} */
			$preData.='"'.$_POST['search_text'].'"';
		}

		$preData.="\nCountry: ";
		if(isset($_POST['country']))
		{
			$countryData=$this->locations_model->getCountryByCode($_POST['country']);
			if(!empty($countryData))
			{
				$query1->where("country_id",$_POST['country']);
				$preData.=$countryData->country_name;
			}
			else
				$preData.="All Countries";
		}
		else
		{
			$preData.="All Countries";
		}

		if($excel==1)
		{
			if(isset($_POST['order_by']) && in_array($_POST['order_by'],$GLOBALS['current_acl']['sort_columns']))
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by($_POST['order_by'],$_POST['dir']);
				else
					$query1->order_by($_POST['order_by'],'asc');
			}
			else
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by('name',$_POST['dir']);
				else
					$query1->order_by('name',"asc");
			}
			$sql=$query1->get_compiled_select();

			$requestResp=$this->excel_exports_model->makeRequest('default',"model","satsangs/satsangs_model",$sql,$this->currentUser,"default",$_POST,"All Satsangs",$preData);
			return $requestResp;
		}


		if($i==1)
		{
			$temp_result = $query1->get()->row();

			$rtn['recordsTotal'] = $temp_result->c;
			$rtn['recordsFiltered'] = $temp_result->c;
			
			goto step1;
		}

		$dir='asc';

		if(isset($_POST['order'][0]['dir']) && in_array($_POST['order'][0]['dir'],$GLOBALS['current_acl']['dir']))
			$dir=$_POST['order'][0]['dir'];


		$order_by='';
		if(isset($_POST['order'][0]['column']) && is_numeric($_POST['order'][0]['column']))
		{
			$col_num=round(abs($_POST['order'][0]['column']));
			$col_name=$_POST['columns'][$col_num]['name'];
			if($col_num && in_array($col_name,$GLOBALS['current_acl']['sort_columns']))
				$query1->order_by($col_name,$dir);
			else
				$query1->order_by('name',$dir);
		}
		else
		{
			$query1->order_by('name',$dir);
		}

		$start=0;
		$length=10;
		if(isset($_POST['start']) && is_numeric($_POST['start']))
		{
			if(round(abs($_POST['start']))%10==0)
			$start=round(abs($_POST['start']));
		}
		if(isset($_POST['length']) && is_numeric($_POST['length']) && in_array($_POST['length'],array(10,20,50,100)))
		{
			$length=abs($_POST['length']);
			if(!$length)
				$length=10;
		}
		
		$query1->limit($length,$start);
		$rtn['data']=$query1->get()->result_array();

		$c=0;
		$sno=$start+1;
		foreach ($rtn['data'] as $row)
		{
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['sno']=$sno;
			$sno++;
			$c++;
		}
		return $rtn;
	}

	public function listUser()
	{
		$i=0;
		$query1=$this->db;

		$query1->select("count(id) as c");

		step1:
		$i++;
		if($i==2)
		{
			$query1->select("id,name,city,state_name,country_name,contact_person,slug");
		}
		$query1->from($this->tableName);


		$preData="Search Keywords: ";
		
		if(isset($_POST['search_text']) && isset($_POST['search_col']) && trim($_POST['search_text'])!='' &&
			in_array($_POST['search_col'],$GLOBALS['current_acl']['search_columns']))
		{
			$query1->like($_POST['search_col'],trim($_POST['search_text']));
			/* if($_POST['wild']=='contains')
				$query1->like($_POST['search_col'],trim($_POST['search_text']));
			else if($_POST['wild']=='starts')
				$query1->like($_POST['search_col'],trim($_POST['search_text']),'after');
			else if($_POST['wild']=='ends')
				$query1->like($_POST['search_col'],trim($_POST['search_text']),'before'); */
		}

		$preData.="\nCountry: ";
		if(isset($_POST['country']))
		{
			$countryData=$this->locations_model->getCountryByCode($_POST['country']);
			if(!empty($countryData))
			{
				$query1->where("country_id",$_POST['country']);
				$preData.=$countryData->country_name;
			}
			else
				$preData.="All Countries";
		}
		else
		{
			$preData.="All Countries";
		}


		if($i==1)
		{
			$temp_result = $query1->get()->row();

			$rtn['recordsTotal'] = $temp_result->c;
			$rtn['recordsFiltered'] = $temp_result->c;
			
			goto step1;
		}

		$dir='asc';

		if(isset($_POST['order'][0]['dir']) && in_array($_POST['order'][0]['dir'],$GLOBALS['current_acl']['dir']))
			$dir=$_POST['order'][0]['dir'];


		$order_by='';
		if(isset($_POST['order'][0]['column']) && is_numeric($_POST['order'][0]['column']))
		{
			$col_num=round(abs($_POST['order'][0]['column']));
			$col_name=$_POST['columns'][$col_num]['name'];
			if($col_num && in_array($col_name,$GLOBALS['current_acl']['sort_columns']))
				$query1->order_by($col_name,$dir);
			else
				$query1->order_by('name',$dir);
		}
		else
		{
			$query1->order_by('name',$dir);
		}

		$start=0;
		$length=10;
		if(isset($_POST['start']) && is_numeric($_POST['start']))
		{
			if(round(abs($_POST['start']))%10==0)
			$start=round(abs($_POST['start']));
		}
		if(isset($_POST['length']) && is_numeric($_POST['length']) && in_array($_POST['length'],array(10,20)))
		{
			$length=abs($_POST['length']);
			if(!$length)
				$length=10;
		}
		
		$query1->limit($length,$start);
		$rtn['data']=$query1->get()->result_array();

		$satsangsIds=array();

		$sno=$start+1;
		foreach ($rtn['data'] as $key => $row)
		{
			if(!in_array($row['id'],$satsangsIds))
			{
				$satsangsIds[]=$row['id'];
			}
			$rtn['data'][$key]['sno']=$sno;
			$sno++;
		}

		if(!empty($satsangsIds))
		{
			$subscribes=$this->satsang_members_model->byId($satsangsIds,$this->currentUser->id,1);
			$newslettersubscribes=$this->satsang_members_model->receiveNewslettersbyId($satsangsIds,$this->currentUser->id);

			$c=0;
			foreach ($rtn['data'] as $row)
			{
				$rtn['data'][$c]=$row;
				$rtn['data'][$c]['member_status']=$subscribes[$row['id']];
				$rtn['data'][$c]['receive_newsletters']=0;
				if(isset($newslettersubscribes[$row['id']]) && $newslettersubscribes[$row['id']]==1)
				{
					$rtn['data'][$c]['receive_newsletters']=1;
				}
				$sno++;
				$c++;
			}
		}
		return $rtn;
	}
	public function delete($id,$satsangData)
	{
		$this->db->where("id",$id);
		$this->db->delete($this->tableName);

		$this->users_model->deleteSatsangAdmin($satsangData->id);

		return 1;
	}
	public function save($id,$satsangData)
	{
		$slug=strtolower(url_title($_POST['name']));
		$countryData=$this->locations_model->getCountryByCode($_POST['country_id']);
		if(!$id)
		{
			$q=$this->db->insert($this->tableName,
                                array(
                                	'name' => $this->general_model->filtertext(trim($_POST["name"])),
                                	'address' => $this->general_model->filtertext(trim($_POST["address"])),
									'description' => $this->general_model->filtertext(trim($_POST["description"])),
									'country_id' => $_POST["country_id"],
									'country_name'=>$countryData->country_name,
									'state_name' => $this->general_model->filtertext(trim($_POST["state_name"])),
									'city' => $this->general_model->filtertext(trim($_POST["city"])),
									'contact_person' => $this->general_model->filtertext(trim($_POST["contact_person"])),
									'contact_email' => $this->general_model->filtertext(trim($_POST["contact_email"])),
									'contact_phone' => $this->general_model->filtertext(trim($_POST["contact_phone"])),
									'slug'=>$slug,
									'created_on'=>date("Y:m:d H:i:s")
								)
								);
			$idd=$this->db->insert_id();
			$adminUsername="satsangadmin".$idd;
			$this->users_model->createAdmin($adminUsername,"Satsang","Admin",6,0,$idd);

			//Create email settings row
			$this->db->insert('email_settings',
                                array(
                                		'service_slug'=>"newsletter_s_".$idd,
                                		'ashram_name'=>$this->general_model->filtertext(trim($_POST["name"])),
                                		'smtp_host'=>base_domain,
                                		'smtp_port'=>'25',
                                		'email_template'=>'email_template'
                                	)
                               );
			$this->db->insert('email_settings',
                                array(
                                		'service_slug'=>"satsang_".$idd,
                                		'ashram_name'=>$this->general_model->filtertext(trim($_POST["name"])),
                                		'smtp_host'=>base_domain,
                                		'smtp_port'=>'25',
                                		'email_template'=>'email_template'
                                	)
                               );

			$emailDb=$this->load->database("emails",true,false);
			$emailDb->query("CREATE TABLE IF NOT EXISTS `mail_track_satsang_".$idd."` (
						  `id` int(11) NOT NULL AUTO_INCREMENT,
						  `message_id` mediumtext COLLATE utf8mb4_unicode_ci,
						  `mail_to` mediumtext COLLATE utf8mb4_unicode_ci,
						  `mail_from` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
						  `mail_from_name` varchar(300) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
						  `mail_subject` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
						  `mail_content` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
						  `date` datetime NOT NULL,
						  `sent_on` datetime DEFAULT NULL,
						  `sent_by` int(11) DEFAULT '0',
						  `mail_que_id` int(11) DEFAULT '0',
						  `delivered` int(11) DEFAULT '0',
						  `viewed` int(11) DEFAULT '0',
						  `bounced` int(4) NOT NULL DEFAULT 0,
						  `status` int(11) DEFAULT '0' COMMENT 'For mail_type=1 (0-Pending,1-Sent,2-Failed), For mail_type=0 (0-Failed,1-Sent)',
						  `user_id` int(11) DEFAULT '0',
						  `username` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
						  `mail_type` int(11) DEFAULT '0' COMMENT '1=relay,0=normal',
						  `resent` int(11) DEFAULT '0',
						  `resent_id` int(11) NOT NULL DEFAULT '0',
						  `type` int(11) DEFAULT '0',
						  `mail_track_id` int(11) DEFAULT '0',
						  `service_slug` mediumtext COLLATE utf8mb4_unicode_ci,
						  `debug` mediumtext COLLATE utf8mb4_unicode_ci,
						  `reads` int(11) NOT NULL DEFAULT '0',
						  `clicked` int(11) DEFAULT '0',
						  `priority` int(11) NOT NULL DEFAULT '0',
						  PRIMARY KEY(`id`)
						) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;");


			$emailDb->query("CREATE TABLE IF NOT EXISTS `mail_track_newsletter_s_".$idd."` (
			                `id` int(11) NOT NULL AUTO_INCREMENT,
			                `mail_to` mediumtext COLLATE utf8mb4_unicode_ci,
			                `mail_from` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
			                `mail_from_name` varchar(300) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
			                `mail_subject` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
			                `date` datetime NOT NULL,
			                `sent_on` datetime DEFAULT NULL,
			                `sent_by` int(11) DEFAULT '0',
			                `newsletter_id` int(11) NOT NULL DEFAULT '0',
			                `delivered` int(11) NOT NULL DEFAULT '0',
			                `viewed` int(11) DEFAULT '0',
			                `bounced` int(4) NOT NULL DEFAULT 0,
			                `status` int(11) DEFAULT '0',
			                `fail_reason` mediumtext COLLATE utf8mb4_unicode_ci,
			                `user_id` int(11) DEFAULT '0',
			                `resent` int(11) DEFAULT '0',
			                `resent_id` int(11) NOT NULL DEFAULT '0',
			                `message_id` mediumtext COLLATE utf8mb4_unicode_ci,
			                `reads` int(11) NOT NULL DEFAULT '0',
			                `clicked` int(11) NOT NULL DEFAULT '0',
			                `debug` text COLLATE utf8mb4_unicode_ci,
			                PRIMARY KEY (`id`)
			            ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

						");
		}
		else
		{
			
			$this->db->where('id', $id);
			$q=$this->db->update($this->tableName,
                                array(
                                	'name' => $this->general_model->filtertext(trim($_POST["name"])),
									'address' => $this->general_model->filtertext(trim($_POST["address"])),
									'description' => $this->general_model->filtertext(trim($_POST["description"])),
									'country_id' => $_POST["country_id"],
									'country_name'=>$countryData->country_name,
									'state_name' => $this->general_model->filtertext(trim($_POST["state_name"])),
									'city' => $this->general_model->filtertext(trim($_POST["city"])),
									'contact_person' => $this->general_model->filtertext(trim($_POST["contact_person"])),
									'contact_email' => $this->general_model->filtertext(trim($_POST["contact_email"])),
									'contact_phone' => $this->general_model->filtertext(trim($_POST["contact_phone"])),
									'slug'=>$slug,
									'modified_on'=>date("Y:m:d H:i:s")
								)
								);
			$idd=$id;
		}

		if($q)
			return $idd;
		else
			return 0;
	}

	public function savePage()
	{
		$satsangId=$this->session->userdata("satsangId");
		$this->db->where('id', $this->session->userdata("satsangId"));
		$q=$this->db->update($this->tableName,
                            array
                            	(
                            		'content' => $this->general_model->filtertext(trim($_POST["content"]))
								)
							);

		$this->load->helper("simple_html_dom");
		$dom=new simple_html_dom();
		$tempContent=trim($_POST['content']);
		$contentDom=$dom->load($tempContent);
		$images=$contentDom->find('img');
		if(count($images))
		{
			if($satsangId)
			{
				$existingImages=$this->satsangpage_images_model->getImagesBySatsangId($satsangId);
				$eArray=[];
				foreach ($existingImages as $eimage)
				{
					$eArray[$eimage->filename]=$eimage->id;
				}
				$editorImages=[];
				foreach ($images as $img_dom) 
				{
					$pathText=$img_dom->attr['src'];
					if(preg_match('/amazon/i',$pathText))
					{
						$editorImages[basename($pathText)]=basename($pathText);
					}
				}
				$diff=array_diff_key($eArray,$editorImages);
				//$keys=array_keys($diff);

				if(count($diff))
				{
					foreach($diff as $ikey)
					$this->satsangpage_images_model->deleteImage($satsangId,$ikey);
				}

			}

			$this->load->library("s3",array("accessKey"=>aws_s3_access_key,
											"secretKey"=>aws_s3_secret_key,
											"useSSL"=>false,
											"endpoint"=>"s3.amazonaws.com"));
			
			$amazonUri="content/satsangs/".$this->session->userdata("satsangId")."/";
			foreach ($images as $img_dom) 
			{
				$pathText=$img_dom->attr['src'];
				if(preg_match('/amazon/i',$pathText))
					continue;

				$path=$_SERVER['DOCUMENT_ROOT'].$pathText;
				if(file_exists($path))
				{
					$fname=basename($path);
					$newFileName=$satsangId."_".$fname;
					$tempContent=str_replace($pathText,aws_s3_base_url.$amazonUri.$newFileName,$tempContent);
					$this->s3->putObjectFile($path,aws_s3_bucket_name,$amazonUri.$newFileName,S3::ACL_PUBLIC_READ, array(), array());
					unlink($path);

					$imageData=array('filename' => $newFileName,
									'satsang_id' =>$satsangId
									);
					$this->satsangpage_images_model->insert($imageData);
				}
			}
			$this->db->where("id",$satsangId);
			$this->db->update($this->tableName,array("content"=>$tempContent));
		}
		else
		{
			$existingImages=$this->satsangpage_images_model->getImagesBySatsangId($satsangId);
			$eArray=[];
			foreach ($existingImages as $eimage)
			{
				$this->satsangpage_images_model->deleteImage($satsangId,$eimage->id);
			}
		}
	}

	public function checkName($name,$id)
	{
		$error=0;

		$slug=strtolower(url_title($name));

		$this->db->where("name",$name);
		$this->db->where("id !=",$id);
		$q=$this->db->get($this->tableName);
		if($q->num_rows())
		{
			$error=1;
		}

		$this->db->where("slug",$slug);
		$this->db->where("id !=",$id);
		$q=$this->db->get($this->tableName);
		if($q->num_rows())
		{
			$error=1;
		}
		return $error;
	}

	public function excelReport($excelData,$objPHPExcel)
	{
		$q=$this->db->query($excelData->query);

		$objPHPExcel->setActiveSheetIndex(0);
		$objPHPExcel->getActiveSheet()->SetCellValue('A1',$excelData->page_name);

		$styleArray = array(
							'font' => array(
							'bold' => true
							)
						);

		$objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('A2',"Report Date: ".date("d M Y h:i A"));

		$j=3;
		$pre_data=explode("\n",$excelData->pre_data);
		foreach ($pre_data as $filter)
		{
			$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,$filter);
			$j++;
		}

		$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,"Total Records: ".$q->num_rows());

		$requestData=unserialize($excelData->request_data);

		$j=$j+2;

		$alpha="A";
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"S No.");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Satsang ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Satsang Name");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Contact Person");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Phone");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Email");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Address");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"City");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"State");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Country");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$i=$j+1;
		$sno=1;
		foreach ($q->result() as $reportrow)
		{
			$alpha="A";
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$sno);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->id);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->name);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->contact_person);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->contact_phone);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->contact_email);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->address);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->city);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->state_name);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->country_name);
			
			$i++;
			$sno++;
		}
		return $objPHPExcel;
	}
}
?>