<?PHP if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Newsletters_que_Model extends CI_Model 
{
	var $tableName;
	var $sub_service;
	var $emailDb='';
	function __construct() 
	{
        parent::__construct();
        $this->emailDb=$this->load->database("emails",true,false);
        $this->tableName="mail_track_newsletter_s_".$this->session->userdata("satsangId");
        $this->sub_service="newsletter_s_".$this->session->userdata("satsangId");
        $this->load->library("SES",null,"ses");
        $this->load->model("email_extension_model");
    }
    public function setId($id)
    {
    	$this->tableName="mail_track_newsletter_s_".$id;
        $this->sub_service="newsletter_s_".$id;
    }
    public function listQueue($newsletterData,$excel=0)
	{
		$satsangData=$this->satsangs_model->satsangData($newsletterData->satsang_id);

		$i=0;
		$query1=$this->emailDb;
		if($excel==0)
			$query1->select("count(id) as c");
		step1:
		$i++;
		if($i==2 || $excel==1)
		{
			$query1->select("*");
		}

		$query1->where("newsletter_id",$newsletterData->id);
		$query1->from($this->tableName);
		
		$preData="Satsang Name: ".$satsangData->name;

		$preData.="\nNewsletter ID: ".$newsletterData->unique_id;

		$preData.="\nSearch Keywords: ";

		if(isset($_POST['search_text']) && trim($_POST['search_text'])!='' && 
		in_array($_POST['search_col'],$GLOBALS['current_acl']['search_columns'])
		 && in_array($_POST['wild'],$GLOBALS['current_acl']['wild']))
		{
			$preData.=$GLOBALS['current_acl']['excel_columns'][$_POST['search_col']];
			if($_POST['wild']=='starts')
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']),'after');
				$preData.=" starting with ";
			}
			else if($_POST['wild']=='ends')
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']),'before');
				$preData.=" ending with ";
			}
			else
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']));
				$preData.=" containing ";
			}
			$preData.='"'.$_POST['search_text'].'"';
		}
		
		$preData.="\nStatus:";

		if(isset($_POST['status']) && $_POST['status'] != "" && in_array($_POST['status'],array(0,1,2,"bounced")))
		{
			if($_POST['status'] == "bounced")
			{
				$this->emailDb->where("bounced",1);
				$preData.="Bounced";
			}
			else
			{
				$this->emailDb->where("status",$_POST['status']);
				if($_POST['status']==0)
				{
					$preData.="Pending";
				}
				if($_POST['status']==1)
				{
					$preData.="Sent";
				}
				if($_POST['status']==2)
				{
					$preData.="Failed";
				}
			}
		}

		$preData.="\nResent:";
		if(isset($_POST['resent']) && is_numeric($_POST['resent']) && in_array($_POST['resent'],array(0,1)))
		{
			$query1->where("resent",$_POST['resent']);
			if($_POST['resent']==0)
			{
				$preData.="No";
			}
			else
			{
				$preData.="Yes";
			}
		}

		$preData.="\nViewed: ";
		if(isset($_POST['viewed']) && is_numeric($_POST['viewed']) && in_array($_POST['viewed'],array(0,1)))
		{
			$query1->where("viewed",$_POST['viewed']);
			if($_POST['viewed']==0)
				$preData.="No";
			else
				$preData.="Yes";
		}

		$preData.="\nFrom Date: ";
		if(isset($_POST['date_col']) && in_array($_POST['date_col'],array('date','sent_on')) &&
			isset($_POST['from_date']) && $_POST['from_date']!='')
		{
			$query1->where("date(".$_POST['date_col'].") >=",date("Y:m:d",strtotime($_POST['from_date'])));
			$preData.=$_POST['from_date']." (".$GLOBALS['current_acl']['excel_columns'][$_POST['date_col']].")";
		}
		$preData.="\nTo Date: ";
		if(isset($_POST['date_col']) && in_array($_POST['date_col'],array('date','sent_on')) &&
			isset($_POST['to_date']) && $_POST['to_date']!='')
		{
			$query1->where("date(".$_POST['date_col'].") <=",date("Y:m:d",strtotime($_POST['to_date'])));
			$preData.=$_POST['to_date']." (".$GLOBALS['current_acl']['excel_columns'][$_POST['date_col']].")";
		}

		if($excel==1)
		{
			if(isset($_POST['order_by']) && in_array($_POST['order_by'],$GLOBALS['current_acl']['sort_columns']))
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by($_POST['order_by'],$_POST['dir']);
				else
					$query1->order_by($_POST['order_by'],'desc');
			}
			else
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by('date',$_POST['dir']);
				else
					$query1->order_by('date',"desc");
			}
			$sql=$query1->get_compiled_select();

			$requestResp=$this->excel_exports_model->makeRequest('emails',"model","satsangs/newsletters_que_model",$sql,$this->currentUser,"emails",$_POST,"Satsang Newsletters - Mail Queue",$preData);
			return $requestResp;
		}

		if($i==1)
		{
			$temp_result = $query1->get()->row();
			$rtn['recordsTotal'] = $temp_result->c;
			$rtn['recordsFiltered'] = $temp_result->c;
			goto step1;
		}

		$dir='desc';

		if(isset($_POST['order'][0]['dir']) && in_array($_POST['order'][0]['dir'],$GLOBALS['current_acl']['dir']))
			$dir=$_POST['order'][0]['dir'];

		$order_by='';
		if(isset($_POST['order'][0]['column']) && is_numeric($_POST['order'][0]['column']))
		{
			$col_num=round(abs($_POST['order'][0]['column']));
			$col_name=$_POST['columns'][$col_num]['name'];
			if($col_num && in_array($col_name,$GLOBALS['current_acl']['sort_columns']))
				$query1->order_by($col_name,$dir);
			else
				$query1->order_by('date',$dir);
		}
		else
		{
			$query1->order_by('date',$dir);
		}

		$start=0;
		$length=10;
		if(isset($_POST['start']) && is_numeric($_POST['start']))
		{
			if(round(abs($_POST['start']))%10==0)
			$start=round(abs($_POST['start']));
		}
		if(isset($_POST['length']) && is_numeric($_POST['length']) && in_array($_POST['length'],array(10,20,50,100)))
		{
			$length=abs($_POST['length']);
			if(!$length)
				$length=10;
		}

		$query1->limit($length,$start);

		$rtn['data']=$query1->get()->result_array();
		$temp=array();
		$sno=$start+1;
		$c=0;
		foreach ($rtn['data'] as $row) 
		{
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['sno']=$sno;
			$rtn['data'][$c]['date']=date("d M Y h:i A",strtotime($rtn['data'][$c]['date']));
			if($rtn['data'][$c]['sent_on'])
				$rtn['data'][$c]['sent_on']=date("d M Y h:i A",strtotime($rtn['data'][$c]['sent_on']));
			else
				$rtn['data'][$c]['sent_on']="N/A";
			$sno++;
			$c++;
		}
		$rtn['page_records']=$c;
		return $rtn;
	}
	public function triggerNewsletters()
	{
		$this->db->like("service_slug",$this->sub_service);
		$settings=$this->db->get('email_settings')->result();

		$newsletterData=array();

		$this->emailDb->where("status",0);
		$this->emailDb->where("bounced",0);
		$this->emailDb->order_by('date','desc');
		$this->emailDb->limit(aws_ses_email_batch);
		$q=$this->emailDb->get($this->tableName);
		$i=1;
		foreach ($q->result() as $mailItem)
		{
			if($i%aws_ses_emails_sent_per_second==0)
			{
				echo $i."\n";
				usleep(aws_ses_emails_batch_delay_microseconds);
			}
			$table_name = "satsang_newsletters";
			$service_slug = $this->sub_service;
			$unsub_link = $this->unsubscribe_link($mailItem->mail_to)."&satsang_id=".$mailItem->satsang_id;
			exec("php index.php newsletters_cli sendEmail ".$table_name." ".$mailItem->id." ".$service_slug." ".$this->tableName." ".$unsub_link." > /dev/null &");
			
			$i++;
		}
	}
	private function unsubscribe_link($email)
	{
		$key=base64_encode(openssl_encrypt($email, open_ssl_encrypt_method, open_ssl_key, 0, open_ssl_iv));
		return base_url."login/unsubscribe/".$key."?type=3";
	}
	public function resend($id,$mailData)
	{
		$this->emailDb->insert($this->tableName,
							array(
							"date"=>date("Y:m:d H:i:s"),
							'mail_to'=>$mailData->mail_to,
							'mail_subject'=>$mailData->mail_subject,
							'resent'=>1,
							'user_id'=>$mailData->user_id,
							'resent_id'=>$mailData->id,
							'newsletter_id'=>$mailData->newsletter_id
							));
		return 1;
	}
	public function mailData($id)
	{
		$this->emailDb->where("id",$id);
		$query = $this->emailDb->get($this->tableName);
		return $query->row();
	}

	public function excelReport($excelData,$objPHPExcel)
	{
		$q=$this->emailDb->query($excelData->query);

		$objPHPExcel->setActiveSheetIndex(0);
		$objPHPExcel->getActiveSheet()->SetCellValue('A1',$excelData->page_name);

		$styleArray = array(
							'font' => array(
							'bold' => true
							)
						);

		$objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('A2',"Report Date: ".date("d M Y h:i A"));

		$j=3;
		$pre_data=explode("\n",$excelData->pre_data);
		foreach ($pre_data as $filter)
		{
			$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,$filter);
			$j++;
		}

		$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,"Total Records: ".$q->num_rows());

		$requestData=unserialize($excelData->request_data);

		$j=$j+2;

		$alpha="A";
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"S No.");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Subject");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Email ID");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Date Created");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Date Sent");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Status");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$alpha++;
		$objPHPExcel->getActiveSheet()->SetCellValue($alpha.$j,"Resent?");
		$objPHPExcel->getActiveSheet()->getStyle($alpha.$j)->applyFromArray($styleArray);

		$i=$j+1;
		$sno=1;
		foreach ($q->result() as $reportrow)
		{
			$alpha="A";
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$sno);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->mail_subject);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$reportrow->mail_to);
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("d M Y h:i A",strtotime($reportrow->date)));
			if($reportrow->sent_on!='')
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,date("d M Y h:i A",strtotime($reportrow->sent_on)));
			else
				$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,'N/A');
			
			$status="Pending";
			if($reportrow->bounced==1 && $reportrow->status==1)
			{
				$status = "Bounced";
			}
			else if($reportrow->status==1 && $reportrow->status==0)
			{
				$status = "Not Sent";
			}
			else
			{
				if($reportrow->status==1)
					$status="Sent";
				if($reportrow->status==2)
					$status="Failed";
			}
			
			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$status);

			$resent="No";
			if($reportrow->resent==1)
				$resent="Yes";

			$objPHPExcel->getActiveSheet()->SetCellValue($alpha++.$i,$resent);
			
			$i++;
			$sno++;
		}
		return $objPHPExcel;
	}
}
?>