<?PHP
class Ramamantra_count_model extends CI_Model 
{
	var $db = "";
	var $tableName="ramamantra_count";
    function __construct()
    {
        parent::__construct();
        $this->db=$this->load->database("misc_services",true,false);
    }

    public function getMantraCountryCodes()
    {
    	$toBeReturnArray = [];
    	$this->db->select('DISTINCT(country)');
    	$this->db->from($this->tableName);
    	$queryres = $this->db->get()->result_array();
    	if(count($queryres)>0)
    	{
    		foreach($queryres as $thisCountry)
    		{
    			array_push($toBeReturnArray,$thisCountry['country']);
    		}
    	}
    	return $toBeReturnArray;
    }
	
    public function getCount()
	{
		return $this->db->get($this->tableName)->num_rows();
	}

	public function listAllsummaries()
	{
		$q = $this->db->select("id as all_entries")->from($this->tableName)->get()->num_rows();
		
		$q1 = $this->db->select("id as total_records_by_city")->from($this->tableName)->group_by("city")->get()->num_rows();

		$q2 = $this->db->select("id as total_records_by_country")->from($this->tableName)->group_by("country")->get()->num_rows();

		$q3 = $this->db->select("id as total_records_by_date")->from($this->tableName)->group_by("DATE_FORMAT(japa_date,'%Y%m%d')")->get()->num_rows();

		$q4 = $this->db->select("sum(participants_count) as india_total")->from($this->tableName)->where("country","IN")->get()->result();

		$q5 = $this->db->select("sum(participants_count) as foreign_total")->from($this->tableName)->where("country!=","IN")->get()->result();

		$data = array();

		$data['all_entries'] 				= $q;
		$data['total_records_by_city'] 		= $q1;
		$data['total_records_by_country'] 	= $q2;
		$data['total_records_by_date'] 		= $q3;
		$data['india_total'] 				= $q4[0]->india_total;
		$data['foreign_total'] 				= $q5[0]->foreign_total;

		return $data;
	}

	public function topCitiesAdmin()
    {
    	$this->db->select("count(id) as submissions, city, country as country_code, name, sum(participants_count) as submission_count");
    	$this->db->where("participants_count >",0);
		$this->db->from($this->tableName." as p");
		$this->db->group_by("city");
		$this->db->order_by("submission_count","desc");
		$query = $this->db->get();
		if($query->num_rows() > 0)
			return $query->result_array();
		else
			return false;
    }

	public function getRamaMantraParayanaCount()
	{
		$this->db->select('sum(participants_count) as c');
		$q=$this->db->get($this->tableName)->row();
		if($q->c)
			return $q->c;
		else
			return "0";
	}

	public function update($data='',$where='')
	{
		if($data && $where)
		{
			$this->db->where("id",$where);
    		$this->db->update($this->tableName,$data);
    		return true;
		}
	}

    public function listAdmin($excel=0)
	{
		$countries=$this->locations_model->getCountries(true);
		$i=0;
		$query1=$this->db;
		if($excel==0)
			$query1->select("count(p.id) as c,sum(participants_count) as total_participants");
		step1:
		$i++;
		if($excel==1 || $i==2)
		{
			if(isset($_POST['group_by']) && in_array($_POST['group_by'],array("user_id","city","country")))
				$query1->select("name,phone,email,count(id) as submissions,country,ramamantra_count_id,family_details,country_name,city,sum(participants_count) as participants_count,created_on as submission_date,japa_date,address_1,address_2,address_3,state");
			else
				$query1->select("name,phone,email,id,'1' as submissions,country,ramamantra_count_id,family_details,country_name,city,participants_count,created_on as submission_date,japa_date,address_1,address_2,address_3,state");
		}
		$query1->from($this->tableName." as p");

		$preData="Search Keywords: ";
				
		if(isset($_POST['search_text']) && trim($_POST['search_text'])!='' && 
		in_array($_POST['search_col'],$GLOBALS['current_acl']['search_columns']))
		{
			$preData.=$GLOBALS['current_acl']['excel_columns'][$_POST['search_col']];
			$query1->like($_POST['search_col'],trim($_POST['search_text']));
				$preData.=" containing ";
			/* if($_POST['wild']=='starts')
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']),'after');
				$preData.=" starting with ";
			}
			else if($_POST['wild']=='ends')
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']),'before');
				$preData.=" ending with ";
			}
			else
			{
				$query1->like($_POST['search_col'],trim($_POST['search_text']));
				$preData.=" containing ";
			} */
			$preData.='"'.$_POST['search_text'].'"';
		}

		$preData.="Total By:";
		if(isset($_POST['group_by']) && in_array($_POST['group_by'],array("user_id","city","country")))
		{
			$query1->group_by($_POST['group_by']);
			if($_POST['group_by']=='user_id')
			{
				$preData.="User";
			}
			if($_POST['group_by']=='city')
			{
				$preData.="City";
			}
			if($_POST['group_by']=='country')
			{
				$preData.="Country";
			}
		}

		$preData.="\nFrom Date: ";
		if(isset($_POST['from_date']) && $_POST['from_date']!='')
		{
			$query1->where("DATE(japa_date) >=",date("Y-m-d",strtotime($_POST['from_date'])));
			$preData.=$_POST['from_date'];
		}
		
		$preData.="\nTo Date: ";
		if(isset($_POST['to_date']) && $_POST['to_date']!='')
		{
			$query1->where("DATE(japa_date) <=",date("Y-m-d",strtotime($_POST['to_date'])));
			$preData.=$_POST['to_date'];
		}
		$preData.="\nCountry: ";
		if(isset($_POST['country']) && $_POST['country']!='')
		{
			$query1->where("country",$_POST['country']);
			$preData.=$_POST['country'];
		}
		if($excel==1)
		{
			if(isset($_POST['order_by']) && in_array($_POST['order_by'],$GLOBALS['current_acl']['sort_columns']))
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
				{
					if($_POST['order_by'] == "name")
					{
						$query1->order_by($_POST['order_by'],$_POST['dir']);
						$query1->order_by("country",$_POST['dir']);
						$query1->order_by("city",$_POST['dir']);
					}
					else if($_POST['order_by'] == "country")
					{
						$query1->order_by($_POST['order_by'],$_POST['dir']);
						$query1->order_by("city",$_POST['dir']);
						$query1->order_by("name",$_POST['dir']);
					}
					else if($_POST['order_by'] == "city")
					{
						$query1->order_by($_POST['order_by'],$_POST['dir']);
						$query1->order_by("country",$_POST['dir']);
						$query1->order_by("name",$_POST['dir']);
					}
					else if($_POST['order_by'] == "participants_count")
					{
						$query1->order_by($_POST['order_by'],$_POST['dir']);
						$query1->order_by("country",$_POST['dir']);
						$query1->order_by("city",$_POST['dir']);
						$query1->order_by("name",$_POST['dir']);
					}
					else
						$query1->order_by($_POST['order_by'],$_POST['dir']);
				}
				else
					$query1->order_by($_POST['order_by'],'asc');
			}
			else
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by('japa_date',$_POST['dir']);
				else
					$query1->order_by('japa_date',"asc");
			}
			$sql=$query1->get_compiled_select();

			$requestResp=$this->excel_exports_model->makeRequest('default',"model","ramamantra/ramamantra_count_model",$sql,$this->currentUser,"misc_services",$_POST,"All Ramamantra Details",$preData);
			return $requestResp;
		}
		
		
		if($i==1)
		{
			if(isset($_POST['group_by']) && in_array($_POST['group_by'],array("user_id","city","country")))
			{
				$temp_result = $query1->get()->result_array();
				$rtn['recordsTotal'] = count($temp_result);
				$rtn['recordsFiltered'] = count($temp_result);
				$total_participants = 0;
				$total_submissions = 0;
				foreach ($temp_result as $key => $value) 
				{
					$total_participants+= $value["total_participants"];
					$total_submissions+= $value["c"];
				}
				$rtn['total_participants'] = $total_participants;
				$rtn['total_submissions'] = $total_submissions;
			}
			else
			{
				$temp_result = $query1->get()->row();
				$rtn['recordsTotal'] = $temp_result->c;
				$rtn['total_submissions'] = $temp_result->c;
				$rtn['total_participants'] = $temp_result->total_participants;
				$rtn['recordsFiltered'] = $temp_result->c;
			}
			goto step1;
		}

		$dir='desc';

		if(isset($_POST['order'][0]['dir']) && in_array($_POST['order'][0]['dir'],$GLOBALS['current_acl']['dir']))
			$dir=$_POST['order'][0]['dir'];

		$order_by='';
		if(isset($_POST['order'][0]['column']) && is_numeric($_POST['order'][0]['column']))
		{
			$col_num=round(abs($_POST['order'][0]['column']));
			$col_name=$_POST['columns'][$col_num]['name'];
			if($col_num && in_array($col_name,$GLOBALS['current_acl']['sort_columns']))
			{
				if($col_num == "name")
				{
					$query1->order_by($col_name,$dir);
					$query1->order_by("country",$dir);
					$query1->order_by("city",$dir);
				}
				else if($col_name == "country")
				{
					$query1->order_by($col_name,$dir);
					$query1->order_by("city",$dir);
					$query1->order_by("name",$dir);
				}
				else if($col_name == "city")
				{
					$query1->order_by($col_name,$dir);
					$query1->order_by("country",$dir);
					$query1->order_by("name",$dir);
				}
				else if($col_name == "participants_count")
				{
					$query1->order_by($col_name,$dir);
					$query1->order_by("country",$dir);
					$query1->order_by("city",$dir);
					$query1->order_by("name",$dir);
				}
				else
					$query1->order_by($col_name,$dir);
			}
			else
				$query1->order_by('japa_date',$dir);
		}
		else
		{
			$query1->order_by('japa_date',$dir);
		}

		$start=0;
		$length=10;
		if(isset($_POST['start']) && is_numeric($_POST['start']))
		{
			if(round(abs($_POST['start']))%10==0)
			$start=round(abs($_POST['start']));
		}
		if(isset($_POST['length']) && is_numeric($_POST['length']) && in_array($_POST['length'],array(10,20,50,100)))
		{
			$length=abs($_POST['length']);
			if(!$length)
				$length=10;
		}

		$query1->limit($length,$start);

		$rtn['data']=$query1->get()->result_array();
		$rtn['q']=$query1->last_query();
		$temp=array();
		$ids=array();
		$sno=$start+1;
		$c=0;
		$total_participants = 0;
		foreach ($rtn['data'] as $row) 
		{
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['sno']=$sno;
			$rtn['data'][$c]['japa_date']=date("d M Y",strtotime($row['japa_date']));
			$rtn['data'][$c]['address']="";
			$address = '';
			if($row['address_1'] != "")
				$address .= $row['address_1']."<br>";
			if($row['address_2'] != "")
				$address .= $row['address_2']."<br>";
			if($row['address_3'] != "")
				$address .= $row['address_3']."<br>";
			if($row['city'] != "")
				$address .= $row['city']."<br>";
			if($row['state'] != "")
				$address .= $row['state']."<br>";
			if($row['country'] != "")
				$address .= $row['country_name'];

			$rtn['data'][$c]['address']=$address;
			if(!empty($row['country']))
				$rtn['data'][$c]['phone']="+".$countries[$row['country']]->isd_code." ".$row['phone'];
			else
				$rtn['data'][$c]['phone']=$row['phone'];

			if(isset($_POST['group_by']) && $_POST['group_by']=="city")
			{
				if(!empty($_POST['search_col']) && $_POST['search_col'] == "user_id")
				{
				}
				else
				{
					$rtn['data'][$c]['username']="N/A";
					$rtn['data'][$c]['firstname']="N/A";
					$rtn['data'][$c]['lastname']="N/A";
					$rtn['data'][$c]['phone'] = "N/A";
					$rtn['data'][$c]['email'] = "N/A";
					$rtn['data'][$c]['name'] = "N/A";
				}
			}
			if(isset($_POST['group_by']) && $_POST['group_by']=="country")
			{
				if(!empty($_POST['search_col']) && $_POST['search_col'] == "user_id")
				{
				}
				else if(!empty($_POST['search_col']) && $_POST['search_col'] != "city")
				{
					$rtn['data'][$c]['name'] = "N/A";
					$rtn['data'][$c]['username']="N/A";
					$rtn['data'][$c]['firstname']="N/A";
					$rtn['data'][$c]['lastname']="N/A";
					$rtn['data'][$c]['phone'] = "N/A";
					$rtn['data'][$c]['email'] = "N/A";
					$rtn['data'][$c]['city'] = "N/A";
				}
			}
			if(isset($_POST['group_by']) && $_POST['group_by']!="")
			{
				$rtn['data'][$c]['japa_date'] = "N/A";
				$rtn['data'][$c]['family_details'] = "N/A";
			}
			$sno++;
			$c++;
		}
		$rtn['page_records']=$c;
		return $rtn;
	}

	public function userReport($excel=0)
	{
		$i=0;
		$query1=$this->db;
		if($excel==0)
		{
			$query1->select("count(id) as c,sum(participants_count) as total_participants");
		}
		step1:
		$i++;
		if($i==2 || $excel==1)
		{
			$query1->select("*,count(id) as submissions,sum(participants_count) as total_participants");
		}
		$query1->from($this->tableName);

		$query1->group_start();
		$query1->where("user_id",$this->currentUser->id);
		$query1->or_where("email",$this->currentUser->email);
		$query1->group_end();
		$query1->where("participants_count >",0);

		$preData="";
		$preData.="\nFrom Date: ";
		if(isset($_POST['from_date']) && $_POST['from_date']!='')
		{
			$query1->where("japa_date >=",date("Y-m-d",strtotime($_POST['from_date'])));
			$preData.=$_POST['from_date'];
		}
		
		$preData.="\nTo Date: ";
		if(isset($_POST['to_date']) && $_POST['to_date']!='')
		{
			$query1->where("japa_date <=",date("Y-m-d",strtotime($_POST['to_date'])));
			$preData.=$_POST['to_date'];
		}
		if($excel==1)
		{
			$query1->order_by('japa_date',$_POST['dir']);
			if(isset($_POST['order_by']) && in_array($_POST['order_by'],$GLOBALS['current_acl']['sort_columns']))
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by($_POST['order_by'],$_POST['dir']);
				else
					$query1->order_by($_POST['order_by'],'desc');
			}
			else
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by('japa_date',$_POST['dir']);
				else
					$query1->order_by('japa_date',"desc");
			}
			$query1->group_by("japa_date");
			$sql=$query1->get_compiled_select();

			$requestResp=$this->excel_exports_model->makeRequest('default',"model","ramamantra/ramamantra_count_model",$sql,$this->currentUser,"misc_services",$_POST,"Rama Mantra Japa Report",$preData,2);
			return $requestResp;
		}
		
		if($i==1)
		{
			$query1->group_by("japa_date");
			$temp_result = $query1->get()->result();
			$t_total=0;
			$total_participants = 0;
			$t_cur_total = 0;
			foreach ($temp_result as $temp_row)
			{
				$t_total+=$temp_row->c;
				$t_cur_total+=$temp_row->total_participants;
			}
			$rtn['recordsTotal'] = count($temp_result);
			$rtn['recordsFiltered'] = count($temp_result);
			$rtn['total_participants'] = $t_cur_total;
			goto step1;
		}

		$dir='desc';
		if(isset($_POST['order'][0]['dir']) && in_array($_POST['order'][0]['dir'],$GLOBALS['current_acl']['dir']))
			$dir=$_POST['order'][0]['dir'];

		$order_by='';
		if(isset($_POST['order'][0]['column']) && is_numeric($_POST['order'][0]['column']))
		{
			$col_num=round(abs($_POST['order'][0]['column']));
			$col_name=$_POST['columns'][$col_num]['name'];
			if($col_num && in_array($col_name,$GLOBALS['current_acl']['sort_columns']))
				$query1->order_by($col_name,$dir);
			else
				$query1->order_by('japa_date',$dir);
		}
		else
		{
			$query1->order_by('japa_date',$dir);
		}
		$query1->group_by("japa_date");
		$start=0;
		$length=10;
		if(isset($_POST['start']) && is_numeric($_POST['start']))
		{
			if(round(abs($_POST['start']))%10==0)
			$start=round(abs($_POST['start']));
		}
		if(isset($_POST['length']) && is_numeric($_POST['length']) && in_array($_POST['length'],array(10,20)))
		{
			$length=abs($_POST['length']);
			if(!$length)
				$length=10;
		}

		$query1->limit($length,$start);

		$rtn['data']=$query1->get()->result_array();
		$sno=$start+1;
		$c=0;
		foreach ($rtn['data'] as $row)
		{
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['sno']=$sno;
			if(empty($rtn['data'][$c]['japa_date']) || $rtn['data'][$c]['japa_date'] == "1970-01-01")
			{
				$rtn['data'][$c]['japa_date']='N/A';
				$rtn['data'][$c]['day']='N/A';
				$rtn['data'][$c]['japa_u_date']='';
			}
			else
			{
				$rtn['data'][$c]['japa_date']=date("d M Y",strtotime($rtn['data'][$c]['japa_date']));
				$rtn['data'][$c]['day']=date("l",strtotime($rtn['data'][$c]['japa_date']));
				$rtn['data'][$c]['japa_u_date']=urlencode(date("d M Y",strtotime($rtn['data'][$c]['japa_date'])));
			}
			if(empty($rtn['data'][$c]['family_details']))
			{
				$rtn['data'][$c]['family_details']="N/A";
			}
			else
			{
				$rtn['data'][$c]['family_details'] = nl2br($rtn['data'][$c]['family_details']);
			}
			
			$sno++;
			$c++;
		}
		return $rtn;
	}

	public function guestReport($mobile_no="",$excel=0)
	{
		$i=0;
		$query1=$this->db;
		if($excel==0)
		{
			$query1->select("count(id) as c,sum(participants_count) as total_participants");
		}
		step1:
		$i++;
		if($i==2 || $excel==1)
		{
			$query1->select("*,count(id) as submissions,sum(participants_count) as total_participants");
		}
		$query1->from($this->tableName);
		$query1->where("phone",$mobile_no);
		$query1->where("participants_count >",0);

		$preData="";
		$preData.="\nFrom Date: ";
		if(isset($_POST['from_date']) && $_POST['from_date']!='')
		{
			$query1->where("japa_date >=",date("Y-m-d",strtotime($_POST['from_date'])));
			$preData.=$_POST['from_date'];
		}
		
		$preData.="\nTo Date: ";
		if(isset($_POST['to_date']) && $_POST['to_date']!='')
		{
			$query1->where("japa_date <=",date("Y-m-d",strtotime($_POST['to_date'])));
			$preData.=$_POST['to_date'];
		}
		if($excel==1)
		{
			$query1->order_by('japa_date',$_POST['dir']);
			if(isset($_POST['order_by']) && in_array($_POST['order_by'],$GLOBALS['current_acl']['sort_columns']))
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by($_POST['order_by'],$_POST['dir']);
				else
					$query1->order_by($_POST['order_by'],'desc');
			}
			else
			{
				if(isset($_POST['dir']) && in_array($_POST['dir'],$GLOBALS['current_acl']['dir']))
					$query1->order_by('japa_date',$_POST['dir']);
				else
					$query1->order_by('japa_date',"desc");
			}
			$query1->group_by("japa_date");
			$sql=$query1->get_compiled_select();

			$requestResp=$this->excel_exports_model->makeRequest('default',"model","ramamantra/ramamantra_count_model",$sql,$this->currentUser,"misc_services",$_POST,"Rama Mantra Japa Report",$preData,3);
			return $requestResp;
		}
		
		if($i==1)
		{
			$query1->group_by("japa_date");
			$temp_result = $query1->get()->result();
			$t_total=0;
			$total_participants = 0;
			$t_cur_total = 0;
			foreach ($temp_result as $temp_row)
			{
				$t_total+=$temp_row->c;
				$t_cur_total+=$temp_row->total_participants;
			}
			$rtn['recordsTotal'] = count($temp_result);
			$rtn['recordsFiltered'] = count($temp_result);
			$rtn['total_participants'] = $t_cur_total;
			goto step1;
		}

		$dir='desc';
		if(isset($_POST['order'][0]['dir']) && in_array($_POST['order'][0]['dir'],$GLOBALS['current_acl']['dir']))
			$dir=$_POST['order'][0]['dir'];

		$order_by='';
		if(isset($_POST['order'][0]['column']) && is_numeric($_POST['order'][0]['column']))
		{
			$col_num=round(abs($_POST['order'][0]['column']));
			$col_name=$_POST['columns'][$col_num]['name'];
			if($col_num && in_array($col_name,$GLOBALS['current_acl']['sort_columns']))
				$query1->order_by($col_name,$dir);
			else
				$query1->order_by('japa_date',$dir);
		}
		else
		{
			$query1->order_by('japa_date',$dir);
		}
		$query1->group_by("japa_date");
		$start=0;
		$length=10;
		if(isset($_POST['start']) && is_numeric($_POST['start']))
		{
			if(round(abs($_POST['start']))%10==0)
			$start=round(abs($_POST['start']));
		}
		if(isset($_POST['length']) && is_numeric($_POST['length']) && in_array($_POST['length'],array(10,20)))
		{
			$length=abs($_POST['length']);
			if(!$length)
				$length=10;
		}

		$query1->limit($length,$start);

		$rtn['data']=$query1->get()->result_array();
		$sno=$start+1;
		$ids = array();
		$c=0;
		foreach ($rtn['data'] as $row)
		{
			$rtn['data'][$c]=$row;
			$rtn['data'][$c]['sno']=$sno;
			$ids[] = $row['id'];
			if(empty($rtn['data'][$c]['japa_date']) || $rtn['data'][$c]['japa_date'] == "1970-01-01")
			{
				$rtn['data'][$c]['japa_date']='N/A';
				$rtn['data'][$c]['day']='N/A';
				$rtn['data'][$c]['japa_u_date']='';
			}
			else
			{
				$rtn['data'][$c]['japa_date']=date("d M Y",strtotime($rtn['data'][$c]['japa_date']));
				$rtn['data'][$c]['day']=date("l",strtotime($rtn['data'][$c]['japa_date']));
				$rtn['data'][$c]['japa_u_date']=urlencode(date("d M Y",strtotime($rtn['data'][$c]['japa_date'])));
			}
			if(empty($rtn['data'][$c]['family_details']))
				$rtn['data'][$c]['family_details']="N/A";
			
			$sno++;
			$c++;
		}
		return $rtn;
	}

	public function getguestDatabyDate($mobile_no,$date)
	{
		if(empty($date))
			return false;

		$this->db->select("*");
		$this->db->where("p.japa_date",date("Y-m-d",strtotime($date)));
		$this->db->where("p.phone",$mobile_no);
		$this->db->where("participants_count >",0);
		$this->db->from($this->tableName." as p");
		$query = $this->db->get();
		if($query->num_rows() > 0)
			return $query->result_array();
		else
			return false;
	}

	public function getDatabyDate($date)
	{
		if(empty($date))
			return false;

		$this->db->select("*");
		$this->db->where("p.japa_date",date("Y-m-d",strtotime($date)));
		$this->db->group_start();
		$this->db->where("p.user_id",$this->currentUser->id);
		$this->db->or_where("p.email",$this->currentUser->email);
		$this->db->group_end();
		$this->db->where("participants_count >",0);
		$this->db->from($this->tableName." as p");
		$query = $this->db->get();
		if($query->num_rows() > 0)
			return $query->result_array();
		else
			return false;
	}
	
	function ramamantraData($id)
	{
		$this->db->select("*");
		$this->db->where("p.id",$id);
		$this->db->from($this->tableName." as p");
		$query = $this->db->get();
		return $query->row();
	}

	public function delete($id)
	{
		$this->db->where("id",$id)->delete($this->tableName);
		return true;
	}

	public function getTotalRecords($limit=100,$offset=0)
	{
		$this->db->select("*")->from($this->tableName)->order_by("id","desc");
		if(!empty($limit) && ($limit > 0))
			$this->db->limit($limit,$offset);
		$q = $this->db->get();
		if($q->num_rows() > 0)
		{
			$r = $q->result_array();
			return $r;
		}
		else
		{
			return false;
		}
	}

	public function getDatabyPhone($phone)
    {
    	$this->db->where("phone",$phone);
        $query=$this->db->get($this->tableName);
        if($query->num_rows())
		{
			return $query->row();
        }
        return 0;
    }

	public function phoneCheck($phone)
    {
    	$this->db->where("phone",$phone);
        $query=$this->db->get($this->tableName);
        if($query->num_rows())
		{
			return 1;
        }
        return 0;
    }

    public function publicphoneCheck($phone)
    {
    	$this->db->select("name");
    	$this->db->where("phone",$phone);
        $query=$this->db->get($this->tableName);
        if($query->num_rows())
		{
			return $query->row();
        }
        return 0;
    }

	public function getTotalRecordsByCity($limit = 0,$offset = 0)
	{
		$this->db->select("count(id) as submissions,city,country_name,sum(participants_count) as participants_count")->from($this->tableName)->order_by("participants_count","desc");
		if(!empty($limit) && ($limit > 0))
			$this->db->limit($limit,$offset);
		$q = $this->db->group_by("city")->get();
		if($q->num_rows() > 0)
		{
			$sno=1;
			$r = $q->result_array();
			foreach ($r as $key=>$value) 
			{
				$r[$key]['rank']=$sno;
				$sno++;
			}
			return $r;
		}
		else
		{
			return false;
		}
	}

	public function getTotalRecordsByCountry($limit = 0,$offset = 0)
	{
		$this->db->select("count(id) as submissions,city,country as country_code,country_name,sum(participants_count) as participants_count")->from($this->tableName);
		if(!empty($limit) && ($limit > 0))
		{
			$this->db->limit($limit,$offset);
		}
		$q = $this->db->group_by("country")->order_by("participants_count","desc")->get();
		if($q->num_rows() > 0)
		{
			$sno=1;
			$r = $q->result_array();
			foreach ($r as $key=>$value) 
			{
				$r[$key]['rank']=$sno;
				$sno++;
			}
			return $r;
		}
		else
		{
			return false;
		}
	}

	public function getTopCities()
	{
		$q = $this->db->select("count(id) as submissions,city,country as country_code,country_name,sum(participants_count) as participants_count")->from($this->tableName)->group_by("city")->order_by("participants_count","desc")->limit(10)->get();
		if($q->num_rows() > 0)
		{
			$sno=1;
			$r = $q->result_array();
			foreach ($r as $key=>$value) 
			{
				$r[$key]['rank']=$sno;
				$sno++;
			}
			return $r;
		}
		else
		{
			return false;
		}
	}

	public function gettodaysTotalRecords()
	{
		$q = $this->db->select("name,phone,email,count(id) as submissions,country as country_code,country_name,city,sum(participants_count) as participants_count,created_on as submission_date")->from($this->tableName)->group_by("phone")->order_by("participants_count","desc")->get();
		if($q->num_rows() > 0)
		{
			$sno=1;
			$r = $q->result_array();
			foreach ($r as $key=>$value) 
			{
				$r[$key]['rank']=$sno;
				$sno++;
			}
			return $r;
		}
		else
		{
			return false;
		}
	}

	public function getTotalRecordsbyDate()
	{
		$q = $this->db->select("count(id) as submissions,sum(participants_count) as participants_count,city,created_on as submission_date,japa_date")->from($this->tableName)->group_by("DATE_FORMAT(japa_date,'%Y%m%d')")->order_by("japa_date","desc")->get();
		if($q->num_rows() > 0)
		{
			$sno=1;
			$r = $q->result_array();
			foreach ($r as $key=>$value) 
			{
				$r[$key]['rank']=$sno;
				$sno++;
			}
			return $r;
		}
		else
		{
			return false;
		}
	}
	
	public function save($info)
	{	
		$user_id=0;
		$username='';
		if($this->session->userdata('user_id'))
		{
		    $user_id=$this->session->userdata('user_id');
		    $username=$this->session->userdata('user_data')->username;
		}

		$users=$this->users_model->getUsersByEmails(array($info['email']));
		if(!empty($users))
		{
			$user_id=$users[0]->id;
		    $username=$users[0]->username;
		}
		$app=0;
		if(isset($GLOBALS['app']) && $GLOBALS['app']==1)
		{
			$app=1;
		}
		
		$family_details = "";
		if($this->session->userdata('ramamantraonFamilyType'))
		{
			$ramamantraonFamilyType = $this->session->userdata('ramamantraonFamilyType');
			if($ramamantraonFamilyType == 'Chanting on all Family Members')
			{
				$donorquery=$this->load->database("sso_auth",true,false);
				$donorquery->select("donor_name, donor_relation, id as donor_id");
				$donorquery->from('donors');
				$donorquery->where('user_id',$this->currentUser->sso_user_id);
				$donorquery->where('is_hidden',0);
				$donorquery->order_by('id','ASC');
				$user_family_donors = $donorquery->get()->result_array();
				$thisnote = "";
				if(count($user_family_donors)>0){
					foreach($user_family_donors as $thisdonr)
					{
						$thisnote .= $thisdonr['donor_name']."\r\n";
					}
				}
				$family_details = $thisnote;
			}
			else if($ramamantraonFamilyType == 'Chanting on selected Family Members')
			{
				if($this->session->userdata('ramamantraonFamilyMembers'))
				{
					$ramamantraonFamilyMembers = $this->session->userdata('ramamantraonFamilyMembers');
					$thisnote = "";
					if(count($ramamantraonFamilyMembers)>0){
						foreach($ramamantraonFamilyMembers as $thisdonr)
						{
							$thisnote .= $thisdonr."\r\n";
						}
					}
					$family_details = $thisnote;
					unset($_SESSION['ramamantraonFamilyMembers']);
				}
			}
			else if($ramamantraonFamilyType == "Chanting on Sri Swamiji's name")
			{
				$family_details = "Sri Ganapathy Sachchidananda Swamiji";
			}
			else if($ramamantraonFamilyType == "Chanting on Sri Datta Vijayananda Teertha Swamiji's name")
			{
				$family_details = "Sri Datta Vijayananda Teertha Swamiji";
			}
			else if($ramamantraonFamilyType == "Enter participant details"){
				if(!empty($_SESSION['ramamantra_family']))
				{
					if(!empty(trim($_SESSION['ramamantra_family'])))
					{
						$family_details = $_SESSION['ramamantra_family'];
					}
				}
			}
			unset($_SESSION['ramamantraonFamilyType']);
		}
		else if(!empty($_SESSION['ramamantra_family']))
		{
			if(!empty(trim($_SESSION['ramamantra_family'])))
			{
				$family_details = $_SESSION['ramamantra_family'];
			}
		}

		if($family_details == "" && isset($this->currentUser->id) && !empty($this->currentUser->id) && isset($this->currentUser->family_details) && !empty($this->currentUser->family_details)
		)
		{
			$family_details = $this->currentUser->family_details;
		}

		if($family_details == "")
		{
			$family_details = trim($info['name']);
		}

		$countryData=$this->locations_model->getCountryByCode($info["country_code"]);
		$query=$this->db->insert($this->tableName,
                            	array(
                            			'name' =>trim($info['name']),
                            			'email' =>strtolower(trim($info['email'])),
                            			'phone' =>trim($info['phone']),
                            			'country' =>trim($info['country_code']),
                            			'country_name' =>$countryData->country_name,
                            			'address_1' =>trim($info['address1']),
                            			'address_2' =>trim($info['address2']),
                            			'address_3' =>trim($info['address3']),
                            			'state' =>trim($info['state']),
                            			'city' =>trim($info['city']),
                            			'zipcode'=>trim($info['zipcode']),
                            			'family_details' => trim($family_details),
                            			'japa_date'=>date("Y-m-d",strtotime($info['japa_date'])),
                            			'participants_count'=>trim($info['participants_count']),
                            			'user_id'=>$user_id,
                            			'username'=>$username,
                            			'app'=>$app,
                            			'created_on'=>date("Y:m:d H:i:s")
									)
								);
		if($query)
		{
			$last_id=$this->db->insert_id();
			$pid="RM-".date("Y")."-".date("m")."-100".$last_id;
			$this->db->where("id",$last_id);
			$this->db->update($this->tableName,
							array("ramamantra_count_id"=>$pid)
						);

			return 1;
		}
		else return 0;
	}

	public function excelReportUser($excelData,$objPHPExcel)
	{
		if($excelData->page_number==3)
		{
			$objPHPExcel=$this->excelReportGuestUser($excelData,$objPHPExcel);
			return $objPHPExcel;
		}
		$q=$this->db->query($excelData->query);

		$objPHPExcel->setActiveSheetIndex(0);
		$objPHPExcel->getActiveSheet()->SetCellValue('A1',$excelData->page_name);

		$styleArray = array(
							'font' => array(
							'bold' => true
							)
						);

		$objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('A2',"Report Date: ".date("d M Y h:i A"));

		$j=3;
		$pre_data=explode("\n",$excelData->pre_data);
		foreach ($pre_data as $filter)
		{
			$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,$filter);
			$j++;
		}

		$request_data=unserialize($excelData->request_data);

		$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,"Total Records: ".$q->num_rows());

		$j=$j+2;

		$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,"S. No.");
		$objPHPExcel->getActiveSheet()->getStyle('A'.$j)->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('B'.$j,"Name");
		$objPHPExcel->getActiveSheet()->getStyle('B'.$j)->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('C'.$j,"Phone");
		$objPHPExcel->getActiveSheet()->getStyle('C'.$j)->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('D'.$j,"Email");
		$objPHPExcel->getActiveSheet()->getStyle('D'.$j)->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('E'.$j,"City");
		$objPHPExcel->getActiveSheet()->getStyle('E'.$j)->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('F'.$j,"Country");
		$objPHPExcel->getActiveSheet()->getStyle('F'.$j)->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('G'.$j,"Participants Details");
		$objPHPExcel->getActiveSheet()->getStyle('G'.$j)->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('H'.$j,"Japa Count");
		$objPHPExcel->getActiveSheet()->getStyle('H'.$j)->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('I'.$j,"Submisions");
		$objPHPExcel->getActiveSheet()->getStyle('I'.$j)->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('J'.$j,"Day");
		$objPHPExcel->getActiveSheet()->getStyle('J'.$j)->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('K'.$j,"Japa Date");
		$objPHPExcel->getActiveSheet()->getStyle('K'.$j)->applyFromArray($styleArray);

		$i=$j+1;
		$sno=1;
		foreach ($q->result() as $reportrow)
		{
			if(empty($reportrow->japa_date) || $reportrow->japa_date == "1970-01-01")
			{
				$reportrow->japa_date='N/A';
				$reportrow->day='N/A';
			}
			else
			{
				$reportrow->japa_date=date("d M Y",strtotime($reportrow->japa_date));
				$reportrow->day=date("l",strtotime($reportrow->japa_date));
			}
			$objPHPExcel->getActiveSheet()->SetCellValue('A'.$i,$sno);
			if(isset($requestData['group_by']) && $requestData['group_by']=="city")
			{
				if(!empty($requestData['search_col']) && $requestData['search_col'] == "user_id")
				{
				}
				else
				{
					$objPHPExcel->getActiveSheet()->SetCellValue('B'.$i,$reportrow->name);
					$objPHPExcel->getActiveSheet()->SetCellValue('C'.$i,$reportrow->phone);
					$objPHPExcel->getActiveSheet()->SetCellValue('D'.$i,$reportrow->email);
					$objPHPExcel->getActiveSheet()->SetCellValue('E'.$i,$reportrow->city);
					$objPHPExcel->getActiveSheet()->SetCellValue('F'.$i,$reportrow->country);
					$objPHPExcel->getActiveSheet()->SetCellValue('G'.$i,"N/A");
				}
			}
			else if(isset($requestData['group_by']) && $requestData['group_by']=="country")
			{
				if(!empty($requestData['search_col']) && $requestData['search_col'] == "user_id")
				{
					$objPHPExcel->getActiveSheet()->SetCellValue('B'.$i,$reportrow->name);
					$objPHPExcel->getActiveSheet()->SetCellValue('C'.$i,$reportrow->phone);
					$objPHPExcel->getActiveSheet()->SetCellValue('D'.$i,$reportrow->email);
					$objPHPExcel->getActiveSheet()->SetCellValue('E'.$i,$reportrow->city);
					$objPHPExcel->getActiveSheet()->SetCellValue('F'.$i,$reportrow->country);
					$objPHPExcel->getActiveSheet()->SetCellValue('G'.$i,"N/A");
				}
				else if(!empty($requestData['search_col']) && $requestData['search_col'] == "city")
				{
					$objPHPExcel->getActiveSheet()->SetCellValue('B'.$i,"N/A");
					$objPHPExcel->getActiveSheet()->SetCellValue('C'.$i,"N/A");
					$objPHPExcel->getActiveSheet()->SetCellValue('D'.$i,"N/A");
					$objPHPExcel->getActiveSheet()->SetCellValue('E'.$i,$reportrow->city);
					$objPHPExcel->getActiveSheet()->SetCellValue('F'.$i,"N/A");
					$objPHPExcel->getActiveSheet()->SetCellValue('G'.$i,"N/A");
				}
			}
			else
			{
				$objPHPExcel->getActiveSheet()->SetCellValue('B'.$i,$reportrow->name);
				$objPHPExcel->getActiveSheet()->SetCellValue('C'.$i,$reportrow->phone);
				$objPHPExcel->getActiveSheet()->SetCellValue('D'.$i,$reportrow->email);
				$objPHPExcel->getActiveSheet()->SetCellValue('E'.$i,$reportrow->city);
				$objPHPExcel->getActiveSheet()->SetCellValue('F'.$i,$reportrow->country);
				$objPHPExcel->getActiveSheet()->SetCellValue('G'.$i,$reportrow->family_details);
			}
			$objPHPExcel->getActiveSheet()->SetCellValue('H'.$i,$reportrow->submissions);
			$objPHPExcel->getActiveSheet()->SetCellValue('I'.$i,$reportrow->total_participants);
			if(isset($requestData['group_by']) && $requestData['group_by']!="")
			{
				$objPHPExcel->getActiveSheet()->SetCellValue('J'.$i,"N/A");
				$objPHPExcel->getActiveSheet()->SetCellValue('K'.$i,"N/A");
			}
			else
			{
				$objPHPExcel->getActiveSheet()->SetCellValue('J'.$i,$reportrow->day);
				$objPHPExcel->getActiveSheet()->SetCellValue('K'.$i,date("d M Y",strtotime($reportrow->japa_date)));
			}
			$i++;
			$sno++;
		}
		return $objPHPExcel;
	}

	public function excelReportGuestUser($excelData,$objPHPExcel)
	{
		$q=$this->db->query($excelData->query);

		$objPHPExcel->setActiveSheetIndex(0);
		$objPHPExcel->getActiveSheet()->SetCellValue('A1',$excelData->page_name);

		$styleArray = array(
							'font' => array(
							'bold' => true
							)
						);

		$objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('A2',"Report Date: ".date("d M Y h:i A"));

		$j=3;
		$pre_data=explode("\n",$excelData->pre_data);
		foreach ($pre_data as $filter)
		{
			$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,$filter);
			$j++;
		}

		$request_data=unserialize($excelData->request_data);

		$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,"Total Records: ".$q->num_rows());

		$j=$j+2;

		$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,"S. No.");
		$objPHPExcel->getActiveSheet()->getStyle('A'.$j)->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('B'.$j,"Name");
		$objPHPExcel->getActiveSheet()->getStyle('B'.$j)->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('C'.$j,"Email");
		$objPHPExcel->getActiveSheet()->getStyle('C'.$j)->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('D'.$j,"Phone");
		$objPHPExcel->getActiveSheet()->getStyle('D'.$j)->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('E'.$j,"Participants Details");
		$objPHPExcel->getActiveSheet()->getStyle('E'.$j)->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('F'.$j,"Japa Count");
		$objPHPExcel->getActiveSheet()->getStyle('F'.$j)->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('G'.$j,"Day");
		$objPHPExcel->getActiveSheet()->getStyle('G'.$j)->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('H'.$j,"Japa Date");
		$objPHPExcel->getActiveSheet()->getStyle('H'.$j)->applyFromArray($styleArray);

		$i=$j+1;
		$sno=1;
		foreach ($q->result() as $reportrow)
		{
			if(empty($reportrow->japa_date) || $reportrow->japa_date == "1970-01-01")
			{
				$reportrow->japa_date='N/A';
				$reportrow->day='N/A';
			}
			else
			{
				$reportrow->japa_date=date("d M Y",strtotime($reportrow->japa_date));
				$reportrow->day=date("l",strtotime($reportrow->japa_date));
			}
			$objPHPExcel->getActiveSheet()->SetCellValue('A'.$i,$sno);
			$objPHPExcel->getActiveSheet()->SetCellValue('B'.$i,$reportrow->name);
			$objPHPExcel->getActiveSheet()->SetCellValue('C'.$i,$reportrow->email);
			$objPHPExcel->getActiveSheet()->SetCellValue('D'.$i,$reportrow->phone);
			$objPHPExcel->getActiveSheet()->SetCellValue('E'.$i,$reportrow->family_details);
			$objPHPExcel->getActiveSheet()->SetCellValue('F'.$i,$reportrow->total_participants);
			$objPHPExcel->getActiveSheet()->SetCellValue('G'.$i,$reportrow->day);
			$objPHPExcel->getActiveSheet()->SetCellValue('H'.$i,date("d M Y",strtotime($reportrow->japa_date)));
			$i++;
			$sno++;
		}
		return $objPHPExcel;
	}

	public function excelReport($excelData,$objPHPExcel)
	{
		if($excelData->page_number==2)
		{
			$objPHPExcel=$this->excelReportUser($excelData,$objPHPExcel);
			return $objPHPExcel;
		}
		if($excelData->page_number==3)
		{
			$objPHPExcel=$this->excelReportGuestUser($excelData,$objPHPExcel);
			return $objPHPExcel;
		}
		$countries=$this->locations_model->getCountries(true);

		$q=$this->db->query($excelData->query);

		$objPHPExcel->setActiveSheetIndex(0);
		$objPHPExcel->getActiveSheet()->SetCellValue('A1',$excelData->page_name);

		$styleArray = array(
							'font' => array(
							'bold' => true
							)
						);

		$objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('A2',"Report Date: ".date("d M Y h:i A"));

		$j=3;
		$pre_data=explode("\n",$excelData->pre_data);
		foreach ($pre_data as $filter)
		{
			$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,$filter);
			$j++;
		}

		$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,"Total Records: ".$q->num_rows());

		$requestData=unserialize($excelData->request_data);

		$j=$j+2;

		$alpha="A";
		$objPHPExcel->getActiveSheet()->SetCellValue('A'.$j,"S. No.");
		$objPHPExcel->getActiveSheet()->getStyle('A'.$j)->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('B'.$j,"Name");
		$objPHPExcel->getActiveSheet()->getStyle('B'.$j)->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('C'.$j,"Phone");
		$objPHPExcel->getActiveSheet()->getStyle('C'.$j)->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('D'.$j,"Email");
		$objPHPExcel->getActiveSheet()->getStyle('D'.$j)->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('E'.$j,"City");
		$objPHPExcel->getActiveSheet()->getStyle('E'.$j)->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('F'.$j,"Country");
		$objPHPExcel->getActiveSheet()->getStyle('F'.$j)->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('G'.$j,"Participants Details");
		$objPHPExcel->getActiveSheet()->getStyle('G'.$j)->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('H'.$j,"Japa Count");
		$objPHPExcel->getActiveSheet()->getStyle('H'.$j)->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('I'.$j,"Submisions");
		$objPHPExcel->getActiveSheet()->getStyle('I'.$j)->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('J'.$j,"Day");
		$objPHPExcel->getActiveSheet()->getStyle('J'.$j)->applyFromArray($styleArray);

		$objPHPExcel->getActiveSheet()->SetCellValue('K'.$j,"Japa Date");
		$objPHPExcel->getActiveSheet()->getStyle('K'.$j)->applyFromArray($styleArray);

		$i=$j+1;
		$sno=1;
		foreach ($q->result() as $reportrow)
		{
			if(empty($reportrow->japa_date) || $reportrow->japa_date == "1970-01-01")
			{
				$reportrow->japa_date='N/A';
				$reportrow->day='N/A';
			}
			else
			{
				$reportrow->japa_date=date("d M Y",strtotime($reportrow->japa_date));
				$reportrow->day=date("l",strtotime($reportrow->japa_date));
			}
			$objPHPExcel->getActiveSheet()->SetCellValue('A'.$i,$sno);
			if(isset($requestData['group_by']) && $requestData['group_by']=="city")
			{
				if(!empty($requestData['search_col']) && $requestData['search_col'] == "user_id")
				{
				}
				else
				{
					$objPHPExcel->getActiveSheet()->SetCellValue('B'.$i,$reportrow->name);
					$objPHPExcel->getActiveSheet()->SetCellValue('C'.$i,$reportrow->phone);
					$objPHPExcel->getActiveSheet()->SetCellValue('D'.$i,$reportrow->email);
					$objPHPExcel->getActiveSheet()->SetCellValue('E'.$i,$reportrow->city);
					$objPHPExcel->getActiveSheet()->SetCellValue('F'.$i,$reportrow->country);
					$objPHPExcel->getActiveSheet()->SetCellValue('G'.$i,"N/A");
				}
			}
			else if(isset($requestData['group_by']) && $requestData['group_by']=="country")
			{
				if(!empty($requestData['search_col']) && $requestData['search_col'] == "user_id")
				{
					$objPHPExcel->getActiveSheet()->SetCellValue('B'.$i,$reportrow->name);
					$objPHPExcel->getActiveSheet()->SetCellValue('C'.$i,$reportrow->phone);
					$objPHPExcel->getActiveSheet()->SetCellValue('D'.$i,$reportrow->email);
					$objPHPExcel->getActiveSheet()->SetCellValue('E'.$i,$reportrow->city);
					$objPHPExcel->getActiveSheet()->SetCellValue('F'.$i,$reportrow->country);
					$objPHPExcel->getActiveSheet()->SetCellValue('G'.$i,"N/A");
				}
				else if(!empty($requestData['search_col']) && $requestData['search_col'] == "city")
				{
					$objPHPExcel->getActiveSheet()->SetCellValue('B'.$i,"N/A");
					$objPHPExcel->getActiveSheet()->SetCellValue('C'.$i,"N/A");
					$objPHPExcel->getActiveSheet()->SetCellValue('D'.$i,"N/A");
					$objPHPExcel->getActiveSheet()->SetCellValue('E'.$i,$reportrow->city);
					$objPHPExcel->getActiveSheet()->SetCellValue('F'.$i,"N/A");
					$objPHPExcel->getActiveSheet()->SetCellValue('G'.$i,"N/A");
				}
			}
			else
			{
				$objPHPExcel->getActiveSheet()->SetCellValue('B'.$i,$reportrow->name);
				$objPHPExcel->getActiveSheet()->SetCellValue('C'.$i,$reportrow->phone);
				$objPHPExcel->getActiveSheet()->SetCellValue('D'.$i,$reportrow->email);
				$objPHPExcel->getActiveSheet()->SetCellValue('E'.$i,$reportrow->city);
				$objPHPExcel->getActiveSheet()->SetCellValue('F'.$i,$reportrow->country);
				$objPHPExcel->getActiveSheet()->SetCellValue('G'.$i,$reportrow->family_details);
			}
			$objPHPExcel->getActiveSheet()->SetCellValue('H'.$i,$reportrow->submissions);
			$objPHPExcel->getActiveSheet()->SetCellValue('I'.$i,$reportrow->participants_count);
			if(isset($requestData['group_by']) && $requestData['group_by']!="")
			{
				$objPHPExcel->getActiveSheet()->SetCellValue('J'.$i,"N/A");
				$objPHPExcel->getActiveSheet()->SetCellValue('K'.$i,"N/A");
			}
			else
			{
				$objPHPExcel->getActiveSheet()->SetCellValue('J'.$i,$reportrow->day);
				$objPHPExcel->getActiveSheet()->SetCellValue('K'.$i,date("d M Y",strtotime($reportrow->japa_date)));
			}
			$i++;
			$sno++;
		}
		return $objPHPExcel;
	}
}
?>