<?PHP
class Payflow_logs_model extends CI_Model 
{
	var $year_table = "";
	var $tableName="";
	var $archivesDb = "";
	public function __construct()
	{
		parent::__construct();
		$this->year_table = date("Y");
		$this->tableName = "payflow_logs_".$this->year_table;
		$this->archivesDb = $this->load->database("data_archives",true,false);
		if ($this->archivesDb->table_exists($this->tableName) )
		{

		}
		else
		{
		  	// table does not exist
		  	$new_table = "CREATE TABLE IF NOT EXISTS `".$this->tableName."` (
			  		`id` int(11) NOT NULL AUTO_INCREMENT,
				  	`date` datetime NOT NULL,
				  	`action` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
				  	`rpref` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
				  	`pnref` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
				  	`tx` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
				  	`data` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
				  	`ip_address` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
				  	`user_id` int(11) NOT NULL DEFAULT 0,
				  	PRIMARY KEY (`id`)
					) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;";
			$this->archivesDb->query($new_table);
		}
	}
	public function log($data=array(),$action='')
	{
		$remote_addr="127.0.0.1";
    	if(isset($_SERVER['REMOTE_ADDR']))
    		$remote_addr=$_SERVER['REMOTE_ADDR'];

		if(!empty($data))
		{
			$user_id=0;
			if($this->session->userdata('loggedIn'))
			{
				if($this->session->userdata('id'))
					$user_id=$this->session->userdata('admin_data')->id;
				else
					$user_id=$this->session->userdata('user_data')->id;
			}
			
			unset($data['ACCT']);
			unset($data['EXPDATE']);
			unset($data['NAME']);
			$insertArray=array(
							"user_id"=>$user_id,
							"date"=>date("Y:m:d H:i:s"),
							"action"=>$action,
							"ip_address"=>$remote_addr,
							"data"=>serialize($data)
						);
			if(isset($data['RPREF']))
			{
				$insertArray['rpref']=$data['RPREF'];
			}
			if(isset($data['PNREF']))
			{
				$insertArray['pnref']=$data['PNREF'];
			}
			$this->archivesDb->insert($this->tableName,$insertArray);
		}
	}
}
?>